/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.app;

import com.ibm.nzna.projects.qit.app.AppletRec;
import com.ibm.nzna.projects.qit.app.AppletSystemListener;
import com.ibm.nzna.projects.qit.app.InitializeQuestAppletThread;
import com.ibm.nzna.projects.qit.app.QuestApplet;
import com.ibm.nzna.projects.qit.app.util.QuestUtil;
import com.ibm.nzna.shared.util.LogSystem;
import java.util.Vector;

public class AppletSystem
implements Runnable {
    private static final String THREAD_FIRE_APPLET_ADD = "FAA";
    private static final String THREAD_FIRE_APPLET_REMOVE = "FAR";
    private static Vector appletVector = null;
    private static final String APPLET_FILE = "quest.applets";
    private static AppletSystem instance = null;
    private static Vector runningAppletVec = null;
    private static Vector listenerVec = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initialize() {
        try {
            appletVector = (Vector)QuestUtil.readObjectFromDisk(APPLET_FILE);
            if (appletVector != null) return;
            appletVector = new Vector(1, 1);
            return;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
    }

    public static void addApplet(AppletRec appletRec) {
        if (appletVector == null) {
            appletVector = new Vector(10, 1);
        }
        appletVector.addElement(appletRec);
        AppletSystem.getInstance().writeToDisk();
        new Thread((Runnable)AppletSystem.getInstance(), THREAD_FIRE_APPLET_ADD).start();
    }

    public static void removeApplet(AppletRec appletRec) {
        if (appletVector != null) {
            appletVector.removeElement(appletRec);
            AppletSystem.getInstance().writeToDisk();
            new Thread((Runnable)AppletSystem.getInstance(), THREAD_FIRE_APPLET_REMOVE).start();
        }
    }

    public static Vector getAppletList() {
        return (Vector)appletVector.clone();
    }

    public static AppletSystem getInstance() {
        return instance;
    }

    public static void createApplet(AppletRec appletRec) {
        new InitializeQuestAppletThread(appletRec);
    }

    public void run() {
        String string = Thread.currentThread().getName();
        if (listenerVec != null && listenerVec.size() > 0) {
            int n = 0;
            int n2 = listenerVec.size();
            while (n < n2) {
                if (string.equals(THREAD_FIRE_APPLET_ADD)) {
                    ((AppletSystemListener)listenerVec.elementAt(n)).appletAdded();
                }
                if (string.equals(THREAD_FIRE_APPLET_REMOVE)) {
                    ((AppletSystemListener)listenerVec.elementAt(n)).appletRemoved();
                }
                ++n;
            }
        }
    }

    public static void addAppletSystemListener(AppletSystemListener appletSystemListener) {
        if (listenerVec == null) {
            listenerVec = new Vector(1, 1);
        }
        listenerVec.addElement(appletSystemListener);
    }

    public static void removeAppletSystemListener(AppletSystemListener appletSystemListener) {
        if (listenerVec != null) {
            listenerVec.removeElement(appletSystemListener);
        }
    }

    private final void writeToDisk() {
        int n = 0;
        if (appletVector != null) {
            int n2 = appletVector.size();
            while (n < n2) {
                ((AppletRec)appletVector.elementAt(n)).prepareForSerialization();
                ++n;
            }
            QuestUtil.writeObjectToDisk(APPLET_FILE, appletVector);
        }
    }

    public static AppletRec getAppletFromName(String string) {
        AppletRec appletRec = null;
        AppletRec appletRec2 = null;
        int n = 0;
        if (appletVector != null) {
            int n2 = appletVector.size();
            while (appletRec == null && n < n2) {
                appletRec2 = (AppletRec)appletVector.elementAt(n);
                if (((String)appletRec2.getColumnData(1)).equals(string)) {
                    appletRec = appletRec2;
                }
                ++n;
            }
        }
        return appletRec;
    }

    protected static void addRunningApplet(QuestApplet questApplet) {
        if (runningAppletVec == null) {
            runningAppletVec = new Vector(1, 1);
        }
        runningAppletVec.addElement(questApplet);
    }

    public AppletSystem() {
        instance = this;
    }
}

