/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.app;

import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.shared.util.LogSystem;
import java.io.BufferedInputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class ChatServer
implements Runnable,
AppConst {
    private static final int LISTEN_PORT = 7469;
    private static ChatServer instance = null;
    private static String ipAddress = null;
    private static ServerSocket serverSocket = null;
    private boolean runServer = true;
    private Thread serverThread = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void startServer() {
        try {
            serverSocket = new ServerSocket(7469);
            ipAddress = InetAddress.getLocalHost().getHostAddress();
            LogSystem.log(1, "ChatServer serving from TCP/IP Address:" + ipAddress);
            this.serverThread = new Thread(this);
            this.serverThread.start();
            return;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
    }

    public static final String getLocalAddress() {
        return ipAddress;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (this.runServer) {
            try {
                Socket socket = serverSocket.accept();
                String string = ChatServer.getStringFromSocket(socket);
            }
            catch (Exception exception) {
                LogSystem.log(1, exception);
            }
        }
    }

    public void stopServer() {
        this.runServer = false;
        if (this.serverThread != null) {
            this.serverThread.interrupt();
        }
    }

    private static final String getStringFromSocket(Socket socket) throws Exception {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(socket.getInputStream());
        String string = "";
        byte[] byArray = new byte[1024];
        boolean bl = true;
        while (bl) {
            if (bufferedInputStream.read(byArray, 0, byArray.length) > 0) {
                string = string + new String(byArray);
                continue;
            }
            bl = false;
        }
        bufferedInputStream.close();
        return string;
    }

    public ChatServer() {
        if (instance == null) {
            instance = this;
            this.startServer();
        }
    }
}

