/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.app;

import com.ibm.nzna.projects.common.storedProc.sqlRunner.SqlRunner;
import com.ibm.nzna.projects.qit.app.BrandMgrRec;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.app.util.QuestUtil;
import com.ibm.nzna.projects.qit.storedProc.sqlRunner.QITSqlRunner;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.gui.MultiListRow;
import com.ibm.nzna.shared.gui.MultiListSort;
import com.ibm.nzna.shared.pom.PersistentRec;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.Text;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;

public class UserRec
extends PersistentRec
implements Serializable,
MultiListSort,
MultiListRow {
    static final long serialVersionUID = 1000000L;
    public static final int LOGIN_OK = 0;
    public static final int LOGIN_USER_NOT_FOUND = 1;
    public static final int LOGIN_PASSWORD_WRONG = 2;
    public static final int LOGIN_TOO_MANY_ATTEMPTS = 3;
    public static final int LOGIN_SQL_ERROR = 4;
    private static final char[][] encrypt = new char[][]{{'@', '#', '$', '%', '^', '&', '*', '(', ')', '-', '=', '[', ']', ';', '1', ',', '.', '/', 'q', '{', '}', ':', '\"', '<', '>', '?', '`', '~', 'D', 'e', 'g', 's', 'u', 'f', 'd', '!'}, {'B', 'Z', 'D', 'C', 'F', 'E', 'H', 'G', 'J', 'I', 'L', '@', 'N', 'O', '%', '#', 'P', '#', 'R', '(', 'T', 'W', 'V', 'Y', 'X', 'A', '2', '1', '4', '3', '6', '5', '8', '7', '0', '9'}, {'D', 'C', 'B', 'A', 'H', 'G', 'F', 'E', 'L', 'K', 'J', 'I', '$', '[', 'N', 'M', '@', 'S', '*', 'Q', ')', '}', 'V', 'U', '{', 'Y', '4', '/', '9', '.', '8', ',', '6', '5', '3', '2'}};
    private static final char[] decrypt = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0'};
    private String userId = null;
    private String name = null;
    private String ipAddress = null;
    private String manager = null;
    private String eMail = null;
    private String managerEMail = null;
    private String phone = null;
    private String password = null;
    private String toString = null;
    private String backUp = null;
    private boolean isManager = false;
    private int languageInd = 0;
    private int attempts = 0;
    private int[] teams = null;
    private int[] auths = null;
    private int[] countries = null;
    private Vector brandMgrVec = null;

    private final void initialize() {
        this.updateRecStatus(0);
        this.auths = new int[1];
        this.toString = this.userId;
    }

    public void setUserId(String string) {
        this.userId = string;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setManagerUserId(String string) {
        this.manager = string;
    }

    public String getManagerUserId() {
        return this.manager;
    }

    public void setEMail(String string) {
        this.eMail = string;
    }

    public String getEMail() {
        return this.eMail;
    }

    public void setManagerEMail(String string) {
        this.managerEMail = string;
    }

    public String getManagerEMail() {
        return this.managerEMail;
    }

    public void setIPAddress(String string) {
        this.ipAddress = string;
    }

    public String getIPAddress() {
        return this.ipAddress;
    }

    public void setLanguage(int n) {
        this.languageInd = n;
    }

    public int getLanguage() {
        return this.languageInd;
    }

    public void setPhone(String string) {
        this.phone = string;
    }

    public String getPhone() {
        return this.phone;
    }

    public Object getColumnData(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = this.userId;
                break;
            }
            case 1: {
                string = this.name;
                break;
            }
            case 2: {
                string = this.eMail;
                break;
            }
            case 3: {
                string = this.phone;
                break;
            }
            case 4: {
                string = this.manager;
                break;
            }
            case 5: {
                string = this.managerEMail;
                break;
            }
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    public int compareTo(MultiListSort multiListSort, int n) {
        int n2 = 0;
        if (multiListSort instanceof UserRec) {
            UserRec userRec = (UserRec)multiListSort;
            switch (n) {
                case 0: {
                    if (this.userId == null || userRec.userId == null) break;
                    n2 = this.userId.compareTo(userRec.userId);
                    break;
                }
                case 1: {
                    if (this.name == null || userRec.name == null) break;
                    n2 = this.name.compareTo(userRec.name);
                    break;
                }
                case 2: {
                    if (this.eMail == null || userRec.eMail == null) break;
                    n2 = this.eMail.compareTo(userRec.eMail);
                    break;
                }
                case 3: {
                    if (this.phone == null || userRec.phone == null) break;
                    n2 = this.phone.compareTo(userRec.phone);
                    break;
                }
                case 4: {
                    if (this.manager == null || userRec.manager == null) break;
                    n2 = this.manager.compareTo(userRec.manager);
                    break;
                }
                case 5: {
                    if (this.managerEMail == null || userRec.managerEMail == null) break;
                    n2 = this.managerEMail.compareTo(userRec.managerEMail);
                    break;
                }
            }
        }
        return n2;
    }

    public String toString() {
        return this.toString;
    }

    public void addTeam(int n) {
        if (this.teams != null) {
            if (!this.hasTeam(n)) {
                int[] nArray = new int[this.teams.length + 1];
                System.arraycopy(this.teams, 0, nArray, 0, this.teams.length);
                nArray[nArray.length - 1] = n;
                this.teams = nArray;
            }
        } else {
            this.teams = new int[1];
            this.teams[0] = n;
        }
    }

    public void removeTeam(int n) {
        boolean bl = false;
        int n2 = 0;
        if (this.teams != null) {
            Vector<Integer> vector = new Vector<Integer>(this.teams.length);
            while (n2 < this.teams.length) {
                if (this.teams[n2] != n) {
                    vector.addElement(new Integer(this.teams[n2]));
                }
                ++n2;
            }
            n2 = 0;
            this.teams = new int[vector.size()];
            while (n2 < vector.size()) {
                this.teams[n2] = (Integer)vector.elementAt(n2);
                ++n2;
            }
        }
    }

    public boolean hasAuth(int n) {
        int n2 = 0;
        boolean bl = false;
        while (!bl && n2 < this.auths.length) {
            boolean bl2 = bl = this.auths[n2] == n;
            if (!bl) {
                bl = this.auths[n2] == 1;
            }
            ++n2;
        }
        return bl;
    }

    public void addAuth(int n) {
        if (this.auths != null) {
            int[] nArray = new int[this.auths.length + 1];
            System.arraycopy(this.auths, 0, nArray, 0, this.auths.length);
            nArray[nArray.length - 1] = n;
            this.auths = nArray;
        } else {
            this.auths = new int[1];
            this.auths[0] = n;
        }
    }

    public void removeAuth(int n) {
        boolean bl = false;
        int n2 = -1;
        while (!bl && n2 < this.auths.length) {
            if (++n2 >= this.auths.length) continue;
            boolean bl2 = bl = this.auths[n2] == n;
        }
        if (bl) {
            int[] nArray = new int[this.auths.length - 1];
            int n3 = 0;
            while (n2 < this.auths.length) {
                if (this.auths[n2] != n) {
                    nArray[n3] = this.auths[n2];
                    ++n3;
                }
                ++n2;
            }
            this.auths = nArray;
        }
    }

    public int[] getTeams() {
        return this.teams;
    }

    public int[] getAuths() {
        return this.auths;
    }

    public void setAuths(int[] nArray) {
        this.auths = nArray;
    }

    public void setTeams(int[] nArray) {
        this.teams = nArray;
    }

    protected static char getDecryptChar(char c, int n) {
        char c2 = '\u0000';
        int n2 = 0;
        while (n2 < encrypt.length && c2 == '\u0000') {
            if (encrypt[n][n2] == c) {
                c2 = decrypt[n2];
            }
            ++n2;
        }
        return c2;
    }

    protected static char getEncryptChar(char c, int n) {
        char c2 = '\u0000';
        int n2 = 0;
        while (n2 < decrypt.length && c2 == '\u0000') {
            if (decrypt[n2] == c) {
                c2 = encrypt[n][n2];
            }
            ++n2;
        }
        return c2;
    }

    public String encryptPassword() {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer(this.password);
        StringBuffer stringBuffer2 = new StringBuffer(this.password);
        int n2 = 0;
        n = 0;
        while (n < this.password.length()) {
            stringBuffer2.setCharAt(n, UserRec.getEncryptChar(this.password.charAt(n), n2));
            if (++n2 > 2) {
                n2 = 0;
            }
            ++n;
        }
        return stringBuffer2.toString();
    }

    public String decryptPassword(String string) {
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer(string);
        StringBuffer stringBuffer2 = new StringBuffer(string);
        n = 0;
        while (n < string.length()) {
            stringBuffer2.setCharAt(n, UserRec.getDecryptChar(string.charAt(n), n2));
            if (++n2 > 2) {
                n2 = 0;
            }
            ++n;
        }
        return stringBuffer2.toString();
    }

    public String getEncryptedPassword() {
        return this.encryptPassword();
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getPassword() {
        return this.password;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean saveToDatabase() {
        boolean bl = false;
        String string = null;
        try {
            int n;
            String string2 = this.isManager ? "Y" : "N";
            switch (this.getRecStatus()) {
                case 2: {
                    string = "INSERT INTO TIGRIS.USERID " + "( USERID,       NAME,      ATTEMPTS, PASSWORD, MANAGER, MANAGERUSERID, " + "  BACKUPUSERID, EMAILADDR, PHONENUM, DBUSER, CHANGEDTIME ) " + "values ( " + "'" + this.userId + "', " + "'" + this.name + "', " + " " + this.attempts + ", " + "'" + Text.cleanDBString(this.getEncryptedPassword()) + "', " + "'" + string2 + "', " + "'" + this.manager + "', " + "'" + this.backUp + "', " + "'" + this.eMail + "', " + "'" + this.phone + "', " + "'" + UserSystem.getUserId() + "', " + "CURRENT TIMESTAMP )" + SqlRunner.END_DELIM;
                    break;
                }
                case 1: {
                    string = "UPDATE TIGRIS.USERID " + "SET NAME           = '" + this.name + "', " + "    ATTEMPTS       = " + this.attempts + ", " + "    MANAGER        = '" + string2 + "', " + "    MANAGERUSERID  = '" + this.manager + "', " + "    BACKUPUSERID   = '" + this.backUp + "', " + "    PHONENUM       = '" + this.phone + "', " + "    EMAILADDR      = '" + this.eMail + "', " + "    DBUSER         = '" + UserSystem.getUserId() + "', " + "    CHANGEDTIME    = CURRENT TIMESTAMP " + "WHERE USERID = '" + this.userId + "'" + SqlRunner.END_DELIM;
                    break;
                }
            }
            if (string == null) return bl;
            string = string + "DELETE FROM TIGRIS.USERIDUSERGROUP WHERE USERID = '" + this.userId + "' " + SqlRunner.END_DELIM;
            if (this.teams != null) {
                n = 0;
                while (n < this.teams.length) {
                    string = string + "INSERT INTO TIGRIS.USERIDUSERGROUP " + "( USERGROUP, USERID, DBUSER, CHANGEDTIME )" + "VALUES ( " + "" + this.teams[n] + ", " + "'" + this.userId + "', " + "'" + UserSystem.getUserId() + "', " + "CURRENT TIMESTAMP )" + SqlRunner.END_DELIM;
                    ++n;
                }
            }
            string = string + "DELETE FROM TIGRIS.USERIDCOUNTRY WHERE USERID = '" + this.userId + "' " + SqlRunner.END_DELIM;
            if (this.countries != null) {
                n = 0;
                while (n < this.countries.length) {
                    string = string + "INSERT INTO TIGRIS.USERIDCOUNTRY " + "( USERID, COUNTRYCODEIND, DBUSER, CHANGEDTIME )" + "VALUES ( " + "'" + this.userId + "', " + "" + this.countries[n] + ", " + "'" + UserSystem.getUserId() + "', " + "CURRENT TIMESTAMP )" + SqlRunner.END_DELIM;
                    ++n;
                }
            }
            switch (this.getRecStatus()) {
                case 2: {
                    string = string + "INSERT INTO TIGRIS.USERLANGUAGE " + "(USERID, LANGUAGEIND, DBUSER, CHANGEDTIME ) " + "VALUES ( " + "'" + this.userId + "', " + "" + this.languageInd + ", " + "'" + UserSystem.getUserId() + "', " + "CURRENT TIMESTAMP )" + SqlRunner.END_DELIM;
                    break;
                }
                case 1: {
                    string = string + "UPDATE TIGRIS.USERLANGUAGE " + "SET LANGUAGEIND = " + this.languageInd + ", " + "    DBUSER      = '" + UserSystem.getUserId() + "', " + "    CHANGEDTIME = CURRENT TIMESTAMP " + "WHERE USERID = '" + this.userId + "'" + SqlRunner.END_DELIM;
                    break;
                }
            }
            string = string + "DELETE FROM TIGRIS.USERIDBRAND WHERE USERID = '" + this.userId + "' " + SqlRunner.END_DELIM;
            if (this.brandMgrVec != null && this.brandMgrVec.size() > 0) {
                n = 0;
                int n2 = this.brandMgrVec.size();
                while (n < n2) {
                    string = string + "INSERT INTO TIGRIS.USERIDBRAND " + "( USERID, BRANDIND, TYPEBRANDMGR, DBUSER, CHANGEDTIME )" + "VALUES ( " + "'" + this.userId + "', " + "" + ((BrandMgrRec)this.brandMgrVec.elementAt(n)).getBrandInd() + ", " + "'" + ((BrandMgrRec)this.brandMgrVec.elementAt(n)).getBrandMgrType() + "', " + "'" + UserSystem.getUserId() + "', " + "CURRENT TIMESTAMP )" + SqlRunner.END_DELIM;
                    ++n;
                }
            }
            if (!(bl = QITSqlRunner.sqlRunner(string))) return bl;
            if (this.getRecStatus() == 2) {
                UserSystem.addUserRec(this);
            }
            this.updateRecStatus(0);
            return bl;
        }
        catch (Exception exception) {
            if (LogSystem.getInstance() != null) {
                LogSystem.log(1, exception, false);
                return bl;
            }
            LogSystem.logExceptionToFile(exception, "c:\\UserRec.err");
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object object) {
        boolean bl = false;
        if (object == null) return bl;
        if (!(object instanceof UserRec)) {
            if (!(object instanceof String)) return bl;
            String string = (String)object;
            if (this.userId == null) return bl;
            return string.equals(this.userId);
        }
        UserRec userRec = (UserRec)object;
        try {
            if (!this.userId.equals(userRec.userId)) return false;
            if (!this.name.equals(userRec.name)) return false;
            if (!this.manager.equals(userRec.manager)) return false;
            if (!this.eMail.equals(userRec.eMail)) return false;
            if (!this.managerEMail.equals(userRec.managerEMail)) return false;
            if (!this.phone.equals(userRec.phone)) return false;
            if (this.languageInd == userRec.languageInd) return true;
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean fuzzyEquals(String string) {
        boolean bl = false;
        try {
            string = string.toUpperCase();
            if (this.userId != null) {
                boolean bl2 = bl = this.userId.toUpperCase().indexOf(string) >= 0;
            }
            if (this.name != null && !bl) {
                boolean bl3 = bl = this.name.toUpperCase().indexOf(string) >= 0;
            }
            if (this.manager != null && !bl) {
                boolean bl4 = bl = this.manager.toUpperCase().indexOf(string) >= 0;
            }
            if (this.eMail != null && !bl) {
                boolean bl5 = bl = this.eMail.toUpperCase().indexOf(string) >= 0;
            }
            if (this.managerEMail != null && !bl) {
                bl = this.managerEMail.toUpperCase().indexOf(string) >= 0;
            }
            if (this.phone == null) return bl;
            if (bl) return bl;
            if (this.phone.toUpperCase().indexOf(string) >= 0) return true;
            return false;
        }
        catch (Exception exception) {
        }
        return bl;
    }

    public void setToString(String string) {
        this.toString = string;
    }

    public boolean isManager() {
        return this.isManager;
    }

    public String getBackUp() {
        return this.backUp;
    }

    public void setBackUp(String string) {
        this.backUp = string;
    }

    public void addCountry(int n) {
        if (this.countries != null && !this.hasCountry(n)) {
            int[] nArray = new int[this.countries.length + 1];
            System.arraycopy(this.countries, 0, nArray, 0, this.countries.length);
            nArray[nArray.length - 1] = n;
            this.countries = nArray;
        } else {
            this.countries = new int[1];
            this.countries[0] = n;
        }
    }

    public void removeCountry(int n) {
        int n2 = 0;
        if (this.countries != null) {
            Vector<Integer> vector = new Vector<Integer>(this.countries.length);
            while (n2 < this.countries.length) {
                if (this.countries[n2] != n) {
                    vector.addElement(new Integer(this.countries[n2]));
                }
                ++n2;
            }
            n2 = 0;
            this.countries = new int[vector.size()];
            while (n2 < vector.size()) {
                this.countries[n2] = (Integer)vector.elementAt(n2);
                ++n2;
            }
        }
    }

    public int[] getCountries() {
        return this.countries;
    }

    public void setCountries(int[] nArray) {
        this.countries = nArray;
    }

    public void setIsManager(boolean bl) {
        this.isManager = bl;
    }

    public int addBrandMgrRec(BrandMgrRec brandMgrRec) {
        if (this.brandMgrVec == null) {
            this.brandMgrVec = new Vector(1, 1);
        }
        if (!this.brandMgrVec.contains(brandMgrRec)) {
            this.brandMgrVec.addElement(brandMgrRec);
        }
        return this.brandMgrVec.size();
    }

    public int removeBrandMgrRec(BrandMgrRec brandMgrRec) {
        int n = 0;
        if (this.brandMgrVec != null) {
            this.brandMgrVec.removeElement(brandMgrRec);
            n = this.brandMgrVec.size();
        }
        return n;
    }

    public Vector getBrandMgrVec() {
        return this.brandMgrVec;
    }

    public void setBrandMgrVec(Vector vector) {
        this.brandMgrVec = vector;
    }

    private final void cleanSQL() {
        Text.cleanDBString(this.userId);
        Text.cleanDBString(this.name);
        Text.cleanDBString(this.ipAddress);
        Text.cleanDBString(this.manager);
        Text.cleanDBString(this.eMail);
        Text.cleanDBString(this.managerEMail);
        Text.cleanDBString(this.phone);
        Text.cleanDBString(this.password);
        Text.cleanDBString(this.toString);
        Text.cleanDBString(this.backUp);
    }

    public boolean hasCountry(int n) {
        boolean bl = false;
        if (this.countries != null) {
            int n2 = 0;
            while (n2 < this.countries.length && !bl) {
                bl = this.countries[n2] == n;
                ++n2;
            }
        }
        return bl;
    }

    public boolean hasTeam(int n) {
        boolean bl = false;
        if (this.teams != null) {
            int n2 = 0;
            while (n2 < this.teams.length && !bl) {
                bl = this.teams[n2] == n;
                ++n2;
            }
        }
        return bl;
    }

    public Object clone() {
        UserRec userRec = new UserRec(this.userId, this.name);
        userRec.ipAddress = this.ipAddress;
        userRec.manager = this.manager;
        userRec.eMail = this.eMail;
        userRec.managerEMail = this.managerEMail;
        userRec.phone = this.phone;
        userRec.password = this.password;
        userRec.toString = this.toString;
        userRec.backUp = this.backUp;
        userRec.isManager = this.isManager;
        userRec.languageInd = this.languageInd;
        if (this.teams != null) {
            userRec.setTeams(this.teams);
        }
        if (this.auths != null) {
            int n = 0;
            while (n < this.auths.length) {
                userRec.addAuth(this.auths[n]);
                ++n;
            }
        }
        if (this.countries != null) {
            userRec.setCountries(this.countries);
        }
        if (this.brandMgrVec != null) {
            userRec.brandMgrVec = (Vector)this.brandMgrVec.clone();
        }
        return userRec;
    }

    public void setData(UserRec userRec) {
        this.ipAddress = userRec.ipAddress;
        this.manager = userRec.manager;
        this.eMail = userRec.eMail;
        this.managerEMail = userRec.managerEMail;
        this.phone = userRec.phone;
        this.password = userRec.password;
        this.toString = userRec.toString;
        this.backUp = userRec.backUp;
        this.isManager = userRec.isManager;
        this.languageInd = userRec.languageInd;
        this.teams = null;
        if (userRec.teams != null) {
            this.setTeams(userRec.teams);
        }
        this.auths = null;
        if (userRec.auths != null) {
            int n = 0;
            while (n < userRec.auths.length) {
                this.addAuth(userRec.auths[n]);
                ++n;
            }
        }
        this.countries = null;
        if (userRec.countries != null) {
            this.setCountries(userRec.countries);
        }
        if (userRec.brandMgrVec != null) {
            this.brandMgrVec = (Vector)userRec.brandMgrVec.clone();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean changePassword(String string) {
        SQLMethod sQLMethod = new SQLMethod(1, "changePassword", 5);
        boolean bl = false;
        try {
            Statement statement = sQLMethod.createStatement();
            this.password = string;
            statement.executeUpdate("UPDATE TIGRIS.USERID " + "SET PASSWORD    = '" + this.encryptPassword() + "', " + "    ATTEMPTS    = 0, " + "    DBUSER      = '" + UserSystem.getUserId() + "', " + "    CHANGEDTIME = CURRENT TIMESTAMP " + "WHERE USERID    = '" + this.userId + "'");
            bl = true;
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            if (LogSystem.getInstance() != null) {
                LogSystem.log(1, exception, false);
            }
            LogSystem.logExceptionToFile(exception, "c:\\UserRec.err");
        }
        sQLMethod.close();
        return bl;
    }

    public int getAttempts() {
        return this.attempts;
    }

    public void setAttempts(int n) {
        this.attempts = n;
    }

    public boolean hasBPMAuth(int n) {
        boolean bl = false;
        if (this.brandMgrVec != null && this.brandMgrVec.size() > 0) {
            int n2 = 0;
            int n3 = this.brandMgrVec.size();
            while (n2 < n3 && !bl) {
                bl = ((BrandMgrRec)this.brandMgrVec.elementAt(n2)).getBrandInd() == n;
                ++n2;
            }
        }
        return bl;
    }

    public boolean hasBrandAuth(int n) {
        boolean bl = this.hasBPMAuth(n);
        if (!bl) {
            bl = this.hasAuth(QuestUtil.brandAuthFromBrandInd(n));
        }
        return bl;
    }

    public boolean hasAvalonBrandAuth(int n) {
        boolean bl = this.hasBPMAuth(n);
        if (!bl) {
            bl = this.hasAuth(QuestUtil.avalonBrandAuthFromBrandInd(n));
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int login() {
        int n;
        boolean bl;
        SQLMethod sQLMethod;
        block7: {
            sQLMethod = new SQLMethod(1, "UserRec.login", 5);
            bl = false;
            n = 0;
            try {
                Statement statement = sQLMethod.createStatement();
                ResultSet resultSet = statement.executeQuery("SELECT A.PASSWORD, A.NAME, A.ATTEMPTS, B.LANGUAGEIND " + "FROM TIGRIS.USERID A, " + "     TIGRIS.USERLANGUAGE B " + "WHERE A.USERID = '" + this.userId + "' AND " + "      A.USERID = B.USERID " + "FOR FETCH ONLY");
                if (resultSet.next()) {
                    String string = resultSet.getString(1).trim();
                    int n2 = resultSet.getInt(3);
                    if (n2 < 5) {
                        if (string.equals(this.getEncryptedPassword())) {
                            this.userId = this.userId;
                            this.name = resultSet.getString(2).trim();
                            this.languageInd = resultSet.getInt(4);
                            resultSet.close();
                            sQLMethod.close();
                            bl = true;
                            this.readAuthorities();
                            this.readTeams();
                            this.readCountry();
                            this.readBrands();
                            if (n2 > 0) {
                                this.setAttempts(0);
                            }
                            break block7;
                        }
                        n = 2;
                        this.setAttempts(n2 + 1);
                        break block7;
                    }
                    n = 0;
                    break block7;
                }
                n = 1;
            }
            catch (Exception exception) {
                LogSystem.log(1, exception, false);
                sQLMethod.rollBack();
                n = 4;
            }
        }
        if (!bl) {
            sQLMethod.close();
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void setAttemptsNow(int n) throws Exception {
        SQLMethod sQLMethod = new SQLMethod(1, "UserRec.setAttemptsNow", 5);
        try {
            Statement statement = sQLMethod.createStatement();
            statement.executeUpdate("UPDATE TIGRIS.USERID " + "SET ATTEMPTS = " + n + " " + "WHERE USERID = '" + this.userId + "'");
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            sQLMethod.rollBack();
        }
        sQLMethod.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void readAuthorities() {
        SQLMethod sQLMethod = new SQLMethod(1, "UserRec.setAttemptsNow", 5);
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT A.AUTHIND " + "FROM TIGRIS.USERGROUPAUTH A,                   " + "     TIGRIS.USERIDUSERGROUP B                  " + "WHERE B.USERID = '" + this.userId + "' AND " + "      A.USERGROUP = B.USERGROUP                " + "FOR FETCH ONLY                                 ");
            while (true) {
                if (!resultSet.next()) {
                    resultSet.close();
                    break;
                }
                this.addAuth(resultSet.getInt(1));
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            sQLMethod.rollBack();
        }
        sQLMethod.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void readTeams() {
        SQLMethod sQLMethod = new SQLMethod(1, "UserRec.setAttemptsNow", 5);
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT USERGROUP                         " + "FROM TIGRIS.USERIDUSERGROUP              " + "WHERE USERID = '" + this.userId + "' " + "FOR FETCH ONLY                           ");
            while (true) {
                if (!resultSet.next()) {
                    resultSet.close();
                    break;
                }
                this.addTeam(resultSet.getInt(1));
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            sQLMethod.rollBack();
        }
        sQLMethod.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void readCountry() {
        SQLMethod sQLMethod = new SQLMethod(1, "UserRec.setAttemptsNow", 5);
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT COUNTRYCODEIND FROM TIGRIS.USERIDCOUNTRY WHERE USERID = '" + this.userId + "'");
            while (true) {
                if (!resultSet.next()) {
                    resultSet.close();
                    break;
                }
                this.addCountry(resultSet.getInt(1));
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            sQLMethod.rollBack();
        }
        sQLMethod.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void readBrands() {
        SQLMethod sQLMethod = new SQLMethod(1, "UserRec.setAttemptsNow", 5);
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT BRANDIND, TYPEBRANDMGR FROM TIGRIS.USERIDBRAND WHERE USERID = '" + this.userId + "'");
            while (true) {
                if (!resultSet.next()) {
                    resultSet.close();
                    break;
                }
                this.addBrandMgrRec(new BrandMgrRec(resultSet.getString(2).trim(), resultSet.getInt(1)));
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            sQLMethod.rollBack();
        }
        sQLMethod.close();
    }

    public UserRec(String string, String string2) {
        this.setUserId(string);
        this.setName(string2);
        this.initialize();
    }
}

