/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.app;

import com.ibm.nzna.projects.qit.app.UserStatListener;
import com.ibm.nzna.projects.qit.app.UserStatRec;
import com.ibm.nzna.projects.qit.app.util.QuestUtil;
import com.ibm.nzna.shared.util.CDate;
import java.util.Vector;

public class UserStatSystem
implements Runnable {
    private static final String THREAD_FIRESTATUPDATE = "FSU";
    private static Vector statVec = null;
    private static String currentStatDate = null;
    private static String USERSTAT_FILE = "quest.userstat";
    private static String USERSTATDATE_FILE = "quest.userstat_date";
    private static UserStatSystem instance = null;
    private Vector listenerVec = null;

    private final void createFromDisk() {
        Vector vector = (Vector)QuestUtil.readObjectFromDisk(USERSTAT_FILE);
        String string = (String)QuestUtil.readObjectFromDisk(USERSTATDATE_FILE);
        statVec = vector != null ? vector : new Vector();
        if (string != null && !string.equals(currentStatDate)) {
            this.clearStats();
        }
    }

    private final void clearStats() {
        int n = 0;
        if (statVec != null) {
            int n2 = statVec.size();
            while (n < n2) {
                ((UserStatRec)statVec.elementAt(n)).setValue(0);
                ++n;
            }
            UserStatSystem.writeToDisk();
        }
    }

    private final void checkDate() {
        String string = new CDate(2).today();
        if (!string.equals(currentStatDate)) {
            currentStatDate = string;
            this.clearStats();
        }
    }

    private static final UserStatRec userStatRecFromUID(int n) {
        int n2 = 0;
        int n3 = statVec.size();
        UserStatRec userStatRec = null;
        while (userStatRec == null && n2 < n3) {
            if (((UserStatRec)statVec.elementAt(n2)).getUID() == n) {
                userStatRec = (UserStatRec)statVec.elementAt(n2);
            }
            ++n2;
        }
        return userStatRec;
    }

    public static void addStatistic(int n, int n2, String string) {
        if (UserStatSystem.userStatRecFromUID(n) == null) {
            UserStatRec userStatRec = new UserStatRec(n, n2, string);
            statVec.addElement(userStatRec);
            UserStatSystem.writeToDisk();
            new Thread((Runnable)UserStatSystem.getInstance(), THREAD_FIRESTATUPDATE).start();
        }
    }

    public static void incrementStatus(int n) {
        UserStatRec userStatRec = UserStatSystem.userStatRecFromUID(n);
        if (userStatRec != null) {
            userStatRec.incrementValue();
            new Thread((Runnable)UserStatSystem.getInstance(), THREAD_FIRESTATUPDATE).start();
        }
    }

    private static final void writeToDisk() {
        QuestUtil.writeObjectToDisk(USERSTAT_FILE, statVec);
        QuestUtil.writeObjectToDisk(USERSTATDATE_FILE, currentStatDate);
    }

    public static UserStatSystem getInstance() {
        return instance;
    }

    public void run() {
        String string = Thread.currentThread().getName();
        if (string.equals(THREAD_FIRESTATUPDATE)) {
            int n = 0;
            if (this.listenerVec != null) {
                int n2 = this.listenerVec.size();
                while (n < n2) {
                    ((UserStatListener)this.listenerVec.elementAt(n)).userStatChanged();
                    ++n;
                }
            }
        }
    }

    public static void addUserStatListener(UserStatListener userStatListener) {
        if (UserStatSystem.getInstance() != null) {
            if (UserStatSystem.getInstance().listenerVec == null) {
                UserStatSystem.getInstance().listenerVec = new Vector(1, 1);
            }
            UserStatSystem.getInstance().listenerVec.addElement(userStatListener);
        }
    }

    public static void removeUserStatListener(UserStatListener userStatListener) {
        if (UserStatSystem.getInstance().listenerVec != null) {
            UserStatSystem.getInstance().listenerVec.removeElement(userStatListener);
        }
    }

    public static Vector getStatList() {
        if (statVec != null) {
            return (Vector)statVec.clone();
        }
        return null;
    }

    public UserStatSystem() {
        instance = this;
        currentStatDate = new CDate(2).today();
        this.createFromDisk();
    }
}

