/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.app;

import com.ibm.nzna.projects.common.quest.brand.Brands;
import com.ibm.nzna.projects.common.quest.type.TypeBrandRec;
import com.ibm.nzna.projects.common.quest.type.TypeCountryCodeRec;
import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.projects.common.storedProc.StoredProcRec;
import com.ibm.nzna.projects.common.storedProc.StoredProcUtil;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.CacheSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.LoggedUserRec;
import com.ibm.nzna.projects.qit.app.MainWindow;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserRec;
import com.ibm.nzna.projects.qit.gui.StatusWin;
import com.ibm.nzna.projects.qit.storedProc.readUsers.ReadUsers;
import com.ibm.nzna.shared.db.DatabaseSystem;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.util.LogSystem;
import java.awt.Frame;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;

public class UserSystem
implements AppConst {
    private static LoggedUserRec loggedUser = null;
    private static Vector allUserVec = null;

    public static boolean hasAuthority(int n) {
        boolean bl = false;
        if (loggedUser != null) {
            return loggedUser.hasAuth(n);
        }
        return bl;
    }

    public static boolean hasBrandAuth(int n) {
        return loggedUser.hasBrandAuth(n);
    }

    public static boolean hasBPMAuth() {
        boolean bl = false;
        if (loggedUser.getBrandMgrVec() != null && loggedUser.getBrandMgrVec().size() > 0) {
            return true;
        }
        bl = UserSystem.hasAuthority(1);
        return bl;
    }

    public static boolean logonUser(String string, String string2) {
        boolean bl = false;
        LoggedUserRec loggedUserRec = null;
        if (MainWindow.getInstance() != null) {
            MainWindow.getInstance().setStatus(139);
        }
        loggedUserRec = new LoggedUserRec(string.trim(), "");
        loggedUserRec.setPassword(string2);
        PropertySystem.put(18, "");
        switch (loggedUserRec.login()) {
            case 2: {
                GUISystem.printBox(Str.getStr(6), Str.getStr(138));
                break;
            }
            case 3: {
                GUISystem.printBox(Str.getStr(6), Str.getStr(140));
                break;
            }
            case 1: {
                GUISystem.printBox(Str.getStr(6), Str.getStr(141));
                break;
            }
            case 4: {
                GUISystem.printBox(Str.getStr(6), Str.getStr(1663));
                break;
            }
            case 0: {
                bl = true;
                loggedUser = loggedUserRec;
                break;
            }
        }
        if (MainWindow.getInstance() != null) {
            MainWindow.getInstance().setStatus(null);
        }
        return bl;
    }

    public static String getUserName() {
        if (loggedUser != null) {
            return loggedUser.getName();
        }
        return "No User Logged";
    }

    public static String getUserId() {
        if (loggedUser != null) {
            return loggedUser.getUserId();
        }
        return "NO_USER";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getLanguage() {
        try {
            return loggedUser.getLanguage();
        }
        catch (Exception exception) {
            return 1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean setLanguage(int n) {
        SQLMethod sQLMethod = new SQLMethod(1, "UserSystem.setLanguage", 5);
        Statement statement = sQLMethod.createStatement();
        boolean bl = false;
        try {
            statement.executeUpdate("UPDATE TIGRIS.USERLANGUAGE " + "SET LANGUAGEIND = " + n + " " + "WHERE USERID = '" + loggedUser.getUserId() + "'");
            loggedUser.setLanguage(n);
            Str.switchLanguage(n);
            PropertySystem.putInt(1, n);
            bl = true;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
            sQLMethod.rollBack();
        }
        sQLMethod.close();
        return bl;
    }

    public static boolean setPassword(String string) {
        loggedUser.setPassword(string);
        loggedUser.setAttempts(0);
        return loggedUser.saveToDatabase();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LoggedUserRec getLoggedUserRec() {
        try {
            return (LoggedUserRec)loggedUser.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void setLoggedUserRec(LoggedUserRec loggedUserRec) {
        loggedUser = loggedUserRec;
    }

    public static boolean refreshAllUsers() {
        boolean bl = false;
        Vector vector = UserSystem.getChangedCachedUsers();
        if (vector != null) {
            int n = 0;
            Frame frame = new Frame();
            StatusWin statusWin = new StatusWin(frame);
            statusWin.setText("Caching " + vector.size() + " users");
            if (allUserVec == null) {
                allUserVec = new Vector(600, 1);
            }
            if (vector.size() > 0) {
                int n2 = vector.size();
                int n3 = 0;
                String string = null;
                int n4 = 200;
                int n5 = 0;
                statusWin.setMaxValue(n2);
                bl = true;
                while (bl && n < n2) {
                    string = "";
                    n5 = 0;
                    n3 = n;
                    while (n3 < n + n4) {
                        if (n3 < n2) {
                            string = string + "'" + (String)vector.elementAt(n3) + "'";
                            ++n5;
                            if (n3 < n + (n4 - 1) && n3 < n2 - 1) {
                                string = string + ",";
                            }
                        } else {
                            n3 = n + n4;
                        }
                        ++n3;
                    }
                    statusWin.setText("Reading " + n + "-" + (n + n5) + " of " + n2 + " users");
                    statusWin.setValue(n);
                    bl = UserSystem.refreshUsersJDBC(string);
                    n += n4;
                }
            } else {
                LogSystem.log(1, "Cannot read in World Wide user list.");
            }
            if (bl) {
                CacheSystem.cacheObject("users.allUserVec", allUserVec);
            }
            statusWin.dispose();
            frame.dispose();
        } else {
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final boolean refreshUsers(String string) {
        boolean bl = false;
        SQLMethod sQLMethod = new SQLMethod(1, "UserSystem.refreshUsers ()", 5);
        CallableStatement callableStatement = sQLMethod.createStoredProc("QUEST.ReadUsers", 3);
        if (MainWindow.getInstance() != null) {
            MainWindow.getInstance().setStatus(194);
        }
        try {
            Vector vector = null;
            callableStatement.setBytes(1, string.getBytes());
            callableStatement.registerOutParameter(2, -4);
            callableStatement.registerOutParameter(3, -4);
            callableStatement.execute();
            StoredProcRec storedProcRec = (StoredProcRec)StoredProcUtil.getObjectFromStatement(callableStatement, 3);
            if (storedProcRec != null && storedProcRec.error) {
                LogSystem.log(1, storedProcRec.errorStr);
                LogSystem.log(1, storedProcRec.userError);
            } else {
                vector = (Vector)StoredProcUtil.getObjectFromStatement(callableStatement, 2);
                bl = true;
                if (vector != null && vector.size() > 0) {
                    int n = 0;
                    int n2 = vector.size();
                    while (n < n2) {
                        allUserVec.addElement(vector.elementAt(n));
                        ++n;
                    }
                }
            }
            bl = true;
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception);
        }
        sQLMethod.close();
        if (MainWindow.getInstance() != null) {
            MainWindow.getInstance().setStatus(null);
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final boolean refreshUsersJDBC(String string) {
        boolean bl = false;
        Connection connection = DatabaseSystem.getConnection(1);
        if (MainWindow.getInstance() != null) {
            MainWindow.getInstance().setStatus(194);
        }
        try {
            Vector vector = null;
            vector = ReadUsers.readUsers(connection, string);
            bl = true;
            if (vector != null && vector.size() > 0) {
                int n = 0;
                int n2 = vector.size();
                while (n < n2) {
                    allUserVec.addElement(vector.elementAt(n));
                    ++n;
                }
            }
            bl = true;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
        DatabaseSystem.releaseConnection(DatabaseSystem.getDatabaseFromConnection(connection));
        if (MainWindow.getInstance() != null) {
            MainWindow.getInstance().setStatus(null);
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final Vector getChangedCachedUsers() {
        var0 = CacheSystem.getCacheTime("users.allUserVec");
        var1_1 = (Vector)CacheSystem.getCachedObject("users.allUserVec");
        var2_2 = new SQLMethod(1, "UserSystem.getChangedCachedUsers", 5);
        var3_3 = null;
        UserSystem.allUserVec = var1_1;
        if (MainWindow.getInstance() != null) {
            MainWindow.getInstance().setStatus(Str.getStr(195));
        }
        try {
            block6: {
                var4_4 = var2_2.createStatement();
                var5_6 = var4_4.executeQuery("SELECT DISTINCT USERID FROM TIGRIS.USERID WHERE CHANGEDTIME > '" + var0 + "'");
                if (!var5_6.next()) break block6;
                var3_3 = new Vector<String>(1, 1);
                UserSystem.removeUserId(var5_6.getString(1).trim());
                var3_3.addElement(var5_6.getString(1).trim());
                if (true) ** GOTO lbl33
            }
            var3_3 = null;
            UserSystem.allUserVec = var1_1;
lbl19:
            // 2 sources

            while (true) {
                var5_6.close();
                var4_4.close();
                break;
            }
        }
        catch (Exception var4_5) {
            LogSystem.log(1, var4_5, false);
        }
        var2_2.close();
        if (MainWindow.getInstance() != null) {
            MainWindow.getInstance().setStatus(null);
        }
        return var3_3;
        do {
            UserSystem.removeUserId(var5_6.getString(1).trim());
            var3_3.addElement(var5_6.getString(1).trim());
lbl33:
            // 2 sources

        } while (var5_6.next());
        ** while (true)
    }

    public static Vector getAllUserVec() {
        return allUserVec;
    }

    public static String getNameFromUserId(String string) {
        UserRec userRec = UserSystem.getUserRecFromUserId(string);
        if (userRec != null) {
            return userRec.getName();
        }
        return "?";
    }

    public static String getUserIdFromName(String string) {
        String string2 = null;
        if (allUserVec != null) {
            int n = 0;
            int n2 = allUserVec.size();
            UserRec userRec = null;
            while (string == null && n < n2) {
                userRec = (UserRec)allUserVec.elementAt(n);
                if (userRec.getName().equals(string)) {
                    string2 = userRec.getUserId();
                }
                ++n;
            }
        }
        return string2;
    }

    public static UserRec getBrandProgramManager(int n, String string) {
        UserRec userRec = null;
        return userRec;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getBrandProgramManager(int n) {
        SQLMethod sQLMethod = new SQLMethod(1, "getBrandProgramManager ( " + n + " )", 5);
        String string = null;
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT OWNER FROM TIGRIS.TYPEBRAND WHERE BRANDIND = " + n + " FOR FETCH ONLY");
            if (resultSet.next()) {
                string = resultSet.getString(1);
            }
            if (string != null) {
                string = string.trim();
            }
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception, false);
            GUISystem.printBox(7, 202);
        }
        sQLMethod.close();
        return string;
    }

    public static UserRec getUserRecFromName(String string) {
        UserRec userRec = null;
        if (allUserVec != null) {
            int n = 0;
            int n2 = allUserVec.size();
            UserRec userRec2 = null;
            while (n < n2 && userRec == null) {
                userRec2 = (UserRec)allUserVec.elementAt(n);
                if (userRec2.getName().equals(string)) {
                    userRec = userRec2;
                }
                ++n;
            }
        }
        return userRec;
    }

    public static UserRec getUserRecFromUserId(String string) {
        UserRec userRec = null;
        if (allUserVec != null) {
            int n = 0;
            int n2 = allUserVec.size();
            UserRec userRec2 = null;
            while (n < n2 && userRec == null) {
                userRec2 = (UserRec)allUserVec.elementAt(n);
                if (userRec2.getUserId().equals(string)) {
                    userRec = userRec2;
                }
                ++n;
            }
        }
        return userRec;
    }

    public static Vector getManagerList() {
        Vector vector = new Vector(1, 1);
        if (allUserVec != null) {
            int n = 0;
            int n2 = allUserVec.size();
            while (n < n2) {
                if (((UserRec)allUserVec.elementAt(n)).isManager()) {
                    vector.addElement(allUserVec.elementAt(n));
                }
                ++n;
            }
        }
        return vector;
    }

    public static void addUserRec(UserRec userRec) {
        if (allUserVec != null) {
            allUserVec.addElement(userRec);
        }
    }

    public static Vector getUserCountries(String string) {
        return UserSystem.getUserCountries(UserSystem.getUserRecFromUserId(string));
    }

    public static Vector getUserCountries(UserRec userRec) {
        if (userRec.getUserId().equals(UserSystem.getUserId())) {
            return UserSystem.getLoggedUserCountries();
        }
        if (userRec != null) {
            int[] nArray = userRec.getCountries();
            Vector<Object> vector = new Vector<Object>(1, 1);
            TypeList typeList = TypeList.getInstance();
            if (nArray != null) {
                int n = 0;
                while (n < nArray.length) {
                    vector.addElement(typeList.objectFromInd(nArray[n], 3));
                    ++n;
                }
            }
            return vector;
        }
        return null;
    }

    public static Vector getLoggedUserCountries() {
        if (loggedUser != null) {
            int[] nArray = loggedUser.getCountries();
            Vector<Object> vector = new Vector<Object>(1, 1);
            TypeList typeList = TypeList.getInstance();
            if (nArray != null) {
                int n = 0;
                while (n < nArray.length) {
                    vector.addElement(typeList.objectFromInd(nArray[n], 3));
                    ++n;
                }
            }
            return vector;
        }
        return null;
    }

    public static void setUserAddress(String string) {
    }

    public static Vector getUserCountries() {
        return UserSystem.getUserCountries(UserSystem.getUserId());
    }

    public static boolean hasCountries(Vector vector) {
        boolean bl = false;
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            while (!bl && n < n2) {
                bl = UserSystem.hasCountry((TypeCountryCodeRec)vector.elementAt(n));
                ++n;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    public static boolean hasCountry(TypeCountryCodeRec typeCountryCodeRec) {
        return UserSystem.hasCountry(typeCountryCodeRec.getInd());
    }

    public static boolean hasCountry(int n) {
        return loggedUser.hasCountry(n);
    }

    public static Vector getUserBrands() {
        Vector vector = new Vector(1, 1);
        Vector vector2 = Brands.getBrands();
        if (vector2 != null && vector2.size() > 0) {
            int n = 0;
            int n2 = vector2.size();
            while (n < n2) {
                if (UserSystem.hasBrandAuth(((TypeBrandRec)vector2.elementAt(n)).getInd())) {
                    vector.addElement(vector2.elementAt(n));
                }
                ++n;
            }
        }
        return vector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final Vector getUniqueUserIdsFromDatabase() {
        Vector vector = null;
        SQLMethod sQLMethod = new SQLMethod(1, "UserSystem.getUniqueUserIdsFromDatabase ()", 5);
        CallableStatement callableStatement = sQLMethod.createStoredProc("QUEST.ReadUsers", 3);
        if (MainWindow.getInstance() != null) {
            MainWindow.getInstance().setStatus(194);
        }
        try {
            Vector vector2 = null;
            callableStatement.setBytes(1, new String("UNIQUE_USERS").getBytes());
            callableStatement.registerOutParameter(2, -4);
            callableStatement.registerOutParameter(3, -4);
            callableStatement.execute();
            StoredProcRec storedProcRec = (StoredProcRec)StoredProcUtil.getObjectFromStatement(callableStatement, 3);
            if (storedProcRec != null && storedProcRec.error) {
                LogSystem.log(1, storedProcRec.errorStr);
                LogSystem.log(1, storedProcRec.userError);
            } else {
                vector = vector2 = (Vector)StoredProcUtil.getObjectFromStatement(callableStatement, 2);
            }
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception, false);
        }
        sQLMethod.close();
        if (MainWindow.getInstance() != null) {
            MainWindow.getInstance().setStatus(null);
        }
        return vector;
    }

    private static final void removeUserId(String string) {
        UserRec userRec;
        if (string != null && allUserVec != null && (userRec = UserSystem.getUserRecFromUserId(string)) != null) {
            allUserVec.removeElement(userRec);
        }
    }
}

