/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.app.userProp;

import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.CacheSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.userProp.BrandListFilter;
import com.ibm.nzna.projects.qit.app.userProp.TypeListFilter;
import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.util.FileUtil;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class CachePage
extends JPanel
implements AppConst,
ActionListener {
    private JCheckBox ck_CACHE_LISTS = null;
    private JCheckBox ck_CACHE_BRANDS = null;
    private DButton pb_CLEAR = null;

    private final void initialize() {
        this.ck_CACHE_LISTS = new JCheckBox(Str.getStr(1635));
        this.ck_CACHE_BRANDS = new JCheckBox(Str.getStr(1634));
        this.pb_CLEAR = new DButton(Str.getStr(1636));
        this.pb_CLEAR.addActionListener(this);
        this.setLayout(null);
        this.add(this.ck_CACHE_LISTS);
        this.add(this.ck_CACHE_BRANDS);
        this.add(this.pb_CLEAR);
        this.refreshData();
    }

    private final void refreshData() {
        this.ck_CACHE_LISTS.setSelected(PropertySystem.getBool(78));
        this.ck_CACHE_BRANDS.setSelected(PropertySystem.getBool(79));
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = 5;
        int n2 = 5;
        int n3 = GUISystem.getRowHeight();
        super.doLayout();
        this.ck_CACHE_LISTS.setBounds(n2, n, dimension.width - n2 * 2, n3);
        this.ck_CACHE_BRANDS.setBounds(n2, n += n3, dimension.width - n2 * 2, n3);
        this.pb_CLEAR.setBounds(n2, n += n3 * 2, 100, 25);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.pb_CLEAR) {
            this.clearListCache();
            this.clearBrandCache();
            GUISystem.printBox(7, 375);
        }
    }

    protected boolean saveInfo() {
        boolean bl = this.ck_CACHE_LISTS.isSelected();
        boolean bl2 = this.ck_CACHE_BRANDS.isSelected();
        PropertySystem.putBool(78, bl);
        PropertySystem.putBool(79, bl2);
        if (!bl) {
            this.clearListCache();
        }
        if (!bl2) {
            this.clearBrandCache();
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private final void clearListCache() {
        File file = new File(CacheSystem.getCacheDir());
        if (file == null) return;
        String[] stringArray = file.list(new TypeListFilter());
        int n = 0;
        if (stringArray == null) return;
        if (stringArray.length <= 1) return;
        while (n < stringArray.length) {
            try {
                FileUtil.deleteFile(stringArray[n]);
            }
            catch (Exception exception) {
            }
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private final void clearBrandCache() {
        File file = new File(CacheSystem.getCacheDir());
        if (file == null) return;
        String[] stringArray = file.list(new BrandListFilter());
        int n = 0;
        if (stringArray == null) return;
        if (stringArray.length <= 1) return;
        while (n < stringArray.length) {
            try {
                FileUtil.deleteFile(stringArray[n]);
            }
            catch (Exception exception) {
            }
            ++n;
        }
    }

    public CachePage() {
        this.initialize();
    }
}

