/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.app.util;

import com.ibm.nzna.projects.common.quest.Constants;
import com.ibm.nzna.projects.common.quest.type.TypeCountryCodeRec;
import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.Authority;
import com.ibm.nzna.projects.qit.app.DisplayRec;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.wordproc.StampedGraphicFactory;
import com.ibm.nzna.shared.ftp.FTP.Ftp;
import com.ibm.nzna.shared.pom.PersistentRec;
import com.ibm.nzna.shared.util.CDate;
import com.ibm.nzna.shared.util.FileUtil;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.Text;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;

public class QuestUtil
implements Runnable,
AppConst,
Authority {
    private static final String THREAD_POPULATE_TEMP_DIR = "TPTD";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object readObjectFromDisk(String string) {
        Object object = null;
        try {
            return FileUtil.readObjectFromDisk(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (Exception exception) {
            object = null;
            LogSystem.log(1, exception, false);
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean writeObjectToDisk(String string, Object object) {
        boolean bl = false;
        try {
            return FileUtil.writeObjectToDisk(string, object);
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
        return bl;
    }

    public static void populateTempDir() {
        new Thread((Runnable)new QuestUtil(), THREAD_POPULATE_TEMP_DIR).start();
    }

    private static final void populateTemp() {
        String string = "skins" + File.separator + PropertySystem.getString(21) + File.separator;
        QuestUtil.copyFileToTempDir(string + "doclink.gif");
        StampedGraphicFactory.copyToTemp();
    }

    public static boolean copyFileToTempDir(String string) {
        return QuestUtil.copyFileToTempDir(string, Text.stripPath(string));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean copyFileToTempDir(String string, String string2) {
        boolean bl = false;
        try {
            String string3 = PropertySystem.getString(30) + File.separator;
            if (string3 == null) {
                LogSystem.log(2, "Not copying file " + string + " because Temp Directory is invalid or null");
                return bl;
            }
            LogSystem.log(2, "Copying file :" + string + "  To :" + string3 + string2);
            if (FileUtil.copyFile(string, string3 + string2)) {
                bl = FileUtil.exists(string3 + string2);
            }
            if (bl) return bl;
            GUISystem.printBox(Str.getStr(6), Str.getStr(435) + " - " + string);
            return bl;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean writeTempFile(String string, byte[] byArray) {
        boolean bl = false;
        try {
            if (string == null) return bl;
            if (string.length() <= 0) return bl;
            if (byArray == null) return bl;
            if (byArray.length <= 0) return bl;
            try {
                String string2 = PropertySystem.getString(30);
                File file = new File(string2 + File.separator + string);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(byArray);
                fileOutputStream.close();
                return true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
                return bl;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return bl;
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean writeObjectToTemp(String string, Object object) {
        boolean bl = false;
        try {
            String string2 = PropertySystem.getString(30);
            return FileUtil.writeObjectToDisk(string2 + File.separator + string, object);
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object readObjectFromTemp(String string) {
        Object object = null;
        try {
            String string2 = PropertySystem.getString(30);
            return FileUtil.readObjectFromDisk(string2 + File.separator + string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (Exception exception) {
            object = null;
            LogSystem.log(1, exception, false);
        }
        return object;
    }

    public static Vector getDataFromDisplay(Vector vector) {
        Vector<Object> vector2 = null;
        if (vector != null) {
            int n = vector.size();
            int n2 = 0;
            vector2 = new Vector<Object>(n);
            while (n2 < n) {
                vector2.addElement(((DisplayRec)vector.elementAt(n2)).getData());
                ++n2;
            }
        }
        return vector2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void clearTempDir() {
        try {
            String string = PropertySystem.getString(30);
            File file = new File(string);
            String[] stringArray = file.list();
            if (stringArray == null) return;
            if (stringArray.length <= 0) return;
            int n = 0;
            while (true) {
                if (n >= stringArray.length) {
                    return;
                }
                new File(string + File.separator + stringArray[n]).delete();
                ++n;
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
    }

    public static Vector getCountriesFromGeo(Vector vector, int n) {
        Vector vector2 = TypeList.getInstance().getTypeList(3);
        if (vector == null) {
            vector = new Vector(1, 1);
        }
        if (vector2 != null) {
            int n2 = vector2.size();
            int n3 = 0;
            while (n3 < n2) {
                if (((TypeCountryCodeRec)vector2.elementAt((int)n3)).geoInd == n) {
                    vector.addElement(vector2.elementAt(n3));
                }
                ++n3;
            }
        }
        return vector;
    }

    public static Vector getValidData(Vector vector) {
        if (vector != null) {
            Vector vector2 = new Vector(vector.size());
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                if (((PersistentRec)vector.elementAt(n)).valid()) {
                    vector2.addElement(vector.elementAt(n));
                }
                ++n;
            }
            return vector2;
        }
        return null;
    }

    public static boolean containsValid(Vector vector) {
        boolean bl = false;
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            while (bl && n < n2) {
                if (((PersistentRec)vector.elementAt(n)).valid()) {
                    bl = true;
                }
                ++n;
            }
        }
        return bl;
    }

    public static int brandAuthFromBrandInd(int n) {
        int n2 = -1;
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 10;
                break;
            }
            case 2: {
                n2 = 7;
                break;
            }
            case 3: {
                n2 = 6;
                break;
            }
            case 4: {
                n2 = 11;
                break;
            }
            case 5: {
                n2 = 12;
                break;
            }
            case 6: {
                n2 = 9;
                break;
            }
            case 7: {
                n2 = 13;
                break;
            }
            case 8: {
                n2 = 14;
                break;
            }
            case 9: {
                n2 = 15;
                break;
            }
            case 10: {
                n2 = 8;
                break;
            }
            case 13: 
            case 14: {
                n2 = 6;
                break;
            }
            default: {
                n2 = 0;
                break;
            }
        }
        return n2;
    }

    public static int avalonBrandAuthFromBrandInd(int n) {
        int n2 = -1;
        switch (n) {
            case 0: {
                n2 = 1;
                break;
            }
            case 1: {
                n2 = 31;
                break;
            }
            case 2: {
                n2 = 28;
                break;
            }
            case 3: {
                n2 = 27;
                break;
            }
            case 4: {
                n2 = 32;
                break;
            }
            case 5: {
                n2 = 33;
                break;
            }
            case 6: {
                n2 = 30;
                break;
            }
            case 7: {
                n2 = 34;
                break;
            }
            case 8: {
                n2 = 35;
                break;
            }
            case 9: {
                n2 = 36;
                break;
            }
            case 10: {
                n2 = 29;
                break;
            }
            case 13: 
            case 14: {
                n2 = 27;
                break;
            }
            default: {
                n2 = 1;
                break;
            }
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void cleanOldLogFiles() {
        int n = PropertySystem.getInt(73);
        try {
            int n2;
            File file = new File(".");
            String[] stringArray = file.list();
            String string = "quest.debug.";
            Vector<String> vector = new Vector<String>(1);
            if (stringArray != null && stringArray.length > 1) {
                String string2 = new CDate(1).today();
                n2 = 0;
                while (n2 < stringArray.length) {
                    String string3;
                    if (stringArray[n2].indexOf("quest.debug") >= 0 && stringArray[n2].length() > string.length() + 1 && (CDate.differenceDate(string2, string3 = stringArray[n2].substring(string.length()), 1) > (long)n || n == 0)) {
                        vector.addElement(stringArray[n2]);
                    }
                    ++n2;
                }
            }
            if (vector.size() <= 0) return;
            int n3 = 0;
            n2 = vector.size();
            while (true) {
                if (n3 >= n2) {
                    return;
                }
                LogSystem.log(1, "Deleting file OLD log file:" + vector.elementAt(n3));
                FileUtil.deleteFile((String)vector.elementAt(n3));
                ++n3;
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Ftp connectToProductionFileFTP() {
        String string = Constants.getStrConst("IT_FILEHOST");
        Ftp ftp = null;
        try {
            ftp = new Ftp();
            ftp.setHost(string);
            ftp.setUser("quest");
            ftp.setPassword("j0hnny");
            ftp.connect();
            ftp.login();
            return ftp;
        }
        catch (Exception exception) {
            LogSystem.log(1, "Could not log into FTP Server:" + string);
            LogSystem.log(1, exception, false);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Ftp connectToTempFileFTP() {
        String string = Constants.getStrConst("IT_FILEHOSTTEMP");
        Ftp ftp = null;
        try {
            ftp = new Ftp();
            ftp.setHost(string);
            ftp.setUser("quest");
            ftp.setPassword("j0hnny");
            ftp.connect();
            ftp.login();
            return ftp;
        }
        catch (Exception exception) {
            LogSystem.log(1, "Could not log into FTP Server:" + string);
            LogSystem.log(1, exception, false);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Ftp connectToProductionGraphicFTP() {
        String string = Constants.getStrConst("IT_IMAGEHOST");
        Ftp ftp = null;
        try {
            ftp = new Ftp();
            ftp.setHost(string);
            ftp.setUser("quest");
            ftp.setPassword("j0hnny");
            ftp.connect();
            ftp.login();
            ftp.setType('I');
            return ftp;
        }
        catch (Exception exception) {
            LogSystem.log(1, "Could not log into Graphics Production FTP Server:" + string);
            LogSystem.log(1, exception, false);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Ftp connectToTempGraphicFTP() {
        String string = Constants.getStrConst("IT_IMAGEHOSTTEMP");
        Ftp ftp = null;
        try {
            ftp = new Ftp();
            ftp.setHost(string);
            ftp.setUser("quest");
            ftp.setPassword("j0hnny");
            ftp.connect();
            ftp.login();
            ftp.setType('I');
            return ftp;
        }
        catch (Exception exception) {
            LogSystem.log(1, "Could not log into temp Graphic FTP Server:" + string);
            LogSystem.log(1, exception, false);
            return null;
        }
    }

    public void run() {
        String string = Thread.currentThread().getName();
        if (string.equals(THREAD_POPULATE_TEMP_DIR)) {
            Thread.currentThread().setPriority(1);
            QuestUtil.populateTemp();
        }
    }
}

