/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.avalon.base;

import com.ibm.nzna.projects.common.quest.oa.Symptom;
import com.ibm.nzna.projects.common.quest.oa.SymptomDraft;
import com.ibm.nzna.projects.common.quest.oa.SymptomTitle;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.DateSystem;
import com.ibm.nzna.projects.qit.app.MainWindow;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.avalon.base.SymptomDisplayRec;
import com.ibm.nzna.projects.qit.avalon.base.SymptomDraftDisplayRec;
import com.ibm.nzna.projects.qit.avalon.cache.AvalonCache;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.Text;
import java.io.File;
import java.util.Vector;

public class SymptomPreviewRec
implements AppConst {
    private static String previewTemplate = "<html><body bgcolor=\"#FFFFFF\"><p><font size=\"5\" face=\"Arial, Helvetica, sans-serif\">TITLE</font></p><p><font size=\"2\" face=\"Arial, Helvetica, sans-serif\">TITLE_TABLE  <font color=\"#800080\">STR_GEOS</font>:<br>GEOS<br><br>  <font color=\"#800080\">STR_INTERNAL_NUM</font>:INTERNAL_NUM<br>  <font color=\"#800080\">STR_ARCHIVED</font>:ARCHIVED<br>  <font color=\"#800080\">STR_CREATE_DATE</font>:CREATEDATE<br>  <font color=\"#800080\">STR_LAST_TOUCHED_ON</font>:LAST_TOUCHED_ON<br>  <font color=\"#800080\">STR_LAST_TOUCHED_BY</font>:LAST_TOUCHED_BY<br>  <font color=\"#800080\">STR_START_DATE</font>:START_DATE</font><br>  <font color=\"#800080\">STR_STOP_DATE</font>:STOP_DATE</font><br></font></p></body></html>";
    private int symptomInd = 0;
    private String title = null;
    private String prettyCreateDate = null;
    private String prettyChangedTime = null;
    private String prettyDbUser = null;
    private boolean dataValid = false;
    private String geos = null;
    private String archived = null;
    private String titleTable = null;
    private String stopDate = null;
    private String startDate = null;

    public String getPreviewHTMLSource() {
        if (this.dataValid) {
            String string = Text.replaceInStr(previewTemplate, "TITLE", this.title);
            string = Text.replaceInStr(string, "STR_INTERNAL_NUM", Str.getStr(264));
            string = Text.replaceInStr(string, "STR_CREATE_DATE", Str.getStr(948));
            string = Text.replaceInStr(string, "STR_LAST_TOUCHED_ON", Str.getStr(267));
            string = Text.replaceInStr(string, "STR_LAST_TOUCHED_BY", Str.getStr(266));
            string = Text.replaceInStr(string, "STR_GEOS", Str.getStr(148));
            string = Text.replaceInStr(string, "STR_ARCHIVED", Str.getStr(863));
            string = Text.replaceInStr(string, "STR_STOP_DATE", Str.getStr(288));
            string = Text.replaceInStr(string, "STR_START_DATE", Str.getStr(287));
            string = Text.replaceInStr(string, "CREATEDATE", this.prettyCreateDate);
            string = Text.replaceInStr(string, "LAST_TOUCHED_BY", this.prettyDbUser);
            string = Text.replaceInStr(string, "LAST_TOUCHED_ON", this.prettyChangedTime);
            string = Text.replaceInStr(string, "INTERNAL_NUM", "" + this.symptomInd);
            string = Text.replaceInStr(string, "GEOS", this.geos);
            string = Text.replaceInStr(string, "ARCHIVED", this.archived);
            string = Text.replaceInStr(string, "STOP_DATE", this.stopDate);
            string = Text.replaceInStr(string, "START_DATE", this.startDate);
            string = Text.replaceInStr(string, "TITLE_TABLE", this.titleTable);
            return string;
        }
        return "<html><body><center>" + Str.getStr(1241) + "</center><br><br><b>SymptomInd:</b>" + this.symptomInd + "</body></html>";
    }

    private void readPreviewInfo() {
        MainWindow mainWindow = MainWindow.getInstance();
        try {
            Symptom symptom = null;
            mainWindow.setStatus(Str.getStr(142));
            symptom = AvalonCache.readSymptom(this.symptomInd, false);
            if (symptom != null) {
                Vector vector = symptom.getSymptomTitles();
                Vector vector2 = symptom.getCountryList();
                this.title = vector != null && vector.size() > 0 ? vector.elementAt(vector.size() - 1).toString() : Str.getStr(958);
                if (vector2 != null && vector2.size() > 0) {
                    int n = 0;
                    int n2 = vector2.size();
                    this.geos = "";
                    while (n < n2) {
                        this.geos = this.geos + vector2.elementAt(n).toString();
                        if (n < n2 - 1) {
                            this.geos = this.geos + ", ";
                        }
                        ++n;
                    }
                } else {
                    this.geos = " ";
                }
                this.startDate = " ";
                this.stopDate = " ";
                this.prettyCreateDate = symptom.getCreationTime();
                this.prettyChangedTime = DateSystem.prettyDateFromStamp(symptom.getChangedTime());
                this.prettyDbUser = UserSystem.getNameFromUserId(symptom.getDbUser());
                this.formatTitleTable(symptom);
            }
            this.dataValid = true;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            this.dataValid = false;
        }
        mainWindow.setStatus(null);
    }

    private void readDraftPreviewInfo() {
        MainWindow mainWindow = MainWindow.getInstance();
        try {
            SymptomDraft symptomDraft = null;
            mainWindow.setStatus(Str.getStr(142));
            symptomDraft = AvalonCache.readSymptomDraft(this.symptomInd, false);
            if (symptomDraft != null) {
                Vector vector = symptomDraft.getSymptomTitles();
                Vector vector2 = symptomDraft.getCountryList();
                this.title = vector != null && vector.size() > 0 ? vector.elementAt(vector.size() - 1).toString() : Str.getStr(958);
                if (vector2 != null && vector2.size() > 0) {
                    int n = 0;
                    int n2 = vector2.size();
                    this.geos = "";
                    while (n < n2) {
                        this.geos = this.geos + vector2.elementAt(n).toString();
                        if (n < n2 - 1) {
                            this.geos = this.geos + ", ";
                        }
                        ++n;
                    }
                } else {
                    this.geos = " ";
                }
                this.startDate = DateSystem.prettyDateFromDBDate(symptomDraft.getStartDate());
                this.stopDate = DateSystem.prettyDateFromDBDate(symptomDraft.getStopDate());
                this.prettyCreateDate = symptomDraft.getCreationTime();
                this.prettyChangedTime = DateSystem.prettyDateFromStamp(symptomDraft.getChangedTime());
                this.prettyDbUser = UserSystem.getNameFromUserId(symptomDraft.getDbUser());
                if (this.stopDate == null) {
                    this.stopDate = "";
                }
                this.formatTitleTable(symptomDraft);
            }
            this.dataValid = true;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            this.dataValid = false;
        }
        mainWindow.setStatus(null);
    }

    private void formatTitleTable(Symptom symptom) {
        if (symptom != null) {
            Vector vector = symptom.getSymptomTitles();
            if (vector != null && vector.size() > 0) {
                int n = 0;
                int n2 = vector.size();
                StringBuffer stringBuffer = new StringBuffer("</font><TABLE BORDER=0>");
                SymptomTitle symptomTitle = null;
                while (n < n2) {
                    symptomTitle = (SymptomTitle)vector.elementAt(n);
                    stringBuffer.append("<tr>");
                    stringBuffer.append("<td><img src=\"file:/");
                    stringBuffer.append(PropertySystem.getString(30));
                    stringBuffer.append(File.separator);
                    switch (symptomTitle.getDocClass().getInd()) {
                        case 1: {
                            stringBuffer.append("ibm_confidential.gif");
                            break;
                        }
                        case 2: {
                            stringBuffer.append("ibm_dealer_confidential.gif");
                            break;
                        }
                        case 3: {
                            stringBuffer.append("unclassified.gif");
                            break;
                        }
                    }
                    stringBuffer.append("\"></td>");
                    stringBuffer.append("<td><font size=\"2\" face=\"Arial, Helvetica, sans-serif\">");
                    stringBuffer.append(symptomTitle.toString());
                    stringBuffer.append("</td>");
                    stringBuffer.append("</tr>");
                    ++n;
                }
                stringBuffer.append("</table><br><font size=\"2\" face=\"Arial, Helvetica, sans-serif\">");
                this.titleTable = stringBuffer.toString();
            } else {
                this.titleTable = " ";
            }
        } else {
            this.titleTable = " ";
        }
    }

    public SymptomPreviewRec(SymptomDisplayRec symptomDisplayRec) {
        this.symptomInd = symptomDisplayRec.getSymptomInd();
        this.readPreviewInfo();
    }

    public SymptomPreviewRec(SymptomDraftDisplayRec symptomDraftDisplayRec) {
        this.symptomInd = symptomDraftDisplayRec.getSymptomInd();
        this.readDraftPreviewInfo();
    }
}

