/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.avalon.editors;

import com.ibm.nzna.projects.common.quest.oa.ActionDraft;
import com.ibm.nzna.projects.common.quest.oa.AddtlInfo;
import com.ibm.nzna.projects.common.quest.oa.Title;
import com.ibm.nzna.projects.common.quest.type.TypeCountryCodeRec;
import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.util.QuestUtil;
import com.ibm.nzna.projects.qit.gui.Browser;
import com.ibm.nzna.shared.util.FileUtil;
import com.ibm.nzna.shared.util.Text;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.Vector;
import javax.swing.JPanel;

public class ActionPreviewPanel
extends JPanel
implements AppConst {
    private static String htmlTemplate = null;
    private ActionDraft action = null;
    private Browser previewPanel = null;

    private void initialize() {
        try {
            this.previewPanel = new Browser();
            if (htmlTemplate == null) {
                String string = "skins" + File.separator + PropertySystem.getString(21) + File.separator + "avalon" + File.separator;
                htmlTemplate = FileUtil.readFile(string + "action_preview.html");
                QuestUtil.copyFileToTempDir(string + "empty_title.gif", "empty_title.gif");
            }
            this.setLayout(new BorderLayout());
            this.add((Component)((Object)this.previewPanel), "Center");
            this.refreshData();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void refreshData() {
        String string = null;
        if (htmlTemplate != null) {
            string = Text.replaceInStr(htmlTemplate, "STR_ADDITIONAL_INFO", Str.getStr(311));
            string = Text.replaceInStr(string, "STR_GEO", Str.getStr(148));
            if (this.action != null) {
                string = Text.replaceInStr(string, "TITLE", this.getDefaultTitle());
                string = Text.replaceInStr(string, "GEO", this.getGeographyList());
                string = Text.replaceInStr(string, "ADDITIONAL_INFO", this.getDefaultAdditionalInfo());
            } else {
                string = Text.replaceInStr(string, "TITLE", Str.getStr(198));
                string = Text.replaceInStr(string, "GEO", Str.getStr(198));
                string = Text.replaceInStr(string, "ADDITIONAL_INFO", Str.getStr(198));
            }
        } else {
            string = "<html><body><center>" + Str.getStr(965) + "</center></body></html>";
        }
        this.previewPanel.setPageContent(string);
    }

    private String getDefaultTitle() {
        Vector vector = this.action.getTitles();
        String string = Str.getStr(198);
        if (vector != null && vector.size() > 0) {
            string = ((Title)vector.elementAt(vector.size() - 1)).getTitle();
        }
        return string;
    }

    private String getDefaultAdditionalInfo() {
        Vector vector = this.action.getAdditionalInfo();
        String string = Str.getStr(198);
        if (vector != null && vector.size() > 0) {
            string = ((AddtlInfo)vector.elementAt(vector.size() - 1)).getAddtlInfo();
        }
        return string;
    }

    private String getGeographyList() {
        Vector vector = this.action.getCountryList();
        String string = null;
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                string = string + TypeList.getInstance().stringFromInd(((TypeCountryCodeRec)vector.elementAt((int)n)).geoInd, 6);
                if (n < n2 - 1) {
                    string = string + ", ";
                }
                ++n;
            }
        }
        return string;
    }

    public boolean bookmark() {
        return false;
    }

    public ActionPreviewPanel() {
        this.initialize();
    }

    public ActionPreviewPanel(ActionDraft actionDraft) {
        this.action = actionDraft;
        this.initialize();
    }
}

