/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.avalon.editors;

import com.ibm.nzna.projects.common.quest.oa.Answer;
import com.ibm.nzna.projects.common.quest.oa.Edge;
import com.ibm.nzna.projects.common.quest.oa.Question;
import com.ibm.nzna.projects.common.quest.oa.Symptom;
import com.ibm.nzna.projects.common.quest.type.TypeDocClassRec;
import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.FontSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.avalon.base.AnswerDisplayRec;
import com.ibm.nzna.projects.qit.avalon.editors.ObjectNode;
import com.ibm.nzna.shared.gui.ButtonPanel;
import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.gui.MultiList;
import com.ibm.nzna.shared.sort.QuickSort;
import com.ibm.nzna.shared.util.WinUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class EdgeDlg
extends JDialog
implements WindowListener,
ActionListener,
Runnable,
AppConst {
    private static final String THREAD_REFRESH = "REFRESH";
    private static final String[] columnHeadingsAnswers = new String[]{"", "", "", "", "", ""};
    private static final String[] columnHeadingsNodes = new String[]{"", ""};
    private JLabel st_IMAGE = null;
    private JLabel st_QUESTION_TITLE = null;
    private JLabel st_ANSWERS = null;
    private MultiList cnr_ANSWERS = null;
    private MultiList cnr_NODES = null;
    private DButton pb_OK = null;
    private DButton pb_CANCEL = null;
    private DButton pb_HELP = null;
    private ButtonPanel buttonPanel = null;
    private JScrollPane scr_ANSWERS = null;
    private DButton pb_OTHER = null;
    private ImageIcon wizardImage = null;
    private ObjectNode headNode = null;
    private Vector objectNodes = null;
    private Question question = null;
    private Edge edge = null;
    private Symptom symptom = null;

    public boolean getResult() {
        ((Component)this).setVisible(true);
        return this.edge != null;
    }

    public Edge getEdge() {
        return this.edge;
    }

    public ObjectNode getTailNode() {
        return (ObjectNode)this.cnr_NODES.getSelectedItem();
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = GUISystem.getRowHeight();
        int n2 = this.wizardImage.getImage().getWidth(this) + 10;
        int n3 = (dimension.height - 40) / 2 - this.wizardImage.getImage().getHeight(this) / 2;
        super.doLayout();
        this.st_IMAGE.setBounds(5, n3, this.wizardImage.getImage().getWidth(this), this.wizardImage.getImage().getHeight(this));
        this.st_QUESTION_TITLE.setBounds(n2, n3, dimension.width - n2 - 10, n);
        this.st_ANSWERS.setBounds(n2, n3 += n, dimension.width - n2 - 10, n);
        this.cnr_ANSWERS.setBounds(n2, n3 += n, dimension.width - n2 - 10, n * 5);
        this.cnr_NODES.setBounds(n2, n3 += n * 5 + 5, dimension.width - n2 - 10, n * 5);
        this.buttonPanel.setBounds(n2, dimension.height - 78, dimension.width - n2, 25);
    }

    private void refreshData() {
        this.enableControls(false);
        this.st_QUESTION_TITLE.setText(Str.getStr(14));
        this.setTitle(Str.getStr(14));
        this.question = (Question)this.headNode.getObject();
        this.st_QUESTION_TITLE.setText(this.headNode.toString());
        this.cnr_NODES.add(this.getValidObjectNodes(this.objectNodes));
        this.cnr_ANSWERS.add(AnswerDisplayRec.convert(this.question.getAnswers()));
        this.setTitle(Str.getStr(1126));
        this.enableControls(true);
    }

    private void enableControls(boolean bl) {
        this.st_IMAGE.setEnabled(bl);
        this.st_QUESTION_TITLE.setEnabled(bl);
        this.st_ANSWERS.setEnabled(bl);
        this.cnr_ANSWERS.setEnabled(bl);
        this.cnr_NODES.setEnabled(bl);
        this.pb_OK.setEnabled(bl);
        this.pb_CANCEL.setEnabled(bl);
        this.pb_HELP.setEnabled(bl);
        this.pb_OTHER.setEnabled(bl);
    }

    public void run() {
        String string = Thread.currentThread().getName();
        if (string.equals(THREAD_REFRESH)) {
            this.refreshData();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.pb_OK) {
            if (this.saveData(false)) {
                this.dispose();
            }
        } else if (actionEvent.getSource() == this.pb_OTHER) {
            if (this.saveData(true)) {
                this.dispose();
            }
        } else if (actionEvent.getSource() == this.pb_CANCEL) {
            this.edge = null;
            this.dispose();
        }
    }

    private boolean saveData(boolean bl) {
        AnswerDisplayRec answerDisplayRec = (AnswerDisplayRec)this.cnr_ANSWERS.getSelectedItem();
        ObjectNode objectNode = (ObjectNode)this.cnr_NODES.getSelectedItem();
        if (objectNode != null && objectNode.getNode() != this.symptom.getRootNode()) {
            if (bl) {
                this.edge = new Edge(this.question);
            } else if (answerDisplayRec != null && objectNode != null) {
                this.edge = new Edge(this.question, (Answer)answerDisplayRec.getData());
            }
            if (this.edge != null) {
                this.edge.setDocClass((TypeDocClassRec)TypeList.getInstance().objectFromInd(1, 5));
                this.edge.setCountryList(UserSystem.getUserCountries());
                if (answerDisplayRec != null) {
                    this.edge.setDefaultAnswerTitle(answerDisplayRec.getData().toString());
                } else {
                    this.edge.setDefaultAnswerTitle(Str.getStr(1215));
                }
            }
        } else {
            GUISystem.printBox(7, 1357);
        }
        return this.edge != null;
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
        new Thread((Runnable)this, THREAD_REFRESH).start();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    private Vector getValidObjectNodes(Vector vector) {
        Vector vector2 = new Vector(1);
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                if (((ObjectNode)vector.elementAt(n)).getNode().valid()) {
                    vector2.addElement(vector.elementAt(n));
                }
                ++n;
            }
        }
        new QuickSort(vector2);
        return vector2;
    }

    public EdgeDlg(Frame frame, Symptom symptom, ObjectNode objectNode, Vector vector, boolean bl) {
        super(frame, Str.getStr(1126), true);
        Container container = this.getContentPane();
        this.symptom = symptom;
        this.objectNodes = vector;
        this.headNode = objectNode;
        vector.removeElement(objectNode);
        this.wizardImage = ImageSystem.getImageIcon((Object)this, 165);
        this.st_IMAGE = new JLabel(this.wizardImage);
        this.st_QUESTION_TITLE = new JLabel();
        this.st_ANSWERS = new JLabel(Str.getStr(966));
        this.cnr_NODES = new MultiList(GUISystem.getFontUtil());
        this.cnr_ANSWERS = new MultiList(GUISystem.getFontUtil());
        this.buttonPanel = new ButtonPanel();
        this.pb_OK = new DButton(Str.getStr(1));
        this.pb_CANCEL = new DButton(Str.getStr(2));
        this.pb_HELP = new DButton(Str.getStr(10));
        this.pb_OTHER = new DButton(Str.getStr(1215));
        this.pb_OK.addActionListener(this);
        this.pb_CANCEL.addActionListener(this);
        this.pb_HELP.addActionListener(this);
        this.pb_OTHER.addActionListener(this);
        this.addWindowListener(this);
        container.setLayout(null);
        container.add(this.st_IMAGE);
        container.add(this.st_QUESTION_TITLE);
        container.add(this.st_ANSWERS);
        container.add(this.cnr_ANSWERS);
        container.add(this.cnr_NODES);
        container.add(this.buttonPanel);
        this.buttonPanel.add(this.pb_OK);
        this.buttonPanel.add(this.pb_OTHER);
        this.buttonPanel.add(this.pb_CANCEL);
        this.buttonPanel.add(this.pb_HELP);
        GUISystem.setPropertiesOnPanel(container);
        this.st_QUESTION_TITLE.setFont(FontSystem.smallTitleFont);
        this.st_IMAGE.setBorder(GUISystem.loweredBorder);
        this.pb_OTHER.setEnabled(bl);
        this.cnr_ANSWERS.setColumnHeadings(columnHeadingsAnswers);
        this.cnr_ANSWERS.setColumnWidth(0, 1);
        this.cnr_ANSWERS.setColumnWidth(1, 1);
        this.cnr_ANSWERS.setColumnWidth(2, 80);
        this.cnr_ANSWERS.setColumnWidth(3, 300);
        this.cnr_ANSWERS.setColumnWidth(4, 150);
        this.cnr_ANSWERS.setColumnWidth(5, 150);
        this.cnr_ANSWERS.showColumnHeadings(false);
        this.cnr_NODES.setColumnHeadings(columnHeadingsNodes);
        this.cnr_NODES.setColumnWidth(0, 80);
        this.cnr_NODES.setColumnWidth(1, 300);
        this.cnr_NODES.showColumnHeadings(false);
        ((Component)this).setSize(525, 325);
        WinUtil.centerWindow(this);
    }
}

