/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.avalon.editors;

import com.ibm.nzna.projects.common.quest.oa.DocLink;
import com.ibm.nzna.projects.common.quest.oa.Link;
import com.ibm.nzna.projects.common.quest.oa.LinkGroup;
import com.ibm.nzna.projects.common.quest.oa.QuestLink;
import com.ibm.nzna.projects.common.quest.type.TypeCountryCodeRec;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.FontSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.LocaleRec;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.app.util.QuestUtil;
import com.ibm.nzna.projects.qit.avalon.base.DocLinkDisplayRec;
import com.ibm.nzna.projects.qit.avalon.base.LinkDisplayRec;
import com.ibm.nzna.projects.qit.avalon.base.LinkDraftDisplayRec;
import com.ibm.nzna.projects.qit.avalon.base.LinkGroupDisplayRec;
import com.ibm.nzna.projects.qit.avalon.editors.DraftEditPanel;
import com.ibm.nzna.projects.qit.avalon.editors.EditPanel;
import com.ibm.nzna.projects.qit.avalon.gui.ConditionList;
import com.ibm.nzna.projects.qit.avalon.gui.SelectOADlg;
import com.ibm.nzna.projects.qit.avalon.gui.SelectOAListener;
import com.ibm.nzna.projects.qit.bookmark.Bookmark;
import com.ibm.nzna.projects.qit.dbgui.CountrySelectPanel;
import com.ibm.nzna.projects.qit.dbgui.DocClassPanel;
import com.ibm.nzna.projects.qit.gui.JTitle;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.gui.ButtonPanel;
import com.ibm.nzna.shared.gui.HotLinkLabel;
import com.ibm.nzna.shared.gui.MultiList;
import com.ibm.nzna.shared.gui.MultiListRow;
import com.ibm.nzna.shared.gui.ToolBarSeparator;
import com.ibm.nzna.shared.pom.PersistentRec;
import com.ibm.nzna.shared.util.LogSystem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class LinkBinderPanel
extends EditPanel
implements ListSelectionListener,
ActionListener,
SelectOAListener,
AppConst {
    private static final String[] cnrLinkTitles = new String[]{"", "", ""};
    private HotLinkLabel pb_ADD_LINK = null;
    private HotLinkLabel pb_REMOVE_LINK = null;
    private JTitle st_LINKS = null;
    private MultiList cnr_LINKS = null;
    private HotLinkLabel pb_LINK_UP = null;
    private HotLinkLabel pb_LINK_DOWN = null;
    private ButtonPanel buttonPanel = null;
    private ButtonPanel linkButtonPanel = null;
    private JPanel linkPanel = null;
    private ConditionList conditionList = null;
    private DocClassPanel docClassPanel = null;
    private CountrySelectPanel countrySelectPanel = null;
    private Dimension prefSize = new Dimension(300, 500);
    private DocLink currentLink = null;
    private Vector links = null;
    private DraftEditPanel draftEditPanel = null;

    private void initialize() {
        this.pb_ADD_LINK = new HotLinkLabel(Str.getStr(1101));
        this.pb_REMOVE_LINK = new HotLinkLabel(Str.getStr(1100));
        this.st_LINKS = new JTitle(Str.getStr(1099));
        this.cnr_LINKS = new MultiList(GUISystem.getFontUtil());
        this.pb_LINK_UP = new HotLinkLabel(Str.getStr(1044));
        this.pb_LINK_DOWN = new HotLinkLabel(Str.getStr(1045));
        this.buttonPanel = new ButtonPanel();
        this.linkButtonPanel = new ButtonPanel();
        this.conditionList = new ConditionList();
        this.linkPanel = new JPanel();
        this.docClassPanel = new DocClassPanel();
        this.countrySelectPanel = new CountrySelectPanel();
        this.buttonPanel.setBorder(GUISystem.grayBorder);
        this.buttonPanel.setBackground(new Color(230, 230, 230));
        this.buttonPanel.setArrowImage(ImageSystem.getImageIcon((Object)this, 146), ImageSystem.getImageIcon((Object)this, 147));
        this.linkButtonPanel.setBorder(GUISystem.grayBorder);
        this.linkButtonPanel.setBackground(new Color(230, 230, 230));
        this.linkButtonPanel.setArrowImage(ImageSystem.getImageIcon((Object)this, 146), ImageSystem.getImageIcon((Object)this, 147));
        this.pb_ADD_LINK.setOpaque(false);
        this.pb_REMOVE_LINK.setOpaque(false);
        this.setBackground(Color.white);
        GUISystem.setPreferredButton(this.pb_LINK_UP);
        GUISystem.setPreferredButton(this.pb_LINK_DOWN);
        this.linkPanel.setOpaque(false);
        this.cnr_LINKS.setColumnHeadings(cnrLinkTitles);
        this.cnr_LINKS.showColumnHeadings(false);
        this.cnr_LINKS.setBorder(GUISystem.blackBorder);
        this.cnr_LINKS.setColumnWidth(0, 18);
        this.cnr_LINKS.setColumnWidth(1, 100);
        this.cnr_LINKS.setColumnWidth(2, 350);
        this.st_LINKS.setFont(FontSystem.smallTitleFont);
        this.pb_ADD_LINK.addActionListener(this);
        this.pb_REMOVE_LINK.addActionListener(this);
        this.pb_LINK_UP.addActionListener(this);
        this.pb_LINK_DOWN.addActionListener(this);
        this.cnr_LINKS.addListSelectionListener(this);
        this.setLayout(null);
        this.add(this.buttonPanel);
        this.add(this.st_LINKS);
        this.add(this.cnr_LINKS);
        this.add(this.linkButtonPanel);
        this.add(this.docClassPanel);
        this.add(this.conditionList);
        this.add(this.countrySelectPanel);
        this.linkButtonPanel.add(this.pb_LINK_UP);
        this.linkButtonPanel.add(new ToolBarSeparator(new Dimension(1, GUISystem.getRowHeight())));
        this.linkButtonPanel.add(this.pb_LINK_DOWN);
        this.buttonPanel.add(this.pb_ADD_LINK);
        this.buttonPanel.add(new ToolBarSeparator(new Dimension(1, GUISystem.getRowHeight())));
        this.buttonPanel.add(this.pb_REMOVE_LINK);
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = GUISystem.getRowHeight();
        int n2 = dimension.width / 2;
        int n3 = 5;
        int n4 = 15;
        this.buttonPanel.setBounds(n4, n3, dimension.width - n4 * 2, n);
        this.cnr_LINKS.setBounds(n4, n3 += n + 5, dimension.width - n4 * 2, n * 10);
        this.linkButtonPanel.setBounds(n4, n3 += n * 10 + 3, dimension.width - n4 * 2, n);
        this.docClassPanel.setBounds(n4, n3 += n + 5, 250, n * 2);
        this.conditionList.setBounds(n4, n3 += n * 2 + 5, n2 - 5 - n4, dimension.height - n3 - 5);
        this.countrySelectPanel.setBounds(n2, n3, n2 - 5, dimension.height - n3 - 5);
    }

    public void selectOAComplete(Vector vector) {
        try {
            int n = PropertySystem.getInt(1);
            if (vector != null && vector.size() > 0) {
                int n2 = 0;
                int n3 = vector.size();
                Object var5_6 = null;
                while (n2 < n3) {
                    var5_6 = vector.elementAt(n2);
                    if (var5_6 instanceof LinkDisplayRec) {
                        this.addLink(new DocLinkDisplayRec(((LinkDisplayRec)var5_6).getLinkInd(), ((LinkDisplayRec)var5_6).getLinkType(), ((LinkDisplayRec)var5_6).getTitle()), ((LinkDisplayRec)var5_6).getLinkType(), ((LinkDisplayRec)var5_6).getDocInd());
                    } else if (var5_6 instanceof LinkDraftDisplayRec) {
                        this.addLink(new DocLinkDisplayRec(((LinkDraftDisplayRec)var5_6).getLinkInd(), ((LinkDraftDisplayRec)var5_6).getLinkType(), ((LinkDraftDisplayRec)var5_6).getTitle()), ((LinkDisplayRec)var5_6).getLinkType(), ((LinkDisplayRec)var5_6).getDocInd());
                    } else if (var5_6 instanceof LinkGroupDisplayRec) {
                        this.addLink(new DocLinkDisplayRec(((LinkGroupDisplayRec)var5_6).getLinkGroupInd(), ((LinkGroupDisplayRec)var5_6).getTitle()), 1, 0);
                    } else if (var5_6 instanceof Bookmark) {
                        PersistentRec persistentRec;
                        if (((Bookmark)var5_6).getBookmarkType() == 7) {
                            persistentRec = Link.readFromDatabase((Integer)((Bookmark)var5_6).getObject(), n);
                            int n4 = -1;
                            int n5 = 0;
                            if (persistentRec instanceof QuestLink) {
                                n4 = 0;
                                n5 = ((QuestLink)persistentRec).getDocInd();
                            } else {
                                n4 = 1;
                            }
                            this.addLink(new DocLinkDisplayRec(((Link)persistentRec).getInd(), n4, ((Link)persistentRec).getLinkTitles().elementAt(0).toString()), n4, n5);
                        }
                        if (((Bookmark)var5_6).getBookmarkType() == 8) {
                            persistentRec = LinkGroup.readFromDatabase((Integer)((Bookmark)var5_6).getObject(), n);
                            this.addLink(new DocLinkDisplayRec(((LinkGroup)persistentRec).getInd(), ((LinkGroup)persistentRec).getLinkGroupTitles().elementAt(0).toString()), 1, 0);
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
    }

    private void addLink(DocLinkDisplayRec docLinkDisplayRec, int n, int n2) {
        DocLink docLink = (DocLink)docLinkDisplayRec.getData();
        this.cnr_LINKS.add(docLinkDisplayRec);
        if (this.links == null) {
            this.links = new Vector(1, 1);
        }
        if (n == 1) {
            docLink.setCountryList(UserSystem.getUserCountries());
        } else {
            docLink.setCountryList(this.getDocCountryList(n2));
        }
        if (this.draftEditPanel != null) {
            docLink.setDocClass(this.draftEditPanel.getDocClass());
        }
        this.links.addElement(docLink);
        this.setCurrentLink(docLinkDisplayRec);
    }

    private void setCurrentLink(DocLinkDisplayRec docLinkDisplayRec) {
        if (docLinkDisplayRec != null) {
            this.setCurrentLink((DocLink)docLinkDisplayRec.getData());
        }
    }

    private void setCurrentLink(DocLink docLink) {
        if (this.currentLink != null) {
            System.out.println("setCurrentLink Calling SaveData");
            this.saveData();
        }
        this.currentLink = docLink;
        this.refreshData();
    }

    private void saveData() {
        System.out.println("Save Data");
        if (this.currentLink != null) {
            System.out.println("   CUrrent Link Not Null in save adata!");
            this.currentLink.setDocClass(this.docClassPanel.getDocClass());
            System.out.println("Country LIst:" + this.countrySelectPanel.getCountryList());
            this.currentLink.setCountryList(this.countrySelectPanel.getCountryList());
            this.conditionList.getConditions();
        }
    }

    private void refreshData() {
        if (this.currentLink != null) {
            try {
                boolean bl = true;
                if (this.cnr_LINKS.getSelectedItem() != null) {
                    bl = !(this.cnr_LINKS.getSelectedItem() instanceof QuestLink);
                }
                this.conditionList.setConditions(this.currentLink.getConditions());
                this.docClassPanel.setDocClass(this.currentLink.getDocClass());
                this.countrySelectPanel.setCountryList(this.currentLink.getCountryList());
                System.out.println("Refresh Data Country List:" + this.currentLink.getCountryList());
                this.docClassPanel.setEnabled(bl);
                this.countrySelectPanel.setEnabled(bl);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.pb_ADD_LINK == actionEvent.getSource()) {
            SelectOADlg selectOADlg = new SelectOADlg();
            System.out.println("pb_ADD_LINK calling saveData()");
            this.saveData();
            selectOADlg.getInstance().addSelectOAListener(this);
            selectOADlg.getInstance().allowDrafts(false);
            selectOADlg.getInstance().setView(1);
        } else if (actionEvent.getSource() == this.pb_REMOVE_LINK) {
            if (this.currentLink != null) {
                this.currentLink.updateRecStatus(3);
                this.cnr_LINKS.remove((MultiListRow)this.cnr_LINKS.getSelectedItem());
            } else {
                GUISystem.printBox((Component)this, (int)7, (int)1104);
            }
        } else if (actionEvent.getSource() == this.pb_LINK_UP) {
            this.moveUp();
        } else if (actionEvent.getSource() == this.pb_LINK_DOWN) {
            this.moveDown();
        }
    }

    public Vector getDocLinks() {
        Vector vector = this.cnr_LINKS.getData();
        Vector vector2 = QuestUtil.getDataFromDisplay(vector);
        return vector2;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.setCurrentLink((DocLinkDisplayRec)this.cnr_LINKS.getSelectedItem());
        }
    }

    private void refreshLinks() {
        this.conditionList.clear();
        this.cnr_LINKS.removeAll();
        if (this.links != null) {
            this.cnr_LINKS.add(DocLinkDisplayRec.convert(QuestUtil.getValidData(this.links)));
        }
    }

    public void setLinks(Vector vector) {
        this.links = vector;
        this.refreshLinks();
    }

    private void moveUp() {
        MultiListRow multiListRow = (MultiListRow)this.cnr_LINKS.getSelectedItem();
        Vector vector = this.cnr_LINKS.getData();
        int n = vector.indexOf(multiListRow);
        vector.removeElement(multiListRow);
        if (n > 0) {
            vector.insertElementAt(multiListRow, n - 1);
            this.cnr_LINKS.removeAll();
            this.cnr_LINKS.add(vector);
            this.cnr_LINKS.setSelectedItem(multiListRow, true);
        }
    }

    private void moveDown() {
        MultiListRow multiListRow = (MultiListRow)this.cnr_LINKS.getSelectedItem();
        Vector vector = this.cnr_LINKS.getData();
        int n = vector.indexOf(multiListRow);
        vector.removeElement(multiListRow);
        if (n < vector.size()) {
            vector.insertElementAt(multiListRow, n + 1);
            this.cnr_LINKS.removeAll();
            this.cnr_LINKS.add(vector);
            this.cnr_LINKS.setSelectedItem(multiListRow, true);
        }
    }

    protected void removeCountryFromPanel(TypeCountryCodeRec typeCountryCodeRec) {
        if (this.links != null && this.links.size() > 0) {
            int n = 0;
            int n2 = this.links.size();
            Vector vector = null;
            while (n < n2) {
                vector = ((DocLink)this.links.elementAt(n)).getCountryList();
                vector.removeElement(typeCountryCodeRec);
                ((DocLink)this.links.elementAt(n)).setCountryList(vector);
                ++n;
            }
        }
        if (this.currentLink != null) {
            this.countrySelectPanel.setCountryList(this.currentLink.getCountryList());
        }
    }

    protected CountrySelectPanel getCountrySelectPanel() {
        return this.countrySelectPanel;
    }

    public Dimension getPreferredSize() {
        return this.prefSize;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setDraftEditPanel(DraftEditPanel draftEditPanel) {
        this.draftEditPanel = draftEditPanel;
    }

    private Vector getDocCountryList(int n) {
        SQLMethod sQLMethod = new SQLMethod(1, "getDocCountryList", 5);
        Vector vector = new Vector();
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = null;
            LocaleRec localeRec = new LocaleRec();
            boolean bl = true;
            resultSet = statement.executeQuery("SELECT GEOIND FROM TIGRIS.DOCGEO WHERE DOCIND = " + n);
            while (bl && resultSet.next()) {
                if (resultSet.getInt(1) == 6) {
                    localeRec.setWorldWide();
                    bl = false;
                    continue;
                }
                System.out.println("Adding Geography:" + resultSet.getInt(1));
                localeRec.addGeography(resultSet.getInt(1));
            }
            resultSet.close();
            statement = sQLMethod.createStatement();
            resultSet = statement.executeQuery("SELECT COUNTRYCODEIND FROM TIGRIS.DOCCOUNTRY WHERE DOCIND = " + n);
            while (bl && resultSet.next()) {
                localeRec.addCountry(resultSet.getInt(1));
                System.out.println("Read country:" + resultSet.getInt(1));
            }
            resultSet.close();
            vector = localeRec.getCountryList();
            System.out.println("RetVec Size:" + vector.size());
            int n2 = 0;
            while (n2 < vector.size()) {
                System.out.println("Returning Country:" + vector.elementAt(n2));
                ++n2;
            }
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception, false);
        }
        sQLMethod.close();
        return vector;
    }

    public LinkBinderPanel() {
        this.initialize();
    }
}

