/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.avalon.editors;

import com.ibm.nzna.projects.common.quest.oa.ExternalLinkDraft;
import com.ibm.nzna.projects.common.quest.oa.LanguageText;
import com.ibm.nzna.projects.common.quest.oa.QuestLinkDraft;
import com.ibm.nzna.projects.common.quest.type.TypeLanguageRec;
import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.projects.qit.Qit;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.FontSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.avalon.editors.EditPanel;
import com.ibm.nzna.projects.qit.bookmark.Bookmark;
import com.ibm.nzna.projects.qit.doc.DocRec;
import com.ibm.nzna.projects.qit.doc.gui.SelectDocDlg;
import com.ibm.nzna.projects.qit.doc.gui.SelectDocListener;
import com.ibm.nzna.projects.qit.gui.ActionButton;
import com.ibm.nzna.projects.qit.gui.JTitle;
import com.ibm.nzna.projects.qit.gui.QuestPanel;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.gui.HotLinkLabel;
import com.ibm.nzna.shared.gui.MaskDocument;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.URLValidator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class LinkEditPanel
extends EditPanel
implements KeyListener,
SelectDocListener,
ActionListener,
AppConst {
    private ActionButton pb_CLOSE = null;
    private ActionButton pb_SAVE = null;
    private JTitle st_TITLE = null;
    private JTextField ef_TITLE = null;
    private JRadioButton rb_URL_LINK = null;
    private JRadioButton rb_QUEST_LINK = null;
    private JTextField ef_URL_LINK = null;
    private JTextField ef_QUEST_LINK = null;
    private HotLinkLabel pb_VALIDATE = null;
    private HotLinkLabel pb_BROWSE = null;
    private JLabel st_VALIDATED = null;
    private QuestLinkDraft questLink = null;
    private ExternalLinkDraft externalLink = null;
    private QuestPanel previousPanel = null;
    private boolean saved = false;

    private void initialize() {
        ButtonGroup buttonGroup = null;
        this.pb_CLOSE = new ActionButton(Str.getStr(28), ImageSystem.getImageIcon((Object)this, 8), Str.getStr(203));
        this.pb_SAVE = new ActionButton(Str.getStr(515), ImageSystem.getImageIcon((Object)this, 62), Str.getStr(951));
        this.st_TITLE = new JTitle(Str.getStr(318));
        this.ef_TITLE = new JTextField(new MaskDocument(0, 254), "", 0);
        this.ef_QUEST_LINK = new JTextField(new MaskDocument(3, 12), "", 0);
        this.ef_URL_LINK = new JTextField(new MaskDocument(0, 1024), "", 0);
        this.rb_QUEST_LINK = new JRadioButton(Str.getStr(952));
        this.rb_URL_LINK = new JRadioButton(Str.getStr(953));
        this.pb_VALIDATE = new HotLinkLabel(Str.getStr(852), ImageSystem.getImageIcon((Object)this, 29));
        this.pb_BROWSE = new HotLinkLabel(Str.getStr(393), ImageSystem.getImageIcon((Object)this, 12));
        this.st_VALIDATED = new JLabel();
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rb_URL_LINK);
        buttonGroup.add(this.rb_QUEST_LINK);
        this.setBackground(Color.white);
        this.st_TITLE.setFont(FontSystem.smallTitleFont);
        this.st_VALIDATED.setOpaque(false);
        this.pb_VALIDATE.setOpaque(false);
        this.pb_BROWSE.setOpaque(false);
        this.rb_QUEST_LINK.setOpaque(false);
        this.rb_URL_LINK.setOpaque(false);
        this.st_TITLE.setOpaque(false);
        this.pb_SAVE.addActionListener(this);
        this.pb_CLOSE.addActionListener(this);
        this.rb_URL_LINK.addActionListener(this);
        this.pb_VALIDATE.addActionListener(this);
        this.pb_BROWSE.addActionListener(this);
        this.rb_QUEST_LINK.addActionListener(this);
        this.ef_URL_LINK.addActionListener(this);
        this.ef_QUEST_LINK.addActionListener(this);
        this.ef_TITLE.addKeyListener(this);
        this.setLayout(null);
        this.add(this.st_TITLE);
        this.add(this.ef_TITLE);
        this.add(this.pb_BROWSE);
        this.add(this.rb_URL_LINK);
        this.add(this.ef_URL_LINK);
        this.add(this.rb_QUEST_LINK);
        this.add(this.ef_QUEST_LINK);
        this.add(this.pb_VALIDATE);
        this.add(this.st_VALIDATED);
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = GUISystem.getRowHeight();
        int n2 = 5;
        int n3 = 15;
        super.doLayout();
        this.st_TITLE.setBounds(n3, n2, dimension.width, n);
        this.ef_TITLE.setBounds(n3, n2 += n + 5, dimension.width / 2, n);
        this.rb_QUEST_LINK.setBounds(n3, n2 += n + 10, dimension.width, n);
        this.ef_QUEST_LINK.setBounds(n3 + 20, n2 += n, 150, n);
        this.pb_BROWSE.setBounds(n3 + 180, n2, 150, n);
        this.rb_URL_LINK.setBounds(n3, n2 += n + 10, dimension.width, n);
        this.ef_URL_LINK.setBounds(n3 + 20, n2 += n, 350, n);
        this.pb_VALIDATE.setBounds(n3 + 380, n2, 150, n);
        this.st_VALIDATED.setBounds(n3 + 20, n2 += n + 10, 250, n);
    }

    public boolean saveData() {
        boolean bl = false;
        String string = this.ef_TITLE.getText();
        try {
            if (string != null && string.length() > 0) {
                Vector vector = null;
                LanguageText languageText = null;
                if (this.questLink != null) {
                    vector = this.questLink.getLinkTitles();
                } else if (this.externalLink != null) {
                    vector = this.externalLink.getLinkTitles();
                }
                languageText = (LanguageText)vector.elementAt(0);
                languageText.setLanguage((TypeLanguageRec)TypeList.getInstance().objectFromInd(PropertySystem.getInt(1), 8));
                if (this.questLink != null) {
                    if (this.validateQuestLink()) {
                        bl = true;
                    }
                } else if (this.externalLink != null) {
                    bl = true;
                }
            } else {
                GUISystem.printBox(7, 1090);
                this.ef_TITLE.requestFocus();
            }
        }
        catch (Exception exception) {
            bl = false;
            LogSystem.log(1, exception, false);
        }
        return bl;
    }

    private void enableEntryFields() {
        this.ef_URL_LINK.setEnabled(this.rb_URL_LINK.isSelected());
        this.ef_QUEST_LINK.setEnabled(this.rb_QUEST_LINK.isSelected());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.rb_URL_LINK || actionEvent.getSource() == this.rb_QUEST_LINK) {
            this.enableEntryFields();
        } else if (actionEvent.getSource() == this.pb_BROWSE || actionEvent.getSource() == this.ef_QUEST_LINK) {
            new SelectDocDlg(false).addSelectDocListener(this);
        } else if (actionEvent.getSource() == this.ef_URL_LINK || actionEvent.getSource() == this.pb_VALIDATE) {
            this.validateURL();
        }
    }

    public void setLink(QuestLinkDraft questLinkDraft) {
        this.questLink = questLinkDraft;
        this.externalLink = null;
        this.ef_TITLE.setEnabled(false);
        this.rb_URL_LINK.setEnabled(false);
        this.ef_URL_LINK.setEnabled(false);
        this.pb_VALIDATE.setEnabled(false);
        this.rb_QUEST_LINK.setSelected(true);
        this.ef_QUEST_LINK.setText("" + questLinkDraft.getDocInd());
        this.ef_TITLE.setText(questLinkDraft.getLinkTitles().elementAt(0).toString());
    }

    public void setLink(ExternalLinkDraft externalLinkDraft) {
        this.externalLink = externalLinkDraft;
        this.questLink = null;
        this.ef_TITLE.setEnabled(true);
        this.rb_QUEST_LINK.setEnabled(false);
        this.ef_QUEST_LINK.setEnabled(false);
        this.pb_BROWSE.setEnabled(false);
        this.rb_URL_LINK.setSelected(true);
        this.ef_URL_LINK.setText(externalLinkDraft.getUrl());
        this.setValidatedText();
        this.ef_TITLE.setText(externalLinkDraft.getLinkTitles().elementAt(0).toString());
    }

    private void setValidatedText() {
        if (this.externalLink != null) {
            if (this.externalLink.isUrlValid()) {
                this.st_VALIDATED.setForeground(Color.blue);
                this.st_VALIDATED.setText(Str.getStr(1081));
            } else {
                this.st_VALIDATED.setForeground(new Color(150, 0, 0));
                this.st_VALIDATED.setText(Str.getStr(958));
            }
        } else {
            this.st_VALIDATED.setText("");
        }
    }

    public void selectDocComplete(Vector vector) {
        if (vector != null && vector.size() > 0) {
            Bookmark bookmark;
            Object e = vector.elementAt(0);
            if (e instanceof DocRec) {
                this.ef_QUEST_LINK.setText("" + ((DocRec)e).getExistingDocInd());
            } else if (e instanceof Bookmark && (bookmark = (Bookmark)e).getBookmarkType() == 3) {
                this.ef_QUEST_LINK.setText("" + (Integer)bookmark.getObject());
            }
        }
    }

    private void validateURL() {
        this.pb_VALIDATE.setEnabled(false);
        Qit.setEnabled(false);
        GUISystem.getParentDefWin(this).setStatus(14);
        try {
            this.externalLink.setUrlValid(URLValidator.validateUrl(this.ef_URL_LINK.getText()));
        }
        catch (Exception exception) {
            String string = exception.toString();
            if (string.indexOf("Operation timed out") >= 0) {
                GUISystem.printBox(7, 1086);
            } else if (string.indexOf("UnknownHostException") >= 0) {
                GUISystem.printBox(7, 1087);
            } else if (string.indexOf("MalformedURLException: no protocol") >= 0) {
                GUISystem.printBox(7, 1088);
            } else if (string.indexOf("ConnectException: Connection refused") >= 0) {
                GUISystem.printBox(7, 1089);
            }
            this.externalLink.setUrlValid(false);
        }
        GUISystem.getParentDefWin(this).setStatus(null);
        Qit.setEnabled(true);
        this.pb_VALIDATE.setEnabled(true);
        this.setValidatedText();
    }

    private boolean validateQuestLink() {
        SQLMethod sQLMethod = new SQLMethod(1, "validateQuestLink", 5);
        boolean bl = false;
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT DOCIND " + "FROM TIGRIS.DOCUMENTS " + "WHERE DOCIND = " + this.ef_QUEST_LINK.getText() + " AND " + "      RECYCLED = 'N' AND " + "      PUBLISH  = 'Y'");
            bl = resultSet.next();
            resultSet.close();
            statement.close();
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception);
        }
        sQLMethod.close();
        return bl;
    }

    public String getTitle() {
        return this.ef_TITLE.getText();
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.fireChangedEvent();
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public LinkEditPanel() {
        this.initialize();
    }
}

