/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.avalon.editors;

import com.ibm.nzna.projects.common.quest.oa.LinkDraft;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.FontSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.avalon.editors.LinkEditorPanel;
import com.ibm.nzna.projects.qit.avalon.editors.OAEdit;
import com.ibm.nzna.projects.qit.avalon.sql.LinkUsage;
import com.ibm.nzna.projects.qit.avalon.sql.UsageRec;
import com.ibm.nzna.projects.qit.gui.JTitle;
import com.ibm.nzna.projects.qit.gui.ListActionPanel;
import com.ibm.nzna.projects.qit.gui.QuestPanel;
import com.ibm.nzna.projects.qit.gui.StatusWin;
import com.ibm.nzna.shared.gui.HotLinkLabel;
import com.ibm.nzna.shared.gui.MultiList;
import com.ibm.nzna.shared.util.LogSystem;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;

public class LinkUsagePanel
extends JPanel
implements ActionListener,
AppConst,
Runnable {
    private static String[] columns = new String[]{"", "", ""};
    private MultiList actionList = null;
    private MultiList questionList = null;
    private MultiList linkGroupList = null;
    private ListActionPanel actionPanel = null;
    private ListActionPanel questionPanel = null;
    private ListActionPanel refreshPanel = null;
    private ListActionPanel linkGroupPanel = null;
    private JTitle st_ACTIONS = null;
    private JTitle st_QUESTIONS = null;
    private JTitle st_LINK_GROUPS = null;
    private HotLinkLabel pb_EDIT_ACTION = null;
    private HotLinkLabel pb_EDIT_QUESTION = null;
    private HotLinkLabel pb_EDIT_LINK_GROUP = null;
    private HotLinkLabel pb_REFRESH = null;
    private LinkEditorPanel linkEditorPanel = null;
    private boolean refreshing = false;
    private boolean refreshed = false;
    private LinkDraft link = null;
    private Dimension prefSize = new Dimension(100, 400);

    public void setLink(LinkDraft linkDraft) {
        this.link = linkDraft;
        this.refreshed = false;
    }

    private void initialize() {
        this.actionList = new MultiList(GUISystem.getFontUtil());
        this.questionList = new MultiList(GUISystem.getFontUtil());
        this.linkGroupList = new MultiList(GUISystem.getFontUtil());
        this.st_ACTIONS = new JTitle(Str.getStr(862));
        this.st_QUESTIONS = new JTitle(Str.getStr(861));
        this.st_LINK_GROUPS = new JTitle(Str.getStr(992));
        this.actionPanel = new ListActionPanel();
        this.questionPanel = new ListActionPanel();
        this.refreshPanel = new ListActionPanel();
        this.linkGroupPanel = new ListActionPanel();
        this.pb_EDIT_ACTION = new HotLinkLabel(Str.getStr(50));
        this.pb_EDIT_QUESTION = new HotLinkLabel(Str.getStr(50));
        this.pb_EDIT_LINK_GROUP = new HotLinkLabel(Str.getStr(50));
        this.pb_REFRESH = new HotLinkLabel(Str.getStr(38) + " " + Str.getStr(218));
        this.st_ACTIONS.setFont(FontSystem.smallTitleFont);
        this.st_QUESTIONS.setFont(FontSystem.smallTitleFont);
        this.st_LINK_GROUPS.setFont(FontSystem.smallTitleFont);
        this.setOpaque(false);
        this.setListProperties(this.actionList);
        this.setListProperties(this.questionList);
        this.setListProperties(this.linkGroupList);
        this.pb_EDIT_ACTION.addActionListener(this);
        this.pb_EDIT_QUESTION.addActionListener(this);
        this.pb_REFRESH.addActionListener(this);
        this.pb_EDIT_LINK_GROUP.addActionListener(this);
        this.questionList.addActionListener(this);
        this.actionList.addActionListener(this);
        this.linkGroupList.addActionListener(this);
        this.setLayout(null);
        this.refreshPanel.add(this.pb_REFRESH);
        this.actionPanel.add(this.pb_EDIT_ACTION);
        this.questionPanel.add(this.pb_EDIT_QUESTION);
        this.linkGroupPanel.add(this.pb_EDIT_LINK_GROUP);
        this.add(this.st_ACTIONS);
        this.add(this.actionList);
        this.add(this.actionPanel);
        this.add(this.st_QUESTIONS);
        this.add(this.questionList);
        this.add(this.questionPanel);
        this.add(this.st_LINK_GROUPS);
        this.add(this.linkGroupList);
        this.add(this.linkGroupPanel);
        this.add(this.refreshPanel);
    }

    public void doLayout() {
        int n = GUISystem.getRowHeight();
        int n2 = 0;
        int n3 = 0;
        Dimension dimension = this.getSize();
        int n4 = dimension.width / 2;
        super.doLayout();
        this.st_ACTIONS.setBounds(n2, n3, n4 - 5, n);
        this.st_QUESTIONS.setBounds(n2 + n4, n3, n4 - 5, n);
        this.actionList.setBounds(n2, n3 += n, n4 - 5, n * 6);
        this.questionList.setBounds(n2 + n4, n3, n4 - 5, n * 6);
        this.actionPanel.setBounds(n2, n3 += n * 6, n4 - 5, n);
        this.questionPanel.setBounds(n2 + n4, n3, n4 - 5, n);
        this.st_LINK_GROUPS.setBounds(n2, n3 += n * 2, n4 - 5, n);
        this.linkGroupList.setBounds(n2, n3 += n, n4 - 5, n * 6);
        this.linkGroupPanel.setBounds(n2, n3 += n * 6, n4 - 5, n);
        this.refreshPanel.setBounds(n2, n3 += n * 2, dimension.width - n2 * 2, n);
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (!this.refreshed) {
            this.refresh();
        }
    }

    private void refresh() {
        if (!this.refreshing) {
            new Thread(this).start();
        }
    }

    public void run() {
        StatusWin statusWin = null;
        try {
            statusWin = new StatusWin(GUISystem.getParentDefWin(this));
            statusWin.setMaxValue(3);
            if (this.link != null) {
                this.actionList.removeAll();
                this.questionList.removeAll();
                this.linkGroupList.removeAll();
                statusWin.setText(Str.getStr(1382));
                this.actionList.add(LinkUsage.getLinkUsageInActions(this.link));
                statusWin.setValue(1);
                this.questionList.add(LinkUsage.getLinkUsageInQuestions(this.link));
                statusWin.setValue(2);
                this.linkGroupList.add(LinkUsage.getLinkUsageInLinkGroups(this.link));
                statusWin.setValue(3);
            }
            this.refreshed = true;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            GUISystem.printBox(7, 202);
        }
        statusWin.dispose();
        this.refreshing = false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        UsageRec usageRec;
        if (actionEvent.getSource() == this.pb_REFRESH) {
            if (!this.refreshing) {
                this.refreshed = false;
                this.refresh();
            }
        } else if (actionEvent.getSource() == this.questionList || actionEvent.getSource() == this.pb_EDIT_QUESTION) {
            UsageRec usageRec2 = (UsageRec)this.questionList.getSelectedItem();
            if (usageRec2 != null) {
                OAEdit.edit(usageRec2, (QuestPanel)this.linkEditorPanel);
            }
        } else if (actionEvent.getSource() == this.actionList || actionEvent.getSource() == this.pb_EDIT_ACTION) {
            UsageRec usageRec3 = (UsageRec)this.actionList.getSelectedItem();
            if (usageRec3 != null) {
                OAEdit.edit(usageRec3, (QuestPanel)this.linkEditorPanel);
            }
        } else if ((actionEvent.getSource() == this.linkGroupList || actionEvent.getSource() == this.pb_EDIT_LINK_GROUP) && (usageRec = (UsageRec)this.linkGroupList.getSelectedItem()) != null) {
            OAEdit.edit(usageRec, (QuestPanel)this.linkEditorPanel);
        }
    }

    private void setListProperties(MultiList multiList) {
        multiList.setColumnHeadings(columns);
        multiList.setColumnWidth(0, 20);
        multiList.setColumnWidth(1, 75);
        multiList.setColumnWidth(2, 350);
        multiList.showColumnHeadings(false);
    }

    public LinkUsagePanel(LinkEditorPanel linkEditorPanel) {
        this.linkEditorPanel = linkEditorPanel;
        this.initialize();
    }
}

