/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.avalon.editors;

import com.ibm.nzna.projects.common.quest.oa.Action;
import com.ibm.nzna.projects.common.quest.oa.ActionDraft;
import com.ibm.nzna.projects.common.quest.oa.Node;
import com.ibm.nzna.projects.common.quest.oa.OAObject;
import com.ibm.nzna.projects.common.quest.oa.Question;
import com.ibm.nzna.projects.common.quest.oa.QuestionDraft;
import com.ibm.nzna.projects.common.quest.oa.Symptom;
import com.ibm.nzna.projects.common.quest.oa.SymptomDraft;
import com.ibm.nzna.projects.common.quest.type.TypeCountryCodeRec;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.FontSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.MainWindow;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.avalon.base.AvalonConst;
import com.ibm.nzna.projects.qit.avalon.base.AvalonUtil;
import com.ibm.nzna.projects.qit.avalon.cache.AvalonCache;
import com.ibm.nzna.projects.qit.avalon.editors.ComponentNode;
import com.ibm.nzna.projects.qit.avalon.editors.FlowEditorFilter;
import com.ibm.nzna.projects.qit.avalon.editors.FlowNode;
import com.ibm.nzna.projects.qit.avalon.editors.OAEditorPanel;
import com.ibm.nzna.projects.qit.avalon.editors.OASaveListener;
import com.ibm.nzna.projects.qit.avalon.sql.OASQL;
import com.ibm.nzna.projects.qit.gui.AppDefaultWin;
import com.ibm.nzna.shared.gui.MultiListRow;
import com.ibm.nzna.shared.util.FontUtil;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.Text;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

public class ObjectNode
implements OASaveListener,
FlowNode,
AppConst,
AvalonConst,
MultiListRow {
    private Point locationBeginPoint = new Point(0, 0);
    private Point locationEndPoint = new Point(0, 0);
    private Node node = null;
    private Rectangle nodeBounds = null;
    private String[] nodeDescriptionArray = null;
    private char[] nodeIndArray = null;
    private char[] draftArray = Str.getStr(1066).toCharArray();
    private FontUtil fontUtil = null;
    private Vector listeners = null;
    private boolean isDraft = false;
    private Object oaObject = null;
    private AppDefaultWin parentWin = null;
    private String nodeDescription = null;
    private FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(FontSystem.defaultFont);
    private int charWidth = this.fm.stringWidth("li");
    private boolean root = false;
    private boolean paint = true;
    private ComponentNode componentNode = null;
    private String nodeIndStr = null;
    private Color backgroundColor = Color.white;
    private Color foregroundColor = Color.black;
    private Dimension size = new Dimension(0, 0);
    private boolean visible = true;
    private int docClassInd = 0;
    private Vector countryList = null;
    private int oaObjectInd = 0;
    private Symptom symptom = null;
    private int edgeTitleY = 0;

    public void paint(Graphics graphics) {
        if (this.paint) {
            int n = this.node.getXPos();
            int n2 = this.node.getYPos();
            int n3 = this.node.getWidth();
            int n4 = this.node.getHeight();
            this.edgeTitleY = 0;
            graphics.setColor(this.getBackground());
            if (this.node != null) {
                switch (this.node.getNodeType()) {
                    case 0: {
                        graphics.fillRoundRect(n, n2, n3, n4, 28, 28);
                        graphics.setColor(this.getForeground());
                        graphics.drawRoundRect(n, n2, n3, n4, 28, 28);
                        break;
                    }
                    case 2: {
                        Polygon polygon = new Polygon();
                        polygon.addPoint(n + n3 / 2, n2);
                        polygon.addPoint(n + n3, n2 + n4 / 2);
                        polygon.addPoint(n + n3 / 2, n2 + n4);
                        polygon.addPoint(n, n2 + n4 / 2);
                        polygon.addPoint(n + n3 / 2, n2);
                        graphics.fillPolygon(polygon);
                        graphics.setColor(this.getForeground());
                        graphics.drawPolygon(polygon);
                        break;
                    }
                    default: {
                        graphics.fillRect(n, n2, n3, n4);
                        graphics.setColor(this.getForeground());
                        graphics.drawRect(n, n2, n3, n4);
                        break;
                    }
                }
            } else {
                graphics.fillRect(n, n2, n3, n4);
                graphics.setColor(this.getForeground());
                graphics.drawRect(n, n2, n3, n4);
            }
            if (this.root) {
                int n5 = 0;
                while (n5 < 3) {
                    graphics.drawRect(n + n5, n2 + n5, n3 - n5 * 2, n4 - n5 * 2);
                    ++n5;
                }
            }
            this.paintText(graphics, n, n2, n3, n4);
        }
    }

    protected void paintText(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = GUISystem.getRowHeight();
        int n6 = 15;
        if (this.nodeDescriptionArray == null) {
            this.setNodeDescription(this.nodeDescription);
        }
        if (this.nodeDescriptionArray != null) {
            int n7 = n + 5;
            int n8 = 0;
            if (this.node != null) {
                if (this.node.getNodeType() == 2) {
                    n7 += n3 / 3;
                    n8 += 10;
                } else if (this.node.getNodeType() == 0) {
                    n7 += 5;
                }
            }
            int n9 = 0;
            while (n9 < this.nodeDescriptionArray.length) {
                graphics.drawString(this.nodeDescriptionArray[n9], n7, n8 + n6 + n2);
                n6 += n5 - 4;
                ++n9;
            }
        }
        this.fontUtil.drawChars(graphics, this.nodeIndArray, this.nodeIndArray.length, n + 5, n6 + n2, (Rectangle)graphics.getClip(), n + n3);
        n6 += n5;
        if (this.isDraft()) {
            this.fontUtil.drawChars(graphics, this.draftArray, this.draftArray.length, n + 5, n6 + n2, (Rectangle)graphics.getClip(), n + n3);
        }
        graphics.drawString(this.nodeIndStr, n + 5, n2 + n4 - 20);
    }

    public void setNode(Node node) {
        int n = 0;
        int n2 = 0;
        this.node = node;
        if (node.getInd() == 0) {
            this.setStatus(Str.getStr(14));
            node.assignDatabaseKey(true);
            this.setStatus(null);
        }
        if (node.getDraftObjectInd() == 0) {
            this.isDraft = false;
            this.oaObjectInd = node.getActiveObjectInd();
        } else {
            this.isDraft = true;
            this.oaObjectInd = node.getDraftObjectInd();
        }
        this.nodeIndStr = "N:" + node.getInd();
        switch (node.getNodeType()) {
            case 2: {
                if (this.oaObject == null || !(this.oaObject instanceof Symptom)) break;
                this.setNodeDescription(AvalonUtil.getDefaultTitleText((Symptom)this.oaObject));
                break;
            }
            case 0: {
                if (this.oaObject == null || !(this.oaObject instanceof Action)) break;
                this.setNodeDescription(AvalonUtil.getDefaultTitleText((Action)this.oaObject));
                break;
            }
            case 1: {
                if (this.oaObject == null || !(this.oaObject instanceof Question)) break;
                this.setNodeDescription(AvalonUtil.getDefaultTitleText((Question)this.oaObject));
                break;
            }
            case 3: {
                this.setNodeDescription(Str.getStr(931));
                break;
            }
            case 4: {
                this.setNodeDescription(Str.getStr(932));
                break;
            }
            case 5: {
                this.setNodeDescription(Str.getStr(933));
                break;
            }
            case 6: {
                this.setNodeDescription(Str.getStr(934));
                break;
            }
        }
        this.setLocation(node.getXPos(), node.getYPos());
        if (node.getWidth() == 0) {
            n = 100;
        }
        if (node.getHeight() == 0) {
            n2 = 100;
        }
        this.setSize(n, n2);
        this.nodeIndArray = this.isDraft() ? new String("" + node.getDraftObjectInd()).toCharArray() : new String("" + node.getActiveObjectInd()).toCharArray();
        this.refreshProperties();
    }

    protected Rectangle getNodeBounds() {
        if (this.nodeBounds == null) {
            this.nodeBounds = new Rectangle();
        }
        this.nodeBounds.x = this.node.getXPos();
        this.nodeBounds.y = this.node.getYPos();
        this.nodeBounds.width = this.node.getWidth();
        this.nodeBounds.height = this.node.getHeight();
        return this.nodeBounds;
    }

    public void setSize(int n, int n2) {
        this.setBounds(-1, -1, n, n2);
    }

    public void setSize(Dimension dimension) {
        this.setBounds(-1, -1, dimension.width, dimension.height);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (this.node.valid()) {
            boolean bl = false;
            boolean bl2 = false;
            if (n3 >= 0) {
                boolean bl3 = bl = n3 != this.node.getWidth();
            }
            if (n4 >= 0) {
                boolean bl4 = bl = n4 != this.node.getHeight();
            }
            if (n >= 0) {
                this.node.setXPos(n);
            }
            if (n2 >= 0) {
                this.node.setYPos(n2);
            }
            if (n3 > 0) {
                this.node.setWidth(n3);
            }
            if (n4 > 0) {
                this.node.setHeight(n4);
            }
        }
        this.locationBeginPoint.x = n;
        this.locationBeginPoint.y = n2;
        this.locationEndPoint.x = n + this.node.getWidth();
        this.locationEndPoint.y = n2 + this.node.getHeight();
    }

    public void setLocation(int n, int n2) {
        this.setBounds(n, n2, -1, -1);
    }

    public void setLocation(Point point) {
        this.setBounds(point.x, point.y, -1, -1);
    }

    public Node getNode() {
        return this.node;
    }

    public String getTitle() {
        if (this.nodeDescription == null) {
            switch (this.node.getNodeType()) {
                case 1: {
                    if (this.isDraft()) {
                        this.setNodeDescription(OASQL.readDefaultQuestionTitle(this.node.getDraftObjectInd(), true));
                        break;
                    }
                    this.setNodeDescription(OASQL.readDefaultQuestionTitle(this.node.getActiveObjectInd(), false));
                    break;
                }
                case 0: {
                    if (this.isDraft()) {
                        this.setNodeDescription(OASQL.readDefaultActionTitle(this.node.getDraftObjectInd(), true));
                        break;
                    }
                    this.setNodeDescription(OASQL.readDefaultActionTitle(this.node.getActiveObjectInd(), false));
                    break;
                }
                case 2: {
                    if (this.isDraft()) {
                        this.setNodeDescription(OASQL.readDefaultSymptomTitle(this.node.getDraftObjectInd(), true));
                        break;
                    }
                    this.setNodeDescription(OASQL.readDefaultSymptomTitle(this.node.getActiveObjectInd(), false));
                    break;
                }
                case 6: {
                    this.setNodeDescription(Str.getStr(1134));
                    break;
                }
                case 5: {
                    this.setNodeDescription(Str.getStr(1222));
                    break;
                }
                case 3: {
                    this.setNodeDescription(Str.getStr(1220));
                    break;
                }
                case 4: {
                    this.setNodeDescription(Str.getStr(1221));
                    break;
                }
            }
        }
        return this.nodeDescription;
    }

    public boolean isDraft() {
        return this.isDraft;
    }

    public Object getDraftObject() {
        if (!this.isObjectRead() && this.isDraft) {
            switch (this.node.getNodeType()) {
                case 1: {
                    if (this.isDraft()) {
                        this.oaObject = AvalonCache.readQuestionDraft(this.node.getDraftObjectInd());
                        break;
                    }
                    this.oaObject = OASQL.getQuestionDraft(MainWindow.getInstance(), this.node.getActiveObjectInd(), 2);
                    this.isDraft = true;
                    break;
                }
                case 0: {
                    if (this.isDraft()) {
                        this.oaObject = AvalonCache.readActionDraft(this.node.getDraftObjectInd());
                        break;
                    }
                    this.oaObject = OASQL.getActionDraft(MainWindow.getInstance(), this.node.getActiveObjectInd(), 2);
                    this.isDraft = true;
                    break;
                }
                case 2: {
                    if (this.isDraft()) {
                        this.oaObject = AvalonCache.readSymptomDraft(this.node.getDraftObjectInd());
                        break;
                    }
                    this.oaObject = OASQL.getSymptomDraft(MainWindow.getInstance(), this.node.getActiveObjectInd(), 2);
                    this.isDraft = true;
                    break;
                }
            }
        }
        if (this.oaObject != null) {
            this.setDocClassInd((OAObject)this.oaObject);
        }
        this.setStatus(null);
        return this.oaObject;
    }

    public Object getObject() {
        if (!this.isObjectRead()) {
            this.setStatus(Str.getStr(142) + " " + this.nodeDescription);
            switch (this.node.getNodeType()) {
                case 1: {
                    if (this.isDraft()) {
                        this.oaObject = AvalonCache.readQuestionDraft(this.node.getDraftObjectInd());
                        break;
                    }
                    this.oaObject = AvalonCache.readQuestion(this.node.getActiveObjectInd());
                    break;
                }
                case 0: {
                    if (this.isDraft()) {
                        this.oaObject = AvalonCache.readActionDraft(this.node.getDraftObjectInd());
                        break;
                    }
                    this.oaObject = AvalonCache.readAction(this.node.getActiveObjectInd());
                    break;
                }
                case 2: {
                    if (this.isDraft()) {
                        this.oaObject = AvalonCache.readSymptomDraft(this.node.getDraftObjectInd());
                        break;
                    }
                    this.oaObject = AvalonCache.readSymptom(this.node.getActiveObjectInd());
                    break;
                }
            }
            this.setDocClassInd((OAObject)this.oaObject);
            this.setStatus(null);
        }
        return this.oaObject;
    }

    public String toString() {
        return this.getTitle();
    }

    protected void refreshProperties() {
        try {
            if (this.node.getNodeType() == 0) {
                this.setBackground((Color)PropertySystem.get(126));
            } else {
                this.setBackground((Color)PropertySystem.get(121));
            }
            this.setForeground((Color)PropertySystem.get(130));
            this.setPaint(this.paint);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setNodeDescription(String string) {
        if (string == null) {
            string = "???";
        }
        try {
            int n = PropertySystem.getInt(122);
            int n2 = this.node.getWidth();
            if (string.length() > n) {
                string = string.substring(0, n);
                string = string + "...";
            }
            this.nodeDescription = string;
            if (n2 > 0) {
                if (this.node.getNodeType() == 2) {
                    n2 /= 2;
                }
                this.nodeDescriptionArray = Text.formatStringLines(string, n2 / this.charWidth);
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
    }

    private void setStatus(String string) {
        MainWindow.getInstance().setStatus(string);
    }

    public void setOAObject(Object object) {
        if (object instanceof Question || object instanceof Action || object instanceof Symptom) {
            this.oaObject = object;
            if (this.oaObject != null) {
                this.setDocClassInd((OAObject)this.oaObject);
            }
            if (object instanceof QuestionDraft) {
                this.node.setDraftObjectInd(((QuestionDraft)object).getInd());
                this.docClassInd = ((QuestionDraft)object).getDocClass().getInd();
            } else if (object instanceof ActionDraft) {
                this.node.setDraftObjectInd(((ActionDraft)object).getInd());
                this.docClassInd = ((ActionDraft)object).getDocClass().getInd();
            } else if (object instanceof SymptomDraft) {
                this.node.setDraftObjectInd(((SymptomDraft)object).getInd());
                this.docClassInd = ((SymptomDraft)object).getDocClass().getInd();
            }
        } else {
            throw new IllegalArgumentException("Can only set Questions, Actions or Symptoms to an ObjectNode's OAObject");
        }
        this.setNode(this.node);
    }

    public Vector getCountryList() {
        return this.countryList;
    }

    public int getDocClass() {
        return this.docClassInd;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    protected void setRoot(boolean bl) {
        this.root = bl;
    }

    protected boolean getRoot() {
        return this.root;
    }

    public Object getColumnData(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = "" + this.node.getInd();
                break;
            }
            case 1: {
                string = this.nodeDescription;
                break;
            }
        }
        return string;
    }

    public boolean isInClip(Rectangle rectangle) {
        return this.locationBeginPoint.x > rectangle.x && this.locationBeginPoint.y > rectangle.y || this.locationEndPoint.x < rectangle.width + rectangle.x && this.locationEndPoint.y < rectangle.height + rectangle.y || this.locationBeginPoint.x > rectangle.x && this.locationEndPoint.y > rectangle.y || this.locationEndPoint.x < rectangle.x && this.locationBeginPoint.y > rectangle.y;
    }

    public boolean containsPoint(Point point) {
        boolean bl = false;
        int n = this.node.getXPos() + this.node.getWidth();
        int n2 = this.node.getYPos() + this.node.getHeight();
        bl = point.x > this.node.getXPos() && point.x < n && point.y > this.node.getYPos() && point.y < n2;
        return bl;
    }

    public void setPaint(boolean bl) {
        FlowEditorFilter flowEditorFilter = (FlowEditorFilter)PropertySystem.get(127);
        if (bl) {
            boolean bl2 = bl = flowEditorFilter.showCountry(this.getCountryList()) && flowEditorFilter.showDocClass(this.getDocClass());
            if (this.node != null) {
                bl = this.node.valid();
            }
        }
        this.paint = bl;
    }

    protected void fireActionEvent() {
        if (this.listeners != null) {
            int n = 0;
            int n2 = this.listeners.size();
            ActionEvent actionEvent = new ActionEvent(this, 0, null);
            while (n < n2) {
                ((ActionListener)this.listeners.elementAt(n)).actionPerformed(actionEvent);
                ++n;
            }
        }
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.listeners == null) {
            this.listeners = new Vector(1);
        }
        this.listeners.addElement(actionListener);
    }

    public String getDebugDescript() {
        String string = "Unknown";
        if (this.node != null) {
            switch (this.node.getNodeType()) {
                case 0: {
                    string = "Action";
                    break;
                }
                case 1: {
                    string = "Question";
                    break;
                }
                case 2: {
                    string = "Symptom";
                    break;
                }
                case 3: {
                    string = "Resolved";
                    break;
                }
                case 4: {
                    string = "Unresolved";
                    break;
                }
                case 5: {
                    string = "Return";
                    break;
                }
                case 6: {
                    string = "AList";
                    break;
                }
            }
        }
        return "Type:" + string + ",  Ind:" + new String(this.nodeIndArray);
    }

    public boolean isObjectRead() {
        return this.oaObject != null;
    }

    public boolean getPaint() {
        return this.paint;
    }

    public void saveComplete(OAEditorPanel oAEditorPanel, Object object, boolean bl) {
        this.setOAObject(this.oaObject);
        if (this.componentNode != null && this.componentNode.getObjectNode() == this) {
            this.componentNode.setObjectNode(this);
        }
    }

    public void setComponentNode(ComponentNode componentNode) {
        this.componentNode = componentNode;
    }

    public void setBackground(Color color) {
        this.backgroundColor = color;
    }

    public Color getBackground() {
        return this.backgroundColor;
    }

    public void setForeground(Color color) {
        this.foregroundColor = color;
    }

    public Color getForeground() {
        return this.foregroundColor;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void addCountry(TypeCountryCodeRec typeCountryCodeRec) {
        if (this.countryList == null) {
            this.countryList = new Vector(1, 1);
        }
        this.countryList.addElement(typeCountryCodeRec);
    }

    public void setDocClassInd(int n) {
        this.docClassInd = n;
    }

    public int getOAObjectInd() {
        return this.oaObjectInd;
    }

    protected String[] getNodeDescriptionArray() {
        return this.nodeDescriptionArray;
    }

    protected void setNodeDescriptionArray(String[] stringArray) {
        this.nodeDescriptionArray = stringArray;
    }

    public boolean equals(Object object) {
        if (object instanceof Node) {
            return this.node.equals((Node)object);
        }
        if (object instanceof ObjectNode) {
            return ((ObjectNode)object).oaObjectInd == this.oaObjectInd;
        }
        if (object instanceof String) {
            return this.toString().equals((String)object);
        }
        return false;
    }

    public void setEdgeTitleY(int n) {
        this.edgeTitleY = n;
    }

    public int getEdgeTitleY() {
        return this.edgeTitleY;
    }

    private void setDocClassInd(OAObject oAObject) {
        if (oAObject != null) {
            this.docClassInd = oAObject.getDocClass().getInd();
        }
    }

    public ObjectNode(Symptom symptom, Node node) {
        this.symptom = symptom;
        this.setNode(node);
        this.fontUtil = GUISystem.getFontUtil();
    }
}

