/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.avalon.editors;

import com.ibm.nzna.projects.common.quest.oa.QuestionDraft;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.FontSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.WindowSystem;
import com.ibm.nzna.projects.qit.avalon.editors.EditPanel;
import com.ibm.nzna.projects.qit.avalon.editors.OAEdit;
import com.ibm.nzna.projects.qit.avalon.editors.QuestionEditorPanel;
import com.ibm.nzna.projects.qit.avalon.sql.QuestionUsage;
import com.ibm.nzna.projects.qit.avalon.sql.UsageRec;
import com.ibm.nzna.projects.qit.gui.AppDefaultWin;
import com.ibm.nzna.projects.qit.gui.JTitle;
import com.ibm.nzna.projects.qit.gui.ListActionPanel;
import com.ibm.nzna.projects.qit.gui.QuestPanel;
import com.ibm.nzna.projects.qit.gui.StatusWin;
import com.ibm.nzna.projects.qit.product.ProductRec;
import com.ibm.nzna.projects.qit.product.prodedit.ProdEditPanel;
import com.ibm.nzna.shared.gui.HotLinkLabel;
import com.ibm.nzna.shared.gui.MultiList;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class QuestionUsagePanel
extends EditPanel
implements ActionListener,
ListSelectionListener,
AppConst,
Runnable {
    private static String[] columns = new String[]{"", "", ""};
    private JTitle st_SYMPTOMS = null;
    private JTitle st_QUESTIONS = null;
    private JTitle st_PRODUCTS = null;
    private JTitle st_ACTIONS = null;
    private JTitle st_DETAILS = null;
    private MultiList cnr_SYMPTOMS = null;
    private MultiList cnr_QUESTIONS = null;
    private MultiList cnr_PRODUCTS = null;
    private MultiList cnr_ACTIONS = null;
    private JTextArea mle_DETAILS = null;
    private JScrollPane scr_DETAILS = null;
    private ListActionPanel refreshPanel = null;
    private HotLinkLabel pb_REFRESH = null;
    private HotLinkLabel pb_EDIT_SYMPTOM = null;
    private HotLinkLabel pb_EDIT_QUESTION = null;
    private HotLinkLabel pb_EDIT_ACTION = null;
    private HotLinkLabel pb_EDIT_PRODUCT = null;
    private ListActionPanel symptomPanel = null;
    private ListActionPanel questionPanel = null;
    private ListActionPanel actionPanel = null;
    private ListActionPanel productPanel = null;
    private boolean readData = false;
    private Dimension minSize = new Dimension(100, 363);
    private QuestionDraft question = null;
    private UsageRec currentUsageRec = null;
    private Vector questionUsage = null;
    private Vector actionUsage = null;
    private Vector symptomUsage = null;
    private Vector productUsage = null;
    private QuestionEditorPanel questionEditorPanel = null;

    private void initialize() {
        this.st_SYMPTOMS = new JTitle(Str.getStr(865));
        this.st_QUESTIONS = new JTitle(Str.getStr(861));
        this.st_PRODUCTS = new JTitle(Str.getStr(299));
        this.st_ACTIONS = new JTitle(Str.getStr(862));
        this.st_DETAILS = new JTitle(Str.getStr(1348));
        this.mle_DETAILS = new JTextArea(Str.getStr(142));
        this.cnr_SYMPTOMS = new MultiList(GUISystem.getFontUtil());
        this.cnr_QUESTIONS = new MultiList(GUISystem.getFontUtil());
        this.cnr_PRODUCTS = new MultiList(GUISystem.getFontUtil());
        this.cnr_ACTIONS = new MultiList(GUISystem.getFontUtil());
        this.scr_DETAILS = new JScrollPane(this.mle_DETAILS);
        this.pb_REFRESH = new HotLinkLabel(Str.getStr(38));
        this.refreshPanel = new ListActionPanel();
        this.pb_EDIT_SYMPTOM = new HotLinkLabel(Str.getStr(50));
        this.pb_EDIT_QUESTION = new HotLinkLabel(Str.getStr(50));
        this.pb_EDIT_ACTION = new HotLinkLabel(Str.getStr(50));
        this.pb_EDIT_PRODUCT = new HotLinkLabel(Str.getStr(50));
        this.symptomPanel = new ListActionPanel();
        this.actionPanel = new ListActionPanel();
        this.questionPanel = new ListActionPanel();
        this.productPanel = new ListActionPanel();
        this.setBackground(Color.white);
        this.st_SYMPTOMS.setFont(FontSystem.smallTitleFont);
        this.st_QUESTIONS.setFont(FontSystem.smallTitleFont);
        this.st_PRODUCTS.setFont(FontSystem.smallTitleFont);
        this.st_ACTIONS.setFont(FontSystem.smallTitleFont);
        this.st_DETAILS.setFont(FontSystem.smallTitleFont);
        this.mle_DETAILS.setFont(FontSystem.defaultFont);
        this.mle_DETAILS.setEditable(false);
        this.mle_DETAILS.setLineWrap(true);
        this.mle_DETAILS.setWrapStyleWord(true);
        this.setListProperties(this.cnr_SYMPTOMS);
        this.setListProperties(this.cnr_QUESTIONS);
        this.setListProperties(this.cnr_PRODUCTS);
        this.setListProperties(this.cnr_ACTIONS);
        this.setLayout(null);
        this.refreshPanel.add(this.pb_REFRESH);
        this.symptomPanel.add(this.pb_EDIT_SYMPTOM);
        this.productPanel.add(this.pb_EDIT_PRODUCT);
        this.actionPanel.add(this.pb_EDIT_ACTION);
        this.questionPanel.add(this.pb_EDIT_QUESTION);
        this.add(this.st_SYMPTOMS);
        this.add(this.cnr_SYMPTOMS);
        this.add(this.symptomPanel);
        this.add(this.st_QUESTIONS);
        this.add(this.cnr_QUESTIONS);
        this.add(this.questionPanel);
        this.add(this.st_PRODUCTS);
        this.add(this.cnr_PRODUCTS);
        this.add(this.productPanel);
        this.add(this.st_ACTIONS);
        this.add(this.cnr_ACTIONS);
        this.add(this.actionPanel);
        this.add(this.st_DETAILS);
        this.add(this.scr_DETAILS);
        this.add(this.refreshPanel);
        this.pb_REFRESH.addActionListener(this);
        this.pb_EDIT_SYMPTOM.addActionListener(this);
        this.pb_EDIT_PRODUCT.addActionListener(this);
        this.pb_EDIT_ACTION.addActionListener(this);
        this.pb_EDIT_QUESTION.addActionListener(this);
        this.cnr_SYMPTOMS.addActionListener(this);
        this.cnr_QUESTIONS.addActionListener(this);
        this.cnr_PRODUCTS.addActionListener(this);
        this.cnr_ACTIONS.addActionListener(this);
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = GUISystem.getRowHeight();
        int n2 = dimension.width / 2;
        int n3 = 5;
        int n4 = 5;
        super.doLayout();
        this.st_SYMPTOMS.setBounds(n3, n4, n2 - n3, n);
        this.st_QUESTIONS.setBounds(n2 + n3, n4, n2 - n3 * 2, n);
        this.cnr_SYMPTOMS.setBounds(n3, n4 += n, n2 - n3, n * 5);
        this.cnr_QUESTIONS.setBounds(n2 + n3, n4, n2 - n3 * 2, n * 5);
        this.symptomPanel.setBounds(n3, n4 += n * 5, n2 - n3, n);
        this.questionPanel.setBounds(n2 + n3, n4, n2 - n3 * 2, n);
        this.st_PRODUCTS.setBounds(n3, n4 += n * 2, n2 - n3, n);
        this.st_ACTIONS.setBounds(n2 + n3, n4, n2 - n3 * 2, n);
        this.cnr_PRODUCTS.setBounds(n3, n4 += n, n2 - n3, n * 5);
        this.cnr_ACTIONS.setBounds(n2 + n3, n4, n2 - n3 * 2, n * 5);
        this.productPanel.setBounds(n3, n4 += n * 5, n2 - n3, n);
        this.actionPanel.setBounds(n2 + n3, n4, n2 - n3 * 2, n);
        this.st_DETAILS.setBounds(n3, n4 += n * 2, dimension.width - n3 * 2, n);
        this.scr_DETAILS.setBounds(n3, n4 += n, dimension.width - n3 * 2, n * 4);
        this.refreshPanel.setBounds(n3, n4 += n * 4, dimension.width - n3 * 2, n);
        n4 += n;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (!this.readData) {
            this.readData = true;
            this.readData();
        }
    }

    private void readData() {
        this.readData = true;
        new Thread(this).start();
    }

    public void run() {
        this.getUsage();
    }

    private void getUsage() {
        StatusWin statusWin = new StatusWin(GUISystem.getParentDefWin(this));
        try {
            if (this.question != null) {
                this.cnr_QUESTIONS.removeAll();
                this.cnr_PRODUCTS.removeAll();
                this.cnr_ACTIONS.removeAll();
                this.cnr_SYMPTOMS.removeAll();
                statusWin.setText(Str.getStr(1382));
                statusWin.setMaxValue(5);
                this.questionUsage = QuestionUsage.getQuestionAnswerUsageInQuestions(this.question);
                this.cnr_QUESTIONS.add(this.questionUsage);
                statusWin.setValue(1);
                this.symptomUsage = QuestionUsage.getQuestionAnswerUsageInSymptoms(this.question);
                this.cnr_SYMPTOMS.add(this.symptomUsage);
                statusWin.setValue(2);
                this.actionUsage = QuestionUsage.getQuestionAnswerUsageInActions(this.question);
                this.cnr_ACTIONS.add(this.actionUsage);
                statusWin.setValue(3);
                this.productUsage = QuestionUsage.getQuestionProductUsage(this.question);
                this.cnr_PRODUCTS.add(this.productUsage);
                statusWin.setValue(4);
                this.cnr_SYMPTOMS.add(QuestionUsage.getQuestionUsageInSymptoms(this.question));
                statusWin.setValue(5);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        statusWin.dispose();
    }

    public Dimension getMinimumSize() {
        return this.minSize;
    }

    public Dimension getPreferredSize() {
        return this.minSize;
    }

    public void setQuestion(QuestionDraft questionDraft) {
        this.readData = false;
        this.question = questionDraft;
        this.cnr_SYMPTOMS.removeAll();
        this.cnr_QUESTIONS.removeAll();
        this.cnr_ACTIONS.removeAll();
        this.cnr_PRODUCTS.removeAll();
        this.mle_DETAILS.setText(Str.getStr(142));
    }

    private void setListProperties(MultiList multiList) {
        multiList.setColumnHeadings(columns);
        multiList.setColumnWidth(0, 20);
        multiList.setColumnWidth(1, 55);
        multiList.setColumnWidth(2, 550);
        multiList.showColumnHeadings(false);
        multiList.addListSelectionListener(this);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.cnr_SYMPTOMS) {
            this.currentUsageRec = (UsageRec)this.cnr_SYMPTOMS.getSelectedItem();
        } else if (listSelectionEvent.getSource() == this.cnr_QUESTIONS) {
            this.currentUsageRec = (UsageRec)this.cnr_QUESTIONS.getSelectedItem();
        } else if (listSelectionEvent.getSource() == this.cnr_PRODUCTS) {
            this.currentUsageRec = (UsageRec)this.cnr_PRODUCTS.getSelectedItem();
        } else if (listSelectionEvent.getSource() == this.cnr_ACTIONS) {
            this.currentUsageRec = (UsageRec)this.cnr_ACTIONS.getSelectedItem();
        }
        this.refreshExplanation();
    }

    private void refreshExplanation() {
        if (this.currentUsageRec != null) {
            this.mle_DETAILS.setText(this.currentUsageRec.getExplanation());
        } else {
            this.mle_DETAILS.setText("");
        }
    }

    protected boolean isAnswerUsed(int n) {
        boolean bl = false;
        if (!this.readData) {
            this.readData = true;
            this.getUsage();
        }
        if (!(bl = this.checkAnswerUsageInVec(n, this.questionUsage))) {
            bl = this.checkAnswerUsageInVec(n, this.productUsage);
        }
        if (!bl) {
            bl = this.checkAnswerUsageInVec(n, this.actionUsage);
        }
        if (!bl) {
            bl = this.checkAnswerUsageInVec(n, this.symptomUsage);
        }
        return bl;
    }

    private boolean checkAnswerUsageInVec(int n, Vector vector) {
        int n2 = 0;
        int n3 = vector.size();
        boolean bl = false;
        while (n2 < n3 && !bl) {
            if (((UsageRec)vector.elementAt(n2)).getAnswerInd() == n) {
                bl = !((UsageRec)vector.elementAt(n2)).getWarning();
            }
            ++n2;
        }
        return bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.pb_REFRESH) {
            new Thread(this).start();
        } else if (actionEvent.getSource() == this.cnr_SYMPTOMS || actionEvent.getSource() == this.pb_EDIT_SYMPTOM) {
            UsageRec usageRec = (UsageRec)this.cnr_SYMPTOMS.getSelectedItem();
            if (usageRec != null) {
                OAEdit.edit(usageRec, (QuestPanel)this.questionEditorPanel);
            }
        } else if (actionEvent.getSource() == this.cnr_QUESTIONS || actionEvent.getSource() == this.pb_EDIT_QUESTION) {
            UsageRec usageRec = (UsageRec)this.cnr_QUESTIONS.getSelectedItem();
            if (usageRec != null) {
                OAEdit.edit(usageRec, (QuestPanel)this.questionEditorPanel);
            }
        } else if (actionEvent.getSource() == this.cnr_ACTIONS || actionEvent.getSource() == this.pb_EDIT_ACTION) {
            UsageRec usageRec = (UsageRec)this.cnr_ACTIONS.getSelectedItem();
            if (usageRec != null) {
                OAEdit.edit(usageRec, (QuestPanel)this.questionEditorPanel);
            }
        } else if (actionEvent.getSource() == this.cnr_PRODUCTS || actionEvent.getSource() == this.pb_EDIT_PRODUCT) {
            UsageRec usageRec = (UsageRec)this.cnr_PRODUCTS.getSelectedItem();
            ProductRec productRec = new ProductRec(usageRec.getReferenceObjectInd());
            AppDefaultWin appDefaultWin = GUISystem.getParentDefWin(this.questionEditorPanel);
            appDefaultWin.setStatus(331);
            if (productRec.readProductForEdit()) {
                ProdEditPanel prodEditPanel = new ProdEditPanel(null, productRec);
                WindowSystem.createPanel(prodEditPanel);
            }
            appDefaultWin.setStatus(null);
        }
    }

    public QuestionUsagePanel(QuestionEditorPanel questionEditorPanel) {
        this.questionEditorPanel = questionEditorPanel;
        this.initialize();
    }
}

