/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.avalon.gui;

import com.ibm.nzna.projects.common.quest.oa.Answer;
import com.ibm.nzna.projects.common.quest.oa.AnswerConcl;
import com.ibm.nzna.projects.common.quest.oa.Question;
import com.ibm.nzna.projects.common.quest.type.TypeDocClassRec;
import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.DateSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.avalon.base.AnswerConclDisplayRec;
import com.ibm.nzna.projects.qit.avalon.base.QuestionDisplayRec;
import com.ibm.nzna.projects.qit.avalon.cache.AvalonCache;
import com.ibm.nzna.projects.qit.avalon.gui.ConclusionDlgListener;
import com.ibm.nzna.projects.qit.avalon.gui.SelectOADlg;
import com.ibm.nzna.projects.qit.avalon.gui.SelectOAListener;
import com.ibm.nzna.projects.qit.bookmark.Bookmark;
import com.ibm.nzna.projects.qit.gui.AppDefaultWin;
import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.gui.MaskDocument;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.WinUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class ConclusionDlg
extends JDialog
implements SelectOAListener,
Runnable,
FocusListener,
ActionListener,
AppConst {
    private static final String THREAD_READ_REFRESH = "READ_REF";
    private JLabel st_IMAGE = null;
    private JLabel st_QUESTION = null;
    private JLabel st_ANSWER = null;
    private JTextField ef_QUESTION = null;
    private JComboBox cb_ANSWERS = null;
    private DButton pb_BROWSE = null;
    private DButton pb_OK = null;
    private DButton pb_CANCEL = null;
    private AnswerConcl answerConcl = null;
    private Question question = null;
    private boolean rc = false;
    private ImageIcon wizardImage = null;
    private ConclusionDlgListener listener = null;
    private AnswerConclDisplayRec displayRec = null;

    private void initialize() {
        Container container = this.getContentPane();
        this.wizardImage = ImageSystem.getImageIcon((Object)this, 158);
        this.st_IMAGE = new JLabel(this.wizardImage);
        this.st_QUESTION = new JLabel(Str.getStr(8));
        this.st_ANSWER = new JLabel(Str.getStr(987));
        this.ef_QUESTION = new JTextField(new MaskDocument(3), "", 0);
        this.cb_ANSWERS = new JComboBox();
        this.pb_BROWSE = new DButton(Str.getStr(393));
        this.pb_OK = new DButton(Str.getStr(1));
        this.pb_CANCEL = new DButton(Str.getStr(2));
        GUISystem.setPreferredButton(this.pb_OK);
        GUISystem.setPreferredButton(this.pb_CANCEL);
        this.st_IMAGE.setBorder(GUISystem.loweredBorder);
        GUISystem.setPropertiesOnPanel(container);
        this.pb_CANCEL.addActionListener(this);
        this.pb_OK.addActionListener(this);
        this.pb_BROWSE.addActionListener(this);
        this.ef_QUESTION.addActionListener(this);
        container.setLayout(null);
        container.add(this.st_IMAGE);
        container.add(this.st_QUESTION);
        container.add(this.st_ANSWER);
        container.add(this.ef_QUESTION);
        container.add(this.pb_BROWSE);
        container.add(this.cb_ANSWERS);
        container.add(this.pb_OK);
        container.add(this.pb_CANCEL);
        ((Component)this).setSize(495, 325);
        WinUtil.centerWindow(this);
        ((Component)this).setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.pb_CANCEL) {
            this.dispose(null, null);
        } else if (actionEvent.getSource() == this.pb_BROWSE) {
            SelectOADlg selectOADlg = new SelectOADlg().getInstance();
            selectOADlg.setView(3);
            selectOADlg.allowDrafts(false);
            selectOADlg.addSelectOAListener(this);
        } else if (actionEvent.getSource() == this.pb_OK) {
            if (this.saveData()) {
                this.dispose(this.answerConcl, this.displayRec);
            }
        } else if (actionEvent.getSource() == this.ef_QUESTION) {
            this.focusLost(null);
        }
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = this.wizardImage.getImage().getWidth(this) + 10;
        int n2 = 5;
        int n3 = GUISystem.getRowHeight();
        super.doLayout();
        this.st_IMAGE.setBounds(5, (dimension.height - 40) / 2 - this.wizardImage.getImage().getHeight(this) / 2, this.wizardImage.getImage().getWidth(this), this.wizardImage.getImage().getHeight(this));
        this.st_QUESTION.setBounds(n, n2, dimension.width - n - 10, n3);
        this.ef_QUESTION.setBounds(n, n2 += n3, dimension.width - n - 10 - 100, n3);
        this.pb_BROWSE.setBounds(dimension.width - 90, n2, 80, n3);
        this.st_ANSWER.setBounds(n, n2 += n3, dimension.width - n - 10, n3);
        this.cb_ANSWERS.setBounds(n, n2 += n3, dimension.width - n - 10, n3);
        n2 += n3;
        this.pb_OK.setLocation(n, dimension.height - 75);
        this.pb_CANCEL.setLocation(n + this.pb_OK.getMinimumSize().width + 5, dimension.height - 75);
    }

    public void selectOAComplete(Vector vector) {
        try {
            if (vector != null && vector.size() > 0) {
                Bookmark bookmark;
                if (vector.elementAt(0) instanceof QuestionDisplayRec) {
                    this.setQuestion(((QuestionDisplayRec)vector.elementAt(0)).getQuestionInd());
                } else if (vector.elementAt(0) instanceof Bookmark && (bookmark = (Bookmark)vector.elementAt(0)).getBookmarkType() == 4) {
                    this.setQuestion((Integer)bookmark.getObject());
                }
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
    }

    private void refreshQuestion() {
        this.cb_ANSWERS.removeAllItems();
        if (this.question != null) {
            Vector vector = this.question.getAnswers();
            if (vector != null && vector.size() > 0) {
                int n = 0;
                while (n < vector.size()) {
                    this.cb_ANSWERS.addItem(vector.elementAt(n));
                    ++n;
                }
                this.ef_QUESTION.setText("" + this.question.getInd());
            } else {
                this.cb_ANSWERS.addItem(Str.getStr(1233));
            }
        }
    }

    public void run() {
        String string = Thread.currentThread().getName();
        try {
            if (string.equals(THREAD_READ_REFRESH)) {
                this.question = this.readQuestion(this.question.getInd());
                this.refreshQuestion();
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
    }

    public void setConclusionDlgListener(ConclusionDlgListener conclusionDlgListener) {
        this.listener = conclusionDlgListener;
    }

    private void dispose(AnswerConcl answerConcl, AnswerConclDisplayRec answerConclDisplayRec) {
        super.dispose();
        if (this.listener != null) {
            this.listener.conclusionDlgClosed(answerConcl, answerConclDisplayRec);
        }
    }

    private boolean saveData() {
        boolean bl = false;
        if (this.cb_ANSWERS.getSelectedItem() instanceof Answer) {
            Answer answer = (Answer)this.cb_ANSWERS.getSelectedItem();
            if (this.question != null) {
                this.answerConcl = new AnswerConcl(this.question.getInd(), answer.getInd());
                this.answerConcl.setDbUser(UserSystem.getUserId());
                this.answerConcl.setDocClass((TypeDocClassRec)TypeList.getInstance().objectFromInd(1, 5));
                this.answerConcl.setChangedTime(DateSystem.getCurrentTimestamp());
                this.displayRec = new AnswerConclDisplayRec(this.answerConcl);
                bl = true;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private Answer answerFromInd(int n) {
        Answer answer = null;
        if (this.question != null) {
            int n2 = 0;
            Vector vector = this.question.getAnswers();
            int n3 = vector.size();
            while (n2 < n3 && answer == null) {
                if (((Answer)vector.elementAt(n2)).getInd() == n) {
                    answer = (Answer)vector.elementAt(n2);
                }
                ++n2;
            }
        }
        return answer;
    }

    private Question readQuestion(int n) {
        Question question = null;
        this.st_QUESTION.setText(Str.getStr(1038));
        this.st_QUESTION.setForeground(Color.blue);
        this.pb_OK.setEnabled(false);
        this.pb_CANCEL.setEnabled(false);
        question = AvalonCache.readQuestion(n);
        this.refreshQuestion();
        this.st_QUESTION.setText(Str.getStr(8));
        this.st_QUESTION.setForeground(Color.black);
        this.pb_OK.setEnabled(true);
        this.pb_CANCEL.setEnabled(true);
        return question;
    }

    private void setQuestion(int n) {
        this.question = new Question(n);
        new Thread((Runnable)this, THREAD_READ_REFRESH).start();
    }

    public void focusLost(FocusEvent focusEvent) {
        try {
            int n = new Integer(this.ef_QUESTION.getText());
            this.setQuestion(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public String getDefaultQuestionTitle() {
        Vector vector = this.question.getTitles();
        return vector.elementAt(vector.size() - 1).toString();
    }

    public ConclusionDlg(AppDefaultWin appDefaultWin) {
        super(appDefaultWin, Str.getStr(990), false);
        this.initialize();
    }
}

