/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.avalon.oanav;

import com.ibm.nzna.projects.qit.Qit;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.DisplayRec;
import com.ibm.nzna.projects.qit.app.ProcessManagerSystem;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.QuestProcess;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.avalon.base.AvalonConst;
import com.ibm.nzna.projects.qit.avalon.base.OASort;
import com.ibm.nzna.projects.qit.avalon.oanav.OANavPanel;
import com.ibm.nzna.projects.qit.avalon.sql.OASQL;
import com.ibm.nzna.projects.qit.customview.CustomView;
import com.ibm.nzna.projects.qit.gui.AppDefaultWin;
import com.ibm.nzna.shared.gui.MutableTreeWrapper;
import com.ibm.nzna.shared.gui.StringTreeNode;
import com.ibm.nzna.shared.gui.ViewTreeNode;
import com.ibm.nzna.shared.sort.QuickSort;
import com.ibm.nzna.shared.util.LogSystem;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class RefreshTreeViewThread
implements QuestProcess,
AvalonConst,
OASort,
AppConst,
Runnable {
    private static final int REFRESH_PREBUILT_VIEW = 1;
    private static final int REFRESH_CUSTOM_VIEW = 2;
    private static OANavPanel oaNavPanel = null;
    private TreePath paths = null;
    private String view = null;
    private CustomView customView = null;
    private DefaultTreeModel model = null;
    private AppDefaultWin defaultWin = null;
    private int refreshType = 0;
    private boolean continueProcess = true;

    public void run() {
        ProcessManagerSystem.addProcess(this);
        if (this.refreshType == 1) {
            this.refreshPrebuiltView();
        } else if (this.refreshType == 2) {
            this.refreshCustomView();
        }
        if (this.continueProcess) {
            ProcessManagerSystem.removeProcess(this);
        }
    }

    private void refreshCustomView() {
        Vector vector = null;
        this.defaultWin.setStatus(Str.getStr(14));
        Qit.setEnabled(false);
        vector = this.customView.getResults();
        this.populateTree(this.model, (StringTreeNode)this.model.getRoot(), vector);
        if (this.continueProcess) {
            Qit.setEnabled(true);
            this.defaultWin.setStatus(null);
        }
    }

    private void refreshPrebuiltView() {
        try {
            Object object = null;
            if (this.paths != null) {
                ViewTreeNode viewTreeNode;
                object = this.paths.getLastPathComponent();
                if (object instanceof StringTreeNode) {
                    StringTreeNode stringTreeNode = (StringTreeNode)object;
                } else if (object instanceof ViewTreeNode && (viewTreeNode = (ViewTreeNode)object).toSQL() != null) {
                    if (this.view.equals("com.ibm.nzna.projects.qit.avalon.oanav.views.ViewSymptomTitle") || this.view.equals("com.ibm.nzna.projects.qit.avalon.oanav.views.ViewSymptomStatus") || this.view.equals("com.ibm.nzna.projects.qit.avalon.oanav.views.ViewCPRSymptom") || this.view.equals("com.ibm.nzna.projects.qit.avalon.oanav.views.ViewOrphanedSymptom") || this.view.equals("com.ibm.nzna.projects.qit.avalon.oanav.views.ViewArchivedSymptom") || this.view.equals("com.ibm.nzna.projects.qit.avalon.oanav.views.ViewSymptomType")) {
                        this.populateTree(this.model, viewTreeNode, OASQL.readSymptomList(viewTreeNode.toSQL()));
                    } else if (this.view.equals("com.ibm.nzna.projects.qit.avalon.oanav.views.ViewDraftSymptomTitle") || this.view.equals("com.ibm.nzna.projects.qit.avalon.oanav.views.ViewNewDraftActivitySymptom") || this.view.equals("com.ibm.nzna.projects.qit.avalon.oanav.views.ViewClosedDraftActivitySymptom") || this.view.equals("com.ibm.nzna.projects.qit.avalon.oanav.views.ViewDraftSymptomStatus") || this.view.equals("com.ibm.nzna.projects.qit.avalon.oanav.views.ViewDraftSymptomType")) {
                        this.populateTree(this.model, viewTreeNode, OASQL.readDraftSymptomList(viewTreeNode.toSQL()));
                    } else if (this.view.equals("com.ibm.nzna.projects.qit.avalon.oanav.views.ViewQuestionTitle") || this.view.equals("com.ibm.nzna.projects.qit.avalon.oanav.views.ViewCPRQuestion") || this.view.equals("com.ibm.nzna.projects.qit.avalon.oanav.views.ViewOrphanedQuestion") || this.view.equals("com.ibm.nzna.projects.qit.avalon.oanav.views.ViewArchivedQuestion") || this.view.equals("com.ibm.nzna.projects.qit.avalon.oanav.views.ViewQuestionType")) {
                        this.populateTree(this.model, viewTreeNode, OASQL.readQuestionList(viewTreeNode.toSQL()));
                    } else if (this.view.equals("com.ibm.nzna.projects.qit.avalon.oanav.views.ViewDraftQuestionTitle") || this.view.equals("com.ibm.nzna.projects.qit.avalon.oanav.views.ViewNewDraftActivityQuestion") || this.view.equals("com.ibm.nzna.projects.qit.avalon.oanav.views.ViewClosedDraftActivityQuestion") || this.view.equals("com.ibm.nzna.projects.qit.avalon.oanav.views.ViewDraftQuestionType")) {
                        this.populateTree(this.model, viewTreeNode, OASQL.readDraftQuestionList(viewTreeNode.toSQL()));
                    } else if (this.view.equals("com.ibm.nzna.projects.qit.avalon.oanav.views.ViewActionTitle") || this.view.equals("com.ibm.nzna.projects.qit.avalon.oanav.views.ViewArchivedAction") || this.view.equals("com.ibm.nzna.projects.qit.avalon.oanav.views.ViewOrphanedAction") || this.view.equals("com.ibm.nzna.projects.qit.avalon.oanav.views.ViewCPRAction") || this.view.equals("com.ibm.nzna.projects.qit.avalon.oanav.views.ViewActionType")) {
                        this.populateTree(this.model, viewTreeNode, OASQL.readActionList(viewTreeNode.toSQL()));
                    } else if (this.view.equals("com.ibm.nzna.projects.qit.avalon.oanav.views.ViewDraftActionType") || this.view.equals("com.ibm.nzna.projects.qit.avalon.oanav.views.ViewNewDraftActivityAction") || this.view.equals("com.ibm.nzna.projects.qit.avalon.oanav.views.ViewClosedDraftActivityAction") || this.view.equals("com.ibm.nzna.projects.qit.avalon.oanav.views.ViewDraftActionTitle")) {
                        this.populateTree(this.model, viewTreeNode, OASQL.readActionDraftList(viewTreeNode.toSQL()));
                    } else if (this.view.equals("com.ibm.nzna.projects.qit.avalon.oanav.views.ViewLinkStatus") || this.view.equals("com.ibm.nzna.projects.qit.avalon.oanav.views.ViewArchivedLink") || this.view.equals("com.ibm.nzna.projects.qit.avalon.oanav.views.ViewOrphanedLink") || this.view.equals("com.ibm.nzna.projects.qit.avalon.oanav.views.ViewCPRLink") || this.view.equals("com.ibm.nzna.projects.qit.avalon.oanav.views.ViewLinkType")) {
                        this.populateTree(this.model, viewTreeNode, OASQL.readLinkList(viewTreeNode.toSQL()));
                    } else if (this.view.equals("com.ibm.nzna.projects.qit.avalon.oanav.views.ViewDraftLinkStatus") || this.view.equals("com.ibm.nzna.projects.qit.avalon.oanav.views.ViewNewDraftActivityLink") || this.view.equals("com.ibm.nzna.projects.qit.avalon.oanav.views.ViewClosedDraftActivityLink") || this.view.equals("com.ibm.nzna.projects.qit.avalon.oanav.views.ViewDraftLinkType")) {
                        this.populateTree(this.model, viewTreeNode, OASQL.readDraftLinkList(viewTreeNode.toSQL()));
                    } else if (this.view.equals("com.ibm.nzna.projects.qit.avalon.oanav.views.ViewLinkGroup") || this.view.equals("com.ibm.nzna.projects.qit.avalon.oanav.views.ViewArchivedLinkGroup") || this.view.equals("com.ibm.nzna.projects.qit.avalon.oanav.views.ViewOrphanedLinkGroup") || this.view.equals("com.ibm.nzna.projects.qit.avalon.oanav.views.ViewCPRLinkGroup")) {
                        this.populateTree(this.model, viewTreeNode, OASQL.readLinkGroupList(viewTreeNode.toSQL()));
                    } else if (this.view.equals("com.ibm.nzna.projects.qit.avalon.oanav.views.ViewDraftLinkGroup") || this.view.equals("com.ibm.nzna.projects.qit.avalon.oanav.views.ViewClosedDraftActivityLinkGroup") || this.view.equals("com.ibm.nzna.projects.qit.avalon.oanav.views.ViewNewDraftActivityLinkGroup")) {
                        this.populateTree(this.model, viewTreeNode, OASQL.readDraftLinkGroupList(viewTreeNode.toSQL()));
                    }
                }
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
    }

    protected void populateTree(DefaultTreeModel defaultTreeModel, DefaultMutableTreeNode defaultMutableTreeNode, Vector vector) {
        int n = defaultMutableTreeNode.getChildCount();
        int n2 = PropertySystem.getInt(129);
        int n3 = 0;
        while (n3 < n) {
            ((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0)).removeFromParent();
            ++n3;
        }
        if (vector != null && vector.size() > 0) {
            n3 = 0;
            int n4 = vector.size();
            this.defaultWin.setStatus(Str.getStr(328) + " " + vector.size());
            while (this.continueProcess && n3 < n4) {
                if (vector.elementAt(n3) != null) {
                    ((DisplayRec)vector.elementAt(n3)).setSort(n2);
                }
                ++n3;
            }
            if (this.continueProcess) {
                new QuickSort(vector);
                this.addChildrenToNode(vector, (MutableTreeWrapper)defaultMutableTreeNode);
            } else {
                defaultTreeModel = null;
            }
        }
        if (defaultTreeModel != null && defaultMutableTreeNode != null) {
            defaultTreeModel.reload(defaultMutableTreeNode);
        }
        this.defaultWin.setStatus(null);
    }

    private void addChildrenToNode(Vector vector, DefaultMutableTreeNode defaultMutableTreeNode) {
        int n = vector.size();
        int n2 = 0;
        MutableTreeWrapper mutableTreeWrapper = null;
        this.defaultWin.setValueMax(n);
        while (n2 < n && this.continueProcess) {
            if (vector.elementAt(n2) != null) {
                mutableTreeWrapper = new MutableTreeWrapper(vector.elementAt(n2));
                defaultMutableTreeNode.add(mutableTreeWrapper);
                if (((DisplayRec)vector.elementAt(n2)).containsChildren()) {
                    this.addChildrenToNode(((DisplayRec)vector.elementAt(n2)).getChildren(), mutableTreeWrapper);
                }
            }
            this.defaultWin.setValue(++n2);
        }
        this.defaultWin.setValue(0);
    }

    public String getProcessName() {
        return "RefreshTreeViewThread";
    }

    public void stopProcess() {
        this.continueProcess = false;
        Qit.setEnabled(true);
        if (this.paths != null) {
            oaNavPanel.closeTree(this.paths);
        }
        ProcessManagerSystem.removeProcess(this);
    }

    public RefreshTreeViewThread() {
    }

    public RefreshTreeViewThread(AppDefaultWin appDefaultWin, DefaultTreeModel defaultTreeModel, TreePath treePath, String string, OANavPanel oANavPanel) {
        this.paths = treePath;
        oaNavPanel = oANavPanel;
        this.defaultWin = appDefaultWin;
        this.model = defaultTreeModel;
        this.view = string;
        this.refreshType = 1;
        new Thread(this).start();
    }

    public RefreshTreeViewThread(AppDefaultWin appDefaultWin, DefaultTreeModel defaultTreeModel, CustomView customView, OANavPanel oANavPanel) {
        this.defaultWin = appDefaultWin;
        this.customView = customView;
        this.model = defaultTreeModel;
        oaNavPanel = oANavPanel;
        this.refreshType = 2;
        new Thread(this).start();
    }
}

