/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.bookmark;

import com.ibm.nzna.projects.qit.bookmark.Bookmark;
import com.ibm.nzna.projects.qit.bookmark.BookmarkListener;
import com.ibm.nzna.projects.qit.bookmark.BookmarkSystem;
import com.ibm.nzna.projects.qit.bookmark.BookmarkTreeCellRenderer;
import com.ibm.nzna.shared.gui.StringTreeNode;
import com.ibm.nzna.shared.util.LogSystem;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;

public class BookmarkTree
extends JTree
implements BookmarkListener {
    private JTree tree = null;
    private DefaultTreeModel model = null;
    private boolean folderOnly = false;

    private final void refreshBookmarkList() {
        StringTreeNode stringTreeNode = null;
        Vector vector = BookmarkSystem.getFolders();
        stringTreeNode = new StringTreeNode(BookmarkSystem.getRootFolderName());
        this.model = new DefaultTreeModel(stringTreeNode);
        this.insertBookmarkFolder(this.model, stringTreeNode, BookmarkSystem.getRootFolder());
        this.setModel(this.model);
        this.setRootVisible(false);
        this.expandRow(0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void insertBookmarkFolder(DefaultTreeModel defaultTreeModel, StringTreeNode stringTreeNode, Bookmark bookmark) {
        try {
            int n;
            int n2;
            Vector vector = BookmarkSystem.getFolders(bookmark.getDescript());
            Vector vector2 = BookmarkSystem.getBookmarks(bookmark.getDescript());
            StringTreeNode stringTreeNode2 = null;
            StringTreeNode stringTreeNode3 = stringTreeNode;
            stringTreeNode = new StringTreeNode(bookmark.getDescript(), bookmark);
            stringTreeNode3.add(stringTreeNode);
            if (vector != null && vector.size() > 0) {
                n2 = 0;
                n = vector.size();
                while (n2 < n) {
                    this.insertBookmarkFolder(defaultTreeModel, stringTreeNode, (Bookmark)vector.elementAt(n2));
                    ++n2;
                }
            }
            if (this.folderOnly) return;
            if (vector2 == null) return;
            if (vector2.size() <= 0) return;
            n2 = 0;
            n = vector2.size();
            while (true) {
                if (n2 >= n) {
                    return;
                }
                if (!((Bookmark)vector2.elementAt(n2)).isFolder()) {
                    stringTreeNode2 = new StringTreeNode(((Bookmark)vector2.elementAt(n2)).getDescript(), vector2.elementAt(n2));
                    stringTreeNode.add(stringTreeNode2);
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void finalize() {
        try {
            super.finalize();
            BookmarkSystem.removeBookmarkListener(this);
            return;
        }
        catch (Throwable throwable) {
        }
    }

    public void bookmarkAdded(Bookmark bookmark) {
        StringTreeNode stringTreeNode = this.nodeFromDescript(bookmark.getParentFolder());
        StringTreeNode stringTreeNode2 = this.nodeFromDescript(bookmark.getDescript());
        if (stringTreeNode2 != null) {
            this.model.removeNodeFromParent(stringTreeNode2);
        }
        if (stringTreeNode != null) {
            StringTreeNode stringTreeNode3 = new StringTreeNode(bookmark.getDescript(), bookmark);
            this.model.insertNodeInto(stringTreeNode3, stringTreeNode, stringTreeNode.getChildCount());
        }
    }

    public void bookmarkRemoved(Bookmark bookmark) {
        StringTreeNode stringTreeNode = this.nodeFromDescript(bookmark.getDescript());
        if (stringTreeNode != null) {
            this.model.removeNodeFromParent(stringTreeNode);
        }
    }

    private final StringTreeNode nodeFromDescript(String string) {
        int n = this.getRowCount();
        StringTreeNode stringTreeNode = null;
        StringTreeNode stringTreeNode2 = null;
        int n2 = 0;
        while (n2 < n && stringTreeNode == null) {
            stringTreeNode2 = (StringTreeNode)this.getPathForRow(n2).getLastPathComponent();
            if (stringTreeNode2 != null && stringTreeNode2.toString() != null && stringTreeNode2.toString().equals(string)) {
                stringTreeNode = stringTreeNode2;
            }
            ++n2;
        }
        return stringTreeNode;
    }

    public void setFolderOnly(boolean bl) {
        this.folderOnly = bl;
        this.refreshBookmarkList();
    }

    public BookmarkTree() {
        BookmarkSystem.addBookmarkListener(this);
        this.setCellRenderer(new BookmarkTreeCellRenderer());
        this.refreshBookmarkList();
    }

    public BookmarkTree(boolean bl) {
        this.folderOnly = bl;
        BookmarkSystem.addBookmarkListener(this);
        this.setCellRenderer(new BookmarkTreeCellRenderer());
        this.refreshBookmarkList();
    }
}

