/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.chat;

import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.chat.ChatListener;
import com.ibm.nzna.projects.qit.chat.ChatSession;
import com.ibm.nzna.projects.qit.chat.ChatUser;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.util.FileUtil;
import com.ibm.nzna.shared.util.LogSystem;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;

public class ChatServer
implements Runnable,
AppConst {
    public static final int LISTEN_PORT = 7469;
    private static final byte END_COMMAND_STRING = 3;
    private static final byte END_DATA = 4;
    public static final String VERIFY_CHAT_USER = "VERIFY_CHAT_USER";
    private static ChatServer instance = null;
    private static String ipAddress = null;
    private static ServerSocket serverSocket = null;
    private static int tempFileNum = 0;
    private boolean runServer = true;
    private Thread serverThread = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void startServer() {
        try {
            serverSocket = new ServerSocket(7469);
            ipAddress = InetAddress.getLocalHost().getHostAddress();
            LogSystem.log(1, "ChatServer serving from TCP/IP Address:" + ipAddress);
            this.serverThread = new Thread(this);
            this.serverThread.start();
            return;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
    }

    public static final String getLocalAddress() {
        return ipAddress;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (this.runServer) {
            try {
                Socket socket = serverSocket.accept();
                String string = ChatServer.getStringFromSocket(socket);
                LogSystem.log(1, "ChatServer received socket. Command:" + string);
            }
            catch (Exception exception) {
                LogSystem.log(1, exception);
            }
        }
    }

    public void stopServer() {
        this.runServer = false;
        if (this.serverThread != null) {
            this.serverThread.interrupt();
        }
    }

    private static final String getStringFromSocket(Socket socket) throws Exception {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(socket.getInputStream());
        String string = "";
        byte[] byArray = new byte[1024];
        boolean bl = true;
        while (bl) {
            if (bufferedInputStream.read(byArray, 0, byArray.length) > 0) {
                string = string + new String(byArray);
                continue;
            }
            bl = false;
        }
        bufferedInputStream.close();
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ChatSession beginChat(ChatListener chatListener, String string, String string2, Object object) throws Exception {
        ChatSession chatSession = new ChatSession();
        try {
            Socket socket = new Socket(string, 7469);
            OutputStream outputStream = socket.getOutputStream();
            Object var7_8 = null;
            chatSession.setIPAddr(string);
            chatSession.setSocket(socket);
            chatSession.setChatListener(chatListener);
            if (ChatServer.sendAndReceiveData(chatSession, string2, object) != null) return chatSession;
            return null;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final byte[] getObjectBytes(ChatSession chatSession, Object object) {
        try {
            String string = chatSession.getUniqueId() + tempFileNum++;
            FileUtil.writeObjectToDisk(string, object);
            return FileUtil.readBytesFromFile(string);
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            return null;
        }
    }

    public static void sendData(ChatSession chatSession, String string, Object object) throws Exception {
        Socket socket = chatSession.getSocket();
        OutputStream outputStream = socket.getOutputStream();
        byte[] byArray = ChatServer.getObjectBytes(chatSession, object);
        outputStream.write(string.getBytes());
        outputStream.write(3);
        if (byArray != null) {
            outputStream.write(byArray);
        }
        outputStream.write(4);
        outputStream.flush();
    }

    public static Object getData(ChatSession chatSession) throws Exception {
        Object object;
        Socket socket = chatSession.getSocket();
        InputStream inputStream = socket.getInputStream();
        int n = 1024;
        byte[] byArray = new byte[n];
        byte[] byArray2 = null;
        boolean bl = false;
        int n2 = 0;
        Object object2 = null;
        while (n2 >= 0) {
            n2 = inputStream.read(byArray);
            if (n2 < 0) continue;
            if (byArray2 == null) {
                byArray2 = new byte[n2];
                System.arraycopy(byArray, 0, byArray2, 0, n2);
                continue;
            }
            object = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, object, 0, byArray2.length);
            byArray2 = new byte[((Object)object).length + n2];
            System.arraycopy(object, 0, byArray2, 0, ((Object)object).length);
            System.arraycopy(byArray, 0, byArray2, ((Object)object).length, n2);
        }
        if (byArray2 != null) {
            object = new ByteArrayInputStream(byArray2);
            ObjectInputStream objectInputStream = new ObjectInputStream((InputStream)object);
            object2 = objectInputStream.readObject();
            objectInputStream.close();
            ((ByteArrayInputStream)object).close();
        }
        return object2;
    }

    public static Object sendAndReceiveData(ChatSession chatSession, String string, Object object) throws Exception {
        ChatServer.sendData(chatSession, string, object);
        return ChatServer.getData(chatSession);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Vector getValidUsers() {
        SQLMethod sQLMethod = new SQLMethod(1, "readUsers (Chat)", 5);
        ChatUser chatUser = null;
        Vector vector = null;
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT NAME, IPADDR " + "FROM TIGRIS.USERID " + "WHERE IPADDR IS NOT NULL AND " + "IPADDR <> '000.000.000.000' AND " + "USERID <> '" + UserSystem.getUserId() + "' FOR FETCH ONLY");
            vector.removeAllElements();
            while (true) {
                if (!resultSet.next()) {
                    resultSet.close();
                    return vector;
                }
                chatUser = new ChatUser(resultSet.getString(1).trim(), resultSet.getString(2).trim());
                vector.addElement(chatUser);
            }
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception, false);
            GUISystem.printBox(7, 1302);
        }
        return vector;
    }

    public ChatServer() {
        if (instance == null) {
            instance = this;
            this.startServer();
        }
    }
}

