/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.customer;

import com.ibm.nzna.projects.common.clio.Counter;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.gui.MultiListRow;
import com.ibm.nzna.shared.pom.PersistentRec;
import com.ibm.nzna.shared.util.LogSystem;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.Statement;

public class CustomerMachineRec
extends PersistentRec
implements MultiListRow,
AppConst,
Serializable {
    private String machineType = "";
    private String model = "";
    private String serialNumber = "";
    private String brand = "";
    private String family = "";
    private String partNumber = null;
    private String operatingSystem = "";
    private int machineNum = 0;
    private int recNum = 0;

    public void setMachineType(String string) {
        this.machineType = string;
    }

    public void setModel(String string) {
        this.model = string;
    }

    public void setSerialNumber(String string) {
        this.serialNumber = string;
    }

    public void setBrand(String string) {
        this.brand = string;
    }

    public void setFamily(String string) {
        this.family = string;
    }

    public String getMachineType() {
        return this.machineType;
    }

    public String getModel() {
        return this.model;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getBrand() {
        return this.brand;
    }

    public String getFamily() {
        return this.family;
    }

    public int getMachineNum() {
        return this.machineNum;
    }

    public int getRecNum() {
        return this.recNum;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getBrandGroupInd() {
        String string = "getBrandGroupInd";
        SQLMethod sQLMethod = new SQLMethod(2, "getBrandGroupInd", 5);
        int n = 0;
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = null;
            resultSet = statement.executeQuery("SELECT A.BRANDIND FROM " + "CLIO.BRANDS A, " + "CLIO.TYPEBRAND B, " + "CLIO.TYPEGROUP C " + "WHERE B.DESCRIPT = '" + this.brand + "' AND " + "      B.BRANDID  = A.BRANDID AND " + "      C.DESCRIPT = '" + this.family + "' AND " + "      C.GROUPID  = A.GROUPID " + "FOR FETCH ONLY");
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
        }
        catch (Exception exception) {
        }
        sQLMethod.close();
        return n;
    }

    public void generateMachineNum() {
        if (this.machineNum == 0) {
            this.machineNum = Counter.getCounter(LogSystem.getInstance(), "MACHINENUM");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean generateRecNum(int n) {
        String string = "generateRecNum";
        SQLMethod sQLMethod = new SQLMethod(2, "generateRecNum", 5);
        boolean bl = false;
        this.recNum = 0;
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT RECNUM FROM CLIO.CUSTMACH WHERE CUSTNUM = " + n + " ORDER BY RECNUM");
            while (true) {
                if (!resultSet.next()) {
                    ++this.recNum;
                    resultSet.close();
                    break;
                }
                this.recNum = resultSet.getInt(1);
            }
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception, false);
        }
        sQLMethod.close();
        return bl;
    }

    public void setPartNumber(String string) {
        this.partNumber = string;
    }

    public String getPartNumber() {
        return this.partNumber;
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public void setOperatingSystem(String string) {
        this.operatingSystem = string;
    }

    public void setMachineNum(int n) {
        this.machineNum = n;
    }

    public void setRecNum(int n) {
        this.recNum = n;
    }

    public Object getColumnData(int n) {
        String string = null;
        switch (n) {
            case 0: {
                if (this.getRecStatus() == 3) {
                    if (this.partNumber != null) {
                        string = "X - " + this.partNumber + " (Deleted)";
                        break;
                    }
                    string = "X - " + this.machineType + " (Deleted)";
                    break;
                }
                if (this.partNumber != null) {
                    string = this.partNumber;
                    break;
                }
                string = this.machineType;
                break;
            }
            case 1: {
                if (this.partNumber != null) {
                    string = this.machineType;
                    break;
                }
                string = this.model;
                break;
            }
            case 2: {
                string = this.serialNumber;
                break;
            }
            case 3: {
                string = this.brand;
                break;
            }
            case 4: {
                string = this.family;
                break;
            }
            case 5: {
                string = this.operatingSystem;
                break;
            }
        }
        return string;
    }
}

