/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.customer;

import com.ibm.nzna.projects.common.clio.Counter;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.DateSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.customer.CustomerAddressRec;
import com.ibm.nzna.projects.qit.customer.CustomerConstants;
import com.ibm.nzna.projects.qit.customer.CustomerMachineRec;
import com.ibm.nzna.projects.qit.customer.CustomerPhoneRec;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.gui.MultiListRow;
import com.ibm.nzna.shared.pom.PersistentRec;
import com.ibm.nzna.shared.util.LogSystem;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;

public class CustomerRec
extends PersistentRec
implements MultiListRow,
AppConst,
Serializable,
CustomerConstants {
    private int custNum = 0;
    private String firstName = "";
    private String middleInitial = "";
    private String lastName = "";
    private String suffix = "";
    private String salutation = "";
    private String eMailAddress = "";
    private boolean validEMail = false;
    private String userId = "";
    private String password = "";
    private String prettyChangedtime = "";
    private String prettyDBUser = "";
    private String dbUser = "";
    private String changedTime = "";
    private String company = "";
    private String company2 = "";
    private String question = "";
    private String answer = "";
    private int callCount = 0;
    private Vector phoneVec = null;
    private Vector addressVec = null;
    private Vector machineVec = null;
    private Vector optionVec = null;

    public void setCustNum(int n) {
        this.custNum = n;
    }

    public int getCustNum() {
        return this.custNum;
    }

    public void setFieldData(int n, Object object) {
        switch (n) {
            case 2: {
                if (object == null || !(object instanceof String)) break;
                this.firstName = ((String)object).trim();
                break;
            }
            case 31: {
                if (object != null && object instanceof String) {
                    if (((String)object).equals("Y")) {
                        this.validEMail = true;
                        break;
                    }
                    this.validEMail = false;
                    break;
                }
                if (object == null || !(object instanceof Boolean)) break;
                this.validEMail = (Boolean)object;
                break;
            }
            case 3: {
                if (object == null || !(object instanceof String)) break;
                this.middleInitial = ((String)object).trim();
                break;
            }
            case 4: {
                if (object == null || !(object instanceof String)) break;
                this.lastName = ((String)object).trim();
                break;
            }
            case 5: {
                if (object == null || !(object instanceof String)) break;
                this.suffix = ((String)object).trim();
                break;
            }
            case 6: {
                if (object == null || !(object instanceof String)) break;
                this.salutation = ((String)object).trim();
                break;
            }
            case 1: {
                if (object == null || !(object instanceof String)) break;
                this.eMailAddress = ((String)object).trim();
                break;
            }
            case 7: {
                if (object == null || !(object instanceof String)) break;
                this.userId = ((String)object).trim();
                break;
            }
            case 8: {
                if (object == null || !(object instanceof String)) break;
                this.password = ((String)object).trim();
                break;
            }
            case 9: {
                if (object == null || !(object instanceof String)) break;
                this.company = ((String)object).trim();
                break;
            }
            case 28: {
                if (object == null || !(object instanceof String)) break;
                this.company2 = ((String)object).trim();
                break;
            }
            case 30: {
                this.changedTime = (String)object;
                this.prettyChangedtime = DateSystem.prettyDateFromStamp(this.changedTime);
                break;
            }
            case 29: {
                this.dbUser = (String)object;
                this.prettyDBUser = UserSystem.getNameFromUserId(this.dbUser);
                break;
            }
        }
    }

    public Object getFieldData(int n) {
        Object object = null;
        switch (n) {
            case 31: {
                object = new Boolean(this.validEMail);
                break;
            }
            case 2: {
                object = this.firstName;
                break;
            }
            case 3: {
                object = this.middleInitial;
                break;
            }
            case 4: {
                object = this.lastName;
                break;
            }
            case 5: {
                object = this.suffix;
                break;
            }
            case 6: {
                object = this.salutation;
                break;
            }
            case 1: {
                object = this.eMailAddress;
                break;
            }
            case 7: {
                object = this.userId;
                break;
            }
            case 8: {
                object = this.password;
                break;
            }
            case 25: {
                object = this.addressVec;
                break;
            }
            case 24: {
                object = this.machineVec;
                break;
            }
            case 26: {
                object = this.phoneVec;
                break;
            }
            case 27: {
                object = this.optionVec;
                break;
            }
            case 9: {
                object = this.company;
                break;
            }
            case 30: {
                object = this.changedTime;
                break;
            }
            case 32: {
                object = this.prettyChangedtime;
                break;
            }
        }
        return object;
    }

    public Object getColumnData(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = new String("" + this.custNum);
                break;
            }
            case 1: {
                string = new String(this.firstName + " " + this.middleInitial + " " + this.lastName);
                break;
            }
            case 2: {
                string = this.eMailAddress;
                break;
            }
            case 3: {
                string = this.userId;
                break;
            }
            case 4: {
                string = this.prettyChangedtime;
                break;
            }
            case 5: {
                string = this.prettyDBUser;
                break;
            }
        }
        return string;
    }

    public void addAddressRec(CustomerAddressRec customerAddressRec) {
        if (this.addressVec == null) {
            this.addressVec = new Vector(1, 1);
        }
        this.addressVec.addElement(customerAddressRec);
    }

    public void addMachineRec(CustomerMachineRec customerMachineRec) {
        if (this.machineVec == null) {
            this.machineVec = new Vector(1, 1);
        }
        this.machineVec.addElement(customerMachineRec);
    }

    public void addOptionRec(CustomerMachineRec customerMachineRec) {
        if (this.optionVec == null) {
            this.optionVec = new Vector(1, 1);
        }
        this.optionVec.addElement(customerMachineRec);
    }

    public void addPhoneRec(CustomerPhoneRec customerPhoneRec) {
        if (this.phoneVec == null) {
            this.phoneVec = new Vector(1, 1);
        }
        this.phoneVec.addElement(customerPhoneRec);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof String) {
            return ((String)object).equals(this.eMailAddress);
        }
        if (!(object instanceof CustomerRec)) return bl;
        CustomerRec customerRec = (CustomerRec)object;
        try {
            if (!customerRec.eMailAddress.equals(this.eMailAddress)) return false;
            if (!customerRec.firstName.equals(this.firstName)) return false;
            if (!customerRec.lastName.equals(this.lastName)) return false;
            if (!customerRec.suffix.equals(this.suffix)) return false;
            if (!customerRec.salutation.equals(this.salutation)) return false;
            if (!customerRec.userId.equals(this.userId)) return false;
            if (customerRec.password.equals(this.password)) return true;
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int existsInDatabase() {
        SQLMethod sQLMethod = new SQLMethod(2, "existsInDatabase", 5);
        int n = 0;
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT CUSTNUM " + "FROM CLIO.CUSTNUM " + "WHERE EMAILADDR = '" + this.eMailAddress + "' " + "FOR FETCH ONLY");
            if (resultSet.next()) {
                n = 1;
            }
            resultSet.close();
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception, false);
            n = 2;
        }
        sQLMethod.close();
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean saveToDatabase() {
        boolean bl;
        SQLMethod sQLMethod;
        block10: {
            sQLMethod = new SQLMethod(2, "existsInDatabase", 5);
            String string = "saveToDatabase";
            bl = false;
            try {
                Statement statement = sQLMethod.createStatement();
                String string2 = null;
                switch (this.getRecStatus()) {
                    case 3: {
                        if (this.custNum <= 0) break;
                        string2 = "UPDATE CLIO.CUSTNUM SET EDITFLAG = 'N', SHOW = 'N' WHERE CUSTNUM = " + this.custNum;
                        break;
                    }
                    case 2: {
                        if (this.custNum == 0) {
                            this.custNum = Counter.getCounter(LogSystem.getInstance(), "CUSTNUM");
                        }
                        string2 = "INSERT INTO CLIO.CUSTNUM " + "( CUSTNUM,        PARENTCUSTNUM,        PINNUM,                      SALUTATION,        " + "  FNAME,          MI,                   LNAME,                       SUFFIX,            " + "  LANGUAGEIND,    EMAILADDR,            CALLCOUNT,                   ESUPCOUNT,         " + "  SOURCECUSTOMER, CREATEDATE,           LASTUPDATE,                  LASTCALLDATE,      " + "  PINNUMREQUIRED, ORGANIZATION,         CUSTTYPE,                    EDITFLAG,          " + "  SHOW,           VALIDEMAIL,           DBUSER,                      CHANGEDTIME )      " + "VALUES                                                                                  " + "( " + this.custNum + ",    NULL,                 NULL,                        '" + this.salutation + "',  " + " '" + this.firstName + "', '" + this.middleInitial + "', '" + this.lastName + "',               '" + this.suffix + "',      " + "  1,              '" + this.eMailAddress + "',   0,                           0,                 " + " 'CLIOTAB',       CURRENT DATE,         CURRENT DATE,                CURRENT DATE,      " + " 'N',             'N',                  0,                           'Y',               " + " 'Y',             'Y',                 '" + UserSystem.getUserId() + "', CURRENT TIMESTAMP )";
                        break;
                    }
                    case 1: {
                        if (this.custNum == 0 && this.eMailAddress != null && this.eMailAddress.length() > 0) {
                            this.custNum = this.findCustNum();
                        }
                        if (this.custNum <= 0) break;
                        string2 = "UPDATE CLIO.CUSTNUM " + "SET PARENTCUSTNUM  = NULL,                         " + "    PINNUM         = NULL,                         " + "    SALUTATION     = '" + this.salutation + "',             " + "    FNAME          = '" + this.firstName + "',              " + "    MI             = '" + this.middleInitial + "',          " + "    LNAME          = '" + this.lastName + "',               " + "    SUFFIX         = '" + this.suffix + "',                 " + "    LANGUAGEIND    = 1,                            " + "    EMAILADDR      = '" + this.eMailAddress + "',           " + "    SOURCECUSTOMER = 'CLIOTAB',                    " + "    LASTUPDATE     = CURRENT DATE,                 " + "    PINNUMREQUIRED = 'N',                          " + "    ORGANIZATION   = 'N',                          " + "    CUSTTYPE       = 0,                            " + "    DBUSER         = '" + UserSystem.getUserId() + "', " + "    CHANGEDTIME    = CURRENT TIMESTAMP             " + "WHERE CUSTNUM = " + this.custNum;
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
                if (string2 == null) break block10;
                statement.executeUpdate(string2);
                if (this.saveCustMachines(statement) && this.saveCustOptions(statement) && this.saveCustAddress(statement) && this.saveCustPhone(statement) && this.saveCustCompany(statement) && this.saveCustUserId(statement)) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                sQLMethod.rollBack();
                LogSystem.log(1, exception, false);
            }
        }
        sQLMethod.close();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int findCustNum() {
        String string = "findCustNum";
        SQLMethod sQLMethod = new SQLMethod(2, string, 5);
        int n = 0;
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT CUSTNUM FROM CLIO.CUSTNUM WHERE EMAILADDR = '" + this.eMailAddress + "' FOR FETCH ONLY");
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception, false);
            n = -1;
        }
        sQLMethod.close();
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int findCustNumByUserId(String string) {
        String string2 = "findCustNumByUserId ( " + string + " )";
        SQLMethod sQLMethod = new SQLMethod(2, string2, 5);
        int n = 0;
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT CUSTNUM FROM CLIO.CUSTPASSWD WHERE CUSTUSERID = '" + string + "' FOR FETCH ONLY");
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception, false);
            n = -1;
        }
        sQLMethod.close();
        return n;
    }

    private final boolean saveCustMachines(Statement statement) throws Exception {
        boolean bl = false;
        if (this.machineVec != null && this.machineVec.size() > 0) {
            int n = 0;
            int n2 = this.machineVec.size();
            CustomerMachineRec customerMachineRec = null;
            String string = null;
            int n3 = 0;
            while (n < n2) {
                customerMachineRec = (CustomerMachineRec)this.machineVec.elementAt(n);
                n3 = customerMachineRec.getBrandGroupInd();
                if (n3 == 0) {
                    GUISystem.printBox(Str.getStr(6), Str.getStr(1546) + "\nBrand:" + customerMachineRec.getBrand() + "\nFamily:" + customerMachineRec.getFamily());
                    return false;
                }
                string = null;
                switch (customerMachineRec.getRecStatus()) {
                    case 3: {
                        string = "DELETE FROM CLIO.CUSTMACH " + "WHERE MACHINENUM = " + customerMachineRec.getMachineNum() + " AND " + "      CUSTNUM    = " + this.custNum;
                        break;
                    }
                    case 2: {
                        if (customerMachineRec.getMachineNum() == 0) {
                            customerMachineRec.generateMachineNum();
                        }
                        if (customerMachineRec.getRecNum() == 0) {
                            customerMachineRec.generateRecNum(this.custNum);
                        }
                        if (customerMachineRec.getMachineNum() > 0 && customerMachineRec.getRecNum() > 0) {
                            string = "INSERT INTO CLIO.CUSTMACH " + "( CUSTNUM,    RECNUM,     MACHINE,        MODEL,       " + "  SERIAL,     BRANDIND,   SYSPRODNUM,     COMPRODNUM,  " + "  MACHINENUM, SOURCEMACHINE, HARDCOPYPOP, SDTFLAG, " + "  DBUSER,     CHANGEDTIME )               " + "VALUES                                                                                                               " + "( " + this.custNum + ", " + "  " + customerMachineRec.getRecNum() + ", " + " '" + customerMachineRec.getMachineType() + "', " + " '" + customerMachineRec.getModel() + "', " + " '" + customerMachineRec.getSerialNumber() + "', " + " " + n3 + ", " + " '" + customerMachineRec.getMachineType() + "-" + customerMachineRec.getModel() + "', " + " '" + customerMachineRec.getMachineType() + "-" + customerMachineRec.getModel() + "', " + " " + customerMachineRec.getMachineNum() + ", " + " 'CUST', " + " 'N', " + " ' ', " + " '" + UserSystem.getUserId() + "', " + " CURRENT TIMESTAMP)";
                            break;
                        }
                        LogSystem.log(1, "CustomerRec - Cannot generate Machine Num or Rec Num for Insert. CUSTNUM:" + this.custNum);
                        break;
                    }
                    case 1: {
                        if (customerMachineRec.getMachineNum() <= 0) break;
                        string = "UPDATE CLIO.CUSTMACH " + "SET MACHINE      = '" + customerMachineRec.getMachineType() + "', " + "    MODEL        = '" + customerMachineRec.getModel() + "', " + "    SERIAL       = '" + customerMachineRec.getSerialNumber() + "', " + "    BRANDIND     = " + n3 + ", " + "    SYSPRODNUM   = '" + customerMachineRec.getMachineType() + "-" + customerMachineRec.getModel() + "', " + "    DBUSER       = '" + UserSystem.getUserId() + "', " + "    CHANGEDTIME  = CURRENT TIMESTAMP " + "WHERE CUSTNUM    = " + this.custNum + " AND " + "      MACHINENUM = " + customerMachineRec.getMachineNum();
                        break;
                    }
                }
                if (string != null) {
                    statement.executeUpdate(string);
                }
                switch (customerMachineRec.getRecStatus()) {
                    case 3: {
                        string = "DELETE FROM CLIO.CUSTCOMPONENT WHERE MACHINENUM = " + customerMachineRec.getMachineNum() + " AND CUSTNUM = " + this.custNum;
                        break;
                    }
                    case 2: {
                        string = "INSERT INTO CLIO.CUSTCOMPONENT " + "( CUSTNUM,       RECNUM,       BRANDIND,    COMPONENTIND,  " + "  FIRSTCALLDATE, HARDCOPYPOP,  MACHINENUM,  PRODUCTNUM,    " + "  SDTFLAG,       SERVICEIND,   WARRANTY,    DBUSER,        " + "  CHANGEDTIME ) " + "VALUES " + "( " + this.custNum + ", " + "  " + customerMachineRec.getRecNum() + ", " + "  0, " + "  2, " + "  CURRENT DATE, " + "  'N',          " + "  " + customerMachineRec.getMachineNum() + ", " + "  '" + customerMachineRec.getOperatingSystem() + "', " + "  ' ', " + "  2, " + "  365, " + "  USER, " + "  CURRENT TIMESTAMP )";
                        break;
                    }
                    case 1: {
                        string = "UPDATE CLIO.CUSTCOMPONENT " + "SET PRODUCTNUM   = '" + customerMachineRec.getOperatingSystem() + "', " + "    DBUSER       = USER, " + "    CHANGEDTIME  = CURRENT TIMESTAMP " + "WHERE CUSTNUM    = " + this.custNum + " AND " + "      MACHINENUM = " + customerMachineRec.getMachineNum() + " AND " + "      RECNUM     = " + customerMachineRec.getRecNum();
                        break;
                    }
                    default: {
                        string = null;
                        break;
                    }
                }
                ++n;
                if (string == null) continue;
                statement.executeUpdate(string);
            }
            bl = true;
        } else {
            bl = true;
        }
        return bl;
    }

    private final boolean saveCustOptions(Statement statement) throws Exception {
        boolean bl = false;
        if (this.optionVec != null && this.optionVec.size() > 0) {
            int n = 0;
            int n2 = this.optionVec.size();
            CustomerMachineRec customerMachineRec = null;
            String string = null;
            while (n < n2) {
                customerMachineRec = (CustomerMachineRec)this.optionVec.elementAt(n);
                string = null;
                switch (customerMachineRec.getRecStatus()) {
                    case 3: {
                        string = "DELETE FROM CLIO.CUSTOPTION " + "WHERE RECNUM     = " + customerMachineRec.getRecNum() + " AND " + "      CUSTNUM    = " + this.custNum;
                        break;
                    }
                    case 2: {
                        if (customerMachineRec.getMachineNum() == 0) {
                            customerMachineRec.generateMachineNum();
                        }
                        if (customerMachineRec.getRecNum() == 0) {
                            customerMachineRec.generateRecNum(this.custNum);
                        }
                        if (customerMachineRec.getMachineNum() > 0 && customerMachineRec.getRecNum() > 0) {
                            string = "INSERT INTO CLIO.CUSTOPTION " + "( CUSTNUM,    RECNUM,     MACHINE,     SERIAL,  " + "  BRANDIND,   PARTNUM,    HARDCOPYPOP, DBUSER,  " + "  CHANGEDTIME )                                 " + "VALUES                                                                                                               " + "( " + this.custNum + ", " + "  " + customerMachineRec.getRecNum() + ", " + " '" + customerMachineRec.getMachineType() + "', " + " '" + customerMachineRec.getSerialNumber() + "', " + " " + customerMachineRec.getBrandGroupInd() + ", " + " '" + customerMachineRec.getPartNumber() + "', " + " 'N', " + " '" + UserSystem.getUserId() + "', " + " CURRENT TIMESTAMP)";
                            break;
                        }
                        LogSystem.log(1, "CustomerRec - Cannot generate Machine Num or Rec Num for Insert. CUSTNUM:" + this.custNum);
                        break;
                    }
                    case 1: {
                        if (customerMachineRec.getMachineNum() <= 0) break;
                        string = "UPDATE CLIO.CUSTOPTION " + "SET MACHINE      = '" + customerMachineRec.getMachineType() + "', " + "    PARTNUMBER   = '" + customerMachineRec.getPartNumber() + "', " + "    SERIAL       = '" + customerMachineRec.getSerialNumber() + "', " + "    DBUSER       = '" + UserSystem.getUserId() + "', " + "    CHANGEDTIME  = CURRENT TIMESTAMP " + "WHERE CUSTNUM    = " + this.custNum + " AND " + "      RECNUM     = " + customerMachineRec.getRecNum();
                        break;
                    }
                }
                if (string != null) {
                    statement.executeUpdate(string);
                    customerMachineRec.updateRecStatus(0);
                }
                ++n;
            }
            bl = true;
        } else {
            bl = true;
        }
        return bl;
    }

    private final boolean saveCustAddress(Statement statement) throws Exception {
        boolean bl = false;
        if (this.addressVec != null && this.addressVec.size() > 0) {
            int n = 0;
            int n2 = this.addressVec.size();
            CustomerAddressRec customerAddressRec = null;
            String string = null;
            while (n < n2) {
                customerAddressRec = (CustomerAddressRec)this.addressVec.elementAt(n);
                string = null;
                switch (customerAddressRec.getRecStatus()) {
                    case 3: {
                        string = "DELETE FROM CLIO.CUSTADDRESS " + "WHERE RECNUM     = " + customerAddressRec.getRecNum() + " AND " + "      CUSTNUM    = " + this.custNum;
                        break;
                    }
                    case 2: {
                        if (customerAddressRec.getRecNum() == 0) {
                            customerAddressRec.generateRecNum(this.custNum);
                        }
                        if (customerAddressRec.getRecNum() > 0) {
                            string = "INSERT INTO CLIO.CUSTADDRESS " + "( CUSTNUM,    RECNUM,      ADDRESS1,    ADDRESS2,    " + "  ADDRESS3,   ADDRESSIND,  CITY,        STATE,       " + "  ZIPCODE,    COUNTRYCODE, DBUSER,      CHANGEDTIME )" + "VALUES                                                                                                               " + "( " + this.custNum + ", " + "  " + customerAddressRec.getRecNum() + ", " + " '" + customerAddressRec.getAddress1() + "', " + " '" + customerAddressRec.getAddress2() + "', " + " '" + customerAddressRec.getAddress3() + "', " + " 1, " + " '" + customerAddressRec.getCity() + "', " + " '" + customerAddressRec.getState() + "', " + " '" + customerAddressRec.getZipcode() + "', " + " '" + customerAddressRec.getCountryCode() + "', " + " '" + UserSystem.getUserId() + "', " + " CURRENT TIMESTAMP)";
                            break;
                        }
                        LogSystem.log(1, "CustomerRec - Cannot generate Machine Num or Rec Num for Insert. CUSTNUM:" + this.custNum);
                        break;
                    }
                    case 1: {
                        if (customerAddressRec.getRecNum() <= 0) break;
                        string = "UPDATE CLIO.CUSTADDRESS " + "SET ADDRESS1     = '" + customerAddressRec.getAddress1() + "', " + "    ADDRESS2     = '" + customerAddressRec.getAddress2() + "', " + "    ADDRESS3     = '" + customerAddressRec.getAddress3() + "', " + "    CITY         = '" + customerAddressRec.getCity() + "', " + "    STATE        = '" + customerAddressRec.getState() + "', " + "    ZIPCODE      = '" + customerAddressRec.getZipcode() + "', " + "    DBUSER       = '" + UserSystem.getUserId() + "', " + "    CHANGEDTIME  = CURRENT TIMESTAMP " + "WHERE CUSTNUM    = " + this.custNum + " AND " + "      RECNUM     = " + customerAddressRec.getRecNum();
                        break;
                    }
                }
                if (string != null) {
                    statement.executeUpdate(string);
                    customerAddressRec.updateRecStatus(0);
                }
                ++n;
            }
            bl = true;
        } else {
            bl = true;
        }
        return bl;
    }

    private final boolean saveCustPhone(Statement statement) throws Exception {
        boolean bl = false;
        if (this.phoneVec != null && this.phoneVec.size() > 0) {
            int n = 0;
            int n2 = this.phoneVec.size();
            CustomerPhoneRec customerPhoneRec = null;
            String string = null;
            while (n < n2) {
                customerPhoneRec = (CustomerPhoneRec)this.phoneVec.elementAt(n);
                string = null;
                switch (customerPhoneRec.getRecStatus()) {
                    case 3: {
                        string = "DELETE FROM CLIO.CUSTPHONE " + "WHERE RECNUM     = " + customerPhoneRec.getRecNum() + " AND " + "      CUSTNUM    = " + this.custNum;
                        break;
                    }
                    case 2: {
                        if (customerPhoneRec.getRecNum() == 0) {
                            customerPhoneRec.generateRecNum(this.custNum);
                        }
                        if (customerPhoneRec.getRecNum() > 0) {
                            string = "INSERT INTO CLIO.CUSTPHONE " + "( CUSTNUM,    RECNUM,            AREACODE,    EXTENSION,    " + "  PHONE,      PHONECOUNTRYCODE,  PHONENUM,    DBUSER,       " + "  CHANGEDTIME )" + "VALUES                                                                                                               " + "( " + this.custNum + ", " + "  " + customerPhoneRec.getRecNum() + ", " + " '" + customerPhoneRec.getAreaCode() + "', " + " '" + customerPhoneRec.getExtension() + "', " + " '" + customerPhoneRec.getPhone() + "', " + " '" + customerPhoneRec.getPhoneCountryCode() + "', " + " '" + customerPhoneRec.getPhoneNumber() + "', " + " '" + UserSystem.getUserId() + "', " + " CURRENT TIMESTAMP)";
                            break;
                        }
                        LogSystem.log(1, "CustomerRec - Cannot generate Machine Num or Rec Num for Insert. CUSTNUM:" + this.custNum);
                        break;
                    }
                    case 1: {
                        if (customerPhoneRec.getRecNum() <= 0) break;
                        string = "UPDATE CLIO.CUSTPHONE " + "SET AREACODE         = '" + customerPhoneRec.getAreaCode() + "', " + "    EXTENSION        = '" + customerPhoneRec.getExtension() + "', " + "    PHONE            = '" + customerPhoneRec.getPhone() + "', " + "    PHONECOUNTRYCODE = '" + customerPhoneRec.getPhoneCountryCode() + "', " + "    PHONENUM         = '" + customerPhoneRec.getPhoneNumber() + "', " + "    DBUSER           = '" + UserSystem.getUserId() + "', " + "    CHANGEDTIME      = CURRENT TIMESTAMP " + "WHERE CUSTNUM    = " + this.custNum + " AND " + "      RECNUM     = " + customerPhoneRec.getRecNum();
                        break;
                    }
                }
                if (string != null) {
                    statement.executeUpdate(string);
                    customerPhoneRec.updateRecStatus(0);
                }
                ++n;
            }
            bl = true;
        } else {
            bl = true;
        }
        return bl;
    }

    private final boolean saveCustCompany(Statement statement) throws Exception {
        boolean bl = false;
        String string = null;
        switch (this.getRecStatus()) {
            case 2: {
                string = "INSERT INTO CLIO.CUSTCOMPANY         " + "(CUSTNUM, COMPANY, COMPANY2, DBUSER, " + " CHANGEDTIME)                        " + "VALUES                               " + "( " + this.custNum + ",   " + " '" + this.company + "',  " + " '" + this.company2 + "', " + " '" + UserSystem.getUserId() + "', " + " CURRENT TIMESTAMP )";
                break;
            }
            case 3: {
                string = "DELETE FROM CLIO.CUSTCOMPANY         " + "WHERE CUSTNUM = " + this.custNum;
                break;
            }
            case 1: {
                string = "UPDATE CLIO.CUSTCOMPANY " + "SET COMPANY     = '" + this.company + "',  " + "    COMPANY2    = '" + this.company2 + "', " + "    DBUSER      = '" + UserSystem.getUserId() + "', " + "    CHANGEDTIME = CURRENT TIMESTAMP " + "WHERE CUSTNUM   = " + this.custNum;
                break;
            }
        }
        if (string != null) {
            statement.executeUpdate(string);
            bl = true;
        }
        return bl;
    }

    private final boolean saveCustUserId(Statement statement) throws Exception {
        boolean bl = false;
        String string = null;
        switch (this.getRecStatus()) {
            case 2: {
                string = "INSERT INTO CLIO.CUSTPASSWD                   " + "(CUSTNUM,    ATTEMPTS, QUESTION, ANSWER,      " + " CUSTUSERID, PASSWORD, DBUSER,   CHANGEDTIME) " + "VALUES                                        " + "( " + this.custNum + ",   " + "  0,             " + " '" + this.question + "',  " + " '" + this.answer + "', " + " '" + this.userId + "', " + " '" + this.password + "', " + " '" + UserSystem.getUserId() + "', " + " CURRENT TIMESTAMP )";
                break;
            }
            case 3: {
                string = "DELETE FROM CLIO.CUSTPASSWD " + "WHERE CUSTNUM = " + this.custNum;
                break;
            }
            case 1: {
                string = "UPDATE CLIO.CUSTPASSWD " + "SET ATTEMPTS    = 0, " + "    CUSTUSERID  = '" + this.userId + "', " + "    PASSWORD    = '" + this.password + "', " + "    QUESTION    = '" + this.question + "', " + "    ANSWER      = '" + this.answer + "', " + "    DBUSER      = '" + UserSystem.getUserId() + "', " + "    CHANGEDTIME = CURRENT TIMESTAMP " + "WHERE CUSTNUM   = " + this.custNum;
                break;
            }
        }
        if (string != null) {
            statement.executeUpdate(string);
            bl = true;
        }
        return bl;
    }

    public String generateUserId() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        String string = null;
        int n = 1;
        if (this.eMailAddress != null && this.eMailAddress.indexOf("@") > 0) {
            stringBuffer.append(this.eMailAddress.substring(0, this.eMailAddress.indexOf("@")));
            if (CustomerRec.findCustNumByUserId(stringBuffer.toString()) == 0) {
                string = stringBuffer.toString();
            }
        }
        if (string == null) {
            stringBuffer.setLength(0);
            if (this.firstName != null && this.firstName.length() > 1) {
                stringBuffer.append(this.firstName.charAt(0));
            }
            if (this.lastName != null) {
                stringBuffer.append(this.lastName);
            }
            if (CustomerRec.findCustNumByUserId(stringBuffer.toString()) == 0) {
                string = stringBuffer.toString();
            }
        }
        if (string == null) {
            while (string == null && n < 50) {
                if (CustomerRec.findCustNumByUserId(stringBuffer.toString() + n) == 0) {
                    string = stringBuffer.toString() + n;
                }
                ++n;
            }
        }
        this.userId = string;
        return string;
    }

    public void generateCustNum() {
        this.custNum = Counter.getCounter(LogSystem.getInstance(), "CUSTNUM");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int readFromDatabase() {
        int n = 0;
        String string = "readFromDatabase";
        SQLMethod sQLMethod = new SQLMethod(2, string, 5);
        if (this.custNum <= 0) return n;
        try {
            Statement statement = sQLMethod.createStatement();
            String string2 = null;
            ResultSet resultSet = null;
            string2 = "SELECT A.CUSTNUM,     A.FNAME,       A.MI,          A.LNAME,      " + "       A.SUFFIX,      A.SALUTATION,  A.EMAILADDR,   A.VALIDEMAIL, " + "       A.ESUPCOUNT                                                " + "FROM CLIO.CUSTNUM     A                                           " + "WHERE A.CUSTNUM = " + this.custNum + "                                     " + "FOR FETCH ONLY";
            resultSet = statement.executeQuery(string2);
            if (!resultSet.next()) return n;
            this.setCustNum(resultSet.getInt(1));
            this.setFieldData(2, resultSet.getString(2).trim());
            this.setFieldData(3, resultSet.getString(3).trim());
            this.setFieldData(4, resultSet.getString(4).trim());
            this.setFieldData(5, resultSet.getString(5).trim());
            this.setFieldData(6, resultSet.getString(6).trim());
            this.setFieldData(1, resultSet.getString(7).trim());
            this.setFieldData(31, resultSet.getString(8).trim());
            this.setCallCount(resultSet.getInt(9));
            string2 = "SELECT CUSTUSERID, PASSWORD FROM CLIO.CUSTPASSWD " + "WHERE CUSTNUM = " + this.custNum + " FOR FETCH ONLY";
            resultSet = statement.executeQuery(string2);
            if (resultSet.next()) {
                this.setFieldData(7, resultSet.getString(1).trim());
                this.setFieldData(8, resultSet.getString(2).trim());
            }
            if ((resultSet = statement.executeQuery(string2 = "SELECT COMPANY, COMPANY2 FROM CLIO.CUSTCOMPANY " + "WHERE CUSTNUM = " + this.custNum + " FOR FETCH ONLY")).next()) {
                try {
                    this.setFieldData(9, resultSet.getString(1).trim());
                    this.setFieldData(28, resultSet.getString(2).trim());
                }
                catch (NullPointerException nullPointerException) {
                }
            }
            resultSet.close();
            sQLMethod.close();
            int n2 = n = this.readCustMachines() ? 1 : 0;
            if (n == 1) {
                int n3 = n = this.readCustOptions() ? 1 : 0;
            }
            if (n == 1) {
                n = this.readCustPhone() ? 1 : 0;
            }
            if (n != 1) return n;
            if (!this.readCustAddress()) return 0;
            return 1;
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            sQLMethod.close();
            LogSystem.log(1, exception, false);
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean readCustMachines() {
        boolean bl = false;
        String string = "readCustMachines";
        SQLMethod sQLMethod = new SQLMethod(2, string, 5);
        if (this.custNum > 0) {
            try {
                CustomerMachineRec customerMachineRec = null;
                Statement statement = sQLMethod.createStatement();
                String string2 = null;
                ResultSet resultSet = null;
                string2 = "SELECT A.MACHINE,  A.MODEL,    A.SERIAL,  B.PRODUCTNUM, " + "       C.DESCRIPT, D.DESCRIPT, A.DEFAULT, A.MACHINENUM  " + "FROM CLIO.CUSTMACH      A, " + "     CLIO.CUSTCOMPONENT B, " + "     CLIO.TYPEBRAND     C, " + "     CLIO.TYPEGROUP     D, " + "     CLIO.BRANDS        E  " + "WHERE A.CUSTNUM    = " + this.custNum + " AND  " + "      B.MACHINENUM = A.MACHINENUM AND " + "      E.BRANDIND   = A.BRANDIND AND   " + "      D.GROUPID    = E.GROUPID AND    " + "      C.BRANDID    = E.BRANDID        " + "FOR FETCH ONLY";
                resultSet = statement.executeQuery(string2);
                this.machineVec = new Vector(10, 1);
                while (true) {
                    if (!resultSet.next()) {
                        bl = true;
                        break;
                    }
                    customerMachineRec = new CustomerMachineRec();
                    customerMachineRec.setMachineType(resultSet.getString(1).trim());
                    customerMachineRec.setModel(resultSet.getString(2).trim());
                    customerMachineRec.setSerialNumber(resultSet.getString(3).trim());
                    customerMachineRec.setOperatingSystem(resultSet.getString(4).trim());
                    customerMachineRec.setBrand(resultSet.getString(5).trim());
                    customerMachineRec.setFamily(resultSet.getString(6).trim());
                    customerMachineRec.setMachineNum(resultSet.getInt(8));
                    this.machineVec.addElement(customerMachineRec);
                }
            }
            catch (Exception exception) {
                sQLMethod.rollBack();
                LogSystem.log(1, exception, true);
            }
        }
        sQLMethod.close();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean readCustOptions() {
        boolean bl = false;
        String string = "readCustOptions";
        SQLMethod sQLMethod = new SQLMethod(2, string, 5);
        if (this.custNum > 0) {
            try {
                CustomerMachineRec customerMachineRec = null;
                Statement statement = sQLMethod.createStatement();
                String string2 = null;
                ResultSet resultSet = null;
                string2 = "SELECT A.MACHINE,  A.PARTNUM,  A.SERIAL,  C.DESCRIPT,   " + "       D.DESCRIPT, A.RECNUM " + "FROM CLIO.CUSTOPTION    A, " + "     CLIO.TYPEBRAND     C, " + "     CLIO.TYPEGROUP     D, " + "     CLIO.BRANDS        E  " + "WHERE A.CUSTNUM    = " + this.custNum + " AND  " + "      E.BRANDIND   = A.BRANDIND AND   " + "      D.GROUPID    = E.GROUPID AND    " + "      C.BRANDID    = E.BRANDID        " + "FOR FETCH ONLY";
                resultSet = statement.executeQuery(string2);
                this.optionVec = new Vector(10, 1);
                while (true) {
                    if (!resultSet.next()) {
                        bl = true;
                        break;
                    }
                    customerMachineRec = new CustomerMachineRec();
                    customerMachineRec.setMachineType(resultSet.getString(1).trim());
                    customerMachineRec.setPartNumber(resultSet.getString(2).trim());
                    customerMachineRec.setSerialNumber(resultSet.getString(3).trim());
                    customerMachineRec.setBrand(resultSet.getString(4).trim());
                    customerMachineRec.setFamily(resultSet.getString(5).trim());
                    customerMachineRec.setRecNum(resultSet.getInt(6));
                    this.optionVec.addElement(customerMachineRec);
                }
            }
            catch (Exception exception) {
                sQLMethod.rollBack();
                LogSystem.log(1, exception, true);
            }
        }
        sQLMethod.close();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean readCustPhone() {
        boolean bl = false;
        String string = "readCustPhone";
        SQLMethod sQLMethod = new SQLMethod(2, string, 5);
        if (this.custNum > 0) {
            try {
                CustomerPhoneRec customerPhoneRec = null;
                Statement statement = sQLMethod.createStatement();
                String string2 = null;
                ResultSet resultSet = null;
                string2 = "SELECT PHONENUM, PHONE, PHONECOUNTRYCODE, EXTENSION, RECNUM, AREACODE " + "FROM CLIO.CUSTPHONE " + "WHERE CUSTNUM    = " + this.custNum + "  " + "FOR FETCH ONLY";
                resultSet = statement.executeQuery(string2);
                this.phoneVec = new Vector(10, 1);
                while (true) {
                    if (!resultSet.next()) {
                        bl = true;
                        break;
                    }
                    customerPhoneRec = new CustomerPhoneRec();
                    if (resultSet.getString(1) != null) {
                        customerPhoneRec.setPhoneNumber(resultSet.getString(1).trim());
                    } else {
                        customerPhoneRec.setPhoneNumber("");
                    }
                    if (resultSet.getString(2) != null) {
                        customerPhoneRec.setPhone(resultSet.getString(2).trim());
                    } else {
                        customerPhoneRec.setPhone("");
                    }
                    if (resultSet.getString(3) != null) {
                        customerPhoneRec.setPhoneCountryCode(resultSet.getString(3).trim());
                    } else {
                        customerPhoneRec.setPhoneCountryCode("");
                    }
                    if (resultSet.getString(4) != null) {
                        customerPhoneRec.setExtension(resultSet.getString(4).trim());
                    } else {
                        customerPhoneRec.setExtension("");
                    }
                    customerPhoneRec.setRecNum(resultSet.getInt(5));
                    if (resultSet.getString(6) != null) {
                        customerPhoneRec.setAreaCode(resultSet.getString(6).trim());
                    } else {
                        customerPhoneRec.setAreaCode("");
                    }
                    this.phoneVec.addElement(customerPhoneRec);
                }
            }
            catch (Exception exception) {
                sQLMethod.rollBack();
                LogSystem.log(1, exception, true);
            }
        }
        sQLMethod.close();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean readCustAddress() {
        boolean bl = false;
        String string = "readCustAddress";
        SQLMethod sQLMethod = new SQLMethod(2, string, 5);
        if (this.custNum > 0) {
            try {
                CustomerAddressRec customerAddressRec = null;
                Statement statement = sQLMethod.createStatement();
                String string2 = null;
                ResultSet resultSet = null;
                string2 = "SELECT A.ADDRESS1, A.ADDRESS2, A.ADDRESS3,    A.CITY,     " + "       A.STATE,    A.ZIPCODE,  A.COUNTRYCODE, B.DESCRIPT, " + "       A.RECNUM                                           " + "FROM CLIO.CUSTADDRESS A,                                  " + "     CLIO.TYPEADDRESS B                                   " + "WHERE A.CUSTNUM    = " + this.custNum + "  AND                     " + "      A.ADDRESSIND = B.ADDRESSIND                         " + "FOR FETCH ONLY";
                resultSet = statement.executeQuery(string2);
                this.addressVec = new Vector(10, 1);
                while (true) {
                    if (!resultSet.next()) {
                        bl = true;
                        break;
                    }
                    customerAddressRec = new CustomerAddressRec();
                    customerAddressRec.setAddress1(resultSet.getString(1).trim());
                    customerAddressRec.setAddress2(resultSet.getString(2).trim());
                    customerAddressRec.setAddress3(resultSet.getString(3).trim());
                    customerAddressRec.setCity(resultSet.getString(4).trim());
                    customerAddressRec.setState(resultSet.getString(5).trim());
                    customerAddressRec.setZipcode(resultSet.getString(6).trim());
                    customerAddressRec.setAddressType(resultSet.getString(8).trim());
                    customerAddressRec.setRecNum(resultSet.getInt(9));
                    this.addressVec.addElement(customerAddressRec);
                }
            }
            catch (Exception exception) {
                sQLMethod.rollBack();
                LogSystem.log(1, exception, true);
            }
        }
        sQLMethod.close();
        return bl;
    }

    public void setCallCount(int n) {
        this.callCount = n;
    }

    public int getCallCount() {
        return this.callCount;
    }

    public void removeMachineRec(CustomerMachineRec customerMachineRec) {
        customerMachineRec.updateRecStatus(3);
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public CustomerRec() {
    }

    public CustomerRec(int n) {
        this.setCustNum(n);
    }
}

