/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.customview;

import com.ibm.nzna.projects.common.storedProc.StoredProcUtil;
import com.ibm.nzna.projects.qit.Qit;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.MainWindow;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.customview.CustomView;
import com.ibm.nzna.projects.qit.customview.CustomViewListener;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.util.FileUtil;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.Text;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;

public class CustomViewSystem
implements Runnable,
AppConst {
    private static final String THREAD_FIRE_ADDED = "FA";
    private static final String THREAD_FIRE_UPDATED = "FU";
    private static final String THREAD_FIRE_REMOVED = "FR";
    private static final String THREAD_SAVE = "SA";
    private static Vector views = null;
    private static Vector listeners = null;
    private CustomView actionObject = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void readViews() {
        SQLMethod sQLMethod = new SQLMethod(1, "CustomViewSystem.readViews", 5);
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = null;
            CustomView customView = null;
            resultSet = statement.executeQuery("SELECT CUSTOMVIEWIND, TYPECUSTOMVIEWIND, DESCRIPT, VIEWOBJECT, " + "       USERGROUPIND,  DBUSER,            CHANGEDTIME " + "FROM QIT.CUSTOMVIEW WHERE (DBUSER = '" + UserSystem.getUserId() + "' OR " + "                           USERGROUPIND in (SELECT USERGROUPIND FROM TIGRIS.USERIDUSERGROUP WHERE USERID = '" + UserSystem.getUserId() + "'))");
            while (true) {
                if (!resultSet.next()) {
                    resultSet.close();
                    statement.close();
                    break;
                }
                try {
                    customView = (CustomView)StoredProcUtil.getObjectFromResultSet(resultSet, 4);
                    if (views == null) {
                        views = new Vector(1);
                    }
                    views.addElement(customView);
                }
                catch (InvalidClassException invalidClassException) {
                    Statement statement2 = sQLMethod.createStatement();
                    LogSystem.log(1, "Could not Read Custom View. VIEWIND:" + resultSet.getInt(1) + "  Description:" + resultSet.getString(3));
                    statement2.executeUpdate("DELETE FROM QIT.CUSTOMVIEW WHERE CUSTOMVIEWIND = " + resultSet.getInt(1));
                }
            }
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception, false);
        }
        sQLMethod.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean writeViews() {
        boolean bl = false;
        SQLMethod sQLMethod = new SQLMethod(1, "CustomViewSystem.writeViews", 5);
        String string = null;
        try {
            PreparedStatement preparedStatement = null;
            int n = 0;
            if (views != null && views.size() > 0) {
                int n2 = views.size();
                CustomView customView = null;
                boolean bl2 = true;
                while (n < n2) {
                    Object object;
                    customView = (CustomView)views.elementAt(n);
                    bl2 = true;
                    switch (customView.getRecStatus()) {
                        case 2: {
                            if (customView.getViewInd() == 0) {
                                customView.assignViewInd();
                            }
                            string = "INSERT INTO QIT.CUSTOMVIEW " + "( CUSTOMVIEWIND, TYPECUSTOMVIEWIND, DESCRIPT, VIEWOBJECT, " + "  USERGROUPIND,  DBUSER,            CHANGEDTIME ) " + "values " + "( " + customView.getViewInd() + ", " + "  " + customView.getViewType() + ", " + "  '" + Text.cleanDBString(customView.getDescript()) + "', " + "  ?, " + "  " + (customView.getTeamInd() == -1 ? "null" : "" + customView.getTeamInd()) + ", " + " '" + UserSystem.getUserId() + "', " + " CURRENT TIMESTAMP )";
                            customView.updateRecStatus(0);
                            break;
                        }
                        case 1: {
                            string = "UPDATE QIT.CUSTOMVIEW " + "SET CUSTOMVIEWIND     = " + customView.getViewInd() + ", " + "    TYPECUSTOMVIEWIND = " + customView.getViewType() + ", " + "    DESCRIPT          = '" + Text.cleanDBString(customView.getDescript()) + "', " + "    VIEWOBJECT        = ?, " + "    USERGROUPIND      = " + (customView.getTeamInd() == -1 ? "null" : "" + customView.getTeamInd()) + ", " + "    DBUSER            = '" + UserSystem.getUserId() + "', " + "    CHANGEDTIME       = CURRENT TIMESTAMP " + "WHERE CUSTOMVIEWIND = " + customView.getViewInd();
                            customView.updateRecStatus(0);
                            break;
                        }
                        case 3: {
                            object = sQLMethod.createStatement();
                            object.executeUpdate("DELETE FROM QIT.CUSTOMVIEW WHERE CUSTOMVIEWIND = " + customView.getViewInd());
                            break;
                        }
                        default: {
                            string = null;
                            bl2 = false;
                            break;
                        }
                    }
                    if (string != null && bl2) {
                        FileUtil.writeObjectToDisk("tempcustomview.ser", customView);
                        object = new File("tempcustomview.ser");
                        FileInputStream fileInputStream = new FileInputStream((File)object);
                        byte[] byArray = FileUtil.readBytesFromFile("tempcustomview.ser");
                        preparedStatement = sQLMethod.createPreparedStatement(string);
                        preparedStatement.setBinaryStream(1, (InputStream)new ByteArrayInputStream(byArray), byArray.length);
                        LogSystem.log(1, string);
                        fileInputStream.close();
                        FileUtil.deleteFile("tempcustomview.ser");
                        preparedStatement.execute();
                        preparedStatement.close();
                        preparedStatement = null;
                    }
                    ++n;
                }
                n = 0;
                while (n < n2) {
                    customView = (CustomView)views.elementAt(n);
                    if (!customView.valid()) {
                        views.removeElementAt(n);
                        n = 0;
                        --n2;
                    } else {
                        customView.updateRecStatus(0);
                    }
                    ++n;
                }
                bl = true;
            }
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception, false);
            GUISystem.printBox(6, 1252);
        }
        sQLMethod.close();
        return bl;
    }

    public static Vector getViews(int n) {
        Vector vector = new Vector(1, 1);
        if (views != null) {
            int n2 = 0;
            int n3 = views.size();
            while (n2 < n3) {
                if (((CustomView)views.elementAt(n2)).getViewType() == n && ((CustomView)views.elementAt(n2)).valid()) {
                    vector.addElement(views.elementAt(n2));
                }
                ++n2;
            }
        }
        return vector;
    }

    public static void addView(CustomView customView) {
        views.addElement(customView);
        new CustomViewSystem(THREAD_FIRE_ADDED, customView);
    }

    public static CustomView getView(String string) {
        int n = 0;
        int n2 = views.size();
        CustomView customView = null;
        while (customView == null && n < n2) {
            if (((CustomView)views.elementAt(n)).getDescript().equals(string)) {
                customView = (CustomView)views.elementAt(n);
            }
            ++n;
        }
        return customView;
    }

    public static void removeView(CustomView customView) {
        customView.updateRecStatus(3);
        new CustomViewSystem(THREAD_FIRE_REMOVED, customView);
    }

    public static Vector getViews() {
        return views;
    }

    public static CustomView getViewFromDescript(String string) {
        int n = 0;
        int n2 = views.size();
        CustomView customView = null;
        while (customView == null && n < n2) {
            if (((CustomView)views.elementAt(n)).getDescript().equals(string)) {
                customView = (CustomView)views.elementAt(n);
            }
            ++n;
        }
        return customView;
    }

    public static void addCustomViewListener(CustomViewListener customViewListener) {
        if (listeners == null) {
            listeners = new Vector(1, 10);
        }
        listeners.addElement(customViewListener);
    }

    public static void removeCustomViewListener(CustomViewListener customViewListener) {
        if (listeners != null) {
            listeners.removeElement(customViewListener);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        String string = Thread.currentThread().getName();
        if (string.equals(THREAD_FIRE_ADDED)) {
            this.fireCustomViewAdded(this.actionObject);
        } else if (string.equals(THREAD_FIRE_REMOVED)) {
            this.fireCustomViewRemoved(this.actionObject);
        } else if (string.equals(THREAD_FIRE_UPDATED)) {
            this.fireCustomViewUpdated(this.actionObject);
        }
        if (string.equals(THREAD_FIRE_ADDED) || string.equals(THREAD_FIRE_REMOVED) || string.equals(THREAD_FIRE_UPDATED) || string.equals(THREAD_SAVE)) {
            Qit.setEnabled(false);
            try {
                MainWindow.getInstance().setStatus(1032);
                CustomViewSystem.writeViews();
                MainWindow.getInstance().setStatus(null);
            }
            catch (Exception exception) {
                LogSystem.log(1, exception, false);
            }
            Qit.setEnabled(true);
        }
    }

    private final void fireCustomViewAdded(CustomView customView) {
        if (listeners != null) {
            int n = 0;
            int n2 = listeners.size();
            while (n < n2) {
                ((CustomViewListener)listeners.elementAt(n)).customViewAdded(customView);
                ++n;
            }
        }
    }

    private final void fireCustomViewRemoved(CustomView customView) {
        if (listeners != null) {
            int n = 0;
            int n2 = listeners.size();
            while (n < n2) {
                ((CustomViewListener)listeners.elementAt(n)).customViewRemoved(customView);
                ++n;
            }
        }
    }

    private final void fireCustomViewUpdated(CustomView customView) {
        if (listeners != null) {
            int n = 0;
            int n2 = listeners.size();
            while (n < n2) {
                ((CustomViewListener)listeners.elementAt(n)).customViewUpdated(customView);
                ++n;
            }
        }
    }

    public static void updateView(CustomView customView) {
        new CustomViewSystem(THREAD_FIRE_UPDATED, customView);
    }

    public CustomViewSystem() {
        views = new Vector(1, 1);
    }

    CustomViewSystem(String string, CustomView customView) {
        this.actionObject = customView;
        new Thread((Runnable)this, string).start();
    }
}

