/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.dbgui;

import com.ibm.nzna.projects.common.quest.brand.Brands;
import com.ibm.nzna.projects.common.quest.type.TypeBrandRec;
import com.ibm.nzna.projects.common.quest.type.TypeGroupRec;
import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.projects.common.quest.type.TypeRec;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.gui.NavList;
import com.ibm.nzna.projects.qit.gui.NavListGroup;
import com.ibm.nzna.shared.gui.HotLinkGroup;
import com.ibm.nzna.shared.gui.HotLinkLabel;
import java.awt.BorderLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class BrandFamilyNavList
extends JPanel
implements Runnable,
ActionListener {
    private String THREAD_AUTOSELECT = "AS";
    private String THREAD_POPULATE = "P";
    private NavList brandFamilyList = null;
    private int currentBrandGroupInd = -1;
    private HotLinkGroup buttonGroup = null;
    private Vector listeners = new Vector(1, 1);
    private Vector labels = new Vector(1, 1);
    private JScrollPane scrollPane = null;
    private HotLinkLabel scrollToSelect = null;

    public BrandFamilyNavList() {
        this.brandFamilyList = new NavList();
        this.scrollPane = new JScrollPane(this.brandFamilyList);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(GUISystem.getRowHeight());
        this.setLayout(new BorderLayout());
        this.add(this.scrollPane);
        new Thread((Runnable)this, this.THREAD_POPULATE).start();
    }

    public void run() {
        String string = Thread.currentThread().getName();
        if (string.equals(this.THREAD_POPULATE)) {
            this.populateBrandFamily();
        } else if (string.equals(this.THREAD_AUTOSELECT)) {
            try {
                this.scrollToSelection();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void populateBrandFamily() {
        Vector vector = TypeList.getInstance().getTypeList(2);
        this.brandFamilyList.removeAll();
        this.labels.removeAllElements();
        this.buttonGroup = new HotLinkGroup();
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            NavListGroup navListGroup = null;
            TypeBrandRec typeBrandRec = null;
            while (n < n2) {
                typeBrandRec = (TypeBrandRec)vector.elementAt(n);
                navListGroup = new NavListGroup(typeBrandRec.toString());
                navListGroup.setOpaque(false);
                if (this.addFamilies(navListGroup, typeBrandRec)) {
                    this.brandFamilyList.add(navListGroup);
                }
                if (((TypeRec)typeBrandRec).getInd() == PropertySystem.getInt(38)) {
                    navListGroup.expand();
                }
                ++n;
            }
        }
        this.revalidate();
        new Thread((Runnable)this, this.THREAD_AUTOSELECT).start();
    }

    public void scrollToSelection() {
        if (this.scrollToSelect != null) {
            Point point = SwingUtilities.convertPoint(this.scrollToSelect, this.scrollToSelect.getLocation(), this.scrollPane);
            this.scrollPane.getVerticalScrollBar().setValue(point.y);
        }
    }

    private boolean addFamilies(NavListGroup navListGroup, TypeBrandRec typeBrandRec) {
        Vector vector = Brands.groupsFromBrand((int)((TypeRec)typeBrandRec).getInd());
        boolean bl = false;
        if (vector != null && vector.size() > 0) {
            int n;
            int n2 = 0;
            int n3 = vector.size();
            TypeGroupRec typeGroupRec = null;
            HotLinkLabel hotLinkLabel = null;
            int n4 = PropertySystem.getInt(69);
            int n5 = PropertySystem.getInt(39);
            TypeBrandRec typeBrandRec2 = Brands.brandRecFromBrandGroupInd((int)n4);
            int n6 = n = typeBrandRec2 != null ? ((TypeRec)typeBrandRec2).getInd() : -1;
            if (n4 != 0) {
                this.currentBrandGroupInd = n4;
            } else if (n >= 0) {
                this.currentBrandGroupInd = Brands.brandGroupIndFromBrandGroup((int)n, (int)n5);
            }
            while (n2 < n3) {
                typeGroupRec = (TypeGroupRec)vector.elementAt(n2);
                hotLinkLabel = new HotLinkLabel(typeGroupRec.toString());
                this.buttonGroup.add(hotLinkLabel);
                hotLinkLabel.setId(Brands.brandGroupIndFromBrandGroup((int)((TypeRec)typeBrandRec).getInd(), (int)typeGroupRec.getInd()));
                hotLinkLabel.addActionListener(this);
                hotLinkLabel.setOpaque(false);
                navListGroup.add(hotLinkLabel);
                this.labels.addElement(hotLinkLabel);
                if (hotLinkLabel.getId() == this.currentBrandGroupInd) {
                    navListGroup.expand();
                    hotLinkLabel.setSelected(true);
                    this.scrollToSelect = hotLinkLabel;
                }
                ++n2;
            }
            bl = true;
        }
        return bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.currentBrandGroupInd = ((HotLinkLabel)actionEvent.getSource()).getId();
        this.saveState();
        this.fireActionEvent();
    }

    public void addActionListener(ActionListener actionListener) {
        this.listeners.addElement(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listeners.removeElement(actionListener);
    }

    private void fireActionEvent() {
        int n = this.listeners.size();
        if (n > 0) {
            ActionEvent actionEvent = new ActionEvent(this, this.currentBrandGroupInd, "");
            int n2 = 0;
            while (n2 < n) {
                ((ActionListener)this.listeners.elementAt(n2)).actionPerformed(actionEvent);
                ++n2;
            }
        }
    }

    private void saveState() {
        PropertySystem.putInt(69, this.currentBrandGroupInd);
    }

    public int getSelectedBrandGroupInd() {
        return this.currentBrandGroupInd;
    }

    public int[] getSelectedBrandGroupInds() {
        int n = this.labels.size();
        int n2 = 0;
        int n3 = 0;
        int[] nArray = null;
        int n4 = 0;
        while (n2 < n) {
            if (((HotLinkLabel)this.labels.elementAt(n2)).getSelected()) {
                ++n4;
            }
            ++n2;
        }
        n2 = 0;
        nArray = new int[n4];
        while (n2 < n) {
            if (((HotLinkLabel)this.labels.elementAt(n2)).getSelected()) {
                nArray[n3++] = ((HotLinkLabel)this.labels.elementAt(n2)).getId();
            }
            ++n2;
        }
        return nArray;
    }

    public void setMultiSelect(boolean bl) {
        if (this.buttonGroup != null) {
            this.buttonGroup.setMultiSelect(bl);
        }
    }
}

