/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.dbgui;

import com.ibm.nzna.projects.common.quest.type.TypeCountryCodeRec;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.FontSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.dbgui.CountrySelectDlg;
import com.ibm.nzna.projects.qit.dbgui.CountrySelectListener;
import com.ibm.nzna.projects.qit.gui.JTitle;
import com.ibm.nzna.shared.gui.ButtonPanel;
import com.ibm.nzna.shared.gui.HotLinkLabel;
import com.ibm.nzna.shared.gui.ToolBarSeparator;
import com.ibm.nzna.shared.sort.QuickSort;
import com.ibm.nzna.shared.util.LogSystem;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class CountrySelectPanel
extends JPanel
implements AppConst,
ActionListener {
    private JList lb_COUNTRIES = null;
    private JScrollPane scr_COUNTRIES = null;
    private JTitle st_TITLE = null;
    private HotLinkLabel pb_ADD = null;
    private HotLinkLabel pb_REMOVE = null;
    private HotLinkLabel pb_ADD_MY_COUNTRY = null;
    private HotLinkLabel pb_ADD_FAVORITES = null;
    private ButtonPanel buttonPanel = null;
    private DefaultListModel countries = null;
    private Vector listeners = null;
    private CountrySelectPanel joinCountrySelectPanel = null;

    private final void initialize() {
        this.st_TITLE = new JTitle(Str.getStr(1138));
        this.buttonPanel = new ButtonPanel();
        this.pb_ADD = new HotLinkLabel(Str.getStr(95));
        this.pb_REMOVE = new HotLinkLabel(Str.getStr(96));
        this.pb_ADD_MY_COUNTRY = new HotLinkLabel(Str.getStr(1141));
        this.pb_ADD_FAVORITES = new HotLinkLabel(Str.getStr(1422));
        this.lb_COUNTRIES = new JList();
        this.scr_COUNTRIES = new JScrollPane(this.lb_COUNTRIES);
        this.scr_COUNTRIES.setBorder(GUISystem.blackBorder);
        this.buttonPanel.setBorder(GUISystem.grayBorder);
        this.buttonPanel.setBackground(new Color(230, 230, 230));
        this.buttonPanel.setArrowImage(ImageSystem.getImageIcon((Object)this, 146), ImageSystem.getImageIcon((Object)this, 147));
        this.st_TITLE.setFont(FontSystem.smallTitleFont);
        this.setBackground(Color.white);
        this.countries = new DefaultListModel();
        this.lb_COUNTRIES.setModel(this.countries);
        this.lb_COUNTRIES.setSelectionBackground(new Color(209, 210, 253));
        this.lb_COUNTRIES.setSelectionForeground(Color.black);
        this.pb_ADD.addActionListener(this);
        this.pb_REMOVE.addActionListener(this);
        this.pb_ADD_MY_COUNTRY.addActionListener(this);
        this.pb_ADD_FAVORITES.addActionListener(this);
        this.setLayout(null);
        this.add(this.scr_COUNTRIES);
        this.add(this.buttonPanel);
        this.buttonPanel.add(this.pb_ADD);
        this.buttonPanel.add(new ToolBarSeparator(new Dimension(1, GUISystem.getRowHeight())));
        this.buttonPanel.add(this.pb_REMOVE);
        this.buttonPanel.add(new ToolBarSeparator(new Dimension(1, GUISystem.getRowHeight())));
        this.buttonPanel.add(this.pb_ADD_MY_COUNTRY);
        this.buttonPanel.add(new ToolBarSeparator(new Dimension(1, GUISystem.getRowHeight())));
        this.buttonPanel.add(this.pb_ADD_FAVORITES);
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = GUISystem.getRowHeight();
        int n2 = this.getInsets().left;
        int n3 = this.getInsets().top;
        this.st_TITLE.setBounds(n2, n3, dimension.width, n);
        this.scr_COUNTRIES.setBounds(n2, n3 += n, dimension.width - n2 * 2, dimension.height - n * 2 - 5);
        this.buttonPanel.setBounds(n2, n3 += dimension.height - n * 2 - 3, dimension.width - n2 * 2, n);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.pb_ADD) {
            Vector vector = null;
            vector = this.joinCountrySelectPanel != null ? new CountrySelectDlg((Frame)GUISystem.getParentDefWin(this), this.joinCountrySelectPanel.getCountryList()).getResult() : new CountrySelectDlg(GUISystem.getParentDefWin(this)).getResult();
            if (vector != null) {
                this.addUniqueCountries(vector);
            }
        } else if (actionEvent.getSource() == this.pb_REMOVE) {
            this.remove();
        } else if (actionEvent.getSource() == this.pb_ADD_MY_COUNTRY) {
            this.addUniqueCountries(UserSystem.getUserCountries(UserSystem.getUserId()));
        } else if (actionEvent.getSource() == this.pb_ADD_FAVORITES) {
            this.addUniqueCountries((Vector)PropertySystem.get(61));
        }
    }

    private final synchronized void addUniqueCountries(Vector vector) {
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                if (!this.countries.contains(vector.elementAt(n)) && this.countryInJoinedPanel((TypeCountryCodeRec)vector.elementAt(n)) && this.checkAddListeners((TypeCountryCodeRec)vector.elementAt(n))) {
                    this.countries.addElement(vector.elementAt(n));
                }
                ++n;
            }
            this.sort();
        }
    }

    public synchronized void setCountryList(Vector vector) {
        this.countries.removeAllElements();
        this.addUniqueCountries(vector);
    }

    public Vector getCountryList() {
        Vector<Object> vector = new Vector<Object>(1, 1);
        Object[] objectArray = this.countries.toArray();
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                vector.addElement(objectArray[n]);
                ++n;
            }
        }
        return vector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void remove() {
        try {
            Object[] objectArray = this.lb_COUNTRIES.getSelectedValues();
            int n = this.lb_COUNTRIES.getSelectedIndex();
            if (objectArray != null) {
                int n2 = 0;
                while (true) {
                    if (n2 >= objectArray.length) {
                        this.sort();
                        this.lb_COUNTRIES.setSelectedIndex(n);
                        break;
                    }
                    if (UserSystem.hasCountry((TypeCountryCodeRec)objectArray[n2]) && this.checkRemoveListeners((TypeCountryCodeRec)objectArray[n2])) {
                        this.countries.removeElement(objectArray[n2]);
                    }
                    ++n2;
                }
            }
            this.notifyRemoveDone();
            return;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
    }

    private final boolean checkRemoveListeners(TypeCountryCodeRec typeCountryCodeRec) {
        boolean bl = true;
        if (this.listeners != null && this.listeners.size() > 0) {
            int n = 0;
            int n2 = this.listeners.size();
            while (n < n2 && bl) {
                bl = ((CountrySelectListener)this.listeners.elementAt(n)).countryRemoved(typeCountryCodeRec);
                ++n;
            }
        }
        return bl;
    }

    private final void notifyRemoveDone() {
        if (this.listeners != null && this.listeners.size() > 0) {
            int n = 0;
            int n2 = this.listeners.size();
            while (n < n2) {
                ((CountrySelectListener)this.listeners.elementAt(n)).countryRemoveDone();
                ++n;
            }
        }
    }

    private final boolean checkAddListeners(TypeCountryCodeRec typeCountryCodeRec) {
        boolean bl = true;
        if (this.listeners != null && this.listeners.size() > 0) {
            int n = 0;
            int n2 = this.listeners.size();
            while (n < n2 && bl) {
                bl = ((CountrySelectListener)this.listeners.elementAt(n)).countryAdded(typeCountryCodeRec);
                ++n;
            }
        }
        return bl;
    }

    public void addCountrySelectListener(CountrySelectListener countrySelectListener) {
        if (this.listeners == null) {
            this.listeners = new Vector(1, 1);
        }
        this.listeners.addElement(countrySelectListener);
    }

    public void removeCountrySelectListener(CountrySelectListener countrySelectListener) {
        if (this.listeners != null) {
            this.listeners.removeElement(countrySelectListener);
            if (this.listeners.size() == 0) {
                this.listeners = null;
            }
        }
    }

    public void joinCountrySelectPanel(CountrySelectPanel countrySelectPanel) {
        this.joinCountrySelectPanel = countrySelectPanel;
    }

    private final boolean countryInJoinedPanel(TypeCountryCodeRec typeCountryCodeRec) {
        boolean bl = true;
        if (this.joinCountrySelectPanel != null) {
            bl = this.joinCountrySelectPanel.getCountryList().contains(typeCountryCodeRec);
        }
        return bl;
    }

    private final void sort() {
        Vector vector = this.getCountryList();
        int n = 0;
        int n2 = vector.size();
        new QuickSort(vector);
        this.countries.removeAllElements();
        while (n < n2) {
            this.countries.addElement(vector.elementAt(n++));
        }
    }

    public CountrySelectPanel getJoinCountrySelectPanel() {
        return this.joinCountrySelectPanel;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.lb_COUNTRIES.setEnabled(bl);
        this.scr_COUNTRIES.setEnabled(bl);
        this.st_TITLE.setEnabled(bl);
        this.pb_ADD.setEnabled(bl);
        this.pb_REMOVE.setEnabled(bl);
        this.pb_ADD_MY_COUNTRY.setEnabled(bl);
        this.pb_ADD_FAVORITES.setEnabled(bl);
    }

    public CountrySelectPanel() {
        this.initialize();
    }
}

