/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.dbgui;

import com.ibm.nzna.projects.common.quest.brand.Brands;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.StatusRec;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.dbgui.ModelListener;
import com.ibm.nzna.projects.qit.doc.DocFamilyRec;
import com.ibm.nzna.projects.qit.product.ProductConstants;
import com.ibm.nzna.projects.qit.product.ProductRec;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.gui.DetailTreeCellRenderer;
import com.ibm.nzna.shared.gui.MutableTreeWrapper;
import com.ibm.nzna.shared.gui.StringTreeNode;
import com.ibm.nzna.shared.util.CDate;
import com.ibm.nzna.shared.util.LogSystem;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class MachineModelTree
extends JTree
implements TreeExpansionListener,
ProductConstants,
AppConst,
Runnable {
    private static final String THREAD_REFRESH_MACHINES = "REFRESH_MACHINES";
    private static final String THREAD_REFRESH_MODELS = "REFRESH_MODELS";
    private static final String THREAD_REFRESH_MACHINE_VEC = "REFRESH_MACHINE_VEC";
    private static final String THREAD_NOTIFY_ACTION = "THREAD_NOTIFY_ACTION";
    private static final String THREAD_REREAD_MODELS = "THREAD_REREAD_MODELS";
    private DocFamilyRec docFamilyRec = null;
    private DefaultTreeModel model = null;
    private StringTreeNode root = null;
    private DetailTreeCellRenderer renderer = null;
    private StringTreeNode lastExpandedNode = null;
    private Vector expandedVec = null;
    private Vector actionListenerVec = null;
    private Vector modelListenerVec = null;
    private boolean processExpand = true;

    private void initialize() {
        this.root = new StringTreeNode(Str.getStr(340));
        this.model = new DefaultTreeModel(this.root);
        this.setCellRenderer();
        this.setModel(this.model);
        this.fireModelChangeEvent();
        this.addTreeExpansionListener(this);
        MachineModelTree machineModelTree = this;
        if (machineModelTree == null) {
            throw null;
        }
        MouseAdapter mouseAdapter = new MouseAdapter(machineModelTree){
            private final /* synthetic */ MachineModelTree this$0;

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = this.this$0.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                TreePath treePath = this.this$0.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (mouseEvent.getClickCount() > 1 && n != -1 && treePath.getLastPathComponent() instanceof MutableTreeWrapper) {
                    MachineModelTree.access$0(this.this$0);
                }
            }
            {
                this.this$0 = machineModelTree;
                this.constructor$0(machineModelTree);
            }

            private final void constructor$0(MachineModelTree machineModelTree) {
            }
        };
        this.addMouseListener(mouseAdapter);
    }

    public void setDocFamilyRec(DocFamilyRec docFamilyRec) {
        this.docFamilyRec = docFamilyRec;
        new Thread((Runnable)this, THREAD_REFRESH_MACHINES).start();
    }

    public void setBrandGroupInd(int n) {
        DocFamilyRec docFamilyRec = new DocFamilyRec(n);
        this.setDocFamilyRec(docFamilyRec);
    }

    public void run() {
        String string = Thread.currentThread().getName();
        if (string.equals(THREAD_REFRESH_MACHINES)) {
            this.refreshMachineList();
        } else if (string.equals(THREAD_REREAD_MODELS)) {
            this.refreshModelThread();
        } else if (string.equals(THREAD_REFRESH_MACHINE_VEC)) {
            if (this.expandedVec != null && this.expandedVec.size() > 0) {
                int n = this.expandedVec.size();
                StringTreeNode stringTreeNode = null;
                int n2 = 0;
                while (n2 < n) {
                    stringTreeNode = (StringTreeNode)this.expandedVec.elementAt(n2);
                    this.resetToWait(stringTreeNode);
                    if (!Brands.isOption((int)this.docFamilyRec.getBrandGroupInd())) {
                        this.populateModels(stringTreeNode, this.readModels(stringTreeNode.toString()));
                    } else {
                        this.populateModels(stringTreeNode, this.readModelsForOptions(stringTreeNode.toString()));
                    }
                    ++n2;
                }
            }
            this.expandedVec = null;
        } else if (string.equals(THREAD_REFRESH_MODELS)) {
            if (this.lastExpandedNode != null) {
                this.resetToWait(this.lastExpandedNode);
                if (!Brands.isOption((int)this.docFamilyRec.getBrandGroupInd())) {
                    this.populateModels(this.lastExpandedNode, this.readModels(this.lastExpandedNode.toString()));
                } else {
                    this.populateModels(this.lastExpandedNode, this.readModelsForOptions(this.lastExpandedNode.toString()));
                }
            }
        } else if (string.equals(THREAD_NOTIFY_ACTION)) {
            int n = 0;
            int n3 = this.actionListenerVec.size();
            ActionEvent actionEvent = new ActionEvent(this, 0, null);
            while (n < n3) {
                ((ActionListener)this.actionListenerVec.elementAt(n)).actionPerformed(actionEvent);
                ++n;
            }
        }
    }

    private void refreshMachineList() {
        StringTreeNode stringTreeNode = new StringTreeNode(Str.getStr(14));
        Vector vector = null;
        this.root = stringTreeNode;
        this.model = new DefaultTreeModel(this.root);
        this.setCellRenderer();
        this.setModel(this.model);
        this.fireModelChangeEvent();
        vector = !Brands.isOption((int)this.docFamilyRec.getBrandGroupInd()) ? this.readMachines() : this.readMachinesForOptions();
        if (vector != null) {
            int n = 0;
            int n2 = vector.size();
            StringTreeNode stringTreeNode2 = null;
            this.root = new StringTreeNode(Str.getStr(340));
            this.setCellRenderer();
            this.model = new DefaultTreeModel(this.root);
            while (n < n2) {
                stringTreeNode2 = new StringTreeNode((String)vector.elementAt(n));
                this.model.insertNodeInto(stringTreeNode2, this.root, n);
                this.model.insertNodeInto(new StringTreeNode(Str.getStr(14)), stringTreeNode2, 0);
                ++n;
            }
            this.setModel(this.model);
            this.fireModelChangeEvent();
            if (n2 == 1) {
                this.expandRow(1);
            }
        }
    }

    private Vector readMachines() {
        Vector<String> vector = new Vector<String>(1, 1);
        SQLMethod sQLMethod = new SQLMethod(1, "MachineModelTree.readMachines", 5);
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT DISTINCT MACHINE " + "FROM TIGRIS.PRODUCTS " + "WHERE BRANDGROUPIND = " + this.docFamilyRec.getBrandGroupInd() + " AND " + "      RECYCLED = 'N' AND " + "      MACHINE <> 'All' " + "ORDER BY MACHINE FOR FETCH ONLY");
            while (resultSet.next()) {
                vector.addElement(resultSet.getString(1).trim());
            }
            resultSet.close();
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            sQLMethod.rollBack();
            GUISystem.printBox((Frame)GUISystem.getParentDefWin(this), Str.getStr(7), Str.getStr(1268));
        }
        sQLMethod.close();
        return vector;
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        if (this.processExpand) {
            Object object = treeExpansionEvent.getPath().getLastPathComponent();
            this.lastExpandedNode = (StringTreeNode)object;
            new Thread((Runnable)this, THREAD_REFRESH_MODELS).start();
        }
        this.processExpand = true;
    }

    private void populateModels(StringTreeNode stringTreeNode, Vector vector) {
        int n = stringTreeNode.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            ((DefaultMutableTreeNode)stringTreeNode.getChildAt(0)).removeFromParent();
            ++n2;
        }
        if (vector != null && vector.size() > 0) {
            n2 = 0;
            int n3 = vector.size();
            while (n2 < n3) {
                stringTreeNode.add(new MutableTreeWrapper(vector.elementAt(n2)));
                ++n2;
            }
        }
        if (this.model != null && stringTreeNode != null) {
            this.model.reload(stringTreeNode);
        }
    }

    private void resetToWait(StringTreeNode stringTreeNode) {
        int n = stringTreeNode.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            ((DefaultMutableTreeNode)stringTreeNode.getChildAt(0)).removeFromParent();
            ++n2;
        }
        stringTreeNode.add(new StringTreeNode(Str.getStr(14)));
        if (this.model != null && stringTreeNode != null) {
            this.model.reload(stringTreeNode);
        }
    }

    private Vector readModels(String string) {
        Vector<ProductRec> vector = new Vector<ProductRec>(1, 1);
        SQLMethod sQLMethod = new SQLMethod(1, "readModels", 10);
        Object var4_4 = null;
        try {
            Statement statement = sQLMethod.createStatement();
            ProductRec productRec = null;
            ResultSet resultSet = statement.executeQuery("SELECT PRODINT, PRODNUM, MACHINE, MODEL, PRODDESC, STATUSIND, STATUSDATE " + "FROM TIGRIS.PRODUCTS " + "WHERE BRANDGROUPIND = " + this.docFamilyRec.getBrandGroupInd() + " AND " + "      MACHINE       = '" + string + "' AND " + "      MODEL        <> 'All' AND " + "      RECYCLED      = 'N' ORDER BY PRODNUM");
            LogSystem.log(1, "SELECT PRODINT, PRODNUM, MACHINE, MODEL, PRODDESC, STATUSIND, STATUSDATE " + "FROM TIGRIS.PRODUCTS " + "WHERE BRANDGROUPIND = " + this.docFamilyRec.getBrandGroupInd() + " AND " + "      MACHINE       = '" + string + "' AND " + "      MODEL        <> 'All' AND " + "      RECYCLED      = 'N' ORDER BY PRODNUM");
            while (resultSet.next()) {
                productRec = new ProductRec(resultSet.getInt(1), resultSet.getString(2).trim(), resultSet.getString(3).trim(), resultSet.getString(4).trim());
                productRec.setFieldData(5, resultSet.getString(5).trim());
                productRec.setFieldData(6, new StatusRec(resultSet.getInt(6), CDate.convertDate(10, 2, resultSet.getString(7).trim())));
                vector.addElement(productRec);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception, false);
            GUISystem.printBox((Frame)GUISystem.getParentDefWin(this), Str.getStr(7), Str.getStr(1269));
        }
        sQLMethod.close();
        return vector;
    }

    private Vector readMachinesForOptions() {
        Vector<String> vector = new Vector<String>(1, 1);
        SQLMethod sQLMethod = new SQLMethod(1, "MachineModelTree.readMachinesForOptions", 5);
        try {
            Statement statement = sQLMethod.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT DISTINCT DESCRIPT " + "FROM TIGRIS.PRODMACHINEDESC A, " + "     TIGRIS.PRODUCTS B " + "WHERE B.BRANDGROUPIND = " + this.docFamilyRec.getBrandGroupInd() + " AND " + "      B.RECYCLED = 'N'   AND " + "      B.MACHINE <> 'All' AND " + "      A.PRODINT = B.PRODINT " + "ORDER BY DESCRIPT FOR FETCH ONLY");
            while (resultSet.next()) {
                vector.addElement(resultSet.getString(1));
            }
            resultSet.close();
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            sQLMethod.rollBack();
            GUISystem.printBox((Frame)GUISystem.getParentDefWin(this), Str.getStr(7), Str.getStr(1268));
        }
        sQLMethod.close();
        return vector;
    }

    private Vector readModelsForOptions(String string) {
        Vector<ProductRec> vector = new Vector<ProductRec>(1, 1);
        SQLMethod sQLMethod = new SQLMethod(1, "readModels", 10);
        Object var4_4 = null;
        try {
            Statement statement = sQLMethod.createStatement();
            ProductRec productRec = null;
            ResultSet resultSet = statement.executeQuery("SELECT A.PRODINT, A.PRODNUM, B.DESCRIPT, A.MODEL, A.PRODDESC, A.STATUSIND, A.STATUSDATE, a.BRANDGROUPIND " + "FROM TIGRIS.PRODUCTS A, " + "     TIGRIS.PRODMACHINEDESC B " + "WHERE A.BRANDGROUPIND = " + this.docFamilyRec.getBrandGroupInd() + " AND " + "      B.DESCRIPT      = '" + string + "' AND " + "      A.MODEL        <> 'All' AND " + "      A.RECYCLED      = 'N' AND " + "      A.PRODINT       = B.PRODINT ORDER BY PRODNUM FOR FETCH ONLY");
            while (resultSet.next()) {
                productRec = new ProductRec(resultSet.getInt(1), resultSet.getString(2).trim(), resultSet.getString(3).trim(), resultSet.getString(4).trim(), resultSet.getInt(8));
                productRec.setFieldData(5, resultSet.getString(5).trim());
                productRec.setFieldData(6, new StatusRec(resultSet.getInt(6), CDate.convertDate(10, 2, resultSet.getString(7).trim())));
                vector.addElement(productRec);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            sQLMethod.rollBack();
            LogSystem.log(1, exception, false);
            GUISystem.printBox((Frame)GUISystem.getParentDefWin(this), Str.getStr(7), Str.getStr(1269));
        }
        sQLMethod.close();
        return vector;
    }

    public int getSelectedMachineModel() {
        Object object = this.getSelectionPath().getLastPathComponent();
        int n = 0;
        if (object != null && object instanceof MutableTreeWrapper) {
            n = ((ProductRec)((MutableTreeWrapper)object).getDataObject()).getProdInt();
        }
        return n;
    }

    private void setCellRenderer() {
        this.renderer = new DetailTreeCellRenderer(GUISystem.getFontUtil(), 4);
        this.setCellRenderer(this.renderer);
    }

    public void refresh() {
        this.refreshMachineList();
    }

    public void removeModel(ProductRec productRec) {
        int n = this.getRowCount();
        ProductRec productRec2 = null;
        boolean bl = false;
        int n2 = 0;
        TreePath treePath = null;
        while (n2 < n && !bl) {
            treePath = this.getPathForRow(n2);
            if (treePath != null && treePath.getLastPathComponent() != null && (productRec2 = treePath.getLastPathComponent() instanceof MutableTreeWrapper ? (ProductRec)((MutableTreeWrapper)treePath.getLastPathComponent()).getDataObject() : null) != null && productRec2.equals(productRec)) {
                if (treePath.getLastPathComponent() instanceof MutableTreeWrapper) {
                    ((DefaultTreeModel)this.getModel()).removeNodeFromParent((MutableTreeWrapper)treePath.getLastPathComponent());
                }
                bl = true;
            }
            ++n2;
        }
    }

    private void notifyActionEvent() {
        if (this.actionListenerVec != null) {
            new Thread((Runnable)this, THREAD_NOTIFY_ACTION).start();
        }
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.actionListenerVec == null) {
            this.actionListenerVec = new Vector(1, 1);
        }
        this.actionListenerVec.addElement(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        if (this.actionListenerVec != null) {
            this.actionListenerVec.removeElement(actionListener);
        }
        if (this.actionListenerVec.size() == 0) {
            this.actionListenerVec = null;
        }
    }

    public void addModelListener(ModelListener modelListener) {
        if (this.modelListenerVec == null) {
            this.modelListenerVec = new Vector(10);
        }
        this.modelListenerVec.addElement(modelListener);
    }

    private void fireModelChangeEvent() {
        if (this.modelListenerVec != null && this.modelListenerVec.size() > 0) {
            int n = 0;
            int n2 = this.modelListenerVec.size();
            while (n < n2) {
                ((ModelListener)this.modelListenerVec.elementAt(n)).modelChanged();
                ++n;
            }
        }
    }

    public void refreshMachines() {
        new Thread((Runnable)this, THREAD_REFRESH_MACHINES).start();
    }

    public void refreshModels() {
        new Thread((Runnable)this, THREAD_REREAD_MODELS).start();
    }

    private void refreshModelThread() {
        Object[] objectArray;
        int n = 0;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.model.getRoot();
        int n2 = this.model.getChildCount(defaultMutableTreeNode);
        boolean bl = Brands.isOption((int)this.docFamilyRec.getBrandGroupInd());
        Vector<Object[]> vector = new Vector<Object[]>(1);
        int n3 = 0;
        Vector<Object> vector2 = new Vector<Object>(1);
        while (n < n2) {
            if (this.model.getChildCount(this.model.getChild(defaultMutableTreeNode, n)) > 1) {
                objectArray = (Object[])this.model.getChild(defaultMutableTreeNode, n);
                vector.addElement(objectArray);
            }
            ++n;
        }
        this.refreshMachineList();
        defaultMutableTreeNode = (DefaultMutableTreeNode)this.model.getRoot();
        n2 = this.model.getChildCount(defaultMutableTreeNode);
        n = 0;
        while (n < n2) {
            n3 = 0;
            while (n3 < vector.size()) {
                if (((StringTreeNode)this.model.getChild(defaultMutableTreeNode, n)).toString().equals(vector.elementAt(n3).toString())) {
                    vector2.addElement(this.model.getChild(defaultMutableTreeNode, n));
                    vector.removeElementAt(n3);
                }
                ++n3;
            }
            ++n;
        }
        n = 0;
        while (n < vector2.size()) {
            objectArray = new Object[]{defaultMutableTreeNode, vector2.elementAt(n)};
            TreePath treePath = new TreePath(objectArray);
            this.processExpand = false;
            this.expandPath(treePath);
            if (bl) {
                this.populateModels((StringTreeNode)vector2.elementAt(n), this.readModelsForOptions(((StringTreeNode)vector2.elementAt(n)).toString()));
            } else {
                this.populateModels((StringTreeNode)vector2.elementAt(n), this.readModels(((StringTreeNode)vector2.elementAt(n)).toString()));
            }
            ++n;
        }
    }

    static /* synthetic */ void access$0(MachineModelTree machineModelTree) {
        machineModelTree.notifyActionEvent();
    }

    public MachineModelTree() {
        this.initialize();
    }

    public MachineModelTree(DocFamilyRec docFamilyRec) {
        this.initialize();
        this.setDocFamilyRec(docFamilyRec);
    }
}

