/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.doc.docedit;

import com.ibm.nzna.projects.common.quest.brand.Brands;
import com.ibm.nzna.projects.common.quest.doc.Document;
import com.ibm.nzna.projects.common.quest.doc.DocumentPropertyListener;
import com.ibm.nzna.projects.common.quest.type.TypeCategory;
import com.ibm.nzna.projects.common.quest.type.TypeCategoryRec;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.dbgui.DocCategoryDlg;
import com.ibm.nzna.projects.qit.dbgui.DocCategoryDlgListener;
import com.ibm.nzna.projects.qit.doc.DocConst;
import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.gui.DPanel;
import com.ibm.nzna.shared.gui.ListPanel;
import com.ibm.nzna.shared.gui.MutableTreeWrapper;
import com.ibm.nzna.shared.gui.StringTreeNode;
import com.ibm.nzna.shared.sort.QuickSort;
import com.ibm.nzna.shared.util.WinUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultTreeModel;

public class CategoryPanel
extends DPanel
implements DocumentPropertyListener,
DocCategoryDlgListener,
ListSelectionListener,
ActionListener,
AppConst,
DocConst {
    private static final String PRE_HTML = "<html><body><font size=2>";
    private static final String SUF_HTML = "</body></html>";
    private static final Dimension prefSize = new Dimension(100, 300);
    private JList categories = new JList();
    private DButton addCategory = new DButton(Str.getStr(95));
    private DButton removeCategory = new DButton(Str.getStr(96));
    private DButton removeAll = new DButton(Str.getStr(96) + " " + Str.getStr(218));
    private DefaultListModel listModel = null;
    private JScrollPane scrollPane = new JScrollPane(this.categories);
    private ListPanel buttonPanel = new ListPanel();
    private Document document = null;

    protected void setDocument(Document document) {
        if (this.document != document) {
            if (this.document != null) {
                this.document.removeDocumentPropertyListener(this);
            }
            this.document = document;
            document.addDocumentPropertyListener(this);
            this.populateList();
        } else {
            this.populateList();
        }
    }

    private final void populateList() {
        if (this.document.getCategory() != null && this.document.getCategory().size() > 0) {
            Vector vector = this.prepareCategoryList(this.document.getCategory());
            WinUtil.setListData(this.document.getCategory(), this.listModel);
            this.removeAll.setEnabled(true);
        } else {
            this.listModel.removeAllElements();
            this.removeAll.setEnabled(false);
        }
        this.removeCategory.setEnabled(false);
        if (this.listModel.size() == 0) {
            this.listModel.addElement("<html><body><font size=2 name=\"Helvetica, Arial\">No Document Categories, press 'Select' to<br>add categories.</font></body></html>");
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.isEnabled()) {
            this.removeCategory.setEnabled(this.categories.getSelectedValue() != null && !(this.categories.getSelectedValue() instanceof String));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isEnabled()) {
            if (actionEvent.getSource() == this.addCategory) {
                Vector vector = this.getAllFamilies();
                if (vector != null && vector.size() > 0) {
                    Vector vector2 = this.getBrands(vector);
                    DocCategoryDlg docCategoryDlg = new DocCategoryDlg(WinUtil.getParentFrame(this), vector2);
                    docCategoryDlg.setDocCategoryDlgListener(this);
                    docCategoryDlg.waitForUser();
                } else {
                    GUISystem.printBox(7, 11006);
                }
            } else if (actionEvent.getSource() == this.removeCategory) {
                Object[] objectArray = this.categories.getSelectedValues();
                Vector vector = this.document.getCategory();
                if (objectArray != null && objectArray.length > 0) {
                    int n = 0;
                    while (n < objectArray.length) {
                        vector.removeElement(objectArray[n]);
                        ++n;
                    }
                    this.document.setCategory(vector);
                    this.populateList();
                }
            } else if (actionEvent.getSource() == this.removeAll) {
                this.document.setCategory(new Vector(1));
                this.populateList();
            }
        }
    }

    private final Vector getBrands(Vector vector) {
        int n = 0;
        int n2 = vector.size();
        Vector<TypeCategoryRec> vector2 = new Vector<TypeCategoryRec>();
        while (n < n2) {
            TypeCategoryRec typeCategoryRec = TypeCategory.getCategory(((TypeCategoryRec)vector.elementAt(n)).getParentCatInd());
            if (!vector2.contains(typeCategoryRec)) {
                vector2.addElement(typeCategoryRec);
            }
            ++n;
        }
        return vector2;
    }

    private final DefaultTreeModel getAvailableCategories() {
        DefaultTreeModel defaultTreeModel = null;
        StringTreeNode stringTreeNode = new StringTreeNode(Str.getStr(11007));
        Vector vector = Brands.getBrands();
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            StringTreeNode stringTreeNode2 = null;
            defaultTreeModel = new DefaultTreeModel(stringTreeNode);
            new QuickSort(vector);
            while (n < n2) {
                TypeCategoryRec typeCategoryRec = (TypeCategoryRec)vector.elementAt(n);
                Vector vector2 = TypeCategory.getChildCategories(typeCategoryRec.getInd(), "doccategory");
                new QuickSort(vector2);
                if (vector2 != null && vector2.size() > 0) {
                    int n3 = 0;
                    int n4 = vector2.size();
                    stringTreeNode2 = new StringTreeNode(typeCategoryRec.toString());
                    defaultTreeModel.insertNodeInto(stringTreeNode2, stringTreeNode, n);
                    while (n3 < n4) {
                        TypeCategoryRec typeCategoryRec2 = (TypeCategoryRec)vector2.elementAt(n3);
                        defaultTreeModel.insertNodeInto(new MutableTreeWrapper(typeCategoryRec2), stringTreeNode2, n3);
                        ++n3;
                    }
                }
                ++n;
            }
        }
        return defaultTreeModel;
    }

    public void docCategoryDlgAdd(Object[] objectArray) {
        if (objectArray != null) {
            Vector<Object> vector = this.document.getCategory();
            if (vector == null) {
                vector = new Vector<Object>(objectArray.length);
            }
            int n = 0;
            while (n < objectArray.length) {
                if (!vector.contains(objectArray[n])) {
                    vector.addElement(objectArray[n]);
                }
                ++n;
            }
            this.document.setCategory(vector);
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.addCategory.setEnabled(bl);
        this.removeCategory.setEnabled(bl);
        this.removeAll.setEnabled(bl);
    }

    public void documentChanged(Document document, int n) {
        if (n == 18) {
            this.populateList();
        }
    }

    private final Vector getAllFamilies() {
        Vector vector = this.document.getApplicableFamilies();
        Vector vector2 = this.document.getFamilies();
        if (vector == null) {
            vector = new Vector(1);
        }
        if (vector2 != null && vector2.size() > 0) {
            int n = 0;
            int n2 = vector2.size();
            while (n < n2) {
                if (!vector.contains(vector2.elementAt(n))) {
                    vector.addElement(vector2.elementAt(n));
                }
                ++n;
            }
        }
        return vector;
    }

    private final Vector prepareCategoryList(Vector vector) {
        Vector vector2 = new Vector();
        new QuickSort(this.document.getCategory());
        return vector2;
    }

    public CategoryPanel() {
        this.listModel = new DefaultListModel();
        this.categories.setModel(this.listModel);
        this.setBackground(Color.white);
        this.buttonPanel.setBackground(Color.white);
        this.removeAll.setEnabled(false);
        this.removeCategory.setEnabled(false);
        this.categories.addListSelectionListener(this);
        this.addCategory.addActionListener(this);
        this.removeCategory.addActionListener(this);
        this.removeAll.addActionListener(this);
        this.buttonPanel.add(this.addCategory);
        this.buttonPanel.add(this.removeCategory);
        this.buttonPanel.add(this.removeAll);
        this.buttonPanel.setPreferredSize(new Dimension(90, 100));
        this.setPreferredSize(new Dimension(515, 150));
        this.setLayout(new BorderLayout());
        this.add((Component)GUISystem.getRequiredJLabel(), "North");
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.buttonPanel, "East");
    }
}

