/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.doc.docedit;

import com.ibm.nzna.projects.common.quest.doc.Document;
import com.ibm.nzna.projects.common.quest.doc.DocumentBody;
import com.ibm.nzna.projects.common.quest.doc.DocumentComment;
import com.ibm.nzna.projects.common.quest.doc.DocumentDraft;
import com.ibm.nzna.projects.common.quest.doc.DocumentPropertyListener;
import com.ibm.nzna.projects.common.quest.doc.DocumentQueryText;
import com.ibm.nzna.projects.common.quest.doc.DocumentStatus;
import com.ibm.nzna.projects.common.quest.type.TypeDocClassRec;
import com.ibm.nzna.projects.common.quest.type.TypeDocRec;
import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.DataLengths;
import com.ibm.nzna.projects.qit.app.DateSystem;
import com.ibm.nzna.projects.qit.app.FontSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.PropertyListener;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.doc.DocConst;
import com.ibm.nzna.projects.qit.doc.docedit.CategoryPanel;
import com.ibm.nzna.projects.qit.doc.docedit.DocumentEditor;
import com.ibm.nzna.projects.qit.doc.docedit.DocumentInfoFormComponent;
import com.ibm.nzna.projects.qit.doc.docedit.DocumentLinkPanel;
import com.ibm.nzna.projects.qit.doc.docedit.DownloadableInfoPanel;
import com.ibm.nzna.projects.qit.doc.docedit.DraftInfoPanel;
import com.ibm.nzna.projects.qit.doc.docedit.FileAttachmentPanel;
import com.ibm.nzna.projects.qit.doc.docedit.LocalePanel;
import com.ibm.nzna.projects.qit.doc.docedit.ProMailPanel;
import com.ibm.nzna.projects.qit.doc.docedit.ProductPanel;
import com.ibm.nzna.projects.qit.doc.docedit.PublishingOptionsPanel;
import com.ibm.nzna.projects.qit.doc.docedit.SaveDocDlg;
import com.ibm.nzna.projects.qit.gui.Browser;
import com.ibm.nzna.shared.gui.ButtonPanel;
import com.ibm.nzna.shared.gui.JTextAreaCounter;
import com.ibm.nzna.shared.gui.ListPanel;
import com.ibm.nzna.shared.gui.MaskDocument;
import com.ibm.nzna.shared.gui.NoTabJTextArea;
import com.ibm.nzna.shared.gui.StraightLayoutMgr;
import com.ibm.nzna.shared.gui.form.FormComponent;
import com.ibm.nzna.shared.gui.form.MultiLineFormComponent;
import com.ibm.nzna.shared.gui.form.RadioFormComponent;
import com.ibm.nzna.shared.spell.SpellPanel;
import com.ibm.nzna.shared.spell.SpellPanelListener;
import com.ibm.nzna.shared.util.CDate;
import com.ibm.nzna.shared.util.FileUtil;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.Text;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.UIManager;

public class DocEditPanel
extends JPanel
implements SpellPanelListener,
DataLengths,
Runnable,
PropertyListener,
ActionListener,
DocumentPropertyListener,
FocusListener,
DocConst,
AppConst {
    private static final String THREAD_SET_DOC_BODY = "DOCBODY";
    public static final String FORM_TITLE = Str.getStr(318);
    public static final String FORM_TYPE_CLASS = Str.getStr(11024);
    public static final String FORM_DRAFT_INFO = Str.getStr(1648);
    public static final String FORM_COMMENT = Str.getStr(290);
    public static final String FORM_COMMENT_HISTORY = Str.getStr(303);
    public static final String FORM_PUBLISHING_OPTIONS = Str.getStr(1649);
    public static final String FORM_CATEGORY = Str.getStr(495);
    public static final String FORM_DOCUMENT_LOCATION = Str.getStr(437);
    public static final String FORM_DOCUMENT_PRODUCTS = Str.getStr(299);
    public static final String FORM_DOWNLOADABLE_FILE_INFO = Str.getStr(11020);
    public static final String FORM_FILE_ATTACHMENTS = Str.getStr(438);
    public static final String FORM_PROACTIVE_EMAIL = Str.getStr(208);
    public static final String FORM_THIS_DOCUMENT_LINKS_TO = Str.getStr(296);
    public static final String FORM_DOCUMENTS_LINK_TO_THIS = Str.getStr(297);
    public static final String FORM_QUEST_DOCUMENT_INFO = Str.getStr(263);
    public static final String FORM_SEARCH_ENGINE_QUERY_INDEX = Str.getStr(11046);
    private static final int SPELL_NONE = 0;
    private static final int SPELL_TITLE = 1;
    private static final int SPELL_EMAIL = 2;
    private static final int SPELL_DESCRIPTION = 3;
    private static final int SPELL_VERSION = 4;
    private static final int SPELL_LAST = 5;
    private int spellCheckStep = 0;
    private SpellPanel spellPanel = null;
    private DocumentEditor documentEditor = null;
    private MultiLineFormComponent titleComponent = null;
    private ProductPanel productComponent = null;
    private NoTabJTextArea currentCommentHistory = null;
    private DocumentLinkPanel docLinksToPanel = null;
    private DocumentLinkPanel refDocLinksPanel = null;
    private ProMailPanel proMailPanel = null;
    private FileAttachmentPanel fileAttachments = null;
    private boolean enableInput = true;
    private NoTabJTextArea currentComment = null;
    private JScrollPane commentHistoryScroll = null;
    private JLabel commentHistoryLabel = null;
    private RadioFormComponent documentClass = null;
    private RadioFormComponent documentType = null;
    private DocumentInfoFormComponent documentInfo = null;
    private MultiLineFormComponent searchEngineQueryComponent = null;
    private CategoryPanel category = null;
    private PublishingOptionsPanel publishingOptions = null;
    private LocalePanel locale = null;
    private DraftInfoPanel draftInfo = null;
    private DownloadableInfoPanel downloadablePanel = null;
    private Dimension defaultFormSize = new Dimension(600, -1);
    private Document document = null;
    private ListPanel dataPanel = new ListPanel();
    private JPanel fieldBodyPanel = new JPanel();
    private JScrollPane scrollPane = new JScrollPane(this.dataPanel);
    private JToggleButton pb_FIELDS = new JToggleButton(Str.getStr(734));
    private JToggleButton pb_BODY = new JToggleButton(Str.getStr(308));
    private Vector focusGUI = new Vector(1);
    private Browser browser = GUISystem.createBrowser();

    private final void initialize() {
        ButtonPanel buttonPanel = new ButtonPanel();
        ButtonGroup buttonGroup = new ButtonGroup();
        PropertySystem.addPropertyListener(159, this);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(GUISystem.getRowHeight());
        this.setBackground(Color.white);
        this.setPreferredSize(new Dimension(630, -1));
        this.dataPanel.setPadding(10);
        this.dataPanel.setBackground(Color.white);
        buttonGroup.add(this.pb_FIELDS);
        buttonGroup.add(this.pb_BODY);
        this.pb_FIELDS.setSelected(true);
        buttonPanel.setBackground(Color.white);
        this.pb_FIELDS.addActionListener(this);
        this.pb_BODY.addActionListener(this);
        buttonPanel.add(this.pb_FIELDS);
        buttonPanel.add(this.pb_BODY);
        this.fieldBodyPanel.setLayout(new CardLayout());
        this.fieldBodyPanel.add((Component)this.scrollPane, "FIELDS");
        this.fieldBodyPanel.add(this.browser.getComponent(), "BODY");
        this.setLayout(new BorderLayout());
        this.add((Component)buttonPanel, "North");
        this.add(this.fieldBodyPanel);
        GUISystem.setPropertiesOnPanel(buttonPanel);
    }

    public void setDocument(Document document) {
        if (this.document != null) {
            this.document.writeToMemory();
            this.document.removeDocumentPropertyListener(this);
        }
        this.document = document;
        if (document != null) {
            document.addDocumentPropertyListener(this);
            document.enableUndo(true);
            this.addFormComponents();
            this.documentType.setSelectedItem(TypeList.getInstance().objectFromInd(document.getDocumentType(), 4));
            this.documentClass.setSelectedItem(TypeList.getInstance().objectFromInd(document.getDocumentClass(), 5));
            this.titleComponent.setText(document.getTitle());
            this.publishingOptions.setDocument(document);
            this.productComponent.setDocument(document);
            this.draftInfo.setDocument(document);
            this.documentInfo.setDocument(document);
            this.category.setDocument(document);
            this.locale.setDocument(document);
            this.proMailPanel.setDocument(document);
            this.docLinksToPanel.setDocumentLinks(document.getDocumentLinks());
            this.refDocLinksPanel.setDocumentLinks(document.getReferringDocumentLinks());
            this.searchEngineQueryComponent.setText(document.getQueryText() != null ? document.getQueryText().toString() : "");
            if (this.fileAttachments != null) {
                this.fileAttachments.setDocument(document);
                this.downloadablePanel.setDocument(document);
            }
            if (document instanceof DocumentDraft) {
                this.currentCommentHistory.setText(((DocumentDraft)document).getOriginalComments());
                this.currentComment.setText("");
                this.currentComment.setDocument(new MaskDocument(0, 1999 - ((DocumentDraft)document).getOriginalComments().length()));
                this.commentHistoryLabel.setText(this.getCommentHistoryAsText((DocumentDraft)document));
            }
            if (document.getDocumentType() != 9) {
                this.pb_BODY.setText(Str.getStr(308));
            } else {
                this.pb_BODY.setText(Str.getStr(311));
            }
            new Thread((Runnable)this, THREAD_SET_DOC_BODY).start();
        } else {
            this.dataPanel.removeAll();
        }
        this.setEnabled(this.enableInput);
        this.revalidate();
    }

    public boolean saveToMemory(boolean bl) {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void addFormComponents() {
        Vector vector = (Vector)PropertySystem.get(159);
        int n = 0;
        int n2 = vector.size();
        String string = null;
        JPanel jPanel = null;
        this.removeAllFocusListeners();
        this.dataPanel.removeAll();
        while (n < n2) {
            block29: {
                block34: {
                    Serializable serializable;
                    JPanel jPanel2;
                    block33: {
                        block32: {
                            block31: {
                                block30: {
                                    block28: {
                                        string = (String)vector.elementAt(n);
                                        if (!string.equals(FORM_TITLE)) break block28;
                                        jPanel = this.titleComponent = new MultiLineFormComponent(Str.getStr(318), "", false);
                                        this.titleComponent.getJTextArea().setDocument(new MaskDocument(0, 254));
                                        this.titleComponent.getJTextArea().setBorder(GUISystem.blackBorder);
                                        this.titleComponent.getJTextArea().setFont(FontSystem.largeTitleFont);
                                        this.titleComponent.getJTextArea().setForeground(new Color(0, 0, 150));
                                        this.titleComponent.setForeground((Color)UIManager.getDefaults().get("Form.titleForeground"));
                                        this.titleComponent.setFont((Font)UIManager.getDefaults().get("Form.titleFont"));
                                        break block29;
                                    }
                                    if (!string.equals(FORM_DOCUMENT_PRODUCTS)) break block30;
                                    this.productComponent = new ProductPanel();
                                    jPanel = new FormComponent(Str.getStr(299), this.productComponent);
                                    break block29;
                                }
                                if (!string.equals(FORM_TYPE_CLASS)) break block31;
                                jPanel2 = new JPanel();
                                serializable = new Dimension(320, -1);
                                this.documentType = new RadioFormComponent(Str.getStr(282), TypeList.getInstance().getTypeList(4));
                                this.documentClass = new RadioFormComponent(Str.getStr(269), TypeList.getInstance().getTypeList(5));
                                this.documentClass.addActionListener(this);
                                this.documentType.addActionListener(this);
                                GUISystem.setPropertiesOnFormComponent(this.documentType);
                                GUISystem.setPropertiesOnFormComponent(this.documentClass);
                                this.documentType.setPreferredSize((Dimension)serializable);
                                this.documentClass.setPreferredSize((Dimension)serializable);
                                jPanel2.setLayout(new StraightLayoutMgr());
                                jPanel2.add((Component)this.documentType, "West");
                                jPanel2.add((Component)this.documentClass, "East");
                                jPanel2.setBackground(Color.white);
                                jPanel = jPanel2;
                                break block29;
                            }
                            if (!string.equals(FORM_DRAFT_INFO)) break block32;
                            this.draftInfo = new DraftInfoPanel();
                            jPanel = new FormComponent(Str.getStr(1648), this.draftInfo);
                            ((FormComponent)jPanel).setPreferredSize(this.defaultFormSize);
                            break block29;
                        }
                        if (!string.equals(FORM_QUEST_DOCUMENT_INFO)) break block33;
                        this.documentInfo = new DocumentInfoFormComponent();
                        jPanel = new FormComponent(Str.getStr(1655), this.documentInfo);
                        ((FormComponent)jPanel).setPreferredSize(this.defaultFormSize);
                        break block29;
                    }
                    if (!string.equals(FORM_COMMENT)) break block34;
                    if (this.document != null && this.document instanceof DocumentDraft) {
                        jPanel2 = new JPanel();
                        serializable = new JPanel();
                        int n3 = 1024;
                        String string2 = null;
                        JTextAreaCounter jTextAreaCounter = null;
                        try {
                            string2 = ((DocumentDraft)this.document).getComments().toString();
                        }
                        catch (Exception exception) {
                            string2 = "";
                        }
                        n3 -= string2.length();
                        this.currentCommentHistory = new NoTabJTextArea();
                        this.currentComment = new NoTabJTextArea();
                        this.currentComment.setFont(FontSystem.defaultFont);
                        this.currentCommentHistory.setFont(FontSystem.defaultFont);
                        this.currentCommentHistory.setBackground(new Color(240, 240, 240));
                        this.currentCommentHistory.setEditable(false);
                        this.currentComment.setDocument(new MaskDocument(0, n3));
                        jTextAreaCounter = new JTextAreaCounter(this.currentComment);
                        jPanel2.setLayout(new BorderLayout());
                        ((Container)serializable).setLayout(new BorderLayout());
                        ((JComponent)serializable).setBackground(Color.white);
                        jPanel2.add((Component)this.currentCommentHistory, "North");
                        jPanel2.add((Component)this.currentComment, "Center");
                        ((Container)serializable).add(new JScrollPane(jPanel2), "Center");
                        ((Container)serializable).add(jTextAreaCounter, "South");
                        jPanel = new FormComponent(Str.getStr(290), (JComponent)serializable);
                        ((FormComponent)jPanel).setPreferredSize(new Dimension(470, GUISystem.getRowHeight() * 5 + 22));
                    }
                    break block29;
                }
                if (string.equals(FORM_COMMENT_HISTORY)) {
                    this.commentHistoryLabel = new JLabel();
                    this.commentHistoryScroll = new JScrollPane(this.commentHistoryLabel);
                    this.commentHistoryScroll.setOpaque(false);
                    jPanel = new FormComponent(Str.getStr(303), this.commentHistoryScroll);
                    ((FormComponent)jPanel).setPreferredSize(new Dimension(470, GUISystem.getRowHeight() * 5 + 22));
                } else if (string.equals(FORM_SEARCH_ENGINE_QUERY_INDEX)) {
                    jPanel = this.searchEngineQueryComponent = new MultiLineFormComponent(Str.getStr(11046), "");
                    jPanel.setPreferredSize(new Dimension(470, GUISystem.getRowHeight() * 5 + 22));
                } else if (string.equals(FORM_PUBLISHING_OPTIONS)) {
                    this.publishingOptions = new PublishingOptionsPanel();
                    jPanel = new FormComponent(Str.getStr(1649), this.publishingOptions);
                } else if (string.equals(FORM_THIS_DOCUMENT_LINKS_TO)) {
                    this.docLinksToPanel = new DocumentLinkPanel();
                    jPanel = new FormComponent(Str.getStr(296), this.docLinksToPanel);
                } else if (string.equals(FORM_DOCUMENTS_LINK_TO_THIS)) {
                    this.refDocLinksPanel = new DocumentLinkPanel();
                    jPanel = new FormComponent(Str.getStr(297), this.refDocLinksPanel);
                } else if (string.equals(FORM_FILE_ATTACHMENTS)) {
                    if (this.document != null && (this.document.getDocumentType() == 8 || this.document.getDocumentType() == 9)) {
                        this.fileAttachments = new FileAttachmentPanel();
                        jPanel = new FormComponent(Str.getStr(438), this.fileAttachments);
                    }
                } else if (string.equals(FORM_PROACTIVE_EMAIL)) {
                    this.proMailPanel = new ProMailPanel();
                    jPanel = new FormComponent(Str.getStr(208), this.proMailPanel);
                } else if (string.equals(FORM_DOCUMENT_LOCATION)) {
                    this.locale = new LocalePanel();
                    jPanel = new FormComponent(Str.getStr(1650), this.locale);
                } else if (string.equals(FORM_CATEGORY)) {
                    this.category = new CategoryPanel();
                    jPanel = new FormComponent(Str.getStr(495), this.category);
                } else if (string.equals(FORM_DOWNLOADABLE_FILE_INFO) && this.document != null && (this.document.getDocumentType() == 8 || this.document.getDocumentType() == 9)) {
                    this.downloadablePanel = new DownloadableInfoPanel();
                    jPanel = new FormComponent(Str.getStr(11020), this.downloadablePanel);
                }
            }
            if (jPanel != null) {
                if (jPanel instanceof FormComponent && jPanel != this.titleComponent) {
                    GUISystem.setPropertiesOnFormComponent(jPanel);
                }
                this.dataPanel.add(jPanel);
                this.addComponentFocus(jPanel);
            } else {
                LogSystem.log(1, "Cannot add FormComponent:" + string);
            }
            ++n;
        }
        if (this.document != null && (this.document.getDocumentType() == 9 || this.document.getDocumentType() == 8)) {
            this.documentType.setEnabled(false);
        }
    }

    private final void addComponentFocus(Container container) {
        Component[] componentArray = container.getComponents();
        if (componentArray != null) {
            int n = 0;
            while (n < componentArray.length) {
                if (componentArray[n] instanceof JCheckBox || componentArray[n] instanceof JRadioButton || componentArray[n] instanceof JList || componentArray[n] instanceof JTextArea || componentArray[n] instanceof JTextField || componentArray[n] instanceof JButton) {
                    componentArray[n].addFocusListener(this);
                    this.focusGUI.addElement(componentArray[n]);
                } else if (componentArray[n] instanceof Container) {
                    this.addComponentFocus((Container)componentArray[n]);
                }
                ++n;
            }
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        boolean bl = true;
        Component component = (Component)focusEvent.getSource();
        Rectangle rectangle = component.getBounds();
        Rectangle rectangle2 = this.scrollPane.getViewport().getViewRect();
        while (bl) {
            Container container = component.getParent();
            Rectangle rectangle3 = container.getBounds();
            boolean bl2 = bl = container != this.dataPanel;
            if (!bl) continue;
            rectangle.y += rectangle3.y;
            component = container;
        }
        if (!rectangle2.contains(rectangle.x, rectangle.y)) {
            this.scrollPane.getViewport().setViewPosition(new Point(rectangle.x, rectangle.y));
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.titleComponent.getJTextArea()) {
            this.document.setTitle(this.titleComponent.getText());
        } else if (focusEvent.getSource() == this.searchEngineQueryComponent.getJTextArea()) {
            DocumentQueryText documentQueryText = this.document.getQueryText();
            if (documentQueryText == null) {
                documentQueryText = new DocumentQueryText(this.searchEngineQueryComponent.getText());
            } else {
                documentQueryText.setQueryText(this.searchEngineQueryComponent.getText());
            }
            this.document.setQueryText(documentQueryText);
        }
    }

    public void documentChanged(Document document, int n) {
        switch (n) {
            case 1: {
                this.titleComponent.setText(document.getTitle());
                break;
            }
            case 24: {
                this.documentType.setSelectedItem(TypeList.getInstance().objectFromInd(document.getDocumentType(), 4));
                break;
            }
            case 22: {
                this.documentClass.setSelectedItem(TypeList.getInstance().objectFromInd(document.getDocumentClass(), 5));
                break;
            }
            case 23: {
                this.docLinksToPanel.setDocumentLinks(document.getDocumentLinks());
                break;
            }
            case 42: {
                this.refDocLinksPanel.setDocumentLinks(document.getReferringDocumentLinks());
                break;
            }
            case 10: 
            case 21: {
                new Thread((Runnable)this, THREAD_SET_DOC_BODY).start();
                break;
            }
        }
    }

    private final void removeAllFocusListeners() {
        int n = 0;
        int n2 = this.focusGUI.size();
        while (n < n2) {
            ((Component)this.focusGUI.elementAt(n)).removeFocusListener(this);
            ++n;
        }
        if (this.documentClass != null) {
            this.documentClass.removeActionListener(this);
        }
        if (this.documentType != null) {
            this.documentType.removeActionListener(this);
        }
        this.focusGUI.removeAllElements();
    }

    public int save() {
        Serializable serializable;
        boolean bl = false;
        boolean bl2 = false;
        if (this.document.getStatus() != null) {
            serializable = this.document.getStatus();
            if (CDate.checkDate(((DocumentStatus)serializable).getStatusDate(), 2) != 0) {
                GUISystem.printBox("Information", "Please enter a valid status and status date");
            } else {
                bl2 = ((DocumentStatus)serializable).getStatus() == 6 ? GUISystem.printBox(8, 11068) : true;
            }
        } else {
            GUISystem.printBox("Information", "Please enter a valid status and status date");
        }
        if (bl2) {
            ((DocumentDraft)this.document).setComments(this.currentComment.getText());
            serializable = new SaveDocDlg(GUISystem.getParentDefWin(this), (DocumentDraft)this.document, this.currentComment.getText());
            return ((SaveDocDlg)serializable).getReturnCode();
        }
        return 0;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.documentType) {
            int n = this.document.getDocumentType();
            if (n != ((TypeDocRec)this.documentType.getSelectedItem()).getInd()) {
                this.document.setDocumentType(((TypeDocRec)this.documentType.getSelectedItem()).getInd());
                this.document.writeToMemory();
                this.setDocument(this.document);
            }
        } else if (actionEvent.getSource() == this.documentClass) {
            this.document.setDocumentClass(((TypeDocClassRec)this.documentClass.getSelectedItem()).getInd());
        } else if (actionEvent.getSource() == this.pb_FIELDS) {
            ((CardLayout)this.fieldBodyPanel.getLayout()).show(this.fieldBodyPanel, "FIELDS");
            this.revalidate();
        } else if (actionEvent.getSource() == this.pb_BODY) {
            ((CardLayout)this.fieldBodyPanel.getLayout()).show(this.fieldBodyPanel, "BODY");
            new Thread((Runnable)this, THREAD_SET_DOC_BODY).start();
        }
    }

    public void propertyChanged(int n, Object object) {
        this.setDocument(this.document);
    }

    public void free() {
        PropertySystem.removePropertyListener(159, this);
    }

    public void run() {
        String string = Thread.currentThread().getName();
        if (string.equals(THREAD_SET_DOC_BODY)) {
            this.refreshDocumentBody();
        }
    }

    public void refreshDocumentBody() {
        String string = null;
        if (this.pb_BODY.isSelected()) {
            if (this.document.getDocumentType() == 9) {
                string = this.document.getAdditionalInfo();
            } else {
                DocumentBody documentBody = this.document.getDocumentBody();
                if (documentBody != null) {
                    string = documentBody.getBody();
                }
            }
            if (string == null || string.length() == 0) {
                string = "<html><body>No Body</body></html>";
            }
            this.browser.setPageContent(string);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.enableInput = bl;
        try {
            this.titleComponent.getJTextArea().setEditable(bl);
            this.productComponent.setEnabled(bl);
            this.proMailPanel.setEnabled(bl);
            if (this.fileAttachments != null) {
                this.fileAttachments.setEnabled(bl);
            }
            this.currentComment.setEditable(bl);
            this.documentClass.setEnabled(bl);
            this.documentType.setEnabled(bl);
            this.documentInfo.setEnabled(bl);
            this.searchEngineQueryComponent.getJTextArea().setEditable(bl);
            this.category.setEnabled(bl);
            this.publishingOptions.setEnabled(bl);
            this.locale.setEnabled(bl);
            this.draftInfo.setEnabled(bl);
            if (this.downloadablePanel != null) {
                this.downloadablePanel.setEnabled(bl);
            }
            if (this.document == null) return;
            if (this.document.getDocumentType() != 9) {
                if (this.document.getDocumentType() != 8) return;
            }
            this.documentType.setEnabled(false);
            return;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
    }

    public JPanel getContentPanel() {
        return this.dataPanel;
    }

    protected void spellCheck(DocumentEditor documentEditor, SpellPanel spellPanel) {
        this.spellPanel = spellPanel;
        this.documentEditor = documentEditor;
        this.spellCheckStep = 1;
        spellPanel.addSpellPanelListener(this);
        spellPanel.spellCheck(this.titleComponent.getText());
    }

    public void spellCheckComplete(boolean bl) {
        int n = this.document.getDocumentType();
        System.out.println("spellCheckComplete ( " + bl + " )");
        ++this.spellCheckStep;
        System.out.println("New Spell Step " + this.spellCheckStep);
        switch (this.spellCheckStep) {
            case 1: {
                this.spellPanel.spellCheck(this.titleComponent.getText());
                break;
            }
            case 2: {
                if (this.document.getEMailable()) {
                    this.spellPanel.spellCheck(this.proMailPanel.getJTextArea().getText());
                    break;
                }
                this.spellCheckComplete(bl);
                break;
            }
            case 3: {
                if (n == 8 || n == 9) {
                    this.spellPanel.spellCheck(this.downloadablePanel.getJTextArea().getText());
                    break;
                }
                this.spellCheckComplete(bl);
                break;
            }
            case 4: {
                if (n == 8 || n == 9) {
                    this.spellPanel.spellCheck(this.downloadablePanel.getVersionJTextField().getText());
                    break;
                }
                this.spellCheckComplete(bl);
                break;
            }
            case 5: {
                GUISystem.printBox("Info", "Spell Check Complete");
                this.spellPanel.removeSpellPanelListener(this);
                this.spellPanel = null;
                this.documentEditor.closeSpellPanel();
                break;
            }
        }
    }

    public void spellCheckWord(String string, int n, int n2) {
        switch (this.spellCheckStep) {
            case 1: {
                this.titleComponent.getJTextArea().setCaretPosition(n);
                this.titleComponent.getJTextArea().moveCaretPosition(n2);
                this.titleComponent.getJTextArea().requestFocus();
                break;
            }
            case 2: {
                JTextArea jTextArea = this.proMailPanel.getJTextArea();
                jTextArea.setCaretPosition(n);
                jTextArea.moveCaretPosition(n2);
                jTextArea.requestFocus();
                break;
            }
            case 3: {
                JTextArea jTextArea = this.downloadablePanel.getJTextArea();
                jTextArea.setCaretPosition(n);
                jTextArea.moveCaretPosition(n2);
                jTextArea.requestFocus();
                break;
            }
            case 4: {
                JTextField jTextField = this.downloadablePanel.getVersionJTextField();
                jTextField.setCaretPosition(n);
                jTextField.moveCaretPosition(n2);
                jTextField.requestFocus();
                break;
            }
        }
    }

    public void replaceWord(String string, String string2, int n) {
        switch (this.spellCheckStep) {
            case 1: {
                String string3 = this.titleComponent.getJTextArea().getText();
                string3 = Text.replaceAllStrInStr(string3, string, string2);
                this.titleComponent.getJTextArea().setText(string3);
                this.document.setTitle(string3);
                break;
            }
            case 2: {
                String string4 = this.proMailPanel.getJTextArea().getText();
                string4 = Text.replaceAllStrInStr(string4, string, string2);
                this.proMailPanel.getJTextArea().setText(string4);
                this.document.setEMailComments(string4);
                break;
            }
        }
    }

    protected boolean isBodyShowing() {
        return this.pb_BODY.isSelected();
    }

    protected String getTempBodyFilename() {
        String string = PropertySystem.getString(30) + File.separator + "1_" + System.currentTimeMillis() + "_temp.html";
        String string2 = null;
        if (this.document.getDocumentType() == 9) {
            string2 = this.document.getAdditionalInfo();
        } else {
            DocumentBody documentBody = this.document.getDocumentBody();
            if (documentBody != null) {
                string2 = documentBody.getBody();
            }
        }
        if (string2 == null || string2.length() == 0) {
            string2 = "<html><body>No Body</body></html>";
        }
        FileUtil.saveFile(string, string2);
        return string;
    }

    public String getCommentHistoryAsText(DocumentDraft documentDraft) {
        Vector vector = documentDraft.getCommentHistory();
        StringBuffer stringBuffer = new StringBuffer("<html><body bgcolor=white><font size=2 face=\"Helvetica, Arial\">");
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                DocumentComment documentComment = (DocumentComment)vector.elementAt(n);
                stringBuffer.append("<font size=2 face=\"Helvetica, Arial\"><b>");
                if (documentComment.toString().indexOf("saved this document but made no comment") != -1) {
                    stringBuffer.append(documentComment.toString());
                } else {
                    stringBuffer.append("On ");
                    stringBuffer.append(DateSystem.prettyDateFromStamp(documentComment.getLastTouchedOn()));
                    stringBuffer.append(" ");
                    stringBuffer.append(UserSystem.getNameFromUserId(documentComment.getLastTouchedBy()));
                    stringBuffer.append(" wrote:</b></font><br>");
                    stringBuffer.append(documentComment.toString());
                }
                if (n < n2 - 1) {
                    stringBuffer.append("<hr><br><br>");
                }
                ++n;
            }
        }
        stringBuffer.append("<br><br><br></body></html>");
        return stringBuffer.toString();
    }

    public DocEditPanel() {
        this.initialize();
    }
}

