/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.doc.docedit;

import com.ibm.nzna.projects.common.quest.doc.Document;
import com.ibm.nzna.projects.common.quest.doc.DocumentDraft;
import com.ibm.nzna.projects.common.quest.doc.DocumentPropertyListener;
import com.ibm.nzna.projects.common.quest.doc.DocumentUndoableEdit;
import com.ibm.nzna.projects.common.quest.type.TypeCategoryRec;
import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.projects.common.quest.type.TypeResolutionRec;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.DateSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserRec;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.app.WindowSystem;
import com.ibm.nzna.projects.qit.doc.DocConst;
import com.ibm.nzna.projects.qit.doc.docedit.DocEditPanel;
import com.ibm.nzna.projects.qit.doc.docedit.ExtBodyEditProcess;
import com.ibm.nzna.projects.qit.doc.docedit.ExtBodyEditProcessListener;
import com.ibm.nzna.projects.qit.doc.docedit.property.PropertyDlg;
import com.ibm.nzna.projects.qit.doc.docmaint.DocMaintPanel;
import com.ibm.nzna.projects.qit.doc.history.DocHistPanel;
import com.ibm.nzna.projects.qit.gui.ActionButton;
import com.ibm.nzna.projects.qit.gui.AppDefaultWin;
import com.ibm.nzna.projects.qit.gui.NavPanel;
import com.ibm.nzna.projects.qit.gui.QuestPanel;
import com.ibm.nzna.projects.qit.gui.ToolBarButton;
import com.ibm.nzna.projects.qit.notify.NotificationRec;
import com.ibm.nzna.projects.qit.notify.SendNotifyDlg;
import com.ibm.nzna.projects.qit.print.Preview;
import com.ibm.nzna.projects.qit.print.PreviewPanel;
import com.ibm.nzna.projects.qit.print.Print;
import com.ibm.nzna.projects.qit.print.PrintPanel;
import com.ibm.nzna.projects.qit.wordproc.WordProcFrame;
import com.ibm.nzna.shared.spell.SpellPanel;
import com.ibm.nzna.shared.spell.SpellPanelListener;
import com.ibm.nzna.shared.util.LogSystem;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class DocumentEditor
extends JPanel
implements SpellPanelListener,
PreviewPanel,
PrintPanel,
ExtBodyEditProcessListener,
Runnable,
DocumentPropertyListener,
DocConst,
ActionListener,
QuestPanel,
AppConst {
    private static final String THREAD_SET_EDIT = "SETEDIT";
    private boolean focusButtonSet = false;
    private DocEditPanel editPanel = null;
    private DocumentDraft draft = null;
    private ActionButton pb_SAVE = null;
    private ActionButton pb_CLOSE = null;
    private ActionButton pb_SEND = null;
    private ActionButton pb_EXT_BODY_EDIT = null;
    private ActionButton pb_INT_BODY_EDIT = null;
    private boolean editorClosing = false;
    private AppDefaultWin parentWin = null;
    private boolean documentChanged = false;
    private JMenuItem mnu_SPELLCHECK = new JMenuItem("Spell Check");
    private ToolBarButton pb_HISTORY = null;
    private SpellPanel spellPanel = null;
    private ToolBarButton pb_UNDO = null;
    private JToolBar toolBar = null;
    private ToolBarButton pb_PROPERTY = null;
    private ExtBodyEditProcess extBodyEditProcess = null;

    public boolean initialize() {
        Object var1_1 = null;
        this.pb_SAVE = new ActionButton(Str.getStr(515), ImageSystem.getImageIcon((Object)this, 62), Str.getStr(515));
        this.pb_CLOSE = new ActionButton(Str.getStr(28), ImageSystem.getImageIcon((Object)this, 8), Str.getStr(28));
        this.pb_SEND = new ActionButton(Str.getStr(516), ImageSystem.getImageIcon((Object)this, 59), Str.getStr(516));
        this.pb_PROPERTY = new ToolBarButton(Str.getStr(1320), ImageSystem.getImageIcon((Object)this, 166), Str.getStr(1320));
        this.pb_HISTORY = new ToolBarButton(Str.getStr(1206), ImageSystem.getImageIcon((Object)this, 125), Str.getStr(1206));
        this.pb_UNDO = new ToolBarButton(Str.getStr(1679), ImageSystem.getImageIcon((Object)this, 76), Str.getStr(1679));
        this.toolBar = new JToolBar();
        if (PropertySystem.getBool(91)) {
            this.pb_INT_BODY_EDIT = new ActionButton(Str.getStr(11048), ImageSystem.getImageIcon((Object)this, 56), Str.getStr(11050));
            this.pb_INT_BODY_EDIT.addActionListener(this);
        }
        if (PropertySystem.getBool(44)) {
            this.pb_EXT_BODY_EDIT = new ActionButton(Str.getStr(11047), ImageSystem.getImageIcon((Object)this, 56), Str.getStr(11049));
            this.pb_EXT_BODY_EDIT.addActionListener(this);
        }
        this.toolBar.add(this.pb_UNDO);
        this.toolBar.add(this.pb_PROPERTY);
        this.toolBar.add(this.pb_HISTORY);
        this.setBackground(Color.white);
        this.toolBar.setBorder(GUISystem.emptyBorder);
        this.toolBar.setOpaque(false);
        this.pb_SAVE.addActionListener(this);
        this.pb_CLOSE.addActionListener(this);
        this.pb_HISTORY.addActionListener(this);
        this.pb_PROPERTY.addActionListener(this);
        this.pb_SEND.addActionListener(this);
        this.pb_UNDO.addActionListener(this);
        this.mnu_SPELLCHECK.addActionListener(this);
        this.setLayout(null);
        return true;
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = 5;
        super.doLayout();
        if (this.spellPanel != null) {
            this.spellPanel.setBounds(5, 5, dimension.width - 5, 58);
            n += 58;
        }
        if (this.editPanel != null) {
            this.editPanel.setBounds(5, n, dimension.width - 5, dimension.height - n - 5);
        }
    }

    public void start() {
        this.parentWin = GUISystem.getParentDefWin(this);
        this.parentWin.addActionComponent(this, this.pb_CLOSE);
        this.parentWin.addActionComponent(this, this.pb_SAVE);
        if (this.pb_EXT_BODY_EDIT != null) {
            this.parentWin.addActionComponent(this, this.pb_EXT_BODY_EDIT);
        }
        if (this.pb_INT_BODY_EDIT != null) {
            this.parentWin.addActionComponent(this, this.pb_INT_BODY_EDIT);
        }
        if (this.draft != null) {
            new Thread((Runnable)this, THREAD_SET_EDIT).start();
            this.documentChanged(this.draft, 0);
            this.documentChanged = false;
        }
        this.parentWin.addActionComponent(this, this.pb_SEND);
        this.panelSelected();
        this.checkDocument();
    }

    public void run() {
        String string = Thread.currentThread().getName();
        if (string.equals(THREAD_SET_EDIT)) {
            this.editPanel = new DocEditPanel();
            this.add(this.editPanel);
            this.editPanel.setDocument(this.draft);
            this.revalidate();
            this.editPanel.setEnabled(!this.documentCheckedOut());
        }
    }

    public String getName() {
        return Str.getStr(50);
    }

    public ImageIcon getIcon() {
        return ImageSystem.getImageIcon((Object)this, 56);
    }

    public void panelDeselected() {
        GUISystem.getParentDefWin(this).removeToolbarButton(this.toolBar);
        GUISystem.getParentDefWin(this).getAppDefaultMenuBar().removeEditMenuItem(this.mnu_SPELLCHECK);
    }

    public void panelSelected() {
        GUISystem.getParentDefWin(this).addToolbarButton(this.toolBar, 2);
        GUISystem.getParentDefWin(this).getAppDefaultMenuBar().addEditMenuItem(this.mnu_SPELLCHECK);
    }

    public boolean copyText() {
        return false;
    }

    public boolean pasteText() {
        return false;
    }

    public boolean cutText() {
        return false;
    }

    public NavPanel getDefaultNavPanel() {
        return null;
    }

    public JComponent getJComponent() {
        return this;
    }

    public boolean stop() {
        this.editorClosing = true;
        if (!this.documentCheckedOut()) {
            if (this.extBodyEditProcess != null) {
                if (GUISystem.printBox("Question", "Do you wish to <b>reimport</b> your body changes?")) {
                    this.extBodyEditProcess.reimportBody();
                    this.editorClosing = false;
                    return false;
                }
                this.bodyReimportComplete();
            }
            if (this.documentChanged && GUISystem.printBox("Question", "Do you wish to save your document?")) {
                return this.saveDocument();
            }
            this.draft.checkIn();
        }
        this.panelDeselected();
        this.editPanel.free();
        this.draft.removeDocumentPropertyListener(this);
        DocMaintPanel docMaintPanel = (DocMaintPanel)WindowSystem.findQuestPanel("DOCMAINT");
        if (docMaintPanel != null) {
            docMaintPanel.refresh();
        }
        this.editorClosing = false;
        return true;
    }

    public boolean shutdown() {
        return true;
    }

    public boolean bookmark() {
        return false;
    }

    public void refresh() {
        GUISystem.printBox("Info", "Refresh not supported here");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.pb_CLOSE) {
            this.parentWin.closePanel(this, null);
        } else if (actionEvent.getSource() == this.mnu_SPELLCHECK) {
            this.spellCheck();
        } else if (actionEvent.getSource() == this.pb_HISTORY) {
            WindowSystem.createPanel(new DocHistPanel(this.draft.getExistingDocInd(), true, null));
        } else if (actionEvent.getSource() == this.pb_UNDO) {
            DocumentUndoableEdit documentUndoableEdit = this.draft.undo();
            if (documentUndoableEdit != null) {
                this.parentWin.setStatus(documentUndoableEdit.getPresentationName() + " Undone", 5);
            }
        } else if (actionEvent.getSource() == this.pb_SEND) {
            this.sendNotification();
        } else if (actionEvent.getSource() == this.pb_SAVE) {
            this.saveDocument();
        } else if (actionEvent.getSource() == this.pb_PROPERTY) {
            new PropertyDlg(this.parentWin);
        } else if (actionEvent.getSource() == this.pb_INT_BODY_EDIT) {
            new WordProcFrame(this.draft, this.draft.getDocumentType() == 9 ? 10 : 21);
        } else if (actionEvent.getSource() == this.pb_EXT_BODY_EDIT) {
            if (this.extBodyEditProcess == null) {
                this.extBodyEditProcess = new ExtBodyEditProcess(this.draft);
                this.extBodyEditProcess.setExtBodyEditProcessListener(this);
                this.pb_EXT_BODY_EDIT.setText(Str.getStr(513));
                this.pb_EXT_BODY_EDIT.setToolTipText(Str.getStr(513));
            } else if (this.extBodyEditProcess != null) {
                this.extBodyEditProcess.reimportBody();
            }
        }
    }

    public void documentChanged(Document document, int n) {
        this.documentChanged = true;
        if (!this.focusButtonSet) {
            String string = document.getFilename();
            String string2 = document.getTitle();
            int n2 = document.getDocInd();
            if (string != null && string.length() > 0) {
                this.focusButtonSet = true;
                this.parentWin.setFocusButtonText(this, string);
            } else if (n2 > 0) {
                this.parentWin.setFocusButtonText(this, "" + n2);
            } else if (string2 != null && string2.length() > 10) {
                this.parentWin.setFocusButtonText(this, string2.substring(0, 10) + "...");
            }
        }
    }

    public boolean equals(Object object) {
        if (object instanceof DocumentDraft) {
            DocumentDraft documentDraft = (DocumentDraft)object;
            if (documentDraft.getExistingDocInd() == 0 && documentDraft.getFilename() != null && this.draft.getFilename() != null) {
                return documentDraft.getFilename().equals(this.draft.getFilename());
            }
            if (documentDraft.getExistingDocInd() == 0 && this.draft.getExistingDocInd() == 0) {
                return false;
            }
            return documentDraft.getExistingDocInd() == this.draft.getExistingDocInd();
        }
        return object == this;
    }

    public void bodyReimportComplete() {
        this.pb_EXT_BODY_EDIT.setText(Str.getStr(11047));
        this.pb_EXT_BODY_EDIT.setToolTipText(Str.getStr(11049));
        this.extBodyEditProcess = null;
    }

    private final void sendNotification() {
        UserRec userRec;
        TypeCategoryRec typeCategoryRec = this.draft.getFirstAvailBrand();
        NotificationRec notificationRec = new NotificationRec();
        boolean bl = false;
        if (typeCategoryRec != null && (userRec = UserSystem.getBrandProgramManager(typeCategoryRec.getInd(), "DOC")) != null) {
            notificationRec.toUser = userRec.getUserId();
        }
        notificationRec.fromUser = UserSystem.getUserId();
        notificationRec.brandRec = typeCategoryRec;
        notificationRec.mustSend = false;
        notificationRec.resolRec = (TypeResolutionRec)TypeList.getInstance().objectFromInd(0, 16);
        notificationRec.openDate = DateSystem.getDate(2);
        notificationRec.docInd = this.draft.getDocInd();
        notificationRec.subject = Str.getStr(50) + " - " + notificationRec.docInd;
        new SendNotifyDlg((Frame)GUISystem.getParentDefWin(this), notificationRec).getResult();
    }

    private final boolean saveDocument() {
        if (this.extBodyEditProcess != null) {
            if (GUISystem.printBox("Question", "Would you like to reimport your body changes before you save?")) {
                this.extBodyEditProcess.reimportBody();
            } else {
                this.extBodyEditProcess = null;
            }
        }
        switch (this.editPanel.save()) {
            case 2: 
            case 3: 
            case 4: {
                this.documentChanged = false;
                this.parentWin.closePanel(this, null);
                return true;
            }
            case 1: {
                this.documentChanged = false;
                if (!this.editorClosing) {
                    GUISystem.printBox("Info", "The document draft has been saved");
                }
                return true;
            }
        }
        return false;
    }

    private final void checkDocument() {
        if (this.documentCheckedOut()) {
            this.pb_SAVE.setVisible(false);
            if (this.pb_EXT_BODY_EDIT != null) {
                this.pb_EXT_BODY_EDIT.setVisible(false);
            }
            if (this.pb_INT_BODY_EDIT != null) {
                this.pb_INT_BODY_EDIT.setVisible(false);
            }
            GUISystem.printBox("Info", UserSystem.getNameFromUserId(this.draft.getCheckedOutBy()) + " currently has this document checked out");
        } else {
            this.parentWin.setStatus("Checking out document");
            this.draft.checkOut(UserSystem.getUserId());
            this.parentWin.setStatus(null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean documentCheckedOut() {
        try {
            if (this.draft == null) return false;
            if (!this.draft.isCheckedOut()) return false;
            if (this.draft.getCheckedOutBy().equals(UserSystem.getUserId())) return false;
            return true;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getPrintObject() {
        if (!this.editPanel.isBodyShowing()) return new Print(this.editPanel.getContentPanel(), GUISystem.getParentDefWin(this), Str.getStr(353));
        String[] stringArray = new String[]{PropertySystem.getString(92), this.editPanel.getTempBodyFilename()};
        System.out.println("Starting Browser!");
        try {
            Runtime.getRuntime().exec(stringArray);
            return null;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            GUISystem.printBox("Info", "Could not launch the 'External Web Browser'. Please verify you have configured the browser correctly by:<br><br>1. Select 'File'->'Preferences'->Application<br>2. When the preferences comes up, look in the 'External Browser Field'");
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getPreviewObject() {
        if (!this.editPanel.isBodyShowing()) return new Preview(this.editPanel.getContentPanel(), GUISystem.getParentDefWin(this), Str.getStr(353));
        String[] stringArray = new String[]{PropertySystem.getString(92), this.editPanel.getTempBodyFilename()};
        try {
            Runtime.getRuntime().exec(stringArray);
            return null;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            GUISystem.printBox("Info", "Could not launch the 'External Web Browser'. Please verify you have configured the browser correctly by:<br><br>1. Select 'File'->'Preferences'->Application<br>2. When the preferences comes up, look in the 'External Browser Field'");
        }
        return null;
    }

    private final void spellCheck() {
        this.spellPanel = new SpellPanel();
        this.spellPanel.addSpellPanelListener(this);
        this.add(this.spellPanel);
        this.revalidate();
        this.editPanel.spellCheck(this, this.spellPanel);
    }

    public void spellCheckComplete(boolean bl) {
    }

    public void spellCheckWord(String string, int n, int n2) {
    }

    public void replaceWord(String string, String string2, int n) {
    }

    protected void closeSpellPanel() {
        this.remove(this.spellPanel);
        this.spellPanel = null;
        this.revalidate();
    }

    public DocumentEditor(DocumentDraft documentDraft) {
        this.draft = documentDraft;
        documentDraft.addDocumentPropertyListener(this);
    }

    public DocumentEditor() {
    }
}

