/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.doc.docedit;

import com.ibm.nzna.projects.common.quest.doc.Document;
import com.ibm.nzna.projects.common.quest.doc.DocumentDraft;
import com.ibm.nzna.projects.common.quest.doc.DocumentPropertyListener;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.DateSystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.doc.DocConst;
import com.ibm.nzna.shared.gui.ListPanel;
import com.ibm.nzna.shared.gui.ValueLabel;
import com.ibm.nzna.shared.util.LogSystem;
import javax.swing.JLabel;

public class DocumentInfoFormComponent
extends ListPanel
implements DocConst,
DocumentPropertyListener,
AppConst {
    private ValueLabel activeDocumentInd = new ValueLabel(Str.getStr(1656), new JLabel("" + 0));
    private ValueLabel draftDocumentInd = new ValueLabel(Str.getStr(1657), new JLabel("" + 0));
    private ValueLabel documentFilename = new ValueLabel(Str.getStr(1658), new JLabel(""));
    private ValueLabel draftCreatedOn = new ValueLabel(Str.getStr(1659), new JLabel(""));
    private ValueLabel createdOn = new ValueLabel(Str.getStr(11092), new JLabel(""));
    private ValueLabel createdBy = new ValueLabel(Str.getStr(11093), new JLabel(""));
    private ValueLabel lastTouchedBy = new ValueLabel(Str.getStr(266), new JLabel(""));
    private ValueLabel lastTouchedOn = new ValueLabel(Str.getStr(267), new JLabel(""));

    private final void setValueLabelProperties(ValueLabel valueLabel) {
        valueLabel.setDescriptionWidth(150);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setDocument(Document document) {
        document.removeDocumentPropertyListener(this);
        document.addDocumentPropertyListener(this);
        if (document instanceof DocumentDraft) {
            this.activeDocumentInd.setValue("" + ((DocumentDraft)document).getExistingDocInd());
            this.draftDocumentInd.setValue("" + ((DocumentDraft)document).getDocInd());
            try {
                this.draftCreatedOn.setValue(DateSystem.prettyDateFromDate(((DocumentDraft)document).getStartDate()));
            }
            catch (Exception exception) {
                LogSystem.log(1, exception, false);
                this.draftCreatedOn.setValue(((DocumentDraft)document).getStartDate());
            }
        } else {
            this.activeDocumentInd.setValue("" + document.getDocInd());
        }
        this.documentFilename.setValue(document.getFilename());
        if (document.getLastTouchedBy() != null) {
            this.lastTouchedBy.setValue(UserSystem.getNameFromUserId(document.getLastTouchedBy()));
        } else {
            this.lastTouchedBy.setValue("-");
        }
        if (document.getLastTouched() != null) {
            this.lastTouchedOn.setValue(DateSystem.prettyDateFromStamp(document.getLastTouched()));
        } else {
            this.lastTouchedOn.setValue("-");
        }
        this.createdOn.setValue(DateSystem.prettyDateFromStamp(document.getCreateDate().toString()));
        this.createdBy.setValue(UserSystem.getNameFromUserId(document.getCreatedBy().toString()));
    }

    public void documentChanged(Document document, int n) {
        this.setDocument(document);
    }

    public DocumentInfoFormComponent() {
        this.add(this.activeDocumentInd);
        this.add(this.createdOn);
        this.add(this.createdBy);
        this.add(new JLabel("_________________________________________"));
        this.add(this.documentFilename);
        this.add(new JLabel("_________________________________________"));
        this.add(this.draftDocumentInd);
        this.add(this.draftCreatedOn);
        this.add(this.lastTouchedBy);
        this.add(this.lastTouchedOn);
        this.setOpaque(false);
        this.setValueLabelProperties(this.activeDocumentInd);
        this.setValueLabelProperties(this.createdOn);
        this.setValueLabelProperties(this.createdBy);
        this.setValueLabelProperties(this.draftDocumentInd);
        this.setValueLabelProperties(this.documentFilename);
        this.setValueLabelProperties(this.draftCreatedOn);
        this.setValueLabelProperties(this.lastTouchedBy);
        this.setValueLabelProperties(this.lastTouchedOn);
        this.setPadding(3);
    }
}

