/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.doc.docedit;

import com.ibm.nzna.projects.common.quest.Constants;
import com.ibm.nzna.projects.common.quest.doc.Document;
import com.ibm.nzna.projects.common.quest.doc.DocumentDraft;
import com.ibm.nzna.projects.common.quest.doc.DocumentFile;
import com.ibm.nzna.projects.common.quest.doc.DocumentGraphic;
import com.ibm.nzna.projects.common.quest.type.TypeCategoryRec;
import com.ibm.nzna.projects.common.storedProc.sqlRunner.SqlRunner;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.MainWindow;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserRec;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.app.util.QuestUtil;
import com.ibm.nzna.projects.qit.doc.DocConst;
import com.ibm.nzna.projects.qit.doc.docedit.DocSaveStatusPanel;
import com.ibm.nzna.projects.qit.gui.SelectUserDlg;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.ftp.FTP.Ftp;
import com.ibm.nzna.shared.gui.JListDlg;
import com.ibm.nzna.shared.util.CDate;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.WinUtil;
import java.awt.Frame;
import java.io.File;
import java.io.FileOutputStream;
import java.sql.ResultSet;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class DocumentSaver
implements AppConst,
DocConst {
    public static boolean saveDraft(DocumentDraft documentDraft, DocSaveStatusPanel docSaveStatusPanel) {
        boolean bl = false;
        bl = docSaveStatusPanel != null ? DocumentSaver.validateOwner(documentDraft, WinUtil.getParentJDialog(docSaveStatusPanel), null) : DocumentSaver.validateOwner(documentDraft, null, MainWindow.getInstance());
        if (documentDraft.getGraphics() != null && documentDraft.getGraphics().size() > 0) {
            if (bl) {
                if (docSaveStatusPanel != null) {
                    docSaveStatusPanel.enableGraphicsLabel(true);
                    docSaveStatusPanel.setGraphicsSelected(true);
                }
                bl = DocumentSaver.saveDraftGraphics(documentDraft.getGraphics(), docSaveStatusPanel);
            }
        } else {
            bl = true;
        }
        if (bl && documentDraft.getFileAttachments() != null && documentDraft.getFileAttachments().size() > 0) {
            if (docSaveStatusPanel != null) {
                docSaveStatusPanel.enableFilesLabel(true);
                docSaveStatusPanel.setFilesSelected(true);
            }
            bl = DocumentSaver.saveDraftFiles(documentDraft.getFileAttachments(), docSaveStatusPanel);
        } else {
            bl = true;
        }
        if (bl) {
            int n = 0;
            if (docSaveStatusPanel != null) {
                docSaveStatusPanel.enableDocumentsLabel(true);
                docSaveStatusPanel.setDocumentsSelected(true);
                docSaveStatusPanel.setText("Saving Document Draft");
            }
            documentDraft.setLastTouchedBy(UserSystem.getUserId());
            n = documentDraft.writeToDatabase();
            switch (n) {
                case 0: {
                    bl = true;
                    documentDraft.updateRecStatus(0);
                    break;
                }
                default: {
                    LogSystem.log(1, "Cannot write document. SQLCode returned:" + n);
                    bl = false;
                    break;
                }
            }
        }
        if (bl) {
            // empty if block
        }
        return bl;
    }

    private static final boolean validateOwner(DocumentDraft documentDraft, JDialog jDialog, JFrame jFrame) {
        boolean bl = false;
        String string = documentDraft.getOwner();
        if (string == null || string.length() == 0) {
            Vector vector = null;
            Vector vector2 = documentDraft.getApplicableBrands();
            Vector vector3 = documentDraft.getBrands();
            vector = vector2 != null && vector2.size() > 0 ? vector2 : vector3;
            if (vector != null) {
                TypeCategoryRec typeCategoryRec = null;
                if (vector.size() > 1) {
                    Vector vector4 = null;
                    vector4 = jDialog != null ? new JListDlg(jDialog, Str.getStr(11064), vector).getResult() : new JListDlg((Frame)jFrame, Str.getStr(11064), vector).getResult();
                    if (vector4 != null && vector4.size() > 0) {
                        typeCategoryRec = (TypeCategoryRec)vector4.elementAt(0);
                    }
                } else {
                    typeCategoryRec = (TypeCategoryRec)vector.elementAt(0);
                }
                if (typeCategoryRec != null) {
                    string = UserSystem.getBrandProgramManager(typeCategoryRec.getInd());
                }
                bl = string != null;
            } else {
                Vector vector5 = null;
                vector5 = jDialog != null ? new SelectUserDlg(jDialog, false).getResult() : new SelectUserDlg((Frame)jFrame, false).getResult();
                if (vector5 != null && vector5.size() > 0) {
                    string = ((UserRec)vector5.elementAt(0)).getUserId();
                    bl = true;
                }
            }
        } else {
            bl = true;
        }
        if (bl) {
            documentDraft.setOwner(string);
        }
        return bl;
    }

    public static boolean publishDraft(DocumentDraft documentDraft, DocSaveStatusPanel docSaveStatusPanel) {
        boolean bl = false;
        Document document = new Document();
        documentDraft.setStopDate(new CDate(2).today());
        bl = DocumentSaver.saveDraft(documentDraft, docSaveStatusPanel);
        if (bl) {
            document.initializeProperties(documentDraft);
            document.updateRecStatus(0);
            if (documentDraft.getWorkRequired() == 2) {
                document.updateRecStatus(1);
            } else if (documentDraft.getWorkRequired() == 1) {
                document.updateRecStatus(2);
            } else if (documentDraft.getWorkRequired() == 3) {
                document.updateRecStatus(3);
            }
            bl = false;
            if (documentDraft.getGraphics() != null && documentDraft.getGraphics().size() > 0) {
                if (docSaveStatusPanel != null) {
                    docSaveStatusPanel.enableGraphicsLabel(true);
                    docSaveStatusPanel.setGraphicsSelected(true);
                }
                if (bl = DocumentSaver.syncGraphics(documentDraft, docSaveStatusPanel)) {
                    bl = DocumentSaver.savePublishGraphics(documentDraft.getGraphics(), docSaveStatusPanel);
                }
                if (bl) {
                    DocumentSaver.removeDraftGraphics(documentDraft.getGraphics(), docSaveStatusPanel);
                }
            } else {
                bl = true;
            }
            if (bl) {
                if (documentDraft.getFileAttachments() != null && documentDraft.getFileAttachments().size() > 0) {
                    if (docSaveStatusPanel != null) {
                        docSaveStatusPanel.enableFilesLabel(true);
                        docSaveStatusPanel.setFilesSelected(true);
                    }
                    bl = DocumentSaver.savePublishFiles(documentDraft, documentDraft.getFileAttachments(), docSaveStatusPanel);
                } else {
                    bl = true;
                }
            }
            if (bl) {
                int n = 0;
                if (docSaveStatusPanel != null) {
                    docSaveStatusPanel.enableDocumentsLabel(true);
                    docSaveStatusPanel.setDocumentsSelected(true);
                    docSaveStatusPanel.setText("Publishing Document Draft");
                }
                document.setLastTouchedBy(UserSystem.getUserId());
                n = document.writeToDatabase();
                switch (n) {
                    case 0: {
                        bl = true;
                        break;
                    }
                    default: {
                        LogSystem.log(1, "Cannot write document. SQLCode returned:" + n);
                        bl = false;
                        break;
                    }
                }
            }
            if (!bl) {
                if (docSaveStatusPanel != null) {
                    docSaveStatusPanel.setText("Opening old draft");
                }
                documentDraft.setStopDate(null);
                documentDraft.writeToDatabase();
            } else {
                if (docSaveStatusPanel != null) {
                    docSaveStatusPanel.setText("Cleaning Draft Servers for Graphics/Files that might be left");
                }
                DocumentSaver.cleanTempFTP(document);
            }
        } else {
            LogSystem.log(1, "Could not continue publish because save as draft failed");
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final boolean saveDraftGraphics(Vector vector, DocSaveStatusPanel docSaveStatusPanel) {
        boolean bl = false;
        int n = 0;
        int n2 = vector.size();
        Ftp ftp = new Ftp();
        String string = Constants.getStrConst("IT_IMAGEHOSTTEMP");
        String string2 = Constants.getStrConst("IT_IMAGELOCTEMP");
        String string3 = PropertySystem.getString(30);
        ftp.setHost(string);
        ftp.setUser("quest");
        ftp.setPassword("j0hnny");
        LogSystem.beginLogSection("Saving Graphics");
        LogSystem.log(1, "FTP Server:" + string);
        LogSystem.log(1, "User Id:" + "quest");
        LogSystem.log(1, "Directory:" + string2);
        try {
            DocumentGraphic documentGraphic = null;
            if (docSaveStatusPanel != null) {
                docSaveStatusPanel.setText("Connecting to Draft Graphics Server");
            }
            ftp.connect();
            ftp.login();
            ftp.cd(string2);
            ftp.setType('I');
            while (true) {
                if (n >= n2) {
                    ftp.disconnect();
                    bl = true;
                    break;
                }
                documentGraphic = (DocumentGraphic)vector.elementAt(n);
                if (documentGraphic.getRecStatus() == 3) {
                    if (docSaveStatusPanel != null) {
                        docSaveStatusPanel.setText("Deleting Graphic " + documentGraphic.getFilename());
                    }
                    LogSystem.log(1, "Deleting Graphic: " + documentGraphic.getFilename());
                    try {
                        ftp.delete(documentGraphic.getFilename());
                    }
                    catch (Exception exception) {
                    }
                } else {
                    if (docSaveStatusPanel != null) {
                        docSaveStatusPanel.setText("Saving Graphic " + documentGraphic.getFilename());
                    }
                    LogSystem.log(1, "FTPing Graphic: " + documentGraphic.getFilename());
                    ftp.put(string3 + File.separator + documentGraphic.getFilename());
                }
                ++n;
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            GUISystem.printBox("Info", "Cannot save graphics");
            bl = false;
        }
        LogSystem.endLogSection();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final boolean savePublishGraphics(Vector vector, DocSaveStatusPanel docSaveStatusPanel) {
        boolean bl = false;
        int n = 0;
        int n2 = vector.size();
        Ftp ftp = new Ftp();
        String string = Constants.getStrConst("IT_IMAGEHOST");
        String string2 = Constants.getStrConst("IT_IMAGELOC");
        String string3 = PropertySystem.getString(30);
        ftp.setHost(string);
        ftp.setUser("quest");
        ftp.setPassword("j0hnny");
        LogSystem.beginLogSection("Publishing Graphics");
        LogSystem.log(1, "FTP Server:" + string);
        LogSystem.log(1, "User Id:" + "quest");
        LogSystem.log(1, "Directory:" + string2);
        try {
            DocumentGraphic documentGraphic = null;
            if (docSaveStatusPanel != null) {
                docSaveStatusPanel.setText("Connecting to Graphics Server");
            }
            ftp.connect();
            ftp.login();
            ftp.cd(string2);
            ftp.setType('I');
            while (true) {
                if (n >= n2) {
                    ftp.disconnect();
                    bl = true;
                    break;
                }
                documentGraphic = (DocumentGraphic)vector.elementAt(n);
                if (!documentGraphic.valid()) {
                    if (docSaveStatusPanel != null) {
                        docSaveStatusPanel.setText("Deleting Graphic " + documentGraphic.getFilename());
                    }
                    LogSystem.log(1, "Deleting Graphic: " + documentGraphic.getFilename());
                    try {
                        ftp.delete(documentGraphic.getFilename());
                    }
                    catch (Exception exception) {
                    }
                } else {
                    if (docSaveStatusPanel != null) {
                        docSaveStatusPanel.setText("Saving Graphic " + documentGraphic.getFilename());
                    }
                    LogSystem.log(1, "FTPing Graphic: " + documentGraphic.getFilename());
                    ftp.put(string3 + File.separator + documentGraphic.getFilename());
                }
                ++n;
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            GUISystem.printBox("Info", "Cannot save graphics");
            bl = false;
        }
        LogSystem.log(1, "FTP Process returning " + bl);
        LogSystem.endLogSection();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final boolean removeDraftGraphics(Vector vector, DocSaveStatusPanel docSaveStatusPanel) {
        boolean bl = false;
        int n = 0;
        int n2 = vector.size();
        Ftp ftp = new Ftp();
        String string = Constants.getStrConst("IT_IMAGEHOSTTEMP");
        String string2 = Constants.getStrConst("IT_IMAGELOCTEMP");
        String string3 = PropertySystem.getString(30);
        ftp.setHost(string);
        ftp.setUser("quest");
        ftp.setPassword("j0hnny");
        LogSystem.beginLogSection("Publishing Graphics");
        LogSystem.log(1, "FTP Server:" + string);
        LogSystem.log(1, "User Id:" + "quest");
        LogSystem.log(1, "Directory:" + string2);
        try {
            DocumentGraphic documentGraphic = null;
            if (docSaveStatusPanel != null) {
                docSaveStatusPanel.setText("Connecting to Draft Graphics Server");
            }
            ftp.connect();
            ftp.login();
            ftp.cd(string2);
            ftp.setType('I');
            while (true) {
                if (n >= n2) {
                    ftp.disconnect();
                    bl = true;
                    break;
                }
                documentGraphic = (DocumentGraphic)vector.elementAt(n);
                if (docSaveStatusPanel != null) {
                    docSaveStatusPanel.setText("Deleting Draft Graphic " + documentGraphic.getFilename());
                }
                LogSystem.log(1, "Deleting Graphic: " + documentGraphic.getFilename());
                try {
                    ftp.delete(documentGraphic.getFilename());
                }
                catch (Exception exception) {
                }
                ++n;
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
        LogSystem.log(1, "FTP Process returning " + bl);
        LogSystem.endLogSection();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final boolean syncGraphics(DocumentDraft documentDraft, DocSaveStatusPanel docSaveStatusPanel) {
        DocumentGraphic documentGraphic;
        Object object;
        SQLMethod sQLMethod = new SQLMethod(1, "syncGraphics", 5);
        boolean bl = false;
        Vector<DocumentGraphic> vector = new Vector<DocumentGraphic>(1, 1);
        try {
            object = sQLMethod.createStatement();
            ResultSet resultSet = null;
            String string = null;
            string = "SELECT FILENAME " + "FROM TIGNEW.GRAPHICS  " + "WHERE DOCIND = " + documentDraft.getExistingDocInd() + " " + "FOR FETCH ONLY";
            resultSet = object.executeQuery(string);
            while (true) {
                if (!resultSet.next()) {
                    resultSet.close();
                    object.close();
                    bl = true;
                    break;
                }
                documentGraphic = new DocumentGraphic(documentDraft.getDocInd(), resultSet.getString(1).trim());
                vector.addElement(documentGraphic);
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
        if (bl) {
            object = documentDraft.getGraphics();
            int n = 0;
            int n2 = vector.size();
            documentGraphic = null;
            while (n < n2) {
                documentGraphic = (DocumentGraphic)vector.elementAt(n);
                if (!((Vector)object).contains(documentGraphic)) {
                    documentGraphic.updateRecStatus(0);
                    documentGraphic.updateRecStatus(3);
                    ((Vector)object).addElement(documentGraphic);
                }
                ++n;
            }
            documentDraft.setGraphics((Vector)object);
        }
        sQLMethod.close();
        LogSystem.log(1, "Graphics Sync Returning " + bl);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final boolean syncFiles(DocumentDraft documentDraft, DocSaveStatusPanel docSaveStatusPanel) {
        DocumentFile documentFile;
        Object object;
        SQLMethod sQLMethod = new SQLMethod(1, "syncFiles", 5);
        boolean bl = false;
        Vector<DocumentFile> vector = new Vector<DocumentFile>(1, 1);
        try {
            object = sQLMethod.createStatement();
            ResultSet resultSet = null;
            String string = null;
            string = "SELECT FILENAME " + "FROM TIGRIS.DOCFILES  " + "WHERE DOCIND = " + documentDraft.getExistingDocInd() + " " + "FOR FETCH ONLY";
            resultSet = object.executeQuery(string);
            while (true) {
                if (!resultSet.next()) {
                    resultSet.close();
                    object.close();
                    bl = true;
                    break;
                }
                documentFile = new DocumentFile(documentDraft.getDocInd(), resultSet.getString(1).trim());
                vector.addElement(documentFile);
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
        if (bl) {
            object = documentDraft.getFileAttachments();
            int n = 0;
            int n2 = vector.size();
            documentFile = null;
            while (n < n2) {
                documentFile = (DocumentFile)vector.elementAt(n);
                if (!((Vector)object).contains(documentFile)) {
                    documentFile.updateRecStatus(0);
                    documentFile.updateRecStatus(3);
                    ((Vector)object).addElement(documentFile);
                }
                ++n;
            }
            documentDraft.setFileAttachments((Vector)object);
        }
        sQLMethod.close();
        LogSystem.log(1, "File Sync returning " + bl);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final boolean saveDraftFiles(Vector vector, DocSaveStatusPanel docSaveStatusPanel) {
        boolean bl = false;
        int n = 0;
        int n2 = vector.size();
        Ftp ftp = new Ftp();
        String string = Constants.getStrConst("IT_FILEHOSTTEMP");
        String string2 = Constants.getStrConst("IT_FILELOCTEMP");
        String string3 = PropertySystem.getString(30);
        ftp.setHost(string);
        ftp.setUser("quest");
        ftp.setPassword("j0hnny");
        LogSystem.beginLogSection("Saving Files");
        LogSystem.log(1, "FTP Server:" + string);
        LogSystem.log(1, "User Id:" + "quest");
        LogSystem.log(1, "Directory:" + string2);
        try {
            DocumentFile documentFile = null;
            if (docSaveStatusPanel != null) {
                docSaveStatusPanel.setText("Connecting to Draft File Server");
            }
            ftp.connect();
            ftp.login();
            ftp.cd(string2);
            while (true) {
                if (n >= n2) {
                    ftp.disconnect();
                    bl = true;
                    break;
                }
                documentFile = (DocumentFile)vector.elementAt(n);
                if (documentFile.getLocalFilename() != null) {
                    if (documentFile.getRecStatus() == 3) {
                        if (docSaveStatusPanel != null) {
                            docSaveStatusPanel.setText("Deleting File " + documentFile.getLocalFilename());
                        }
                        LogSystem.log(1, "Deleting File: " + documentFile.getLocalFilename());
                        try {
                            ftp.delete(documentFile.getLocalFilename());
                        }
                        catch (Exception exception) {
                        }
                    } else {
                        if (docSaveStatusPanel != null) {
                            docSaveStatusPanel.setText("Saving File " + documentFile.getLocalFilename());
                        }
                        LogSystem.log(1, "FTPing File: " + documentFile.getLocalFilename());
                        ftp.setType(documentFile.getFTPMode() == 0 ? (char)'I' : 'A');
                        ftp.put(documentFile.getLocalFilename());
                    }
                }
                ++n;
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            GUISystem.printBox("Info", "Cannot save files");
            bl = false;
        }
        LogSystem.log(1, "FTP Process returning " + bl);
        LogSystem.endLogSection();
        return bl;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final boolean savePublishFiles(DocumentDraft var0, Vector var1_1, DocSaveStatusPanel var2_2) {
        block27: {
            block25: {
                var3_3 = null;
                var4_4 = new Vector<DocumentFile>(1);
                var5_5 = 0;
                var6_6 = var1_1.size();
                var7_7 = false;
                var8_8 = Constants.getStrConst("IT_FILELOCTEMP");
                var9_9 = null;
                var10_10 = PropertySystem.getString(30);
                var11_11 = Constants.getStrConst("IT_FILELOC");
                LogSystem.beginLogSection("Publishing Files");
                if (var2_2 != null) {
                    var2_2.setText("Connecting to Draft File Server");
                }
                var3_3 = QuestUtil.connectToTempFileFTP();
                try {
                    block26: {
                        if (var2_2 != null) {
                            var2_2.setText("Downloading changed files");
                        }
                        if (var3_3 != null) {
                            var3_3.cd(var8_8);
                            while (true) {
                                if (var5_5 >= var6_6) {
                                    var3_3.disconnect();
                                    break;
                                }
                                var9_9 = (DocumentFile)var1_1.elementAt(var5_5);
                                if (var9_9.valid()) {
                                    if (var9_9.getLocalFilename() != null) {
                                        var4_4.addElement(var9_9);
                                    } else {
                                        try {
                                            if (var2_2 != null) {
                                                var2_2.setText("Downloading " + var9_9.getFilename() + "(" + var9_9.getSize() + " bytes) from Draft File Server");
                                            }
                                            var3_3.setType(var9_9.getFTPMode() == 0 ? 'I' : 'A');
                                            var3_3.get(var9_9.getFilename(), var10_10 + File.separator + var9_9.getFilename());
                                            var4_4.addElement(var9_9);
                                        }
                                        catch (Exception var12_12) {
                                        }
                                    }
                                }
                                ++var5_5;
                            }
                        }
                        if (!DocumentSaver.syncFiles(var0, var2_2)) break block26;
                        var1_1 = var0.getFileAttachments();
                        if (var1_1 == null || var1_1.size() <= 0) break block25;
                        var12_13 = var1_1.size();
                        var5_5 = 0;
                        if (true) ** GOTO lbl62
                    }
                    var7_7 = false;
                }
                catch (Exception var12_15) {
                    LogSystem.log(1, var12_15, false);
                    GUISystem.printBox("Error", "Could not FTP file attachments. The Document will not be published");
                    var7_7 = false;
                }
                break block27;
                do {
                    if (!var4_4.contains(var1_1.elementAt(var5_5))) {
                        var4_4.addElement((DocumentFile)var1_1.elementAt(var5_5));
                    } else {
                        ((DocumentFile)var4_4.elementAt(var5_5)).updateRecStatus(0);
                        ((DocumentFile)var4_4.elementAt(var5_5)).updateRecStatus(((DocumentFile)var1_1.elementAt(var5_5)).getRecStatus());
                    }
                    ++var5_5;
lbl62:
                    // 2 sources

                } while (var5_5 < var12_13);
            }
            var5_5 = 0;
            var6_6 = var4_4.size();
            if (var2_2 != null) {
                var2_2.setText("Connecting to Publish File Server");
            }
            var3_3 = QuestUtil.connectToProductionFileFTP();
            try {
                var3_3.cd(var11_11);
                while (true) {
                    if (var5_5 >= var6_6) {
                        var3_3.disconnect();
                        var7_7 = true;
                    }
                    var9_9 = (DocumentFile)var4_4.elementAt(var5_5);
                    if (var9_9.getLocalFilename() != null && var9_9.valid()) {
                        if (DocumentSaver.createFileHeader(var9_9)) {
                            var3_3.setType('I');
                            if (var2_2 != null) {
                                var2_2.setText("Attaching file " + var9_9.getLocalFilename());
                            }
                            var3_3.put(var10_10 + File.separator + var9_9.getFilename() + ".hdr");
                            var3_3.setType(var9_9.getFTPMode() == 0 ? 'I' : 'A');
                            var3_3.put(var9_9.getLocalFilename());
                        }
                    } else {
                        return false;
                    }
                    ++var5_5;
                }
            }
            catch (Exception var12_14) {
                LogSystem.log(1, var12_14, false);
                GUISystem.printBox("Error", "Cannot publish file attachments. This document will not be published");
                var7_7 = false;
            }
        }
        LogSystem.log(1, "FTP Process returning " + var7_7);
        LogSystem.endLogSection();
        return var7_7;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final boolean createFileHeader(DocumentFile documentFile) {
        String string = PropertySystem.getString(30);
        File file = new File(string + File.separator + documentFile.getFilename() + ".hdr");
        boolean bl = false;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(new String("Filename: " + documentFile.getFilename() + "\n").getBytes());
            fileOutputStream.write(new String("filesize: " + documentFile.getSize() + "\n").getBytes());
            fileOutputStream.write(new String("filearea: " + documentFile.getLocation() + "\n").getBytes());
            fileOutputStream.write(new String("filetype: " + (documentFile.getFTPMode() == 0 ? "binary" : "ascii") + "\n").getBytes());
            if (documentFile.valid()) {
                fileOutputStream.write(new String("actiontype: insert\n").getBytes());
            } else {
                fileOutputStream.write(new String("actiontype: delete\n").getBytes());
            }
            fileOutputStream.flush();
            fileOutputStream.close();
            return true;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            GUISystem.printBox("Error", "The header for file " + documentFile.getFilename() + " could not be created. Please make sure that you have enough Disk Space left for your temp directory");
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void cleanTempFTP(Document document) {
        int n;
        int n2;
        String string;
        Ftp ftp;
        Vector vector = document.getGraphics();
        Vector vector2 = document.getFileAttachments();
        LogSystem.beginLogSection("Cleaning temp FTP directory");
        if (vector != null && vector.size() > 0) {
            try {
                ftp = QuestUtil.connectToTempGraphicFTP();
                string = Constants.getStrConst("IT_IMAGELOCTEMP");
                if (ftp != null) {
                    n2 = 0;
                    n = vector.size();
                    ftp.cd(string);
                    while (n2 < n) {
                        try {
                            ftp.delete(((DocumentGraphic)vector.elementAt(n2)).getFilename());
                        }
                        catch (Exception exception) {
                        }
                        ++n2;
                    }
                }
                ftp.disconnect();
            }
            catch (Exception exception) {
                LogSystem.log(1, "Could not clean temp graphics");
            }
        }
        if (vector2 != null && vector2.size() > 0) {
            try {
                ftp = QuestUtil.connectToTempFileFTP();
                string = Constants.getStrConst("IT_FILELOCTEMP");
                if (ftp != null) {
                    n2 = 0;
                    n = vector2.size();
                    ftp.cd(string);
                    while (n2 < n) {
                        try {
                            ftp.delete(((DocumentFile)vector2.elementAt(n2)).getFilename());
                        }
                        catch (Exception exception) {
                        }
                        ++n2;
                    }
                }
                ftp.disconnect();
            }
            catch (Exception exception) {
                LogSystem.log(1, "Could not clean temp files");
            }
        }
        LogSystem.endLogSection();
    }

    public static boolean publishDraftNow(DocumentDraft documentDraft, DocSaveStatusPanel docSaveStatusPanel) {
        boolean bl = false;
        if (DocumentSaver.publishDraft(documentDraft, docSaveStatusPanel)) {
            String string = "DELETE FROM TIGRIS.PUBLISHNOW WHERE DOCIND = " + documentDraft.getExistingDocInd() + SqlRunner.END_DELIM + "INSERT INTO TIGRIS.PUBLISHNOW VALUES ( " + documentDraft.getExistingDocInd() + " )" + SqlRunner.END_DELIM;
            int n = SqlRunner.sqlRunnerCode(1, string);
            if (n != 0) {
                LogSystem.log(1, "Could not execute Publish now. rc:" + n);
                GUISystem.printBox(6, 202);
            } else {
                bl = true;
            }
        }
        return bl;
    }
}

