/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.doc.docedit;

import com.ibm.nzna.projects.common.quest.doc.Document;
import com.ibm.nzna.projects.common.quest.doc.DocumentPropertyListener;
import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.projects.common.quest.type.TypePubRec;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.DataLengths;
import com.ibm.nzna.projects.qit.app.DateSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.doc.DocConst;
import com.ibm.nzna.projects.qit.gui.DateEntryField;
import com.ibm.nzna.shared.gui.DPanel;
import com.ibm.nzna.shared.gui.MaskDocument;
import com.ibm.nzna.shared.gui.NoTabJTextArea;
import com.ibm.nzna.shared.gui.ValueLabel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class DownloadableInfoPanel
extends DPanel
implements DocumentPropertyListener,
ActionListener,
FocusListener,
DocConst,
DataLengths,
AppConst {
    private boolean processChanges = true;
    private JLabel st_DESCRIPTION = new JLabel("*" + Str.getStr(100));
    private NoTabJTextArea mle_DESCRIPTION = new NoTabJTextArea();
    private JScrollPane scr_DESCRIPTION = new JScrollPane(this.mle_DESCRIPTION);
    private JComboBox cb_PUB_TYPE = new JComboBox(TypeList.getInstance().getTypeList(13));
    private ValueLabel vl_PUB_TYPE = new ValueLabel(Str.getStr(312), this.cb_PUB_TYPE);
    private JTextField ef_PARTNUM = new JTextField(new MaskDocument(0, 50), "", 0);
    private ValueLabel partNumber = new ValueLabel("*" + Str.getStr(293), this.ef_PARTNUM);
    private JTextField ef_VERSION = new JTextField(new MaskDocument(0, 25), "", 0);
    private ValueLabel version = new ValueLabel("*" + Str.getStr(294), this.ef_VERSION);
    private JTextField ef_URL = new JTextField(new MaskDocument(0, 1024), "", 0);
    private ValueLabel url = new ValueLabel("*" + Str.getStr(309), this.ef_URL);
    private DateEntryField ef_RELEASE_DATE = new DateEntryField();
    private ValueLabel releaseDate = new ValueLabel("*" + Str.getStr(310), this.ef_RELEASE_DATE);
    private Document document = null;

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = 0;
        int n2 = 0;
        int n3 = GUISystem.getRowHeight();
        super.doLayout();
        this.st_DESCRIPTION.setBounds(n, n2, dimension.width, n3);
        this.scr_DESCRIPTION.setBounds(n, n2 += n3, dimension.width, n3 * 4);
        this.partNumber.setBounds(n, n2 += n3 * 4, 250, n3);
        this.version.setBounds(n, n2 += n3, 200, n3);
        this.url.setBounds(n, n2 += n3, dimension.width, n3);
        this.releaseDate.setBounds(n, n2 += n3, 250, n3);
        this.vl_PUB_TYPE.setBounds(n, n2 += n3, 350, n3);
    }

    public void setDocument(Document document) {
        if (this.document != null) {
            this.document.removeDocumentPropertyListener(this);
        }
        document.addDocumentPropertyListener(this);
        this.document = document;
        this.mle_DESCRIPTION.setText(document.getDescription());
        this.ef_URL.setText(document.getURL());
        this.ef_RELEASE_DATE.setText(DateSystem.dateFromDBDate(document.getReleaseDate()));
        this.ef_PARTNUM.setText(document.getPartNumber());
        this.ef_VERSION.setText(document.getVersion());
        this.cb_PUB_TYPE.setSelectedItem(TypeList.getInstance().objectFromInd(document.getPublicationType(), 13));
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.ef_URL) {
            this.document.setURL(this.ef_URL.getText());
        } else if (focusEvent.getSource() == this.ef_VERSION) {
            this.document.setVersion(this.ef_VERSION.getText());
        } else if (focusEvent.getSource() == this.ef_RELEASE_DATE) {
            String string = this.ef_RELEASE_DATE.getText();
            this.processChanges = false;
            if (string != null) {
                this.document.setReleaseDate(string);
            } else {
                GUISystem.printBox(7, 414);
            }
            this.processChanges = true;
        } else if (focusEvent.getSource() == this.mle_DESCRIPTION) {
            this.document.setDescription(this.mle_DESCRIPTION.getText());
        } else if (focusEvent.getSource() == this.ef_PARTNUM) {
            this.document.setPartNumber(this.ef_PARTNUM.getText());
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.cb_PUB_TYPE) {
            this.document.setPublicationType(((TypePubRec)this.cb_PUB_TYPE.getSelectedItem()).getInd());
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.cb_PUB_TYPE.setEnabled(bl);
        this.ef_URL.setEnabled(bl);
        this.ef_RELEASE_DATE.setEnabled(bl);
        this.ef_VERSION.setEnabled(bl);
        this.mle_DESCRIPTION.setEnabled(bl);
        this.ef_PARTNUM.setEnabled(bl);
    }

    public void documentChanged(Document document, int n) {
        if (this.processChanges && (n == 20 || n == 47 || n == 6 || n == 46 || n == 39 || n == 43)) {
            this.setDocument(document);
        }
    }

    public JTextArea getJTextArea() {
        return this.mle_DESCRIPTION;
    }

    public JTextField getVersionJTextField() {
        return this.ef_VERSION;
    }

    public DownloadableInfoPanel() {
        this.setPreferredSize(new Dimension(500, 220));
        this.setBackground(Color.white);
        this.mle_DESCRIPTION.setFont(this.st_DESCRIPTION.getFont());
        this.version.setDescriptionWidth(150);
        this.partNumber.setDescriptionWidth(150);
        this.releaseDate.setDescriptionWidth(150);
        this.vl_PUB_TYPE.setDescriptionWidth(150);
        this.url.setDescriptionWidth(150);
        this.mle_DESCRIPTION.addFocusListener(this);
        this.ef_PARTNUM.addFocusListener(this);
        this.ef_URL.addFocusListener(this);
        this.ef_VERSION.addFocusListener(this);
        this.ef_RELEASE_DATE.addFocusListener(this);
        this.cb_PUB_TYPE.addActionListener(this);
        this.setLayout(null);
        this.add(this.st_DESCRIPTION);
        this.add(this.scr_DESCRIPTION);
        this.add(this.partNumber);
        this.add(this.version);
        this.add(this.url);
        this.add(this.releaseDate);
        this.add(this.vl_PUB_TYPE);
    }
}

