/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.doc.docedit;

import com.ibm.nzna.projects.common.quest.doc.Document;
import com.ibm.nzna.projects.common.quest.doc.DocumentDraft;
import com.ibm.nzna.projects.common.quest.doc.DocumentPropertyListener;
import com.ibm.nzna.projects.common.quest.doc.DocumentStatus;
import com.ibm.nzna.projects.common.quest.status.Status;
import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.projects.common.quest.type.TypeMetricRec;
import com.ibm.nzna.projects.common.quest.type.TypeStatusRec;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserRec;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.gui.DateEntryField;
import com.ibm.nzna.projects.qit.gui.UserEntryPanel;
import com.ibm.nzna.projects.qit.gui.UserEntryPanelListener;
import com.ibm.nzna.shared.gui.ListPanel;
import com.ibm.nzna.shared.gui.ValueLabel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class DraftInfoPanel
extends ListPanel
implements DocumentPropertyListener,
ActionListener,
UserEntryPanelListener,
AppConst,
FocusListener {
    private JComboBox cb_SOURCECLASS = new JComboBox(TypeList.getInstance().getTypeList(11));
    private ValueLabel requestor = new ValueLabel(Str.getStr(285), new JLabel(""));
    private ValueLabel contentOwner = new ValueLabel("*" + Str.getStr(304), new UserEntryPanel());
    private ValueLabel source = new ValueLabel(Str.getStr(283), new JTextField(""));
    private ValueLabel sourceClassification = new ValueLabel("*" + Str.getStr(504), this.cb_SOURCECLASS);
    private JComboBox cb_STATUS = new JComboBox(Status.getStatusList(1));
    private ValueLabel vl_STATUS = new ValueLabel("*" + Str.getStr(319), this.cb_STATUS);
    private DateEntryField ef_STATUS_DATE = new DateEntryField();
    private ValueLabel vl_STATUS_DATE = new ValueLabel("*" + Str.getStr(708), this.ef_STATUS_DATE);
    private Document document = null;

    public void setDocument(Document document) {
        if (this.document != null) {
            this.document.removeDocumentPropertyListener(this);
        }
        document.addDocumentPropertyListener(this);
        this.document = document;
        if (document instanceof DocumentDraft) {
            this.requestor.setValue(UserSystem.getNameFromUserId(((DocumentDraft)document).getRequestor()));
            this.contentOwner.getComponent().setEnabled(true);
            this.source.getComponent().setEnabled(true);
            this.sourceClassification.getComponent().setEnabled(true);
        } else {
            this.contentOwner.getComponent().setEnabled(false);
            this.source.getComponent().setEnabled(false);
            this.sourceClassification.getComponent().setEnabled(false);
        }
        ((UserEntryPanel)this.contentOwner.getComponent()).setText(document.getOwner());
        this.source.setValue(document.getSource());
        ((JComboBox)this.sourceClassification.getComponent()).setSelectedItem(TypeList.getInstance().objectFromInd(document.getMetric(), 11));
        if (document.getStatus() != null) {
            DocumentStatus documentStatus = document.getStatus();
            this.cb_STATUS.removeActionListener(this);
            this.cb_STATUS.setSelectedItem((TypeStatusRec)TypeList.getInstance().objectFromInd(documentStatus.getStatus(), 15));
            this.cb_STATUS.addActionListener(this);
            this.ef_STATUS_DATE.setText(documentStatus.getStatusDate());
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.source.getComponent()) {
            ((DocumentDraft)this.document).setSource((String)this.source.getValue());
        }
        if (focusEvent.getSource() == this.ef_STATUS_DATE) {
            this.saveStatus();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.cb_SOURCECLASS) {
            if (this.document instanceof DocumentDraft) {
                ((DocumentDraft)this.document).setMetric(((TypeMetricRec)this.cb_SOURCECLASS.getSelectedItem()).getInd());
            }
        } else if (actionEvent.getSource() == this.cb_STATUS) {
            this.saveStatus();
        }
    }

    public void userSelected(UserRec userRec) {
        ((DocumentDraft)this.document).setOwner(((UserEntryPanel)this.contentOwner.getComponent()).getUserId());
    }

    public void saveStatus() {
        ((DocumentDraft)this.document).setStatus(new DocumentStatus(this.document.getDocInd(), ((TypeStatusRec)this.cb_STATUS.getSelectedItem()).getInd(), this.ef_STATUS_DATE.getText()));
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.ef_STATUS_DATE.setEnabled(bl);
        this.cb_STATUS.setEnabled(bl);
        this.cb_SOURCECLASS.setEnabled(bl);
        this.contentOwner.getComponent().setEnabled(bl);
        this.source.getComponent().setEnabled(bl);
    }

    public void documentChanged(Document document, int n) {
        if (n == 45 || n == 44 || n == 36 || n == 38) {
            this.setDocument(document);
        }
    }

    public DraftInfoPanel() {
        ((UserEntryPanel)this.contentOwner.getComponent()).addUserEntryPanelListener(this);
        this.source.getComponent().addFocusListener(this);
        this.cb_SOURCECLASS.addActionListener(this);
        this.ef_STATUS_DATE.addFocusListener(this);
        this.add(this.requestor);
        this.add(this.contentOwner);
        this.add(this.source);
        this.add(this.sourceClassification);
        this.add(this.vl_STATUS);
        this.add(this.vl_STATUS_DATE);
        this.requestor.setDescriptionWidth(150);
        this.contentOwner.setDescriptionWidth(150);
        this.source.setDescriptionWidth(150);
        this.sourceClassification.setDescriptionWidth(150);
        this.vl_STATUS.setDescriptionWidth(150);
        this.vl_STATUS_DATE.setDescriptionWidth(150);
        this.setPadding(5);
    }
}

