/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.doc.docedit;

import com.ibm.nzna.projects.common.quest.Constants;
import com.ibm.nzna.projects.common.quest.doc.CreateDocumentDraft;
import com.ibm.nzna.projects.common.quest.doc.Document;
import com.ibm.nzna.projects.common.quest.doc.DocumentDraft;
import com.ibm.nzna.projects.common.quest.doc.DocumentGraphic;
import com.ibm.nzna.projects.common.quest.doc.DocumentRow;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.app.WindowSystem;
import com.ibm.nzna.projects.qit.app.util.QuestUtil;
import com.ibm.nzna.projects.qit.doc.docedit.DocumentEditor;
import com.ibm.nzna.projects.qit.gui.QuestPanel;
import com.ibm.nzna.shared.ftp.FTP.Ftp;
import com.ibm.nzna.shared.util.CDate;
import com.ibm.nzna.shared.util.LogSystem;
import java.io.File;
import java.util.Vector;

public class EditDocument
implements AppConst {
    public static void editDocument(DocumentRow documentRow) {
        int n = 0;
        n = documentRow.readDocument(false);
        switch (n) {
            case 0: {
                if (documentRow.getDocument() instanceof DocumentDraft) {
                    EditDocument.editDocument((DocumentDraft)documentRow.getDocument());
                    break;
                }
                EditDocument.editDocument(documentRow.getDocument());
                break;
            }
            case 100: {
                GUISystem.printBox(7, 220);
                break;
            }
            default: {
                LogSystem.log(1, "Cannot Read Document For Editing. SQLCode returned from DocumentRow.readDocument: " + n);
                GUISystem.printBox(7, 202);
                break;
            }
        }
    }

    public static void editDocument(Document document) {
        DocumentDraft documentDraft = EditDocument.createDraft(document);
        if (documentDraft != null) {
            EditDocument.editDocument(documentDraft);
            EditDocument.readDocumentGraphics(document);
            System.out.println("After read. Rec Status:" + documentDraft.getRecStatus());
        }
    }

    public static DocumentDraft createDraft(Document document) {
        CreateDocumentDraft createDocumentDraft = DocumentDraft.createDraft(document);
        DocumentDraft documentDraft = null;
        switch (createDocumentDraft.getReturnCode()) {
            case 0: {
                GUISystem.printBox(7, 202);
                break;
            }
            case 1: {
                if (GUISystem.printBox(Str.getStr(8) + " - " + document.getFilename(), UserSystem.getNameFromUserId(createDocumentDraft.getDocumentDraft().getLastTouchedBy()) + " " + Str.getStr(1488))) {
                    documentDraft = createDocumentDraft.getDocumentDraft();
                    documentDraft.updateRecStatus(0);
                    documentDraft.updateRecStatus(1);
                    break;
                }
                documentDraft = null;
                break;
            }
            case 2: {
                if (!GUISystem.printBox(Str.getStr(8), UserSystem.getNameFromUserId(document.getLastTouchedBy()) + " " + Str.getStr(1660) + createDocumentDraft.getDocumentDraft().getComments())) break;
                documentDraft = createDocumentDraft.getDocumentDraft();
                break;
            }
            case 4: {
                documentDraft = createDocumentDraft.getDocumentDraft();
                break;
            }
        }
        return documentDraft;
    }

    public static void editDocument(DocumentDraft documentDraft) {
        QuestPanel questPanel = null;
        if (documentDraft.getTitle() == null) {
            documentDraft.readFromDatabase();
        }
        if (documentDraft.getRecStatus() != 2) {
            EditDocument.readDocumentGraphics(documentDraft);
        }
        EditDocument.setDefaultValues(documentDraft);
        questPanel = WindowSystem.findQuestPanel(documentDraft);
        if (questPanel != null) {
            WindowSystem.showPanel(questPanel);
        } else {
            WindowSystem.createPanel(new DocumentEditor(documentDraft));
        }
    }

    public static void setDefaultValues(DocumentDraft documentDraft) {
        if (documentDraft.getCreateDate() == null) {
            documentDraft.setCreateDate(new CDate(1).today());
        }
        if (documentDraft.getRequestor() == null) {
            documentDraft.setRequestor(UserSystem.getUserId());
        }
        if (documentDraft.getCreatedBy() == null) {
            documentDraft.setCreatedBy(UserSystem.getUserId());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void readDocumentGraphics(DocumentDraft documentDraft) {
        Vector vector = documentDraft.getGraphics();
        if (vector == null) return;
        if (vector.size() <= 0) return;
        int n = 0;
        int n2 = vector.size();
        Ftp ftp = QuestUtil.connectToTempGraphicFTP();
        String string = Constants.getStrConst("IT_IMAGELOCTEMP");
        String string2 = PropertySystem.getString(30);
        try {
            if (ftp == null) return;
            DocumentGraphic documentGraphic = null;
            ftp.cd(string);
            while (true) {
                if (n >= n2) {
                    return;
                }
                documentGraphic = (DocumentGraphic)vector.elementAt(n);
                LogSystem.log(1, "Downloading graphic " + documentGraphic.getFilename());
                ftp.get(documentGraphic.getFilename(), string2 + File.separator + documentGraphic.getFilename());
                ++n;
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            GUISystem.printBox("Info", "Cannot read document graphics");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void readDocumentGraphics(Document document) {
        Vector vector = document.getGraphics();
        if (vector == null) return;
        if (vector.size() <= 0) return;
        int n = 0;
        int n2 = vector.size();
        Ftp ftp = QuestUtil.connectToProductionGraphicFTP();
        String string = Constants.getStrConst("IT_IMAGELOC");
        String string2 = PropertySystem.getString(30);
        try {
            if (ftp == null) return;
            DocumentGraphic documentGraphic = null;
            ftp.cd(string);
            while (true) {
                if (n >= n2) {
                    return;
                }
                documentGraphic = (DocumentGraphic)vector.elementAt(n);
                LogSystem.log(1, "Downloading graphic " + documentGraphic.getFilename());
                ftp.get(documentGraphic.getFilename(), string2 + File.separator + documentGraphic.getFilename());
                ++n;
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
            GUISystem.printBox("Info", "Cannot read document graphics");
        }
    }
}

