/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.doc.docedit;

import com.ibm.nzna.projects.common.quest.doc.Document;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.DataLengths;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.doc.DocConst;
import com.ibm.nzna.projects.qit.gui.DateEntryField;
import com.ibm.nzna.shared.gui.DPanel;
import com.ibm.nzna.shared.gui.JTextAreaCounter;
import com.ibm.nzna.shared.gui.MaskDocument;
import com.ibm.nzna.shared.gui.NoTabJTextArea;
import com.ibm.nzna.shared.gui.ValueLabel;
import com.ibm.nzna.shared.util.CDate;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ProMailPanel
extends DPanel
implements Runnable,
ActionListener,
DataLengths,
AppConst,
DocConst,
FocusListener {
    private static final String THREAD_CHECK_DATE = "checkDate";
    private DateEntryField ef_DATE = new DateEntryField();
    private ValueLabel vl_DATE = new ValueLabel(Str.getStr(11042), this.ef_DATE);
    private boolean processActions = true;
    private JCheckBox ck_EMAILABLE = new JCheckBox("");
    private ValueLabel vl_EMAILABLE = new ValueLabel(Str.getStr(11043), this.ck_EMAILABLE);
    private JLabel st_BODY = new JLabel(Str.getStr(11044));
    private NoTabJTextArea mle_BODY = new NoTabJTextArea(new MaskDocument(0, 999));
    private JScrollPane scr_BODY = new JScrollPane(this.mle_BODY);
    private Document document = null;
    private JTextAreaCounter mle_BODY_COUNTER = new JTextAreaCounter(this.mle_BODY);

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = 0;
        int n2 = 0;
        int n3 = GUISystem.getRowHeight();
        this.vl_EMAILABLE.setBounds(n, n2, dimension.width - n * 2, n3);
        this.vl_DATE.setBounds(n, n2 += n3, dimension.width - n * 2, n3);
        this.st_BODY.setBounds(n, n2 += n3, dimension.width - n * 2, n3);
        this.scr_BODY.setBounds(n, n2 += n3, dimension.width - n * 2, dimension.height - n2 - 15);
        this.mle_BODY_COUNTER.setBounds(n, dimension.height - 15, dimension.width - n * 2, 15);
    }

    public void setDocument(Document document) {
        this.document = document;
        this.processActions = false;
        if (document.getEMailable()) {
            this.ef_DATE.setText(document.getEMailableDate());
            this.mle_BODY.setText(document.getEMailComments());
            this.ef_DATE.setEnabled(true);
            this.mle_BODY.setEnabled(true);
            this.ck_EMAILABLE.setSelected(true);
        } else {
            this.ef_DATE.setEnabled(false);
            this.mle_BODY.setEnabled(false);
            this.ck_EMAILABLE.setSelected(false);
            if (document.getEMailableDate() != null) {
                this.ef_DATE.setText(document.getEMailableDate());
            }
            if (document.getEMailComments() != null) {
                this.mle_BODY.setText(document.getEMailComments());
            }
        }
        this.processActions = true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.processActions && this.isEnabled() && actionEvent.getSource() == this.ck_EMAILABLE) {
            this.document.setEMailable(this.ck_EMAILABLE.isSelected());
            this.setDocument(this.document);
            if (this.ck_EMAILABLE.isSelected()) {
                this.ef_DATE.requestFocus();
                this.ef_DATE.selectAll();
            }
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.processActions && this.isEnabled()) {
            if (focusEvent.getSource() == this.ef_DATE) {
                new Thread((Runnable)this, THREAD_CHECK_DATE).start();
            } else if (focusEvent.getSource() == this.mle_BODY) {
                this.document.setEMailComments(this.mle_BODY.getText());
            }
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.ck_EMAILABLE.setEnabled(bl);
        if (this.document != null && !this.document.getEMailable()) {
            bl = false;
        }
        this.ck_EMAILABLE.removeActionListener(this);
        this.ck_EMAILABLE.addActionListener(this);
        this.mle_BODY.setEnabled(bl);
        this.ef_DATE.setEnabled(bl);
    }

    protected JTextArea getJTextArea() {
        return this.mle_BODY;
    }

    public void run() {
        String string = Thread.currentThread().getName();
        if (string.equals(THREAD_CHECK_DATE)) {
            this.checkDate();
        }
    }

    private final void checkDate() {
        String string = this.ef_DATE.getText();
        if (string != null) {
            if (CDate.isFutureDate(string, 2)) {
                this.document.setEMailableDate(string);
            } else {
                GUISystem.printBox(7, 11045);
                this.ef_DATE.setText("");
                this.ef_DATE.requestFocus();
                this.ef_DATE.selectAll();
            }
        } else {
            GUISystem.printBox(7, 414);
            this.ef_DATE.setText("");
            this.ef_DATE.requestFocus();
            this.ef_DATE.selectAll();
        }
    }

    public ProMailPanel() {
        this.setBackground(Color.white);
        this.setPreferredSize(new Dimension(470, 200));
        this.vl_EMAILABLE.setDescriptionWidth(200);
        this.vl_DATE.setDescriptionWidth(200);
        this.ef_DATE.setEnabled(false);
        this.mle_BODY.setEnabled(false);
        this.ef_DATE.addFocusListener(this);
        this.mle_BODY.addFocusListener(this);
        this.ck_EMAILABLE.addActionListener(this);
        this.setLayout(null);
        this.add(this.vl_EMAILABLE);
        this.add(this.vl_DATE);
        this.add(this.st_BODY);
        this.add(this.scr_BODY);
        this.add(this.mle_BODY_COUNTER);
    }
}

