/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.doc.docedit;

import com.ibm.nzna.projects.common.quest.doc.DocumentDraft;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.Authority;
import com.ibm.nzna.projects.qit.app.DataLengths;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.app.util.QuestUtil;
import com.ibm.nzna.projects.qit.doc.DocConst;
import com.ibm.nzna.projects.qit.doc.DocTemplateSystem;
import com.ibm.nzna.projects.qit.doc.docedit.DocSaveCheck;
import com.ibm.nzna.projects.qit.doc.docedit.DocSaveStatusPanel;
import com.ibm.nzna.projects.qit.doc.docedit.DocumentSaver;
import com.ibm.nzna.projects.qit.gui.AppDefaultWin;
import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.gui.MaskDocument;
import com.ibm.nzna.shared.gui.NoTabJTextArea;
import com.ibm.nzna.shared.util.CDate;
import com.ibm.nzna.shared.util.Text;
import com.ibm.nzna.shared.util.WinUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class SaveDocDlg
extends JDialog
implements DataLengths,
MouseListener,
DocConst,
ActionListener,
AppConst,
Authority {
    public static final int SAVE_CANCEL = 0;
    public static final int SAVE_SAVED = 1;
    public static final int SAVE_PUBLISHED = 2;
    public static final int SAVE_TEMPLATE = 3;
    public static final int SAVE_CANCEL_DRAFT = 4;
    public static final int SAVE_NEW_DOCUMENT = 5;
    private Color buttonHighlightBackground = null;
    private Color buttonDefaultBackground = null;
    private DocSaveStatusPanel statusPanel = null;
    private JPanel templatePanel = new JPanel();
    private JPanel mainPanel = new JPanel();
    private JCheckBox ck_TRANSLATION = new JCheckBox(Str.getStr(521));
    private DButton pb_PUBLISH = new DButton(Str.getStr(520));
    private DButton pb_PUBLISH_NOW = new DButton(Str.getStr(11089));
    private DButton pb_SAVE = new DButton(Str.getStr(518));
    private DButton pb_CANCEL_DRAFT = new DButton(Str.getStr(1483));
    private JLabel st_TEMPLATE_NAME = new JLabel(Str.getStr(11022));
    private JLabel st_COMMENTS = new JLabel(Str.getStr(290));
    private JTextField ef_TEMPLATE_NAME = new JTextField(new MaskDocument(0, 254), "", 0);
    private DButton pb_SAVE_AS_NEW = new DButton(Str.getStr(11021));
    private DButton pb_SAVE_AS_TEMPLATE = new DButton(Str.getStr(519));
    private DButton pb_CANCEL = new DButton(Str.getStr(2));
    private NoTabJTextArea mle_OLD_COMMENTS = new NoTabJTextArea();
    private NoTabJTextArea mle_COMMENTS = new NoTabJTextArea();
    private JPanel commentPanel = new JPanel();
    private JScrollPane commentScroll = new JScrollPane(this.commentPanel);
    private int returnCode = 0;
    private DButton pb_SAVE_TEMPLATE_NOW = new DButton(Str.getStr(1));
    private DocumentDraft document = null;
    private JLabel st_IMAGE = null;
    private ImageIcon wizardImage = null;
    private String comments = null;

    private final void initialize() {
        this.wizardImage = ImageSystem.getImageIcon((Object)this, 177);
        this.st_IMAGE = new JLabel(this.wizardImage);
        this.mle_OLD_COMMENTS.setEditable(false);
        this.mle_OLD_COMMENTS.setBackground(new Color(230, 230, 230));
        this.mle_OLD_COMMENTS.setFont(this.pb_PUBLISH.getFont());
        this.mle_COMMENTS.setFont(this.pb_PUBLISH.getFont());
        this.buttonDefaultBackground = this.pb_SAVE.getBackground();
        this.buttonHighlightBackground = this.buttonDefaultBackground.brighter();
        if (this.document.getWorkRequired() == 3) {
            this.pb_PUBLISH.setText("Publish (Delete Active Doc)");
            this.pb_PUBLISH_NOW.setText("Delete Now!");
        }
        this.pb_PUBLISH.setEnabled(UserSystem.hasAuthority(5));
        this.pb_PUBLISH_NOW.setEnabled(UserSystem.hasAuthority(5));
        if (this.document.getStatus().getStatus() == 6) {
            this.pb_PUBLISH.setEnabled(false);
            this.pb_PUBLISH_NOW.setEnabled(false);
            this.pb_SAVE_AS_NEW.setEnabled(false);
            this.pb_SAVE.setEnabled(false);
            this.pb_SAVE_AS_TEMPLATE.setEnabled(false);
        }
        this.pb_PUBLISH_NOW.addActionListener(this);
        this.pb_SAVE_TEMPLATE_NOW.addActionListener(this);
        this.pb_CANCEL.addActionListener(this);
        this.pb_PUBLISH.addActionListener(this);
        this.pb_CANCEL_DRAFT.addActionListener(this);
        this.pb_SAVE_AS_TEMPLATE.addActionListener(this);
        this.pb_SAVE_AS_NEW.addActionListener(this);
        this.pb_SAVE.addActionListener(this);
        this.pb_SAVE_AS_NEW.addMouseListener(this);
        this.pb_PUBLISH_NOW.addMouseListener(this);
        this.pb_PUBLISH.addMouseListener(this);
        this.pb_CANCEL_DRAFT.addMouseListener(this);
        this.pb_SAVE_AS_TEMPLATE.addMouseListener(this);
        this.pb_SAVE.addMouseListener(this);
        this.ck_TRANSLATION.addActionListener(this);
        this.mainPanel.setLayout(null);
        this.templatePanel.setLayout(null);
        this.commentPanel.setLayout(new BorderLayout());
        this.commentPanel.add((Component)this.mle_OLD_COMMENTS, "North");
        this.commentPanel.add(this.mle_COMMENTS);
        this.mainPanel.add(this.st_COMMENTS);
        this.mainPanel.add(this.commentScroll);
        this.mainPanel.add(this.ck_TRANSLATION);
        this.mainPanel.add(this.pb_SAVE);
        this.mainPanel.add(this.pb_SAVE_AS_TEMPLATE);
        this.mainPanel.add(this.pb_SAVE_AS_NEW);
        this.mainPanel.add(this.pb_CANCEL_DRAFT);
        this.mainPanel.add(this.pb_PUBLISH);
        this.mainPanel.add(this.pb_PUBLISH_NOW);
        this.templatePanel.add(this.st_TEMPLATE_NAME);
        this.templatePanel.add(this.ef_TEMPLATE_NAME);
        this.templatePanel.add(this.pb_SAVE_TEMPLATE_NOW);
        this.getContentPane().setLayout(null);
        this.getContentPane().add(this.mainPanel);
        this.getContentPane().add(this.templatePanel);
        this.getContentPane().add(this.pb_CANCEL);
        this.getContentPane().add(this.st_IMAGE);
        this.setResizable(false);
        this.templatePanel.setVisible(false);
        this.mle_OLD_COMMENTS.setText(this.document.getOriginalComments());
        this.mle_COMMENTS.setDocument(new MaskDocument(0, 1999 - this.document.getOriginalComments().length()));
        this.mle_COMMENTS.setText(this.comments);
        this.ef_TEMPLATE_NAME.setText(this.document.getTitle());
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = GUISystem.getRowHeight();
        int n2 = this.wizardImage.getImage().getWidth(this) + 15;
        int n3 = 5;
        super.doLayout();
        this.st_IMAGE.setBounds(5, (dimension.height - 40) / 2 - this.wizardImage.getImage().getHeight(this) / 2, this.wizardImage.getImage().getWidth(this), this.wizardImage.getImage().getHeight(this));
        this.mainPanel.setBounds(n2, 5, dimension.width - n2 - 5, dimension.height - 90);
        this.templatePanel.setBounds(n2, 5, dimension.width - n2 - 5, dimension.height - 90);
        if (this.statusPanel != null) {
            this.statusPanel.setBounds(n2, 5, dimension.width - n2 - 5, dimension.height - 90);
        }
        this.pb_CANCEL.setBounds(n2, dimension.height - 68, 80, 25);
        n2 = 0;
        n3 = 0;
        dimension = this.mainPanel.getSize();
        this.st_COMMENTS.setBounds(n2, n3, dimension.width, n);
        this.commentScroll.setBounds(n2, n3 += n, dimension.width - 15, n * 5);
        this.ck_TRANSLATION.setBounds(n2, n3 += n * 5, dimension.width - 15, n);
        this.pb_SAVE.setBounds(n2, n3 += n, 168, 25);
        this.pb_SAVE_AS_TEMPLATE.setBounds(n2 + 173, n3, 168, 25);
        this.pb_SAVE_AS_NEW.setBounds(n2, n3 += 28, 168, 25);
        this.pb_CANCEL_DRAFT.setBounds(n2 + 173, n3, 168, 25);
        this.pb_PUBLISH.setBounds(n2, n3 += 28, 168, 25);
        this.pb_PUBLISH_NOW.setBounds(n2 + 173, n3, 168, 25);
        n3 += 28;
        n2 = 5;
        n3 = 5;
        this.st_TEMPLATE_NAME.setBounds(n2, n3, dimension.width - 15, n);
        this.ef_TEMPLATE_NAME.setBounds(n2, n3 += n, dimension.width - 15, n);
        this.pb_SAVE_TEMPLATE_NOW.setBounds(n2, n3 += n + 5, 80, 25);
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.pb_CANCEL) {
            if (this.mainPanel.isVisible()) {
                this.dispose();
            } else {
                this.mainPanel.setVisible(true);
                this.templatePanel.setVisible(false);
                this.validate();
            }
        } else if (actionEvent.getSource() == this.pb_CANCEL_DRAFT) {
            this.document.updateRecStatus(3);
            this.createSavePanel();
            if (DocumentSaver.saveDraft(this.document, this.statusPanel)) {
                this.returnCode = 4;
                this.dispose();
            } else {
                this.destroySavePanel();
                this.document.updateRecStatus(0);
                this.document.updateRecStatus(1);
            }
        } else if (actionEvent.getSource() == this.pb_SAVE) {
            if (DocSaveCheck.checkDraft(this.document, this)) {
                this.saveComment();
                this.createSavePanel();
                if (DocumentSaver.saveDraft(this.document, this.statusPanel)) {
                    this.returnCode = 1;
                    this.dispose();
                } else {
                    this.destroySavePanel();
                }
            }
        } else if (actionEvent.getSource() == this.pb_PUBLISH) {
            if (DocSaveCheck.checkPublish(this.document, this)) {
                this.saveComment();
                this.createSavePanel();
                if (DocumentSaver.publishDraft(this.document, this.statusPanel)) {
                    this.returnCode = 2;
                    this.dispose();
                } else {
                    this.destroySavePanel();
                }
            }
        } else if (actionEvent.getSource() == this.pb_PUBLISH_NOW) {
            System.out.println("Publish now!");
            if (DocSaveCheck.checkPublish(this.document, this)) {
                this.saveComment();
                this.createSavePanel();
                if (DocumentSaver.publishDraftNow(this.document, this.statusPanel)) {
                    this.returnCode = 2;
                    this.dispose();
                } else {
                    this.destroySavePanel();
                }
            }
        } else if (actionEvent.getSource() == this.pb_SAVE_AS_TEMPLATE) {
            if (this.canSaveAsTemplate()) {
                this.mainPanel.setVisible(false);
                this.templatePanel.setVisible(true);
            } else {
                GUISystem.printBox((JDialog)this, "Info", "Templates cannot have graphics or file attachments. Please remove any graphic and file attachment and try again");
            }
            this.validate();
        } else if (actionEvent.getSource() == this.pb_SAVE_TEMPLATE_NOW) {
            String string = this.ef_TEMPLATE_NAME.getText();
            if (string != null && string.length() > 0) {
                boolean bl = true;
                if (bl) {
                    this.document.setTitle(string);
                    this.document.setTemplate(true);
                    this.saveComment();
                    this.createSavePanel();
                    if (DocumentSaver.saveDraft(this.document, this.statusPanel)) {
                        this.returnCode = 3;
                        DocTemplateSystem.addTemplate(this.document);
                        GUISystem.printBox((JDialog)this, "Info", "A new Document Template is now available");
                        this.dispose();
                    } else {
                        this.destroySavePanel();
                    }
                }
            } else {
                GUISystem.printBox((JDialog)this, "Info", "Please supply the name for this template");
            }
        } else if (actionEvent.getSource() == this.pb_SAVE_AS_NEW) {
            this.document.createNew();
            if (DocSaveCheck.checkDraft(this.document, this)) {
                this.saveComment();
                this.createSavePanel();
                if (DocumentSaver.saveDraft(this.document, this.statusPanel)) {
                    this.returnCode = 1;
                    this.dispose();
                } else {
                    this.destroySavePanel();
                }
            }
        } else if (actionEvent.getSource() == this.ck_TRANSLATION) {
            if (this.ck_TRANSLATION.isSelected()) {
                this.mle_COMMENTS.setText(this.mle_COMMENTS.getText() + "(BODY HAS BEEN CHANGED)");
            } else {
                String string = Text.replaceAllStrInStr(this.mle_COMMENTS.getText(), "(BODY HAS BEEN CHANGED)", "");
                this.mle_COMMENTS.setText(string);
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        ((DButton)mouseEvent.getSource()).setBackground(this.buttonHighlightBackground);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        ((DButton)mouseEvent.getSource()).setBackground(this.buttonDefaultBackground);
    }

    private final void createSavePanel() {
        this.statusPanel = new DocSaveStatusPanel(this.document);
        this.getContentPane().add(this.statusPanel);
        this.mainPanel.setVisible(false);
        this.templatePanel.setVisible(false);
        this.pb_CANCEL.setEnabled(false);
        this.validate();
    }

    private final void destroySavePanel() {
        this.getContentPane().remove(this.statusPanel);
        this.statusPanel = null;
        this.mainPanel.setVisible(true);
        this.pb_CANCEL.setEnabled(true);
        this.validate();
    }

    private final void saveComment() {
        String string = this.mle_COMMENTS.getText();
        if (string == null || string.length() == 0) {
            String string2 = new CDate(14).today();
            string = "On " + string2 + " " + UserSystem.getUserName() + " " + "saved this document but made no comment\n";
        }
        this.document.setComments(string);
    }

    private final boolean canSaveAsTemplate() {
        if (this.document.getGraphics() == null && this.document.getFileAttachments() == null) {
            return true;
        }
        boolean bl = true;
        if (this.document.getGraphics() != null && QuestUtil.getValidData(this.document.getGraphics()).size() > 0) {
            bl = false;
        } else if (this.document.getFileAttachments() != null && QuestUtil.getValidData(this.document.getFileAttachments()).size() > 0) {
            bl = false;
        }
        return bl;
    }

    public SaveDocDlg(AppDefaultWin appDefaultWin, DocumentDraft documentDraft, String string) {
        super(appDefaultWin, Str.getStr(515), true);
        this.document = documentDraft;
        this.comments = string;
        this.initialize();
        ((Component)this).setSize(495, 305);
        WinUtil.centerWindow(this);
        ((Component)this).setVisible(true);
    }
}

