/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.doc.docmaint;

import com.ibm.nzna.projects.common.quest.type.TypeBrandRec;
import com.ibm.nzna.projects.common.quest.type.TypeDocCatRec;
import com.ibm.nzna.projects.common.quest.type.TypeDocRec;
import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.FontSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.doc.docmaint.BrandCatTypeRec;
import com.ibm.nzna.projects.qit.gui.JTitle;
import com.ibm.nzna.projects.qit.type.QITTypeList;
import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.gui.MultiList;
import com.ibm.nzna.shared.util.WinUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JComboBox;
import javax.swing.JDialog;

public class BrandCatTypeDlg
extends JDialog
implements WindowListener,
ActionListener,
AppConst {
    private MultiList cnr_CATEGORY = null;
    private MultiList cnr_DOCTYPE = null;
    private JComboBox cb_BRANDS = null;
    private JTitle st_HELP = null;
    private DButton pb_OK = null;
    private DButton pb_CANCEL = null;
    private BrandCatTypeRec retRec = null;

    public BrandCatTypeRec getResult() {
        ((Component)this).setVisible(true);
        return this.retRec;
    }

    public void createControls() {
        Container container = this.getContentPane();
        this.cb_BRANDS = new JComboBox(QITTypeList.getInstance().getTypeList(2));
        this.cnr_DOCTYPE = new MultiList(GUISystem.getFontUtil());
        this.cnr_CATEGORY = new MultiList(GUISystem.getFontUtil());
        this.st_HELP = new JTitle(Str.getStr(372));
        this.pb_OK = new DButton(Str.getStr(1));
        this.pb_CANCEL = new DButton(Str.getStr(2));
        this.cnr_CATEGORY.addActionListener(this);
        this.cnr_DOCTYPE.addActionListener(this);
        this.pb_OK.addActionListener(this);
        this.pb_CANCEL.addActionListener(this);
        this.addWindowListener(this);
        this.cnr_CATEGORY.setColumnWidth(0, 200);
        this.cnr_DOCTYPE.setColumnWidth(0, 200);
        this.cnr_CATEGORY.setForeground(Color.black);
        this.cnr_DOCTYPE.setForeground(Color.black);
        this.cnr_CATEGORY.setRowHeight(18);
        this.cnr_DOCTYPE.setRowHeight(18);
        this.st_HELP.setBorder(GUISystem.loweredBorder);
        this.st_HELP.setFont(FontSystem.defaultFont);
        container.setLayout(null);
        container.add(this.st_HELP);
        container.add(this.cb_BRANDS);
        container.add(this.cnr_CATEGORY);
        container.add(this.cnr_DOCTYPE);
        container.add(this.pb_OK);
        container.add(this.pb_CANCEL);
    }

    public void refreshList() {
        TypeList.refreshList(this.cnr_CATEGORY, 10, null);
        TypeList.refreshList(this.cnr_DOCTYPE, 4, null);
    }

    public void doLayout() {
        int n = 5;
        int n2 = 5;
        Dimension dimension = this.getSize();
        int n3 = GUISystem.getRowHeight();
        super.doLayout();
        this.st_HELP.setBounds(n, n2, dimension.width - n * 2, n3);
        this.cb_BRANDS.setBounds(n, n2 += n3 * 2, dimension.width / 2 - 20, n3);
        this.cnr_DOCTYPE.setBounds(n + (dimension.width / 2 + 5), n2, dimension.width / 2 - 25, 150);
        this.cnr_CATEGORY.setBounds(n, n2 += n3 + 8, dimension.width / 2 - 20, 100);
        this.pb_OK.setBounds(n, n2 += 105, 70, 25);
        this.pb_CANCEL.setBounds(n + 75, n2, 70, 25);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.pb_OK || actionEvent.getSource() == this.cnr_CATEGORY || actionEvent.getSource() == this.cnr_DOCTYPE) {
            if (this.saveData()) {
                this.dispose();
            }
        } else if (this.pb_CANCEL == actionEvent.getSource()) {
            this.retRec = null;
            this.dispose();
        }
    }

    private boolean saveData() {
        TypeBrandRec typeBrandRec = (TypeBrandRec)this.cb_BRANDS.getSelectedItem();
        TypeDocCatRec typeDocCatRec = (TypeDocCatRec)this.cnr_CATEGORY.getSelectedItem();
        TypeDocRec typeDocRec = (TypeDocRec)this.cnr_DOCTYPE.getSelectedItem();
        if (typeBrandRec != null && typeDocRec != null && typeDocCatRec != null) {
            this.retRec = new BrandCatTypeRec(typeBrandRec, typeDocCatRec, typeDocRec);
        } else if (typeBrandRec == null) {
            GUISystem.printBox(Str.getStr(7), Str.getStr(373));
        } else if (typeDocRec == null) {
            GUISystem.printBox(Str.getStr(7), Str.getStr(373));
        } else if (typeDocCatRec == null) {
            GUISystem.printBox(Str.getStr(7), Str.getStr(373));
        }
        return this.retRec != null;
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
        this.selectDefaultBrand();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
        this.selectDefaultBrand();
    }

    private void selectDefaultBrand() {
        try {
            TypeBrandRec typeBrandRec = (TypeBrandRec)TypeList.getInstance().objectFromInd(PropertySystem.getInt(38), 2);
            if (typeBrandRec != null) {
                this.cb_BRANDS.setSelectedItem(typeBrandRec);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public BrandCatTypeDlg(Frame frame) {
        super(frame, Str.getStr(372), true);
        ((Component)this).setSize(400, 230);
        WinUtil.centerWindow(this);
        this.createControls();
        this.refreshList();
    }
}

