/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.doc.docmaint;

import com.ibm.nzna.projects.common.quest.status.Status;
import com.ibm.nzna.projects.common.quest.type.TypeBrandRec;
import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.projects.common.quest.type.TypeStatusRec;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.FontSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.doc.docmaint.BrandStatusRec;
import com.ibm.nzna.projects.qit.gui.JTitle;
import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.gui.MultiList;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.WinUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JDialog;

public class BrandStatusDlg
extends JDialog
implements WindowListener,
ActionListener,
AppConst {
    private MultiList cnr_BRANDS = null;
    private MultiList cnr_STATUSTYPE = null;
    private JTitle st_HELP = null;
    private DButton pb_OK = null;
    private DButton pb_CANCEL = null;
    private BrandStatusRec retRec = null;

    public BrandStatusRec getResult() {
        ((Component)this).setVisible(true);
        return this.retRec;
    }

    public void createControls() {
        Container container = this.getContentPane();
        this.cnr_BRANDS = new MultiList(GUISystem.getFontUtil());
        this.cnr_STATUSTYPE = new MultiList(GUISystem.getFontUtil());
        this.st_HELP = new JTitle(Str.getStr(377));
        this.pb_OK = new DButton(Str.getStr(1));
        this.pb_CANCEL = new DButton(Str.getStr(2));
        this.cnr_BRANDS.setColumnWidth(0, 200);
        this.cnr_STATUSTYPE.setColumnWidth(0, 200);
        this.cnr_BRANDS.setForeground(Color.black);
        this.cnr_STATUSTYPE.setForeground(Color.black);
        this.cnr_BRANDS.setRowHeight(18);
        this.cnr_STATUSTYPE.setRowHeight(18);
        this.st_HELP.setFont(FontSystem.defaultFont);
        this.st_HELP.setBorder(GUISystem.loweredBorder);
        container.setLayout(null);
        container.add(this.st_HELP);
        container.add(this.cnr_BRANDS);
        container.add(this.cnr_STATUSTYPE);
        container.add(this.pb_OK);
        container.add(this.pb_CANCEL);
        this.cnr_BRANDS.addActionListener(this);
        this.cnr_STATUSTYPE.addActionListener(this);
        this.pb_OK.addActionListener(this);
        this.pb_CANCEL.addActionListener(this);
    }

    public void refreshList() {
        TypeList.refreshList(this.cnr_BRANDS, 2, null);
        Status.refreshList(this.cnr_STATUSTYPE, 1);
    }

    public void doLayout() {
        int n = 5;
        int n2 = 5;
        Dimension dimension = this.getSize();
        int n3 = GUISystem.getRowHeight();
        super.doLayout();
        this.st_HELP.setBounds(n, n2, dimension.width - n * 2, n3);
        this.cnr_BRANDS.setBounds(n, n2 += n3 + 10, dimension.width / 2 - 20, 140);
        this.cnr_STATUSTYPE.setBounds(n + (dimension.width / 2 + 5), n2, dimension.width / 2 - 25, 140);
        this.pb_OK.setBounds(n, n2 += 145, 70, 25);
        this.pb_CANCEL.setBounds(n + 75, n2, 70, 25);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.pb_OK || actionEvent.getSource() == this.cnr_BRANDS || actionEvent.getSource() == this.cnr_STATUSTYPE) {
            if (this.saveData()) {
                this.dispose();
            }
        } else if (actionEvent.getSource() == this.pb_CANCEL) {
            this.retRec = null;
            this.dispose();
        }
    }

    private boolean saveData() {
        TypeBrandRec typeBrandRec = (TypeBrandRec)this.cnr_BRANDS.getSelectedItem();
        TypeStatusRec typeStatusRec = (TypeStatusRec)this.cnr_STATUSTYPE.getSelectedItem();
        if (typeBrandRec != null && typeStatusRec != null) {
            this.retRec = new BrandStatusRec(typeBrandRec, typeStatusRec);
        } else if (typeBrandRec == null) {
            GUISystem.printBox(Str.getStr(7), Str.getStr(378));
        } else if (typeStatusRec == null) {
            GUISystem.printBox(Str.getStr(7), Str.getStr(378));
        }
        return this.retRec != null;
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
        this.selectDefaultBrand();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
        this.selectDefaultBrand();
    }

    private void selectDefaultBrand() {
        try {
            TypeBrandRec typeBrandRec = (TypeBrandRec)TypeList.getInstance().objectFromInd(PropertySystem.getInt(38), 2);
            if (typeBrandRec != null) {
                this.cnr_BRANDS.setSelectedItem(typeBrandRec, true);
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
    }

    public BrandStatusDlg(Frame frame) {
        super(frame, Str.getStr(377), true);
        ((Component)this).setSize(400, 265);
        WinUtil.centerChildInParent(this, frame);
        this.createControls();
        this.refreshList();
        this.addWindowListener(this);
    }
}

