/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.doc.docmaint;

import com.ibm.nzna.projects.common.quest.type.TypeBrandRec;
import com.ibm.nzna.projects.common.quest.type.TypeDocRec;
import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.FontSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.doc.docmaint.BrandTypeRec;
import com.ibm.nzna.projects.qit.gui.JTitle;
import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.gui.MultiList;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.WinUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JDialog;

public class BrandTypeDlg
extends JDialog
implements WindowListener,
ActionListener,
AppConst {
    private MultiList cnr_BRANDS = null;
    private MultiList cnr_DOCTYPE = null;
    private JTitle st_HELP = null;
    private DButton pb_OK = null;
    private DButton pb_CANCEL = null;
    private BrandTypeRec retRec = null;

    public BrandTypeRec getResult() {
        ((Component)this).setVisible(true);
        return this.retRec;
    }

    public void createControls() {
        Container container = this.getContentPane();
        this.cnr_BRANDS = new MultiList(GUISystem.getFontUtil());
        this.cnr_DOCTYPE = new MultiList(GUISystem.getFontUtil());
        this.st_HELP = new JTitle(Str.getStr(383));
        this.pb_OK = new DButton(Str.getStr(1));
        this.pb_CANCEL = new DButton(Str.getStr(2));
        this.cnr_BRANDS.addActionListener(this);
        this.cnr_DOCTYPE.addActionListener(this);
        this.pb_OK.addActionListener(this);
        this.pb_CANCEL.addActionListener(this);
        this.cnr_DOCTYPE.setRowHeight(18);
        this.cnr_BRANDS.setRowHeight(18);
        this.cnr_BRANDS.setColumnWidth(0, 200);
        this.cnr_DOCTYPE.setColumnWidth(0, 200);
        this.cnr_BRANDS.setForeground(Color.black);
        this.cnr_DOCTYPE.setForeground(Color.black);
        this.st_HELP.setBorder(GUISystem.loweredBorder);
        this.st_HELP.setFont(FontSystem.defaultFont);
        container.setLayout(null);
        container.add(this.st_HELP);
        container.add(this.cnr_BRANDS);
        container.add(this.cnr_DOCTYPE);
        container.add(this.pb_OK);
        container.add(this.pb_CANCEL);
    }

    public void refreshList() {
        TypeList.refreshList(this.cnr_BRANDS, 2, null);
        TypeList.refreshList(this.cnr_DOCTYPE, 4, null);
    }

    public void doLayout() {
        int n = 5;
        int n2 = 5;
        int n3 = GUISystem.getRowHeight();
        Dimension dimension = this.getSize();
        super.doLayout();
        this.st_HELP.setBounds(n, n2, dimension.width - n * 2, n3);
        this.cnr_BRANDS.setBounds(n, n2 += n3 + 2, dimension.width / 2 - 20, 150);
        this.cnr_DOCTYPE.setBounds(n + (dimension.width / 2 + 5), n2, dimension.width / 2 - 25, 150);
        this.pb_OK.setBounds(n, n2 += 155, 70, 25);
        this.pb_CANCEL.setBounds(n + 75, n2, 70, 25);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.pb_OK) {
            if (this.saveData()) {
                this.dispose();
            }
        } else if (actionEvent.getSource() == this.pb_CANCEL) {
            this.retRec = null;
            this.dispose();
        }
    }

    private boolean saveData() {
        TypeBrandRec typeBrandRec = (TypeBrandRec)this.cnr_BRANDS.getSelectedItem();
        TypeDocRec typeDocRec = (TypeDocRec)this.cnr_DOCTYPE.getSelectedItem();
        if (typeBrandRec != null && typeDocRec != null) {
            this.retRec = new BrandTypeRec(typeBrandRec, typeDocRec);
        } else if (typeBrandRec == null) {
            GUISystem.printBox(Str.getStr(7), Str.getStr(384));
        } else if (typeDocRec == null) {
            GUISystem.printBox(Str.getStr(7), Str.getStr(384));
        }
        return this.retRec != null;
    }

    public void windowActivated(WindowEvent windowEvent) {
        try {
            TypeBrandRec typeBrandRec = (TypeBrandRec)TypeList.getInstance().objectFromInd(PropertySystem.getInt(38), 2);
            if (typeBrandRec != null) {
                this.cnr_BRANDS.setSelectedItem(typeBrandRec, true);
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public BrandTypeDlg(Frame frame) {
        super(frame, Str.getStr(383), true);
        this.addWindowListener(this);
        this.setResizable(false);
        ((Component)this).setSize(400, 265);
        WinUtil.centerChildInParent(this, frame);
        this.createControls();
        this.refreshList();
    }
}

