/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.doc.docview;

import com.ibm.nzna.projects.common.quest.doc.DocumentRow;
import com.ibm.nzna.projects.common.storedProc.StoredProcRec;
import com.ibm.nzna.projects.common.storedProc.StoredProcUtil;
import com.ibm.nzna.projects.qit.Qit;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.MainWindow;
import com.ibm.nzna.projects.qit.app.ProcessManagerSystem;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.QuestProcess;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.bookmark.Bookmark;
import com.ibm.nzna.projects.qit.doc.DocConst;
import com.ibm.nzna.projects.qit.doc.docview.DocViewListener;
import com.ibm.nzna.projects.qit.doc.docview.DocViewRec;
import com.ibm.nzna.shared.db.SQLMethod;
import com.ibm.nzna.shared.util.CDate;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.Text;
import java.sql.CallableStatement;
import java.sql.Statement;
import java.util.Vector;

public class RefreshDocViewThread
extends Thread
implements QuestProcess,
DocConst,
AppConst {
    private boolean onlyRequest = false;
    private CallableStatement stmt = null;
    private Statement sqlStmt = null;
    private boolean continueProcess = true;
    private Vector listeners = null;
    private DocViewRec viewRec = null;

    public void run() {
        ProcessManagerSystem.addProcess(this);
        this.fireStartEvent();
        if (this.continueProcess) {
            Qit.setEnabled(false);
            if (this.viewRec != null) {
                if (this.viewRec.isCustomView()) {
                    this.viewRec.setResults(this.viewRec.getCustomView().getResults());
                    this.fireStopEvent();
                } else {
                    this.readDocData();
                    this.fireStopEvent();
                }
            }
        }
        if (this.continueProcess) {
            Qit.setEnabled(true);
        }
        if (this.continueProcess) {
            ProcessManagerSystem.removeProcess(this);
        }
    }

    private boolean readDocData() {
        boolean bl = false;
        String string = null;
        if (this.continueProcess) {
            boolean bl2 = this.viewRec.getCategoryInd() >= 0;
            String string2 = "QUEST";
            String string3 = this.viewRec.getShowDeletedDocsOnly() ? "'N'" : "'Y'";
            String string4 = this.viewRec.getShowDeletedDocsOnly() ? "'Y'" : "'N'";
            switch (this.viewRec.getViewType()) {
                case 28: {
                    string = this.viewRec.getSQLQuery();
                    break;
                }
                case 0: {
                    string = "SELECT DISTINCT(DOCUMENTS.DOCIND),      DOCUMENTS.DOCIND,  DOCUMENTS.TITLE,   DOCUMENTS.OWNER,      " + "       DOCUMENTS.DOCCLASSIND, DOCUMENTS.LNDOCID, DOCUMENTS.WORKIND, DOCUMENTS.DBUSER,     " + "       DOCUMENTS.CHANGEDTIME " + "FROM   TIGRIS.DOCUMENTS DOCUMENTS," + "       TIGRIS.CATEGORY CATEGORY " + "WHERE  CATEGORY.TYPECATIND IN (SELECT TYPECATIND FROM PRODUCT.TYPECATCHILD WHERE PARENTCATIND = " + this.viewRec.getBrandInd() + ") AND " + "       DOCUMENTS.DOCIND     = CATEGORY.DOCIND AND" + "       DOCUMENTS.DOCTYPEIND = " + this.viewRec.getDocTypeInd() + " AND " + "       DOCUMENTS.PUBLISH    = " + string3 + " AND " + "       DOCUMENTS.RECYCLED   = " + string4 + " ";
                    string2 = "TIGRIS";
                    break;
                }
                case 4: {
                    String string5 = this.viewRec.getMachine(true);
                    if (string5 == null || string5.length() <= 0) break;
                    if (string5.length() > 4) {
                        string5 = string5.substring(0, 4);
                    }
                    string = "SELECT DISTINCT(DOCUMENTS.DOCIND),      DOCUMENTS.DOCIND,  DOCUMENTS.TITLE,   DOCUMENTS.OWNER,      " + "       DOCUMENTS.DOCCLASSIND, DOCUMENTS.LNDOCID, DOCUMENTS.WORKIND, DOCUMENTS.DBUSER,     " + "       DOCUMENTS.CHANGEDTIME " + "FROM   TIGRIS.DOCUMENTS DOCUMENTS," + "       TIGRIS.CATEGORY CATEGORY, " + "       PRODUCT.TYPECATEGORY TYPECATEGORY " + "WHERE  DOCUMENTS.DOCTYPEIND = " + this.viewRec.getDocTypeInd() + " AND " + "       DOCUMENTS.PUBLISH    = " + string3 + " AND " + "       DOCUMENTS.RECYCLED   = " + string4 + " AND " + "       CATEGORY.DOCIND      = DOCUMENTS.DOCIND AND " + "       CATEGORY.TYPECATIND  = (SELECT TYPECATIND FROM PRODUCT.TYPECATEGORY WHERE translate(DESCRIPTION) like '%" + string5 + "%' AND CATEGORYLEVEL = '" + "machine" + "')  ";
                    break;
                }
                case 3: {
                    string = "SELECT DISTINCT(DOCUMENTS.DOCIND),      DOCUMENTS.DOCIND,  DOCUMENTS.TITLE,   DOCUMENTS.OWNER,      " + "       DOCUMENTS.DOCCLASSIND, DOCUMENTS.LNDOCID, DOCUMENTS.WORKIND, DOCUMENTS.DBUSER,     " + "       DOCUMENTS.CHANGEDTIME " + "FROM   TIGRIS.DOCUMENTS DOCUMENTS," + "       TIGRIS.CATEGORY CATEGORY " + "WHERE  CATEGORY.TYPECATIND IN (SELECT TYPECATIND FROM PRODUCT.TYPECATCHILD WHERE PARENTCATIND = " + this.viewRec.getBrandGroupInd() + ") AND " + "       DOCUMENTS.DOCIND     = CATEGORY.DOCIND AND" + "       DOCUMENTS.DOCTYPEIND = " + this.viewRec.getDocTypeInd() + " AND " + "       DOCUMENTS.PUBLISH    = " + string3 + " AND " + "       DOCUMENTS.RECYCLED   = " + string4 + " ";
                    string2 = "TIGRIS";
                    break;
                }
                case 31: {
                    String string6 = this.viewRec.getPartNumber(true);
                    if (string6 == null || string6.length() <= 0) break;
                    string = "SELECT DISTINCT(DOCUMENTS.DOCIND),      DOCUMENTS.DOCIND,  DOCUMENTS.TITLE,   DOCUMENTS.OWNER,      " + "       DOCUMENTS.DOCCLASSIND, DOCUMENTS.LNDOCID, DOCUMENTS.WORKIND, DOCUMENTS.DBUSER,     " + "       DOCUMENTS.CHANGEDTIME " + "FROM   TIGRIS.DOCUMENTS DOCUMENTS, " + "       TIGRIS.CATEGORY  CATEGORY, " + "       PRODUCT.TYPECATEGORY TYPECATEGORY " + "WHERE  DOCUMENTS.DOCTYPEIND = " + this.viewRec.getDocTypeInd() + " AND " + "       DOCUMENTS.PUBLISH    = " + string3 + " AND " + "       DOCUMENTS.RECYCLED   = " + string4 + " AND " + "       CATEGORY.DOCIND      = DOCUMENTS.DOCIND AND " + "       CATEGORY.TYPECATIND  = (SELECT TYPECATIND FROM PRODUCT.TYPECATEGORY WHERE translate(DESCRIPTION) like '%" + string6 + "%' AND CATEGORYLEVEL = '" + "partnum" + "')  ";
                    break;
                }
                case 1: {
                    string = "SELECT DISTINCT(DOCUMENTS.DOCIND),      DOCUMENTS.DOCIND,  DOCUMENTS.TITLE,   DOCUMENTS.OWNER,      " + "       DOCUMENTS.DOCCLASSIND, DOCUMENTS.LNDOCID, DOCUMENTS.WORKIND, DOCUMENTS.DBUSER,     " + "       DOCUMENTS.CHANGEDTIME " + "FROM   TIGRIS.DOCUMENTS DOCUMENTS " + "WHERE  DOCUMENTS.DOCTYPEIND = " + this.viewRec.getDocTypeInd() + " AND" + "       DOCUMENTS.RECYCLED   = " + string4 + " AND " + "       DOCUMENTS.PUBLISH    = " + string3 + " ";
                    break;
                }
                case 15: {
                    string = "SELECT DISTINCT(DOCUMENTS.DOCIND), DOCUMENTS.EXISTINGDOCIND, DOCUMENTS.TITLE,   DOCUMENTS.OWNER,      " + "       DOCUMENTS.DOCCLASSIND,      DOCUMENTS.LNDOCID,        DOCUMENTS.WORKIND, DOCUMENTS.DBUSER,     " + "       DOCUMENTS.CHANGEDTIME " + "FROM QUEST.DOCUMENTS DOCUMENTS " + "WHERE DOCUMENTS.DBUSER = '" + UserSystem.getUserId() + "' AND " + "      DOCUMENTS.STOPDATE IS NULL AND " + "      DOCUMENTS.TEMPLATE = 'N' AND " + "      DOCUMENTS.RECYCLED = " + string4 + "";
                    break;
                }
                case 6: {
                    if (this.viewRec.getStatusInd() != 6) {
                        string = "SELECT DISTINCT(DOCUMENTS.DOCIND), DOCUMENTS.EXISTINGDOCIND, DOCUMENTS.TITLE,   DOCUMENTS.OWNER,      " + "       DOCUMENTS.DOCCLASSIND,      DOCUMENTS.LNDOCID,        DOCUMENTS.WORKIND, DOCUMENTS.DBUSER,     " + "       DOCUMENTS.CHANGEDTIME " + "FROM QUEST.DOCUMENTS DOCUMENTS, " + "     QUEST.CATEGORY  CATEGORY, " + "     QUEST.DOCSTATUS DOCSTATUS " + "WHERE DOCUMENTS.STOPDATE       IS NULL       AND " + "      DOCUMENTS.RECYCLED       = " + string4 + " AND " + "      DOCUMENTS.TEMPLATE       = 'N'         AND " + "      DOCUMENTS.DOCIND         = DOCSTATUS.DOCIND AND " + "      DOCUMENTS.DOCIND         = CATEGORY.DOCIND AND " + "      CATEGORY.TYPECATIND IN (SELECT TYPECATIND FROM PRODUCT.TYPECATCHILD WHERE PARENTCATIND = " + this.viewRec.getBrandInd() + ") AND " + "      DOCSTATUS.STATUSIND      = " + this.viewRec.getStatusInd() + "  AND" + "      DOCSTATUS.RECNUM         = (SELECT MAX(RECNUM) FROM QUEST.DOCSTATUS WHERE DOCIND = DOCUMENTS.DOCIND) ";
                        break;
                    }
                    string = "SELECT DISTINCT(DOCUMENTS.DOCIND), DOCUMENTS.EXISTINGDOCIND, DOCUMENTS.TITLE,   DOCUMENTS.OWNER,      " + "       DOCUMENTS.DOCCLASSIND,      DOCUMENTS.LNDOCID,        DOCUMENTS.WORKIND, DOCUMENTS.DBUSER,     " + "       DOCUMENTS.CHANGEDTIME " + "FROM QUEST.DOCUMENTS DOCUMENTS, " + "     QUEST.CATEGORY  CATEGORY, " + "     QUEST.DOCSTATUS DOCSTATUS " + "WHERE DOCUMENTS.RECYCLED       = " + string4 + " AND " + "      DOCUMENTS.TEMPLATE       = 'N'         AND " + "      DOCUMENTS.DOCIND         = DOCSTATUS.DOCIND AND " + "      DOCUMENTS.DOCIND         = CATEGORY.DOCIND AND " + "      CATEGORY.TYPECATIND IN (SELECT TYPECATIND FROM PRODUCT.TYPECATCHILD WHERE PARENTCATIND = " + this.viewRec.getBrandInd() + ") AND " + "      DOCSTATUS.STATUSIND      = " + this.viewRec.getStatusInd() + "  AND" + "      DOCSTATUS.RECNUM         = (SELECT MAX(RECNUM) FROM QUEST.DOCSTATUS WHERE DOCIND = DOCUMENTS.DOCIND) ";
                    break;
                }
                case 17: {
                    string = "SELECT DISTINCT(DOCUMENTS.DOCIND),          DOCUMENTS.EXISTINGDOCIND, DOCUMENTS.TITLE,   DOCUMENTS.OWNER,      " + "       DOCUMENTS.DOCCLASSIND,     DOCUMENTS.LNDOCID,        DOCUMENTS.WORKIND, DOCUMENTS.DBUSER,     " + "       DOCUMENTS.CHANGEDTIME " + "FROM QUEST.DOCUMENTS DOCUMENTS " + "WHERE STOPDATE IS NULL        AND " + "      RECYCLED  = " + string4 + " AND " + "      TEMPLATE  = 'N' ";
                    break;
                }
                case 24: {
                    string = "SELECT DOCUMENTS.DOCIND,      DOCUMENTS.DOCIND,  DOCUMENTS.TITLE,   DOCUMENTS.OWNER,      " + "       DOCUMENTS.DOCCLASSIND, DOCUMENTS.LNDOCID, DOCUMENTS.WORKIND, DOCUMENTS.DBUSER,     " + "       DOCUMENTS.CHANGEDTIME " + "FROM TIGRIS.DOCUMENTS   DOCUMENTS " + "WHERE DOCUMENTS.RECYCLED   = " + string4 + " AND " + "      DOCUMENTS.PUBLISH    = " + string3 + " AND " + "      DOCUMENTS.DBUSER     = '" + UserSystem.getUserId() + "' ";
                    break;
                }
                case 19: {
                    String string7 = this.viewRec.getComment(true);
                    if (string7 == null || string7.length() <= 0) break;
                    string = "SELECT DISTINCT(DOCUMENTS.DOCIND),          DOCUMENTS.EXISTINGDOCIND, DOCUMENTS.TITLE,   DOCUMENTS.OWNER,      " + "       DOCUMENTS.DOCCLASSIND,     DOCUMENTS.LNDOCID,        DOCUMENTS.WORKIND, DOCUMENTS.DBUSER,     " + "       DOCUMENTS.CHANGEDTIME " + "FROM QUEST.DOCUMENTS DOCUMENTS " + "WHERE translate(COMMENT) LIKE '%" + this.viewRec.getComment(false).toUpperCase() + "%' AND " + "      DOCUMENTS.STOPDATE IS NULL     AND " + "      DOCUMENTS.RECYCLED  = " + string4 + " AND " + "      DOCUMENTS.TEMPLATE  = 'N' ";
                    break;
                }
                case 20: {
                    String string8 = this.viewRec.getSource(true);
                    if (string8 == null || string8.length() <= 0) break;
                    string = "SELECT DISTINCT(DOCUMENTS.DOCIND),       DOCUMENTS.DOCIND,  DOCUMENTS.TITLE,   DOCUMENTS.OWNER, " + "       DOCUMENTS.DOCCLASSIND,  DOCUMENTS.LNDOCID, DOCUMENTS.WORKIND, DOCUMENTS.DBUSER, " + "       DOCUMENTS.CHANGEDTIME " + "FROM TIGRIS.DOCUMENTS DOCUMENTS " + "WHERE translate(DOCUMENTS.SOURCE) LIKE '%" + string8.toUpperCase() + "%' AND " + "      DOCUMENTS.RECYCLED  = " + string4 + " AND " + "      DOCUMENTS.PUBLISH   = " + string3 + " ";
                    string2 = "TIGRIS";
                    break;
                }
                case 21: {
                    String string9 = this.viewRec.getSource(true);
                    if (string9 == null || string9.length() <= 0) break;
                    string = "SELECT DISTINCT(DOCUMENTS.DOCIND),          DOCUMENTS.EXISTINGDOCIND, DOCUMENTS.TITLE,   DOCUMENTS.OWNER,      " + "       DOCUMENTS.DOCCLASSIND,     DOCUMENTS.LNDOCID,        DOCUMENTS.WORKIND, DOCUMENTS.DBUSER,     " + "       DOCUMENTS.CHANGEDTIME " + "FROM QUEST.DOCUMENTS DOCUMENTS " + "WHERE translate(SOURCE) LIKE '%" + this.viewRec.getSource(false).toUpperCase() + "%' AND " + "      DOCUMENTS.STOPDATE IS NULL     AND " + "      DOCUMENTS.RECYCLED  = " + string4 + " AND " + "      DOCUMENTS.TEMPLATE  = 'N' ";
                    break;
                }
                case 2: {
                    String string10 = this.viewRec.getUserId(true);
                    if (string10 == null || string10.length() <= 0) break;
                    string = "SELECT DISTINCT(DOCUMENTS.DOCIND),          DOCUMENTS.DOCIND , DOCUMENTS.TITLE,   DOCUMENTS.OWNER,      " + "       DOCUMENTS.DOCCLASSIND,     DOCUMENTS.LNDOCID, DOCUMENTS.WORKIND, DOCUMENTS.DBUSER,     " + "       DOCUMENTS.CHANGEDTIME " + "FROM TIGRIS.DOCUMENTS DOCUMENTS " + "WHERE DOCUMENTS.DBUSER = '" + string10 + "' AND " + "      DOCUMENTS.DOCTYPEIND = " + this.viewRec.getDocTypeInd() + " AND " + "      DOCUMENTS.RECYCLED  = " + string4 + " AND " + "      DOCUMENTS.PUBLISH   = " + string3 + " ";
                    break;
                }
                case 5: {
                    String string11 = this.viewRec.getUserId(true);
                    if (string11 == null || string11.length() <= 0) break;
                    string = "SELECT DISTINCT(DOCUMENTS.DOCIND),          DOCUMENTS.EXISTINGDOCIND, DOCUMENTS.TITLE,   DOCUMENTS.OWNER,      " + "       DOCUMENTS.DOCCLASSIND,     DOCUMENTS.LNDOCID,        DOCUMENTS.WORKIND, DOCUMENTS.DBUSER,     " + "       DOCUMENTS.CHANGEDTIME " + "FROM QUEST.DOCUMENTS DOCUMENTS " + "WHERE DOCUMENTS.REQUESTOR = '" + this.viewRec.getUserId() + "' AND " + "      DOCUMENTS.STOPDATE IS NULL     AND " + "      DOCUMENTS.RECYCLED  = " + string4 + " AND " + "      DOCUMENTS.TEMPLATE  = 'N' ";
                    break;
                }
                case 7: {
                    String string12 = this.viewRec.getUserId(true);
                    if (string12 == null || string12.length() <= 0) break;
                    string = "SELECT DISTINCT(DOCUMENTS.DOCIND), DOCUMENTS.EXISTINGDOCIND, DOCUMENTS.TITLE,   DOCUMENTS.OWNER,      " + "       DOCUMENTS.DOCCLASSIND,      DOCUMENTS.LNDOCID,        DOCUMENTS.WORKIND, DOCUMENTS.DBUSER,     " + "       DOCUMENTS.CHANGEDTIME " + "FROM QUEST.DOCUMENTS DOCUMENTS, " + "     QUEST.CATEGORY CATEGORY " + "WHERE  CATEGORY.TYPECATIND IN (SELECT TYPECATIND FROM PRODUCT.TYPECATCHILD WHERE PARENTCATIND = " + this.viewRec.getBrandInd() + ") AND " + "      DOCUMENTS.OWNER   = '" + string12 + "' AND " + "      DOCUMENTS.DOCIND  = CATEGORY.DOCIND AND " + "      DOCUMENTS.STOPDATE IS NULL     AND " + "      DOCUMENTS.RECYCLED  = " + string4 + " AND " + "      DOCUMENTS.TEMPLATE  = 'N' ";
                    break;
                }
                case 23: {
                    string = "SELECT DISTINCT(DOCUMENTS.DOCIND), DOCUMENTS.EXISTINGDOCIND, DOCUMENTS.TITLE,   DOCUMENTS.OWNER,      " + "       DOCUMENTS.DOCCLASSIND,      DOCUMENTS.LNDOCID,        DOCUMENTS.WORKIND, DOCUMENTS.DBUSER,     " + "       DOCUMENTS.CHANGEDTIME " + "FROM QUEST.DOCUMENTS DOCUMENTS, " + "     QUEST.CATEGORY CATEGORY " + "WHERE CATEGORY.TYPECATIND IN (SELECT TYPECATIND FROM PRODUCT.TYPECATCHILD WHERE PARENTCATIND = " + this.viewRec.getBrandInd() + ") AND " + "      DOCUMENTS.DOCIND  = CATEGORY.DOCIND AND " + "      DOCUMENTS.STOPDATE IS NULL     AND " + "      DOCUMENTS.RECYCLED  = " + string4 + " AND " + "      DOCUMENTS.TEMPLATE  = 'N' ";
                    break;
                }
                case 27: {
                    int n = 0;
                    Vector vector = this.viewRec.getBookmarkVec();
                    int n2 = vector.size();
                    string = "SELECT DISTINCT(DOCUMENTS.DOCIND),      DOCUMENTS.DOCIND,  DOCUMENTS.TITLE,   DOCUMENTS.OWNER,      " + "       DOCUMENTS.DOCCLASSIND, DOCUMENTS.LNDOCID, DOCUMENTS.WORKIND, DOCUMENTS.DBUSER,     " + "       DOCUMENTS.CHANGEDTIME " + "FROM TIGRIS.DOCUMENTS DOCUMENTS " + "WHERE DOCUMENTS.RECYCLED   = " + string4 + " AND " + "      DOCUMENTS.PUBLISH    = " + string3 + " AND " + "      DOCUMENTS.DOCIND IN ( ";
                    while (n < n2) {
                        Integer n3 = (Integer)((Bookmark)vector.elementAt(n)).getObject();
                        string = string + " " + n3;
                        if (n < n2 - 1) {
                            string = string + ",";
                        }
                        ++n;
                    }
                    string = string + ") ";
                    break;
                }
                case 26: {
                    int n = 0;
                    Vector vector = this.viewRec.getBookmarkVec();
                    int n4 = vector.size();
                    string = "SELECT DISTINCT(DOCUMENTS.DOCIND), DOCUMENTS.EXISTINGDOCIND, DOCUMENTS.TITLE,   DOCUMENTS.OWNER,      " + "       DOCUMENTS.DOCCLASSIND,      DOCUMENTS.LNDOCID,        DOCUMENTS.WORKIND, DOCUMENTS.DBUSER,     " + "       DOCUMENTS.CHANGEDTIME " + "FROM QUEST.DOCUMENTS DOCUMENTS, " + "WHERE DOCUMENTS.STOPDATE IS NULL        AND " + "      DOCUMENTS.RECYCLED  = " + string4 + " AND " + "      DOCUMENTS.TEMPLATE  = 'N'         AND " + "      DOCUMENTS.DOCIND IN ( ";
                    while (n < n4) {
                        Integer n5 = (Integer)((Bookmark)vector.elementAt(n)).getObject();
                        string = string + " " + n5;
                        if (n < n4 - 1) {
                            string = string + ",";
                        }
                        ++n;
                    }
                    string = string + ") ";
                    break;
                }
                case 32: {
                    String string13 = this.viewRec.getYear();
                    int n = CDate.getMonthNumFromDescript(this.viewRec.getMonth());
                    String string14 = null;
                    string14 = n > 0 ? "'" + string13 + "-" + n + "-01-07.00.00.000000'" : "'" + string13 + "-12-31-23.59.59.000000'";
                    string = this.viewRec.getBrandInd() > 0 ? "SELECT DISTINCT(DOCUMENTS.DOCIND),      DOCUMENTS.DOCIND,  DOCUMENTS.TITLE,   DOCUMENTS.OWNER,      " + "       DOCUMENTS.DOCCLASSIND, DOCUMENTS.LNDOCID, DOCUMENTS.WORKIND, DOCUMENTS.DBUSER,     " + "       DOCUMENTS.CHANGEDTIME " + "FROM   TIGRIS.DOCUMENTS DOCUMENTS," + "       TIGRIS.CATEGORY CATEGORY " + "WHERE  CATEGORY.TYPECATIND IN (SELECT TYPECATIND FROM PRODUCT.TYPECATCHILD WHERE PARENTCATIND = " + this.viewRec.getBrandInd() + ") AND " + "       DOCUMENTS.DOCIND     = CATEGORY.DOCIND AND" + "       DOCUMENTS.PUBLISH    = " + string3 + " AND " + "       DOCUMENTS.RECYCLED   = " + string4 + " AND " + "       DOCUMENTS.CHANGEDTIME + (select reviewperiod from tigris.documents where docind = DOCUMENTS.DOCIND ) MONTHS <= " + string14 + " AND " + "       DOCUMENTS.REVIEWPERIOD > 0 " : "SELECT DISTINCT(DOCUMENTS.DOCIND),      DOCUMENTS.DOCIND,  DOCUMENTS.TITLE,   DOCUMENTS.OWNER,      " + "       DOCUMENTS.DOCCLASSIND, DOCUMENTS.LNDOCID, DOCUMENTS.WORKIND, DOCUMENTS.DBUSER,     " + "       DOCUMENTS.CHANGEDTIME " + "FROM   TIGRIS.DOCUMENTS DOCUMENTS " + "WHERE  DOCUMENTS.PUBLISH    = " + string3 + " AND " + "       DOCUMENTS.RECYCLED   = " + string4 + " AND " + "       DOCUMENTS.CHANGEDTIME + (select reviewperiod from tigris.documents where docind = DOCUMENTS.DOCIND ) MONTHS <= " + string14 + " AND " + "       DOCUMENTS.REVIEWPERIOD > 0 ";
                    string2 = "TIGRIS";
                    bl2 = false;
                    break;
                }
            }
            if (string != null) {
                if (bl2) {
                    string = Text.replaceInStr(string, "WHERE", ", " + string2 + ".CATEGORY DOCCATEGORY WHERE");
                    string = string + " AND DOCCATEGORY.DOCIND     = DOCUMENTS.DOCIND " + " AND DOCCATEGORY.TYPECATIND = " + this.viewRec.getCategoryInd() + " " + "ORDER BY DOCUMENTS.CHANGEDTIME DESC ";
                } else {
                    string = string + "ORDER BY DOCUMENTS.CHANGEDTIME DESC ";
                }
                bl = this.callDocListReader(this.viewRec, string);
            }
        }
        return bl;
    }

    public boolean callDocListReader(DocViewRec docViewRec, String string) {
        String string2 = "callDocListReader";
        SQLMethod sQLMethod = new SQLMethod(1, string2, 5);
        boolean bl = false;
        if (this.continueProcess && string != null && sQLMethod != null) {
            try {
                CallableStatement callableStatement = sQLMethod.createStoredProc("QUEST.DocListReader", 6);
                if (this.continueProcess) {
                    boolean bl2 = false;
                    boolean bl3 = false;
                    callableStatement.setBytes(1, string.getBytes());
                    callableStatement.setInt(2, PropertySystem.getInt(151));
                    callableStatement.setInt(3, docViewRec.getFromCount());
                    callableStatement.registerOutParameter(4, 4);
                    callableStatement.registerOutParameter(5, -4);
                    callableStatement.registerOutParameter(6, -4);
                    LogSystem.log(1, "Executing Query:" + string);
                    callableStatement.execute();
                    StoredProcRec storedProcRec = (StoredProcRec)StoredProcUtil.getObjectFromStatement(callableStatement, 6);
                    if (storedProcRec != null && storedProcRec.error) {
                        LogSystem.beginLogSection("DocListReader Returned Error");
                        LogSystem.log(1, "sqlCode:   " + storedProcRec.sqlCode);
                        LogSystem.log(1, "userError: " + storedProcRec.userError);
                        LogSystem.log(1, "errorStr:  " + storedProcRec.errorStr);
                        LogSystem.log(1, "error:     " + storedProcRec.error);
                        LogSystem.endLogSection();
                    } else {
                        docViewRec.setResults((Vector)StoredProcUtil.getObjectFromStatement(callableStatement, 5));
                        if (docViewRec.getResults() != null) {
                            LogSystem.log(1, "DocListReader returned " + docViewRec.getResults().size() + " hit(s)");
                        } else {
                            LogSystem.log(1, "DocListReader returned no hits");
                        }
                        if (docViewRec.actualCount == 0) {
                            docViewRec.actualCount = callableStatement.getInt(4);
                        }
                        this.adjustDocumentRows(docViewRec.getResults());
                        bl = true;
                    }
                }
                bl = true;
            }
            catch (Exception exception) {
                sQLMethod.rollBack();
                LogSystem.log(1, exception, false);
                GUISystem.printBox(7, 202);
            }
        }
        sQLMethod.close();
        return bl;
    }

    public String getProcessName() {
        return "Refresh Document List";
    }

    public void stopProcess() {
        this.continueProcess = false;
        this.fireStopEvent();
        Qit.setEnabled(true);
        ProcessManagerSystem.removeProcess(this);
        try {
            if (this.sqlStmt != null) {
                this.sqlStmt.cancel();
            } else if (this.stmt != null) {
                this.stmt.cancel();
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
    }

    private void fireStopEvent() {
        if (this.listeners != null) {
            int n = 0;
            int n2 = this.listeners.size();
            while (n < n2) {
                ((DocViewListener)this.listeners.elementAt(n)).docViewStopped(this.viewRec);
                ++n;
            }
        }
    }

    private void fireStartEvent() {
        if (this.continueProcess && this.listeners != null) {
            int n = 0;
            int n2 = this.listeners.size();
            while (this.continueProcess && n < n2) {
                ((DocViewListener)this.listeners.elementAt(n)).docViewStarted(this.viewRec);
                ++n;
            }
        }
    }

    private void adjustDocumentRows(Vector vector) {
        int n = 0;
        int n2 = vector.size();
        int n3 = 0;
        DocumentRow documentRow = null;
        while (n < n2) {
            documentRow = (DocumentRow)vector.elementAt(n);
            n3 = documentRow.getDocClassInd();
            switch (n3) {
                case 1: {
                    documentRow.setDocClassImage(ImageSystem.getImage((Object)MainWindow.getInstance(), 102));
                    break;
                }
                case 2: {
                    documentRow.setDocClassImage(ImageSystem.getImage((Object)MainWindow.getInstance(), 103));
                    break;
                }
                case 3: {
                    documentRow.setDocClassImage(ImageSystem.getImage((Object)MainWindow.getInstance(), 104));
                    break;
                }
            }
            documentRow.setLastTouchedBy(UserSystem.getNameFromUserId(documentRow.getLastTouchedBy()));
            ++n;
        }
    }

    public RefreshDocViewThread(DocViewRec docViewRec) {
        this.viewRec = docViewRec;
        this.listeners = docViewRec.getListeners();
        this.start();
    }

    public RefreshDocViewThread(DocViewRec docViewRec, boolean bl) {
        this.viewRec = docViewRec;
        this.listeners = docViewRec.getListeners();
        if (bl) {
            this.start();
        }
    }
}

