/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.doc.storedProc.docReader;

import COM.ibm.db2.app.Blob;
import COM.ibm.db2.app.Lob;
import COM.ibm.db2.app.StoredProc;
import com.ibm.nzna.projects.qit.doc.storedProc.docReader.DocReaderBuffer;
import com.ibm.nzna.projects.qit.doc.storedProc.docReader.DocReaderLinkBuffer;
import com.ibm.nzna.projects.qit.doc.storedProc.docReader.DocReaderMediaBuffer;
import com.ibm.nzna.projects.qit.doc.storedProc.docReader.DocReaderProdBuffer;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.StringTokenizer;
import java.util.Vector;

public class DocReader
extends StoredProc {
    private static final String LOG_FILE = "/tmp/DocReader.log";
    private static final int READLEVEL_ALL = 0;
    private static final int READLEVEL_PREVIEW = 1;
    private int sqlCode = 0;
    private DocReaderBuffer buffer = null;
    private Connection con = null;
    private int docInd = 0;
    private int existingDocInd = 0;
    private int request = 0;
    private String qualifier = "TIGRIS";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readDocument(int n, int n2, int n3, int n4, Blob blob, int n5, String string) throws Exception {
        this.con = this.getConnection();
        try {
            this.docInd = n;
            this.request = n3;
            if (n3 == 1) {
                this.qualifier = "QUEST";
            } else {
                this.docInd = n2;
            }
            this.buffer = new DocReaderBuffer();
            n5 = n3 == 0 ? this.readDocumentInfo() : this.readDocumentRequestInfo();
            if (n5 == 0 && n4 == 0) {
                n5 = this.readDocProperties();
            }
            if (n5 == 0 && n4 == 0) {
                n5 = this.readDocGeo();
            }
            if (n5 == 0 && n4 == 0) {
                n5 = this.readDocCountry();
            }
            if (n5 == 0 && n4 == 0) {
                n5 = this.readDocProducts();
            }
            if (n5 == 0 && n4 == 0) {
                n5 = this.readDocQueryText();
            }
            if (n5 == 0 && n4 == 0 && (this.buffer.docTypeInd == 9 || this.buffer.docTypeInd == 8)) {
                n5 = this.readDocMedia();
            }
            if (n5 == 0 && n4 == 0) {
                n5 = this.readDocLinks();
            }
            if (n5 == 0 && this.buffer.docTypeInd != 9) {
                n5 = this.readDocBody();
            }
            if (n5 == 0 && n4 == 0) {
                n5 = this.readDocCategory();
            }
            if (n5 == 0) {
                n5 = this.readCommentHistory();
            }
            blob = Lob.newBlob();
            DocReader.setObjectInBlob(blob, this.buffer);
            this.set(5, blob);
            this.set(6, n5);
        }
        catch (Exception exception) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            this.set(7, exception.toString());
        }
        this.con.commit();
        this.con.close();
    }

    public static void setObjectInBlob(Blob blob, Object object) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(blob.getOutputStream());
        objectOutputStream.writeObject(object);
        objectOutputStream.flush();
        objectOutputStream.close();
    }

    private final int readDocumentInfo() throws Exception {
        Statement statement = this.con.createStatement();
        String string = null;
        ResultSet resultSet = null;
        String string2 = null;
        string = "SELECT DOCTYPEIND,   DOCCLASSIND, TITLE,     OWNER,         REVIEWPERIOD, " + "       AUTHIND,      WEBABLE,     WEBONLY,   FAXABLE,       FLASHNEWS,    " + "       FLASHDATE,    FAQ,         EMAILABLE, EMAILABLEDATE, SUMMARY,      " + "       METRICIND,    ADDINFO,     PARTNUM,   PUBTYPE,       LNDOCID,      " + "       SOURCE,       MAINTLOCK,   SHOW,      WORKIND,       DBUSER,       " + "       CHANGEDTIME,  KNOWLEDGEBASE                                        " + "FROM   TIGRIS.DOCUMENTS                                                   " + "WHERE  DOCIND   = " + this.docInd + " AND                                          " + "       RECYCLED = 'N'                                                     " + "       FOR FETCH ONLY                                                     ";
        resultSet = statement.executeQuery(string);
        if (resultSet.next()) {
            this.buffer.docTypeInd = resultSet.getInt(1);
            this.buffer.docClassInd = resultSet.getInt(2);
            this.buffer.title = resultSet.getString(3).trim();
            this.buffer.owner = resultSet.getString(4).trim();
            this.buffer.reviewPeriod = resultSet.getInt(5);
            this.buffer.authInd = resultSet.getInt(6);
            this.buffer.webable = resultSet.getString(7).trim();
            this.buffer.webonly = resultSet.getString(8).trim();
            this.buffer.faxable = resultSet.getString(9).trim();
            this.buffer.flash = resultSet.getString(10).trim();
            this.buffer.flashDate = resultSet.getString(11);
            this.buffer.faq = resultSet.getString(12);
            this.buffer.emailable = resultSet.getString(13).trim();
            this.buffer.emailableDate = resultSet.getString(14);
            this.buffer.summary = resultSet.getString(15);
            this.buffer.metricInd = resultSet.getInt(16);
            string2 = resultSet.getString(17);
            this.buffer.partNumber = resultSet.getString(18);
            this.buffer.pubTypeInd = resultSet.getInt(19);
            this.buffer.lnDocId = resultSet.getString(20);
            this.buffer.source = resultSet.getString(21);
            this.buffer.maintLock = resultSet.getString(22).trim();
            this.buffer.show = resultSet.getString(23).trim();
            this.buffer.workInd = resultSet.getInt(24);
            this.buffer.dbUser = resultSet.getString(25).trim();
            this.buffer.changedTime = resultSet.getString(26).trim();
            this.buffer.knowledgeBase = resultSet.getString(27).trim();
            this.buffer.existingDocInd = this.docInd;
            this.buffer.docInd = 0;
            if (this.buffer.emailableDate != null) {
                this.buffer.emailableDate = this.buffer.emailableDate.trim();
            }
            if (this.buffer.flashDate != null) {
                this.buffer.flashDate = this.buffer.flashDate.trim();
            }
            if (string2 != null) {
                string2 = string2.trim();
            }
            if (this.buffer.partNumber != null) {
                this.buffer.partNumber = this.buffer.partNumber.trim();
            }
            if (this.buffer.lnDocId != null) {
                this.buffer.lnDocId = this.buffer.lnDocId.trim();
            }
            if (this.buffer.source != null) {
                this.buffer.source = this.buffer.source.trim();
            }
        } else {
            return 100;
        }
        this.buffer.addInfoVec = new Vector(1, 1);
        DocReaderBuffer.breakStringIntoVec(string2, this.buffer.addInfoVec);
        resultSet.close();
        statement.close();
        return 0;
    }

    private final int readDocumentRequestInfo() throws Exception {
        Statement statement = this.con.createStatement();
        String string = null;
        ResultSet resultSet = null;
        String string2 = null;
        string = "SELECT DOCTYPEIND,   DOCCLASSIND, TITLE,     OWNER,         REVIEWPERIOD,   " + "       AUTHIND,      WEBABLE,     WEBONLY,   FAXABLE,       FLASHNEWS,      " + "       FLASHDATE,    FAQ,         EMAILABLE, EMAILABLEDATE, SUMMARY,        " + "       METRICIND,    ADDINFO,     PARTNUM,   PUBTYPE,       LNDOCID,        " + "       SOURCE,       MAINTLOCK,   SHOW,      WORKIND,       DBUSER,         " + "       CHANGEDTIME,  STOPDATE,    STARTDATE, REQUESTOR,     EXISTINGDOCIND, " + "       COMMENT,      KNOWLEDGEBASE                                          " + "FROM   QUEST.DOCUMENTS                                                      " + "WHERE  DOCIND   = " + this.docInd + " AND                                            " + "       RECYCLED = 'N'                                                       " + "       FOR FETCH ONLY                                                       ";
        resultSet = statement.executeQuery(string);
        if (resultSet.next()) {
            this.buffer.docTypeInd = resultSet.getInt(1);
            this.buffer.docClassInd = resultSet.getInt(2);
            this.buffer.title = resultSet.getString(3).trim();
            this.buffer.owner = resultSet.getString(4).trim();
            this.buffer.reviewPeriod = resultSet.getInt(5);
            this.buffer.authInd = resultSet.getInt(6);
            this.buffer.webable = resultSet.getString(7).trim();
            this.buffer.webonly = resultSet.getString(8).trim();
            this.buffer.faxable = resultSet.getString(9).trim();
            this.buffer.flash = resultSet.getString(10).trim();
            this.buffer.flashDate = resultSet.getString(11);
            this.buffer.faq = resultSet.getString(12);
            this.buffer.emailable = resultSet.getString(13).trim();
            this.buffer.emailableDate = resultSet.getString(14);
            this.buffer.summary = resultSet.getString(15);
            this.buffer.metricInd = resultSet.getInt(16);
            string2 = resultSet.getString(17);
            this.buffer.partNumber = resultSet.getString(18);
            this.buffer.pubTypeInd = resultSet.getInt(19);
            this.buffer.lnDocId = resultSet.getString(20);
            this.buffer.source = resultSet.getString(21);
            this.buffer.maintLock = resultSet.getString(22).trim();
            this.buffer.show = resultSet.getString(23).trim();
            this.buffer.workInd = resultSet.getInt(24);
            this.buffer.dbUser = resultSet.getString(25).trim();
            this.buffer.changedTime = resultSet.getString(26).trim();
            this.buffer.startDate = resultSet.getString(28);
            this.buffer.stopDate = resultSet.getString(27);
            this.buffer.requestor = resultSet.getString(29);
            this.buffer.existingDocInd = resultSet.getInt(30);
            this.buffer.comment = resultSet.getString(31);
            this.buffer.knowledgeBase = resultSet.getString(32).trim();
            this.existingDocInd = this.buffer.existingDocInd;
            if (this.buffer.emailableDate != null) {
                this.buffer.emailableDate = this.buffer.emailableDate.trim();
            }
            if (this.buffer.flashDate != null) {
                this.buffer.flashDate = this.buffer.flashDate.trim();
            }
            if (string2 != null) {
                string2 = string2.trim();
            }
            if (this.buffer.partNumber != null) {
                this.buffer.partNumber = this.buffer.partNumber.trim();
            }
            if (this.buffer.lnDocId != null) {
                this.buffer.lnDocId = this.buffer.lnDocId.trim();
            }
            if (this.buffer.source != null) {
                this.buffer.source = this.buffer.source.trim();
            }
            if (this.buffer.startDate != null) {
                this.buffer.startDate = this.buffer.startDate.trim();
            }
            if (this.buffer.stopDate != null) {
                this.buffer.stopDate = this.buffer.stopDate.trim();
            }
            if (this.buffer.requestor != null) {
                this.buffer.requestor = this.buffer.requestor.trim();
            }
            if (this.buffer.comment != null) {
                this.buffer.comment = this.buffer.comment.trim();
            }
        } else {
            return 100;
        }
        this.buffer.addInfoVec = new Vector(1, 1);
        DocReaderBuffer.breakStringIntoVec(string2, this.buffer.addInfoVec);
        resultSet.close();
        statement.close();
        return 0;
    }

    private final int readDocProperties() throws Exception {
        Statement statement = this.con.createStatement();
        String string = null;
        ResultSet resultSet = null;
        this.buffer.descript = "";
        this.buffer.countryComment = "";
        string = "SELECT PROPERTYIND, ORDERNUM, VALUE " + "FROM " + this.qualifier + ".DOCPROPERTIES " + "WHERE DOCIND = " + this.docInd + " " + "ORDER BY ORDERNUM " + "FOR FETCH ONLY";
        resultSet = statement.executeQuery(string);
        while (resultSet.next()) {
            if (resultSet.getString(3) == null) continue;
            switch (resultSet.getInt(1)) {
                case 1: {
                    this.buffer.universalNotesId = resultSet.getString(3).trim();
                    break;
                }
                case 2: {
                    this.buffer.descript = this.buffer.descript + resultSet.getString(3);
                    break;
                }
                case 3: {
                    this.buffer.releaseDate = resultSet.getString(3).trim();
                    break;
                }
                case 4: {
                    this.buffer.countryComment = this.buffer.countryComment + resultSet.getString(3).trim();
                    break;
                }
                case 5: {
                    this.buffer.createDate = resultSet.getString(3).trim();
                    break;
                }
                case 6: {
                    this.buffer.lastUpdateCTSTips = resultSet.getString(3).trim();
                    break;
                }
                case 7: {
                    this.buffer.url = resultSet.getString(3).trim();
                    break;
                }
                case 8: {
                    this.buffer.version = resultSet.getString(3).trim();
                    break;
                }
            }
        }
        if (this.buffer.descript != null && this.buffer.descript.length() > 0) {
            this.buffer.descript = this.buffer.descript.trim();
        }
        resultSet.close();
        statement.close();
        return 0;
    }

    private final int readDocCountry() throws Exception {
        Statement statement = this.con.createStatement();
        ResultSet resultSet = null;
        String string = null;
        this.buffer.countryVec = new Vector(10, 10);
        string = "SELECT COUNTRYCODEIND FROM " + this.qualifier + ".DOCCOUNTRY " + "WHERE DOCIND = " + this.docInd + " FOR FETCH ONLY";
        resultSet = statement.executeQuery(string);
        while (resultSet.next()) {
            this.buffer.countryVec.addElement(new Integer(resultSet.getInt(1)));
        }
        resultSet.close();
        statement.close();
        return 0;
    }

    private final int readDocGeo() throws Exception {
        Statement statement = this.con.createStatement();
        ResultSet resultSet = null;
        String string = null;
        this.buffer.geoVec = new Vector(10, 10);
        string = "SELECT GEOIND FROM " + this.qualifier + ".DOCGEO " + "WHERE DOCIND = " + this.docInd + " FOR FETCH ONLY";
        resultSet = statement.executeQuery(string);
        while (resultSet.next()) {
            this.buffer.geoVec.addElement(new Integer(resultSet.getInt(1)));
        }
        resultSet.close();
        statement.close();
        return 0;
    }

    private final int readDocProducts() throws Exception {
        Statement statement = this.con.createStatement();
        ResultSet resultSet = null;
        DocReaderProdBuffer docReaderProdBuffer = null;
        String string = "SELECT A.PRODINT, A.BRANDGROUPIND, A.MACHINE, A.MODEL, A.PRODNUM " + "FROM " + this.qualifier + ".PRODDOCS B, " + "     TIGRIS.PRODUCTS A " + "WHERE A.PRODINT = B.PRODINT AND " + "      B.DOCIND  = " + this.docInd + " " + " FOR FETCH ONLY";
        resultSet = statement.executeQuery(string);
        this.buffer.prodVec = new Vector(10, 10);
        while (resultSet.next()) {
            docReaderProdBuffer = new DocReaderProdBuffer();
            docReaderProdBuffer.prodInt = resultSet.getInt(1);
            docReaderProdBuffer.brandGroupInd = resultSet.getInt(2);
            docReaderProdBuffer.machine = resultSet.getString(3).trim();
            docReaderProdBuffer.model = resultSet.getString(4).trim();
            docReaderProdBuffer.productNum = resultSet.getString(5).trim();
            this.buffer.prodVec.addElement(docReaderProdBuffer);
        }
        resultSet.close();
        statement.close();
        return 0;
    }

    private final int readDocMedia() throws Exception {
        Statement statement = this.con.createStatement();
        ResultSet resultSet = null;
        String string = null;
        DocReaderMediaBuffer docReaderMediaBuffer = null;
        string = "SELECT A.MULTIMEDIAIND, B.GENINFO,      B.FILENAME, B.SIZE, " + "       B.FILEURL,       B.FILEVERSION,  B.MEDIAIND          " + "FROM   " + this.qualifier + ".DOCMEDIA   A,                          " + "       TIGRIS.MULTIMEDIA B                                  " + "WHERE  A.DOCIND = " + this.docInd + " AND                            " + "       B.MULTIMEDIAIND = A.MULTIMEDIAIND                    " + "       ORDER BY B.CHANGEDTIME FOR FETCH ONLY ";
        resultSet = statement.executeQuery(string);
        this.buffer.mediaVec = new Vector(10, 10);
        while (resultSet.next()) {
            docReaderMediaBuffer = new DocReaderMediaBuffer();
            docReaderMediaBuffer.fileInd = resultSet.getInt(1);
            docReaderMediaBuffer.descript = resultSet.getString(2).trim();
            docReaderMediaBuffer.sFilename = resultSet.getString(3).trim();
            docReaderMediaBuffer.fileSize = resultSet.getInt(4);
            docReaderMediaBuffer.fileURL = resultSet.getString(5).trim();
            docReaderMediaBuffer.version = resultSet.getString(6).trim();
            this.buffer.mediaVec.addElement(docReaderMediaBuffer);
        }
        resultSet.close();
        statement.close();
        return 0;
    }

    private final int readDocLinks() throws Exception {
        Statement statement = this.con.createStatement();
        ResultSet resultSet = null;
        String string = null;
        DocReaderLinkBuffer docReaderLinkBuffer = null;
        string = "SELECT A.DOCLINKIND, B.TITLE, B.DOCCLASSIND, B.LNDOCID " + "FROM   " + this.qualifier + ".DOCLINKS A, " + "       TIGRIS.DOCUMENTS B " + "WHERE  A.DOCIND      = " + this.docInd + " AND " + "       A.DOCLINKIND  = B.DOCIND " + "       FOR FETCH ONLY";
        resultSet = statement.executeQuery(string);
        this.buffer.docLinksVec = new Vector(10, 10);
        this.buffer.refDocLinksVec = new Vector(10, 10);
        while (resultSet.next()) {
            docReaderLinkBuffer = new DocReaderLinkBuffer();
            docReaderLinkBuffer.docInd = resultSet.getInt(1);
            docReaderLinkBuffer.title = resultSet.getString(2).trim();
            docReaderLinkBuffer.docClassInd = resultSet.getInt(3);
            docReaderLinkBuffer.lndocInd = resultSet.getString(4).trim();
            this.buffer.docLinksVec.addElement(docReaderLinkBuffer);
        }
        resultSet.close();
        string = "SELECT A.DOCIND, B.TITLE, B.DOCCLASSIND, B.LNDOCID " + "FROM   " + this.qualifier + ".DOCLINKS A, " + "       TIGRIS.DOCUMENTS B " + "WHERE  A.DOCLINKIND  = " + this.docInd + " AND " + "       A.DOCIND  = B.DOCIND " + "       FOR FETCH ONLY";
        resultSet = statement.executeQuery(string);
        while (resultSet.next()) {
            docReaderLinkBuffer = new DocReaderLinkBuffer();
            docReaderLinkBuffer.docInd = resultSet.getInt(1);
            docReaderLinkBuffer.title = resultSet.getString(2).trim();
            docReaderLinkBuffer.docClassInd = resultSet.getInt(3);
            docReaderLinkBuffer.lndocInd = resultSet.getString(4).trim();
            this.buffer.refDocLinksVec.addElement(docReaderLinkBuffer);
        }
        resultSet.close();
        statement.close();
        return 0;
    }

    private final int readDocBody() throws Exception {
        Statement statement = this.con.createStatement();
        ResultSet resultSet = null;
        String string = null;
        int n = 0;
        string = "SELECT BODY, RECNUM " + "FROM " + this.qualifier + ".DOCBODY " + "WHERE DOCIND = " + this.docInd + " " + "ORDER BY RECNUM FOR FETCH ONLY";
        resultSet = statement.executeQuery(string);
        this.buffer.bodyVec = new Vector(1, 1);
        while (resultSet.next()) {
            this.buffer.bodyVec.addElement(resultSet.getString(1));
            ++n;
        }
        resultSet.close();
        statement.close();
        return 0;
    }

    private final int readDocCategory() throws Exception {
        Statement statement = this.con.createStatement();
        ResultSet resultSet = null;
        String string = null;
        string = "SELECT DOCCATIND " + "FROM " + this.qualifier + ".DOCCATEGORY " + "WHERE DOCIND = " + this.docInd + " FOR FETCH ONLY";
        resultSet = statement.executeQuery(string);
        this.buffer.docCatVec = new Vector(10, 10);
        while (resultSet.next()) {
            this.buffer.docCatVec.addElement(new Integer(resultSet.getInt(1)));
        }
        resultSet.close();
        statement.close();
        return 0;
    }

    private final int readCommentHistory() throws Exception {
        Statement statement = this.con.createStatement();
        ResultSet resultSet = null;
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        n = this.request == 0 ? this.docInd : this.existingDocInd;
        string = "SELECT STOPDATE, COMMENT " + "FROM QUEST.DOCUMENTS " + "WHERE  EXISTINGDOCIND = " + n + " AND " + "       STOPDATE IS NOT NULL AND " + "       RECYCLED = 'N' AND " + "       TEMPLATE = 'N' " + "ORDER BY STOPDATE DESC FETCH FIRST 5 ROWS ONLY";
        resultSet = statement.executeQuery(string);
        while (resultSet.next()) {
            stringBuffer.append(resultSet.getString(1).trim() + "\n");
            if (resultSet.getString(2) != null) {
                stringBuffer.append(resultSet.getString(2).trim());
            } else {
                stringBuffer.append("No Comment");
            }
            stringBuffer.append("\n\n\n");
        }
        resultSet.close();
        statement.close();
        this.buffer.commentHistory = stringBuffer.toString();
        stringBuffer = null;
        return 0;
    }

    private final String formatStringLineBreaks(String string, int n) {
        boolean bl = true;
        int n2 = n;
        int n3 = 0;
        String string2 = "";
        StringTokenizer stringTokenizer = null;
        StringBuffer stringBuffer = null;
        if (string != null) {
            stringTokenizer = new StringTokenizer(string, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                string2 = string2.concat(stringTokenizer.nextToken());
                string2 = string2.concat(" ");
            }
            if (string2 != null) {
                if (string2.length() > n) {
                    stringBuffer = new StringBuffer(string2);
                    while (bl) {
                        n3 = string2.lastIndexOf(" ", n2);
                        if (n3 < 1) {
                            bl = false;
                            continue;
                        }
                        if (n3 < string2.length()) {
                            stringBuffer.setCharAt(n3, '\n');
                            n2 = n3 + n;
                            if (n2 <= string2.length()) continue;
                            bl = false;
                            continue;
                        }
                        bl = false;
                    }
                } else {
                    stringBuffer = new StringBuffer(string2);
                }
            }
        }
        return stringBuffer.toString().trim();
    }

    private final int readDocQueryText() throws Exception {
        Statement statement = this.con.createStatement();
        ResultSet resultSet = null;
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        n = this.request == 0 ? this.docInd : this.existingDocInd;
        string = "SELECT QUERYTEXT " + "FROM " + this.qualifier + ".DOCQUERYTEXT " + "WHERE  DOCIND = " + this.docInd;
        resultSet = statement.executeQuery(string);
        if (resultSet.next()) {
            this.buffer.queryText = resultSet.getString(1).trim();
        }
        resultSet.close();
        statement.close();
        return 0;
    }
}

