/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.ftp_explorer;

import com.ibm.nzna.projects.qit.Qit;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.FontSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.ProcessManagerSystem;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.QuestProcess;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.app.util.QuestUtil;
import com.ibm.nzna.projects.qit.doc.DocConst;
import com.ibm.nzna.projects.qit.ftp_explorer.FTPFileRec;
import com.ibm.nzna.projects.qit.ftp_explorer.FTPLogonDlg;
import com.ibm.nzna.projects.qit.ftp_explorer.FTPNavPanel;
import com.ibm.nzna.projects.qit.gui.ActionButton;
import com.ibm.nzna.projects.qit.gui.AppDefaultWin;
import com.ibm.nzna.projects.qit.gui.JTitle;
import com.ibm.nzna.projects.qit.gui.NavPanel;
import com.ibm.nzna.projects.qit.gui.QuestPanel;
import com.ibm.nzna.shared.ftp.sun.SunFTP;
import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.gui.DefaultTreeRenderer;
import com.ibm.nzna.shared.gui.MultiList;
import com.ibm.nzna.shared.sort.QuickSort;
import com.ibm.nzna.shared.util.FileUtil;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.StoreUtil;
import com.ibm.nzna.shared.util.Text;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.tree.DefaultTreeModel;

public class FTPExplorerPanel
extends JPanel
implements QuestPanel,
QuestProcess,
DocConst,
ListSelectionListener,
AppConst,
ActionListener,
ItemListener,
Runnable {
    private static final String bodyTemplate = "<HTML><BODY><P><FONT FACE=\"Helvetica\" SIZE=1><FONT COLOR=\"#800080\">FILENAME: </FONT><b>VAL_FILENAME<b><BR><FONT COLOR=\"#800080\">VERSION: </FONT>VAL_VERSION<BR><FONT COLOR=\"#800080\">LASTTOUCHEDON: </FONT>VAL_LASTTOUCHEDON<BR><FONT COLOR=\"#800080\">ASSOCIATEDDOCS: </FONT>VAL_ASSOCIATEDDOCS<BR><FONT COLOR=\"#800080\">DESCRIPTION: </FONT>VAL_DESCRIPTION<BR><hr>VAL_BODY</P></FONT></BODY></HTML>";
    private static final String THREAD_CONNECT = "Connect";
    private static final String THREAD_REFRESHDIRECTORIES = "RefDir";
    private static final String THREAD_REFRESHPREVIEW = "RefPre";
    private static final String[] fileTitle = new String[]{"", Str.getStr(456), Str.getStr(436)};
    private JLabel st_FTPSITE = new JLabel(Str.getStr(903));
    private DButton pb_GO = new DButton(Str.getStr(112));
    private JComboBox cb_FTPSITE = new JComboBox();
    private MultiList cnr_FILELIST = new MultiList(GUISystem.getFontUtil());
    private JTextPane mle_PREVIEW = new JTextPane();
    private JSplitPane pnl_FILEPREV = new JSplitPane(0);
    private JScrollPane scr_PREVIEW = new JScrollPane(this.mle_PREVIEW);
    private JPanel pnl_FILELIST = new JPanel();
    private JTitle st_DIRECTORY = new JTitle("");
    private ActionButton pb_CREATE = null;
    private ActionButton pb_DELETE = null;
    private ActionButton pb_EDIT = null;
    private ActionButton pb_CLOSE = null;
    private ActionButton pb_DOWNLOAD = null;
    private FTPNavPanel navPanel = null;
    private DefaultTreeModel model = null;
    private String currentFTPSite = "";
    private Vector siteList = null;
    private SunFTP ftp = null;
    private boolean connected = false;
    private DefaultTreeRenderer treeRenderer = null;
    private String curPath = null;
    private Vector fileVec = null;
    private String wholePath = "";
    private FTPFileRec currentFileRec = null;
    private boolean firstShow = false;
    private AppDefaultWin parentWin = null;
    private boolean continueProcessing = false;

    public boolean initialize() {
        Dimension dimension = this.getSize();
        this.pb_CLOSE = new ActionButton(Str.getStr(28), ImageSystem.getImageIcon((Object)this, 8), Str.getStr(203));
        this.pb_CREATE = new ActionButton(Str.getStr(171), ImageSystem.getImageIcon((Object)this, 59), Str.getStr(171));
        this.pb_EDIT = new ActionButton(Str.getStr(50), ImageSystem.getImageIcon((Object)this, 56), Str.getStr(50));
        this.pb_DELETE = new ActionButton(Str.getStr(172), ImageSystem.getImageIcon((Object)this, 58), Str.getStr(172));
        this.pb_DOWNLOAD = new ActionButton(Str.getStr(917), ImageSystem.getImageIcon((Object)this, 62), Str.getStr(917));
        this.navPanel = new FTPNavPanel(this);
        this.siteList = (Vector)QuestUtil.readObjectFromDisk("ftphist.ser");
        if (this.siteList == null) {
            this.siteList = new Vector(10, 1);
            this.siteList.addElement(new String("f3.pc.ibm.com"));
        }
        this.cb_FTPSITE = new JComboBox(this.siteList);
        this.pnl_FILELIST.setBackground(Color.white);
        this.pnl_FILELIST.setBorder(GUISystem.loweredBorder);
        this.pnl_FILELIST.setLayout(new BorderLayout());
        this.cnr_FILELIST.setBorder(null);
        this.cnr_FILELIST.setColumnHeadingBorder(null);
        this.cnr_FILELIST.setOpaque(true);
        this.cnr_FILELIST.setColumnHeadings(fileTitle);
        this.cnr_FILELIST.setColumnWidth(0, 25);
        this.cnr_FILELIST.setColumnWidth(1, 250);
        this.cnr_FILELIST.setColumnWidth(2, 50);
        this.cnr_FILELIST.setPreferredSize(new Dimension(100, dimension.height - 200));
        this.cb_FTPSITE.setEditable(true);
        this.st_DIRECTORY.setFont(FontSystem.largeTitleFont);
        this.mle_PREVIEW.setPreferredSize(new Dimension(100, 200));
        this.mle_PREVIEW.setEditorKit(new HTMLEditorKit());
        this.mle_PREVIEW.setEditable(false);
        this.cb_FTPSITE.addItemListener(this);
        this.pb_GO.addActionListener(this);
        this.pb_CLOSE.addActionListener(this);
        this.pb_DOWNLOAD.addActionListener(this);
        this.pb_CREATE.addActionListener(this);
        this.cnr_FILELIST.addListSelectionListener(this);
        this.add(this.st_FTPSITE);
        this.add(this.cb_FTPSITE);
        this.add(this.pb_GO);
        this.add(this.pnl_FILEPREV);
        this.pnl_FILELIST.add((Component)this.st_DIRECTORY, "North");
        this.pnl_FILELIST.add((Component)this.cnr_FILELIST, "Center");
        this.pnl_FILEPREV.add((Component)this.pnl_FILELIST, "top");
        this.pnl_FILEPREV.add((Component)this.scr_PREVIEW, "bottom");
        this.pnl_FILEPREV.setDividerLocation(0.9);
        return true;
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = GUISystem.getRowHeight();
        int n2 = this.st_FTPSITE.getPreferredSize().width;
        super.doLayout();
        this.st_FTPSITE.setBounds(2, 2, n2, n);
        this.cb_FTPSITE.setBounds(2 + n2, 2, dimension.width - 60 - n2, n);
        this.pb_GO.setBounds(dimension.width - 50, 2, 45, n);
        this.pnl_FILEPREV.setBounds(0, 4 + n, dimension.width, dimension.height - n);
        if (!this.firstShow && dimension.height > 0) {
            this.firstShow = true;
            this.pnl_FILEPREV.setDividerLocation(0.75);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.pb_GO) {
            this.currentFTPSite = (String)this.cb_FTPSITE.getSelectedItem();
            new Thread((Runnable)this, THREAD_CONNECT).start();
            return;
        }
        if (actionEvent.getSource() == this.pb_CREATE) {
            if (this.ftp != null) {
                this.create();
                return;
            }
            GUISystem.printBox(7, 904);
            return;
        }
        if (actionEvent.getSource() == this.pb_DOWNLOAD) {
            try {
                if (this.currentFileRec != null) {
                    File[] fileArray = GUISystem.getFileOpen(this.parentWin, Str.getStr(731), PropertySystem.getString(51), this.currentFileRec.getFilename(), false);
                    if (fileArray == null) return;
                    if (fileArray.length <= 0) return;
                    String string = fileArray[0].getAbsolutePath();
                    string = string.substring(0, string.lastIndexOf(File.separator));
                    PropertySystem.putString(51, string);
                    if (!this.downloadCurrentFile(string)) return;
                    GUISystem.printBox(7, 905);
                    return;
                }
                GUISystem.printBox(7, 358);
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
        if (actionEvent.getSource() != this.pb_CLOSE) return;
        try {
            if (this.connected) {
                this.ftp.doCommand("bye");
            }
            QuestUtil.writeObjectToDisk("ftphist.ser", this.siteList);
        }
        catch (Exception exception) {
        }
        this.parentWin.closePanel(this, null);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            String string = (String)this.cb_FTPSITE.getSelectedItem();
            if (!StoreUtil.vectorContains(this.siteList, string)) {
                this.siteList.insertElementAt(string, 0);
            }
            this.currentFTPSite = string;
            this.disconnect();
            new Thread((Runnable)this, THREAD_CONNECT).start();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void disconnect() {
        Qit.setEnabled(false);
        try {
            if (this.ftp != null) {
                this.parentWin.setStatus(Str.getStr(916));
                this.ftp.doCommand("bye");
                this.ftp = null;
                System.gc();
                this.parentWin.setStatus(null);
            }
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
        this.connected = false;
        Qit.setEnabled(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void connect() {
        this.navPanel.clear();
        this.cnr_FILELIST.removeAll();
        this.wholePath = "";
        this.parentWin.setStatus(Str.getStr(892) + " " + this.currentFTPSite);
        Qit.setEnabled(false);
        this.connected = false;
        try {
            FTPLogonDlg fTPLogonDlg = new FTPLogonDlg(this.parentWin);
            if (this.onInternalSite()) {
                this.ftp = new SunFTP(this.currentFTPSite, "anonymous", UserSystem.getUserId() + "@questInput.com");
                this.connected = true;
            } else if (fTPLogonDlg.getResponse()) {
                String string = fTPLogonDlg.getUserId();
                String string2 = fTPLogonDlg.getPassword();
                boolean bl = fTPLogonDlg.getAnonymous();
                if (bl) {
                    string = "anonymous";
                    string2 = UserSystem.getUserId() + "@QuestInput.com";
                }
                this.ftp = new SunFTP(this.currentFTPSite, string, string2);
                this.connected = true;
            } else {
                this.disconnect();
            }
            fTPLogonDlg = null;
            if (this.connected) {
                if (this.onInternalSite()) {
                    this.ftp.cd("pub/pccbbs");
                }
                this.refreshDirectories();
            }
        }
        catch (UnknownHostException unknownHostException) {
            GUISystem.printBox(Str.getStr(7), Str.getStr(906) + " " + this.currentFTPSite);
        }
        catch (Exception exception) {
            if (exception.toString().indexOf("Login incorrect") >= 0) {
                GUISystem.printBox(7, 907);
            }
            if (exception.toString().indexOf("Connection refused") >= 0) {
                GUISystem.printBox(7, 908);
            }
            LogSystem.log(1, exception);
        }
        Qit.setEnabled(true);
        this.parentWin.setStatus(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block5: {
            String string = Thread.currentThread().getName();
            this.continueProcessing = true;
            ProcessManagerSystem.addProcess(this);
            try {
                if (string.equals(THREAD_CONNECT)) {
                    this.connect();
                    break block5;
                }
                if (string.equals(THREAD_REFRESHDIRECTORIES)) {
                    this.refreshDirectories();
                    break block5;
                }
                if (string.equals(THREAD_REFRESHPREVIEW)) {
                    this.refreshPreview();
                }
            }
            catch (Exception exception) {
                LogSystem.log(1, exception);
            }
        }
        ProcessManagerSystem.removeProcess(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void refreshDirectories() {
        if (this.connected) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                Vector vector = null;
                int n = 0;
                long l = 0L;
                int n2 = 0;
                Vector<FTPFileRec> vector2 = new Vector<FTPFileRec>(10, 10);
                int n3 = 0;
                String string = null;
                this.parentWin.setStatus(Str.getStr(142));
                vector = this.ftp.lsDir();
                n3 = vector.size();
                this.fileVec = new Vector(10, 10);
                while (true) {
                    FTPFileRec fTPFileRec;
                    if (!this.continueProcessing || n >= n3) {
                        new QuickSort(vector2);
                        new QuickSort(this.fileVec);
                        this.cnr_FILELIST.removeAll();
                        this.cnr_FILELIST.add(vector2);
                        this.cnr_FILELIST.add(this.fileVec);
                        this.navPanel.clear();
                        this.navPanel.refreshList(vector2);
                        this.revalidate();
                        break;
                    }
                    string = (String)vector.elementAt(n);
                    if (string.startsWith("d")) {
                        fTPFileRec = this.parseFilename((String)vector.elementAt(n));
                        if (fTPFileRec != null) {
                            fTPFileRec.setDirectory(true);
                            fTPFileRec.autoSetIcon();
                            vector2.addElement(fTPFileRec);
                        }
                        ++n2;
                    } else {
                        fTPFileRec = this.parseFilename((String)vector.elementAt(n));
                        if (fTPFileRec != null) {
                            fTPFileRec.autoSetIcon();
                            fTPFileRec.setSize(l);
                            this.fileVec.addElement(fTPFileRec);
                        }
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                if (exception.toString().indexOf("Illegal PORT Command") >= 0) {
                    GUISystem.printBox(7, 909);
                    LogSystem.log(1, exception, false);
                }
                if (exception.toString().indexOf("No files found") >= 0) {
                    this.navPanel.clear();
                    this.cnr_FILELIST.removeAll();
                }
                if (exception.toString().indexOf("EOF") >= 0) {
                    GUISystem.printBox(7, 910);
                }
                LogSystem.log(1, exception);
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.parentWin.setStatus(null);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        FTPFileRec fTPFileRec;
        if (listSelectionEvent.getSource() == this.cnr_FILELIST && (fTPFileRec = (FTPFileRec)this.cnr_FILELIST.getSelectedItem()) != null) {
            if (fTPFileRec.getDirectory()) {
                this.changeDir(fTPFileRec.getFilename());
            } else {
                this.currentFileRec = fTPFileRec;
                new Thread((Runnable)this, THREAD_REFRESHPREVIEW).start();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final FTPFileRec parseFilename(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int n = 0;
        FTPFileRec fTPFileRec = null;
        try {
            stringTokenizer.nextElement();
            stringTokenizer.nextElement();
            stringTokenizer.nextElement();
            stringTokenizer.nextElement();
            n = new Integer((String)stringTokenizer.nextElement());
            stringTokenizer.nextElement();
            stringTokenizer.nextElement();
            stringTokenizer.nextElement();
            fTPFileRec = new FTPFileRec(((String)stringTokenizer.nextElement()).trim());
            fTPFileRec.setSize(n);
            return fTPFileRec;
        }
        catch (Exception exception) {
        }
        return fTPFileRec;
    }

    public long getFileSize(String string) {
        long l = 0L;
        return l;
    }

    public void enableComponents(boolean bl) {
        this.pb_GO.setEnabled(bl);
        this.cb_FTPSITE.setEnabled(bl);
        this.cnr_FILELIST.setEnabled(bl);
        this.pnl_FILELIST.setEnabled(bl);
        this.navPanel.setEnabled(bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void refreshPreview() {
        try {
            String string = this.currentFileRec.getType();
            String string2 = this.currentFileRec.getFilename();
            String string3 = PropertySystem.getString(30) + File.separator + string2;
            String string4 = "";
            String string5 = null;
            this.parentWin.setStatus(Str.getStr(323));
            string4 = "<html>";
            if (!this.onInternalSite()) {
                string4 = "<b>" + Str.getStr(456) + ":</b> " + string2 + "<b>";
            }
            string4 = string4 + "<b><u>" + Str.getStr(100) + ":</u></b><br>" + string5 + "<br><br>";
            string4 = string4 + "<hr>";
            if (string.equals("GIF") || string.equals("JPG")) {
                this.downloadCurrentFile(PropertySystem.getString(30) + File.separator);
                string4 = string4 + "<img src=\"file:/" + string3 + "\">";
            } else if (!(string.equals("EXE") || string.equals("PDF") || string.equals("DSK") || string.equals("ZIP") || string.equals("INF") || string.equals("COM") || string.equals("DOC") || string.equals("SYS") || string.equals("TAR"))) {
                String string6 = null;
                this.downloadCurrentFile(PropertySystem.getString(30) + File.separator);
                string6 = FileUtil.readFile(string3);
                string6 = Text.replaceAllStrInStr(string6, "\n", "<br>");
                string4 = string4 + string6 + "<br>";
            }
            string4 = string4 + "</html>";
            this.mle_PREVIEW.setText(string4);
            this.revalidate();
        }
        catch (Exception exception) {
            if (exception.toString().indexOf("denied") >= 0) {
                GUISystem.printBox(7, 912);
            } else if (exception.toString().indexOf("expired") >= 0) {
                // empty if block
            }
            exception.printStackTrace();
        }
        this.parentWin.setStatus(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void changeDir(String string) {
        try {
            this.ftp.cd(string);
            new Thread((Runnable)this, THREAD_REFRESHDIRECTORIES).start();
            return;
        }
        catch (Exception exception) {
            GUISystem.printBox(7, 913);
            LogSystem.log(1, exception, false);
        }
    }

    private final boolean onInternalSite() {
        return this.currentFTPSite.equals("f3.pc.ibm.com") || this.currentFTPSite.equals("ftp.pc.ibm.com");
    }

    private final boolean downloadCurrentFile(String string) {
        String string2 = this.currentFileRec.getFilename();
        boolean bl = false;
        return bl;
    }

    private final void create() {
        Object var1_1 = null;
        this.parentWin.setStatus(null);
    }

    public boolean copyText() {
        return false;
    }

    public boolean cutText() {
        return false;
    }

    public boolean pasteText() {
        return false;
    }

    public void panelSelected() {
    }

    public void panelDeselected() {
    }

    public void start() {
        this.parentWin = GUISystem.getParentDefWin(this);
        this.parentWin.addActionComponent(this, this.pb_CLOSE);
        this.parentWin.addActionComponent(this, this.pb_CREATE);
        this.parentWin.addActionComponent(this, this.pb_DOWNLOAD);
    }

    public boolean stop() {
        if (Qit.getEnabled()) {
            this.removeAll();
            return true;
        }
        return false;
    }

    public boolean shutdown() {
        return Qit.getEnabled();
    }

    public JComponent getJComponent() {
        return this;
    }

    public NavPanel getDefaultNavPanel() {
        return this.navPanel;
    }

    public ImageIcon getIcon() {
        return ImageSystem.getImageIcon((Object)this, 131);
    }

    public String getName() {
        return Str.getStr(897);
    }

    public void refresh() {
    }

    public boolean bookmark() {
        return false;
    }

    public String getProcessName() {
        return "FTPExplorerPanel ";
    }

    public void stopProcess() {
        this.continueProcessing = false;
    }
}

