/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.gui;

import com.ibm.nzna.projects.common.quest.type.TypeCustomerRec;
import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.DataLengths;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.gui.CustomerEntryPanelListener;
import com.ibm.nzna.projects.qit.gui.SelectCustomerDlg;
import com.ibm.nzna.projects.qit.product.ProductConst;
import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.util.LogSystem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CustomerEntryPanel
extends JPanel
implements ActionListener,
Runnable,
AppConst,
ProductConst,
DataLengths {
    private static final String THREAD_SEARCH = "SE";
    private static final String THREAD_FIRE_EVENT = "FE";
    private JTextField ef_CUST = new JTextField();
    private DButton pb_SELECTCUST = null;
    private Vector listeners = new Vector(1);
    private String lastCustomerSearch = "";
    private boolean inSearch = false;
    private Vector customerVec = null;
    private TypeCustomerRec customerRec = null;
    private boolean showFullName = true;
    private boolean continueThread = true;
    private String curTempCustomer = null;
    private boolean showManagerOnly = false;

    private final void init() {
        this.createControls();
        this.customerVec = (Vector)TypeList.getInstance().getTypeList(25).clone();
        new Thread((Runnable)this, THREAD_SEARCH).start();
    }

    private final void createControls() {
        this.setLayout(null);
        this.pb_SELECTCUST = new DButton(ImageSystem.getImageIcon((Object)this, 32));
        this.pb_SELECTCUST.setFocusPainted(false);
        this.pb_SELECTCUST.setBorderPainted(false);
        this.pb_SELECTCUST.setBackground(Color.white);
        this.pb_SELECTCUST.addActionListener(this);
        this.ef_CUST.addActionListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.ef_CUST, "Center");
        this.add((Component)this.pb_SELECTCUST, "East");
    }

    public String getText() {
        return this.ef_CUST.getText();
    }

    public void setText(String string) {
        if (string != null && string.length() > 0) {
            this.curTempCustomer = string;
            this.customerRec = this.findCustomer(string, true);
            this.refreshCustomerField();
        } else {
            this.ef_CUST.setText("");
        }
    }

    public void setShowFullName(boolean bl) {
        this.showFullName = bl;
        this.refreshCustomerField();
    }

    public boolean getShowFullName() {
        return this.showFullName;
    }

    public void run() {
        String string = Thread.currentThread().getName();
        if (string.equals(THREAD_SEARCH)) {
            this.search();
        } else if (string.equals(THREAD_FIRE_EVENT)) {
            this.fireEvent();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void search() {
        String string = null;
        String string2 = null;
        while (this.continueThread) {
            try {
                Thread.sleep(1500L);
            }
            catch (Exception exception) {
            }
            string = this.ef_CUST.getText();
            if (string != null && string.length() > 0 && this.lastCustomerSearch != null) {
                try {
                    Thread.sleep(300L);
                }
                catch (Exception exception) {
                }
                string2 = this.ef_CUST.getText();
                if (!string2.equals(string) || string2.equals(this.lastCustomerSearch)) continue;
                this.lastCustomerSearch = string2;
                this.customerRec = this.findCustomer(string2);
                this.refreshCustomerField();
                if (this.customerRec == null) continue;
                new Thread((Runnable)this, THREAD_FIRE_EVENT).start();
                continue;
            }
            this.customerRec = null;
        }
    }

    private final TypeCustomerRec findCustomer(String string) {
        return this.findCustomer(string, false);
    }

    private final TypeCustomerRec findCustomer(String string, boolean bl) {
        TypeCustomerRec typeCustomerRec = null;
        if (string != null && this.customerVec != null) {
            int n = 0;
            int n2 = this.customerVec.size();
            TypeCustomerRec typeCustomerRec2 = null;
            Vector<TypeCustomerRec> vector = new Vector<TypeCustomerRec>(1, 10);
            string = string.toUpperCase();
            while (n < n2) {
                typeCustomerRec2 = (TypeCustomerRec)this.customerVec.elementAt(n);
                if (typeCustomerRec2 != null) {
                    if (bl) {
                        if (typeCustomerRec2.toString().toUpperCase().equals(string)) {
                            vector.addElement(typeCustomerRec2);
                        }
                    } else if (typeCustomerRec2.toString().toUpperCase().startsWith(string)) {
                        vector.addElement(typeCustomerRec2);
                    }
                }
                ++n;
            }
            vector.trimToSize();
            if (vector.size() > 1) {
                Vector vector2 = null;
                vector2 = new SelectCustomerDlg(GUISystem.getParentFrame(this), vector, false).getResult();
                if (vector2 != null && vector2.size() > 0) {
                    typeCustomerRec2 = (TypeCustomerRec)vector2.elementAt(0);
                }
                typeCustomerRec = this.customerRec = typeCustomerRec2;
                this.refreshCustomerField();
            } else if (vector.size() == 1) {
                typeCustomerRec = (TypeCustomerRec)vector.elementAt(0);
            }
        }
        return typeCustomerRec;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void refreshCustomerField() {
        if (this.customerRec == null) {
            this.ef_CUST.setText("");
            return;
        }
        if (this.showFullName) {
            this.ef_CUST.setText(this.customerRec.toString());
        }
        try {
            this.ef_CUST.setSelectionStart(this.lastCustomerSearch.length());
            this.ef_CUST.setSelectionEnd(this.ef_CUST.getText().length());
        }
        catch (Exception exception) {
        }
        this.lastCustomerSearch = this.ef_CUST.getText();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            if (!(actionEvent.getSource() instanceof DButton)) {
                if (!(actionEvent.getSource() instanceof JTextField)) return;
                String string = this.ef_CUST.getText();
                this.customerRec = this.findCustomer(string);
                this.refreshCustomerField();
                return;
            }
            DButton dButton = (DButton)actionEvent.getSource();
            if (this.pb_SELECTCUST != dButton) return;
            Vector vector = null;
            vector = new SelectCustomerDlg(GUISystem.getParentFrame(this), false).getResult();
            if (vector != null && vector.size() > 0) {
                this.customerRec = (TypeCustomerRec)vector.elementAt(0);
            }
            this.refreshCustomerField();
            return;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
    }

    public void stop() {
        this.continueThread = false;
    }

    public String getName() {
        String string = null;
        if (this.customerRec != null) {
            string = this.customerRec.toString();
        }
        return string;
    }

    public TypeCustomerRec getCustomerRec() {
        if (this.customerRec == null) {
            this.customerRec = this.findCustomer(this.ef_CUST.getText());
        }
        return this.customerRec;
    }

    public TypeCustomerRec getCustomerRecNoLookup() {
        return this.customerRec;
    }

    public String getDescript() {
        String string = null;
        if (this.customerRec != null) {
            string = this.customerRec.toString();
        }
        return string;
    }

    public void requestFocus() {
        this.ef_CUST.requestFocus();
    }

    public void setEnabled(boolean bl) {
        this.ef_CUST.setEnabled(bl);
        this.pb_SELECTCUST.setEnabled(bl);
        super.setEnabled(bl);
    }

    private final void fireEvent() {
        int n = 0;
        int n2 = this.listeners.size();
        while (n < n2) {
            ((CustomerEntryPanelListener)this.listeners.elementAt(n)).customerSelected(this.customerRec);
            ++n;
        }
    }

    public void addCustomerEntryPanelListener(CustomerEntryPanelListener customerEntryPanelListener) {
        this.listeners.addElement(customerEntryPanelListener);
    }

    public void removeCustomerEntryPanelListener(CustomerEntryPanelListener customerEntryPanelListener) {
        this.listeners.removeElement(customerEntryPanelListener);
    }

    public CustomerEntryPanel() {
        this.init();
    }
}

