/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.gui;

import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.PropertyListener;
import com.ibm.nzna.projects.qit.app.PropertySystem;
import com.ibm.nzna.projects.qit.app.ThemeSystem;
import com.ibm.nzna.projects.qit.gui.NavList;
import com.ibm.nzna.projects.qit.gui.NavListExpandListener;
import com.ibm.nzna.projects.qit.gui.NavListGroup;
import com.ibm.nzna.projects.qit.gui.NavPanel;
import com.ibm.nzna.projects.qit.gui.NavPanelHeader;
import com.ibm.nzna.shared.gui.AntiAliasPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;

class NavHoldPanel
extends AntiAliasPanel
implements NavListExpandListener,
AppConst,
PropertyListener {
    private NavPanelHeader navHeader = null;
    private NavPanel navPanel = null;
    private int width = 0;
    private int height = 0;
    private boolean showSkin = false;
    private Dimension prefSize = new Dimension(200, 150);

    public Dimension getPreferredSize() {
        return this.prefSize;
    }

    public Dimension getMinimumSize() {
        return this.prefSize;
    }

    protected void addNavPanelHeader(NavPanelHeader navPanelHeader) {
        boolean bl = true;
        this.navHeader = navPanelHeader;
        if (this.navPanel != null) {
            navPanelHeader.setTitle(this.navPanel.getTitle());
        }
        this.add((Component)navPanelHeader, "North");
    }

    protected void addNavPanel(NavPanel navPanel) {
        this.navPanel = navPanel;
        if (navPanel != null && navPanel.getJComponent() != null) {
            this.add((Component)navPanel.getJComponent(), "Center");
            if (this.navHeader != null) {
                if (navPanel.getTitle() != null && navPanel.getTitle().length() > 0) {
                    this.navHeader.setTitle(navPanel.getTitle());
                    this.navHeader.setVisible(true);
                } else {
                    this.navHeader.setVisible(false);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void propertyChanged(int n, Object object) {
        try {
            switch (n) {
                case 1: {
                    if (this.navPanel != null) {
                        this.navHeader.setTitle(this.navPanel.getTitle());
                    }
                }
                case 9: 
                case 21: {
                    Color color = ThemeSystem.getColor("NAVPANEL_BG_COLOR");
                    this.showSkin = PropertySystem.getBool(9);
                    if (this.showSkin) {
                        GUISystem.setComponentOpaque(this, false);
                        this.setBorder(null);
                    } else {
                        this.setBorder(GUISystem.loweredBorder);
                    }
                    this.invalidate();
                    this.repaint();
                    return;
                }
            }
            this.setAntiAlias(PropertySystem.getBool(82));
            return;
        }
        catch (Exception exception) {
        }
    }

    public void free() {
        PropertySystem.removePropertyListener(82, this);
        PropertySystem.removePropertyListener(1, this);
        PropertySystem.removePropertyListener(9, this);
        PropertySystem.removePropertyListener(21, this);
    }

    public Component add(Component component) {
        component = super.add(component);
        this.addComponent(component);
        return component;
    }

    public Component add(String string, Component component) {
        component = super.add(string, component);
        this.addComponent(component);
        return component;
    }

    public void add(Component component, Object object) {
        super.add(component, object);
        this.addComponent(component);
    }

    public Component add(Component component, int n) {
        component = super.add(component, n);
        this.addComponent(component);
        return component;
    }

    private final void addComponent(Component component) {
        if (component instanceof NavListGroup || component instanceof NavList || component instanceof Container) {
            this.addNavListExpandListeners((Container)component);
        }
    }

    private final void addNavListExpandListeners(Container container) {
        if (container instanceof NavListGroup) {
            ((NavListGroup)container).addExpandListener(this);
        } else {
            Object var2_2 = null;
            Component[] componentArray = container.getComponents();
            if (componentArray != null) {
                int n = 0;
                while (n < componentArray.length) {
                    if (componentArray[n] instanceof NavListGroup || componentArray[n] instanceof Container) {
                        this.addNavListExpandListeners((Container)componentArray[n]);
                    }
                    ++n;
                }
            }
        }
    }

    public void expanded(NavListGroup navListGroup, boolean bl) {
        if (!bl) {
            this.invalidate();
            this.repaint();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NavHoldPanel() {
        try {
            this.setLayout(new BorderLayout(0, 0));
            PropertySystem.addPropertyListener(82, this);
            PropertySystem.addPropertyListener(1, this);
            PropertySystem.addPropertyListener(9, this);
            PropertySystem.addPropertyListener(21, this);
            this.showSkin = PropertySystem.getBool(9);
            this.propertyChanged(21, null);
            this.setAntiAlias(PropertySystem.getBool(82));
            if (this.showSkin) return;
            this.setBorder(GUISystem.loweredBorder);
            return;
        }
        catch (Exception exception) {
        }
    }
}

