/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.gui;

import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.gui.DPanel;
import com.ibm.nzna.shared.gui.HotLinkLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

public class NavList
extends DPanel
implements ActionListener {
    private static final Font defaultFont = new Font("SansSerif", 0, 12);
    private static final Insets insets = new Insets(0, 0, 0, 0);
    private Dimension prefSize = new Dimension(0, 0);
    private DButton curSelectedButton = null;
    private Vector actionListenerVec = null;

    public Component add(Component component) {
        if (component instanceof DButton) {
            DButton dButton = (DButton)component;
            dButton.setMargin(insets);
            dButton.actAsLink(true);
            dButton.setFont(defaultFont);
            dButton.setBorder(null);
            dButton.setFocusPainted(false);
            dButton.setOpaque(false);
            dButton.setContentAreaFilled(false);
            dButton.addActionListener(this);
            dButton.setHorizontalAlignment(2);
            dButton.setHighlightForeground(Color.blue);
        } else if (component instanceof HotLinkLabel) {
            ((HotLinkLabel)component).addActionListener(this);
        }
        this.invalidate();
        return super.add(component);
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        Component[] componentArray = this.getComponents();
        int n = 0;
        Insets insets = this.getInsets();
        int n2 = 0;
        int n3 = 0;
        if (insets == null) {
            n3 = 0;
        } else {
            insets.left += 2;
            n3 = insets.left;
            n2 = insets.top;
            dimension.width -= insets.right - insets.left;
            dimension.height -= insets.top - insets.bottom;
        }
        if (componentArray != null && componentArray.length >= 0) {
            Dimension dimension2 = null;
            while (n < componentArray.length) {
                dimension2 = componentArray[n].getPreferredSize();
                componentArray[n].setBounds(n3, n2, dimension.width - n3 * 2, dimension2.height);
                n2 += dimension2.height;
                ++n;
            }
        }
        super.doLayout();
    }

    public Dimension getPreferredSize() {
        Component[] componentArray = this.getComponents();
        int n = 0;
        if (componentArray != null && componentArray.length > 0) {
            Dimension dimension = null;
            this.prefSize.height = 0;
            this.prefSize.width = 0;
            while (n < componentArray.length) {
                dimension = componentArray[n].getPreferredSize();
                this.prefSize.height += dimension.height;
                if (dimension.width > this.prefSize.width) {
                    this.prefSize.width = dimension.width;
                }
                ++n;
            }
        }
        return this.prefSize;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public DButton getSelectedButton() {
        return this.curSelectedButton;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof DButton) {
            DButton dButton = (DButton)actionEvent.getSource();
            this.setFonts(defaultFont);
            this.curSelectedButton = dButton;
            this.repaint();
            this.fireActionEvent(actionEvent);
        } else if (actionEvent.getSource() instanceof HotLinkLabel) {
            HotLinkLabel hotLinkLabel = (HotLinkLabel)actionEvent.getSource();
            this.fireActionEvent(actionEvent);
        }
    }

    private final void setFonts(Font font) {
        Component[] componentArray = this.getComponents();
        int n = 0;
        if (componentArray != null && componentArray.length > 0) {
            while (n < componentArray.length) {
                componentArray[n].setFont(font);
                ++n;
            }
        }
        this.invalidate();
    }

    public void add(Vector vector) {
        if (vector != null && vector.size() > 0) {
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                this.add((Component)vector.elementAt(n));
                ++n;
            }
        }
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.actionListenerVec == null) {
            this.actionListenerVec = new Vector(1, 1);
        }
        this.actionListenerVec.addElement(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        if (this.actionListenerVec != null) {
            this.actionListenerVec.removeElement(actionListener);
            this.actionListenerVec.trimToSize();
            if (this.actionListenerVec.size() == 0) {
                this.actionListenerVec = null;
            }
        }
    }

    private final void fireActionEvent(ActionEvent actionEvent) {
        if (this.actionListenerVec != null && this.actionListenerVec.size() > 0) {
            int n = 0;
            int n2 = this.actionListenerVec.size();
            while (n < n2) {
                ((ActionListener)this.actionListenerVec.elementAt(n)).actionPerformed(actionEvent);
                ++n;
            }
        }
    }

    public boolean contains(Component component) {
        Component[] componentArray = this.getComponents();
        int n = 0;
        boolean bl = false;
        if (componentArray != null && componentArray.length > 0) {
            while (!bl && n < componentArray.length) {
                if (componentArray[n] == component) {
                    bl = true;
                }
                ++n;
            }
        }
        return bl;
    }

    protected void scrollSmooth(int n, int n2) {
        Graphics graphics = this.getGraphics();
        Dimension dimension = this.getSize();
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = true;
        if (n2 > 0 && graphics != null) {
            n3 = 0;
            while (n3 < n2) {
                ++n3;
            }
            graphics.copyArea(0, n + n3, dimension.width, dimension.height - (n + n3) - 1, 0, 1);
        } else if (n2 < 0 && graphics != null) {
            n2 = Math.abs(n2);
            n3 = 0;
            while (n3 < n2) {
                ++n3;
            }
            graphics.copyArea(0, n - n3, dimension.width, dimension.height - (n - n3) - 1, 0, -1);
        }
        this.revalidate();
    }

    public NavList() {
        this.setLayout(null);
        this.setBackground(Color.white);
    }
}

