/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.gui;

import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.FontSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserRec;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.gui.JTitle;
import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.gui.MaskDocument;
import com.ibm.nzna.shared.gui.MultiList;
import com.ibm.nzna.shared.sort.QuickSort;
import com.ibm.nzna.shared.util.ComponentPopFocus;
import com.ibm.nzna.shared.util.WinUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class SelectUserDlg
extends JDialog
implements ActionListener,
AppConst {
    private static final String[] userTitle = new String[]{Str.getStr(4), Str.getStr(99)};
    private JLabel st_DESCRIPT = new JLabel(Str.getStr(409));
    private MultiList userList = new MultiList(GUISystem.getFontUtil());
    private JPanel pnl_USERLIST = new JPanel();
    private JTitle st_TITLE = new JTitle(Str.getStr(403));
    private DButton pb_SELECT = new DButton(Str.getStr(404));
    private DButton pb_CANCEL = new DButton(Str.getStr(2));
    private DButton pb_SEARCH = new DButton(Str.getStr(15));
    private JPanel brd_SEARCH = new JPanel();
    private JPanel brd_USERS = new JPanel();
    private JTextField ef_SEARCH = new JTextField(new MaskDocument(0, 80), "", 0);
    private UserRec userRec = null;
    private Vector retVec = null;
    private Vector userVec = null;
    private boolean multiple = false;
    private boolean showManagersOnly = false;
    private int rowHeight = 18;

    private final void init() {
        this.setResizable(false);
        this.createControls();
        this.refreshList();
        ((Component)this).setSize(340, 300);
        WinUtil.centerWindow(this);
        this.addWindowListener(new ComponentPopFocus(this.ef_SEARCH));
    }

    public Vector getResult() {
        ((Component)this).setVisible(true);
        return this.retVec;
    }

    public void createControls() {
        this.userList.setColumnHeadings(userTitle);
        this.userList.setColumnWidth(1, 250);
        this.userList.setForeground(Color.black);
        this.userList.setRowHeight(18);
        this.brd_SEARCH.setBorder(new TitledBorder(Str.getStr(15)));
        this.brd_USERS.setBorder(new TitledBorder(""));
        this.brd_SEARCH.setLayout(null);
        this.brd_USERS.setLayout(null);
        this.userList.setBorder(null);
        this.userList.showColumnHeadings(false);
        this.pnl_USERLIST.setBackground(Color.white);
        this.pnl_USERLIST.setBorder(GUISystem.loweredBorder);
        this.st_TITLE.setFont(FontSystem.defaultFont);
        this.pnl_USERLIST.setLayout(new BorderLayout());
        this.pnl_USERLIST.add((Component)this.st_TITLE, "North");
        this.pnl_USERLIST.add(this.userList);
        this.brd_SEARCH.add(this.ef_SEARCH);
        this.brd_SEARCH.add(this.pb_SEARCH);
        this.brd_USERS.add(this.pnl_USERLIST);
        this.ef_SEARCH.setBounds(10, 15, 200, this.rowHeight);
        this.pb_SEARCH.setBounds(210, 15, 90, this.rowHeight);
        this.pnl_USERLIST.setBounds(10, 15, 300, 150);
        this.ef_SEARCH.addActionListener(this);
        this.pb_SEARCH.addActionListener(this);
        this.userList.addActionListener(this);
        this.pb_CANCEL.addActionListener(this);
        this.pb_SELECT.addActionListener(this);
        this.getContentPane().setLayout(null);
        this.getContentPane().add(this.brd_SEARCH);
        this.getContentPane().add(this.brd_USERS);
        this.getContentPane().add(this.pb_SELECT);
        this.getContentPane().add(this.pb_CANCEL);
    }

    public void refreshList() {
        if (this.userVec == null) {
            Vector vector = null;
            vector = this.showManagersOnly ? UserSystem.getManagerList() : UserSystem.getAllUserVec();
            new QuickSort(vector);
            if (vector != null) {
                this.userList.add(vector);
            }
        } else {
            this.userList.add(this.userVec);
        }
        if (this.userRec != null) {
            this.userList.setSelectedItem(this.userRec, true);
        }
        this.ef_SEARCH.requestFocus();
        this.userList.paintAll(this.userList.getGraphics());
    }

    public void doLayout() {
        int n = 10;
        int n2 = 10;
        Dimension dimension = this.getSize();
        super.doLayout();
        dimension.height -= 30;
        this.brd_SEARCH.setBounds(n, n2, dimension.width - n * 2, this.rowHeight * 2 + 5);
        this.brd_USERS.setBounds(n, n2 += this.rowHeight * 2 + 5, dimension.width - n * 2, dimension.height - 50 - n2);
        this.pb_SELECT.setBounds(n, dimension.height - 40, 70, 25);
        this.pb_CANCEL.setBounds(n + 75, dimension.height - 40, 90, 25);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.ef_SEARCH) {
            this.search();
        } else if (actionEvent.getSource() instanceof DButton) {
            DButton dButton = (DButton)actionEvent.getSource();
            if (this.pb_CANCEL == dButton) {
                this.retVec = null;
                this.dispose();
            } else if (this.pb_SEARCH == dButton) {
                this.search();
            } else if (this.pb_SELECT == dButton && this.saveData()) {
                this.dispose();
            }
        } else if (actionEvent.getSource() == this.userList && this.saveData()) {
            this.dispose();
        }
    }

    public boolean saveData() {
        boolean bl = false;
        this.retVec = this.userList.getSelection();
        if (this.retVec == null) {
            GUISystem.printBox(Str.getStr(6), Str.getStr(358));
        } else {
            bl = true;
        }
        return bl;
    }

    private final void search() {
        String string = this.ef_SEARCH.getText();
        if (string != null && string.length() > 0) {
            Vector vector = UserSystem.getAllUserVec();
            int n = 0;
            string = string.toUpperCase();
            if (vector != null) {
                int n2 = 0;
                boolean bl = false;
                UserRec userRec = null;
                n2 = vector.size();
                while (!bl && n < n2) {
                    userRec = (UserRec)vector.elementAt(n);
                    if (userRec != null && userRec.getUserId().toUpperCase().indexOf(string) != -1 || userRec.getName().toUpperCase().indexOf(string) != -1) {
                        bl = true;
                    }
                    ++n;
                }
                if (bl) {
                    this.userList.setSelectedItem(userRec, true);
                }
            }
        }
    }

    public SelectUserDlg(Frame frame) {
        super(frame, Str.getStr(409), true);
        this.init();
    }

    public SelectUserDlg(Frame frame, boolean bl) {
        super(frame, Str.getStr(409), true);
        this.multiple = bl;
        this.init();
    }

    public SelectUserDlg(Frame frame, boolean bl, boolean bl2) {
        super(frame, Str.getStr(409), true);
        this.showManagersOnly = bl2;
        this.multiple = bl;
        this.init();
    }

    public SelectUserDlg(Frame frame, Vector vector) {
        super(frame, Str.getStr(409), true);
        this.userVec = vector;
        this.multiple = this.multiple;
        this.init();
    }

    public SelectUserDlg(Frame frame, Vector vector, boolean bl) {
        super(frame, Str.getStr(409), true);
        this.userVec = vector;
        this.multiple = bl;
        this.init();
    }

    public SelectUserDlg(Frame frame, Vector vector, boolean bl, boolean bl2) {
        super(frame, Str.getStr(409), true);
        this.showManagersOnly = bl2;
        this.userVec = vector;
        this.multiple = bl;
        this.init();
    }

    public SelectUserDlg(Frame frame, UserRec userRec) {
        super(frame, Str.getStr(409), true);
        this.userRec = userRec;
        this.init();
    }

    public SelectUserDlg(JDialog jDialog) {
        super(jDialog, Str.getStr(409), true);
        this.init();
    }

    public SelectUserDlg(JDialog jDialog, boolean bl) {
        super(jDialog, Str.getStr(409), true);
        this.multiple = bl;
        this.init();
    }

    public SelectUserDlg(JDialog jDialog, boolean bl, boolean bl2) {
        super(jDialog, Str.getStr(409), true);
        this.showManagersOnly = bl2;
        this.multiple = bl;
        this.init();
    }

    public SelectUserDlg(JDialog jDialog, Vector vector) {
        super(jDialog, Str.getStr(409), true);
        this.userVec = vector;
        this.multiple = this.multiple;
        this.init();
    }

    public SelectUserDlg(JDialog jDialog, Vector vector, boolean bl) {
        super(jDialog, Str.getStr(409), true);
        this.userVec = vector;
        this.multiple = bl;
        this.init();
    }

    public SelectUserDlg(JDialog jDialog, Vector vector, boolean bl, boolean bl2) {
        super(jDialog, Str.getStr(409), true);
        this.showManagersOnly = bl2;
        this.userVec = vector;
        this.multiple = bl;
        this.init();
    }

    public SelectUserDlg(JDialog jDialog, UserRec userRec) {
        super(jDialog, Str.getStr(409), true);
        this.userRec = userRec;
        this.init();
    }
}

