/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.gui;

import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.projects.common.quest.type.TypeWarrantyRec;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.DataLengths;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.gui.SelectWarrantyDlg;
import com.ibm.nzna.projects.qit.gui.WarrantyEntryPanelListener;
import com.ibm.nzna.projects.qit.product.ProductConst;
import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.util.LogSystem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class WarrantyEntryPanel
extends JPanel
implements ActionListener,
Runnable,
AppConst,
ProductConst,
DataLengths {
    private static final String THREAD_SEARCH = "SE";
    private static final String THREAD_FIRE_EVENT = "FE";
    private JTextField ef_WARR = new JTextField();
    private DButton pb_SELECTWARR = null;
    private Vector listeners = new Vector(1);
    private String lastWarrantySearch = "";
    private boolean inSearch = false;
    private Vector warrantyVec = null;
    private TypeWarrantyRec warrantyRec = null;
    private boolean showFullName = true;
    private boolean continueThread = true;
    private String curTempWarranty = null;
    private boolean showManagerOnly = false;

    private final void init() {
        this.createControls();
        this.warrantyVec = (Vector)TypeList.getInstance().getTypeList(26).clone();
        new Thread((Runnable)this, THREAD_SEARCH).start();
    }

    private final void createControls() {
        this.setLayout(null);
        this.pb_SELECTWARR = new DButton(ImageSystem.getImageIcon((Object)this, 32));
        this.pb_SELECTWARR.setFocusPainted(false);
        this.pb_SELECTWARR.setBorderPainted(false);
        this.pb_SELECTWARR.setBackground(Color.white);
        this.pb_SELECTWARR.addActionListener(this);
        this.ef_WARR.addActionListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.ef_WARR, "Center");
        this.add((Component)this.pb_SELECTWARR, "East");
    }

    public String getText() {
        return this.ef_WARR.getText();
    }

    public void setText(String string) {
        if (string != null && string.length() > 0) {
            this.curTempWarranty = string;
            this.warrantyRec = this.findWarranty(string, true);
            this.refreshWarrantyField();
        } else {
            this.ef_WARR.setText("");
        }
    }

    public void setShowFullName(boolean bl) {
        this.showFullName = bl;
        this.refreshWarrantyField();
    }

    public boolean getShowFullName() {
        return this.showFullName;
    }

    public void run() {
        String string = Thread.currentThread().getName();
        if (string.equals(THREAD_SEARCH)) {
            this.search();
        } else if (string.equals(THREAD_FIRE_EVENT)) {
            this.fireEvent();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void search() {
        String string = null;
        String string2 = null;
        while (this.continueThread) {
            try {
                Thread.sleep(1500L);
            }
            catch (Exception exception) {
            }
            string = this.ef_WARR.getText();
            if (string != null && string.length() > 0 && this.lastWarrantySearch != null) {
                try {
                    Thread.sleep(300L);
                }
                catch (Exception exception) {
                }
                string2 = this.ef_WARR.getText();
                if (!string2.equals(string) || string2.equals(this.lastWarrantySearch)) continue;
                this.lastWarrantySearch = string2;
                this.warrantyRec = this.findWarranty(string2);
                this.refreshWarrantyField();
                if (this.warrantyRec == null) continue;
                new Thread((Runnable)this, THREAD_FIRE_EVENT).start();
                continue;
            }
            this.warrantyRec = null;
        }
    }

    private final TypeWarrantyRec findWarranty(String string) {
        return this.findWarranty(string, false);
    }

    private final TypeWarrantyRec findWarranty(String string, boolean bl) {
        TypeWarrantyRec typeWarrantyRec = null;
        if (string != null && this.warrantyVec != null) {
            int n = 0;
            int n2 = this.warrantyVec.size();
            TypeWarrantyRec typeWarrantyRec2 = null;
            Vector<TypeWarrantyRec> vector = new Vector<TypeWarrantyRec>(1, 10);
            string = string.toUpperCase();
            while (n < n2) {
                typeWarrantyRec2 = (TypeWarrantyRec)this.warrantyVec.elementAt(n);
                if (typeWarrantyRec2 != null) {
                    if (bl) {
                        if (typeWarrantyRec2.toString().toUpperCase().equals(string)) {
                            vector.addElement(typeWarrantyRec2);
                        }
                    } else if (typeWarrantyRec2.toString().toUpperCase().startsWith(string)) {
                        vector.addElement(typeWarrantyRec2);
                    }
                }
                ++n;
            }
            vector.trimToSize();
            if (vector.size() > 1) {
                Vector vector2 = null;
                vector2 = new SelectWarrantyDlg(GUISystem.getParentFrame(this), vector, false).getResult();
                if (vector2 != null && vector2.size() > 0) {
                    typeWarrantyRec2 = (TypeWarrantyRec)vector2.elementAt(0);
                }
                typeWarrantyRec = this.warrantyRec = typeWarrantyRec2;
                this.refreshWarrantyField();
            } else if (vector.size() == 1) {
                typeWarrantyRec = (TypeWarrantyRec)vector.elementAt(0);
            }
        }
        return typeWarrantyRec;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void refreshWarrantyField() {
        if (this.warrantyRec == null) {
            this.ef_WARR.setText("");
            return;
        }
        if (this.showFullName) {
            this.ef_WARR.setText(this.warrantyRec.toString());
        }
        try {
            this.ef_WARR.setSelectionStart(this.lastWarrantySearch.length());
            this.ef_WARR.setSelectionEnd(this.ef_WARR.getText().length());
        }
        catch (Exception exception) {
        }
        this.lastWarrantySearch = this.ef_WARR.getText();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            if (!(actionEvent.getSource() instanceof DButton)) {
                if (!(actionEvent.getSource() instanceof JTextField)) return;
                String string = this.ef_WARR.getText();
                this.warrantyRec = this.findWarranty(string);
                this.refreshWarrantyField();
                return;
            }
            DButton dButton = (DButton)actionEvent.getSource();
            if (this.pb_SELECTWARR != dButton) return;
            Vector vector = null;
            vector = new SelectWarrantyDlg(GUISystem.getParentFrame(this), false).getResult();
            if (vector != null && vector.size() > 0) {
                this.warrantyRec = (TypeWarrantyRec)vector.elementAt(0);
            }
            this.refreshWarrantyField();
            return;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
    }

    public void stop() {
        this.continueThread = false;
    }

    public String getName() {
        String string = null;
        if (this.warrantyRec != null) {
            string = this.warrantyRec.toString();
        }
        return string;
    }

    public TypeWarrantyRec getWarrantyRec() {
        if (this.warrantyRec == null) {
            this.warrantyRec = this.findWarranty(this.ef_WARR.getText());
        }
        return this.warrantyRec;
    }

    public TypeWarrantyRec getWarrantyRecNoLookup() {
        return this.warrantyRec;
    }

    public String getDescript() {
        String string = null;
        if (this.warrantyRec != null) {
            string = this.warrantyRec.toString();
        }
        return string;
    }

    public void requestFocus() {
        this.ef_WARR.requestFocus();
    }

    public void setEnabled(boolean bl) {
        this.ef_WARR.setEnabled(bl);
        this.pb_SELECTWARR.setEnabled(bl);
        super.setEnabled(bl);
    }

    private final void fireEvent() {
        int n = 0;
        int n2 = this.listeners.size();
        while (n < n2) {
            ((WarrantyEntryPanelListener)this.listeners.elementAt(n)).warrantySelected(this.warrantyRec);
            ++n;
        }
    }

    public void addWarrantyEntryPanelListener(WarrantyEntryPanelListener warrantyEntryPanelListener) {
        this.listeners.addElement(warrantyEntryPanelListener);
    }

    public void removeWarrantyEntryPanelListener(WarrantyEntryPanelListener warrantyEntryPanelListener) {
        this.listeners.removeElement(warrantyEntryPanelListener);
    }

    public WarrantyEntryPanel() {
        this.init();
    }
}

