/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.gui.popup;

import com.ibm.nzna.projects.common.quest.LocaleRec;
import com.ibm.nzna.projects.common.quest.type.TypeCountryCodeRec;
import com.ibm.nzna.projects.common.quest.type.TypeGeoRec;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.dbgui.LocaleDlg;
import com.ibm.nzna.projects.qit.dbgui.LocaleDlgListener;
import com.ibm.nzna.projects.qit.gui.popup.PopUpDlg;
import com.ibm.nzna.projects.qit.gui.popup.PopUpPanel;
import com.ibm.nzna.projects.qit.product.ProductConst;
import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.util.LogSystem;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PopUpLocation
extends PopUpPanel
implements ProductConst,
AppConst,
ActionListener,
LocaleDlgListener,
ListSelectionListener {
    private JLabel st_DESCRIPT = new JLabel(Str.getStr(20026));
    private JList results = new JList();
    private JScrollPane j_SCROLL_PANE = new JScrollPane(this.results);
    private DButton add = new DButton(Str.getStr(95));
    private DButton remove = new DButton(Str.getStr(96));
    private DButton worldWide = new DButton(Str.getStr(210));
    LocaleRec localeRec = null;
    private int rowHeight = GUISystem.getRowHeight();

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = 0;
        super.doLayout();
        this.st_DESCRIPT.setBounds(140, 0, dimension.width, this.rowHeight);
        this.j_SCROLL_PANE.setBounds(60, n += this.rowHeight + 2, 300, this.rowHeight * 6);
        this.add.setBounds(90, n += this.rowHeight + 100, 70, this.rowHeight);
        this.remove.setBounds(170, n, 70, this.rowHeight);
        this.worldWide.setBounds(250, n, 70, this.rowHeight);
    }

    public void setDescript(String string) {
    }

    public Object saveData() {
        LocaleRec localeRec = null;
        if (this.requireData) {
            if (!this.localeRec.isWorldWide() && this.localeRec.countryCount() == 0) {
                GUISystem.printBox(Str.getStr(6), Str.getStr(358));
            } else {
                localeRec = this.localeRec;
            }
        }
        return localeRec;
    }

    public void refreshData(Object object) {
        if (object instanceof LocaleRec) {
            LocaleRec localeRec = (LocaleRec)object;
            this.setDefaults(localeRec);
        }
    }

    private void setDefaults(LocaleRec localeRec) {
        this.localeRec = localeRec;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.add) {
            LocaleDlg localeDlg = new LocaleDlg(GUISystem.getParentDefWin(this));
            localeDlg.setLocaleDlgListener(this);
            localeDlg.waitForUser();
        } else if (actionEvent.getSource() == this.remove) {
            this.removeItem();
        } else if (actionEvent.getSource() == this.worldWide) {
            if (this.localeRec == null) {
                this.localeRec = new LocaleRec();
            }
            this.localeRec.setWorldWide(true);
            this.populateList(this.localeRec);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.isEnabled()) {
            this.remove.setEnabled(this.results.getSelectedValue() != null);
        }
    }

    public void localeDlgAddCountries(Object[] objectArray) {
        try {
            if (this.localeRec == null) {
                this.localeRec = new LocaleRec();
            }
            int n = 0;
            while (n < objectArray.length) {
                this.localeRec.addCountry((TypeCountryCodeRec)objectArray[n]);
                ++n;
            }
            this.populateList(this.localeRec);
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
    }

    public void localeDlgAddGeo(TypeGeoRec typeGeoRec) {
        try {
            if (this.localeRec == null) {
                this.localeRec = new LocaleRec();
            }
            this.localeRec.addGeography(typeGeoRec);
            this.populateList(this.localeRec);
        }
        catch (Exception exception) {
            LogSystem.log(1, exception, false);
        }
    }

    public void setMultiSelect(boolean bl) {
        if (bl) {
            this.results.setSelectionMode(2);
        } else {
            this.results.setSelectionMode(0);
        }
    }

    public void setRequired(boolean bl) {
        this.requireData = bl;
    }

    private void removeItem() {
        Object[] objectArray = this.results.getSelectedValues();
        if (objectArray != null && objectArray.length > 0 && this.localeRec != null) {
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] instanceof TypeGeoRec) {
                    this.localeRec.removeGeography((TypeGeoRec)objectArray[n]);
                } else if (objectArray[n] instanceof TypeCountryCodeRec) {
                    this.localeRec.removeCountry((TypeCountryCodeRec)objectArray[n]);
                } else if (objectArray[n] instanceof String) {
                    this.localeRec.setWorldWide(false);
                }
                ++n;
            }
            this.populateList(this.localeRec);
        }
    }

    public void populateList(LocaleRec localeRec) {
        DefaultListModel defaultListModel = (DefaultListModel)this.results.getModel();
        defaultListModel.clear();
        if (localeRec != null) {
            if (this.isEnabled()) {
                this.worldWide.setEnabled(!localeRec.isWorldWide());
                this.add.setEnabled(!localeRec.isWorldWide());
            }
            if (localeRec.isWorldWide()) {
                Vector vector = new Vector(1);
                defaultListModel.addElement("<html><body><font size=5><b>" + Str.getStr(210) + "</b></font></body></html>");
            } else {
                int n;
                int n2;
                Vector vector = localeRec.getGeoListContainingAll();
                Vector vector2 = localeRec.getSingleCountryList();
                if (vector != null && vector.size() > 0) {
                    n2 = 0;
                    n = vector.size();
                    while (n2 < n) {
                        if (!((TypeGeoRec)vector.elementAt(n2)).valid()) continue;
                        ((TypeGeoRec)vector.elementAt(n2)).setEnhanceOutput(true);
                        defaultListModel.addElement(vector.elementAt(n2++));
                    }
                }
                if (vector2 != null && vector2.size() > 0) {
                    n2 = 0;
                    n = vector2.size();
                    while (n2 < n) {
                        if (!((TypeCountryCodeRec)vector2.elementAt(n2)).valid()) continue;
                        defaultListModel.addElement(vector2.elementAt(n2++));
                    }
                }
            }
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.worldWide.setEnabled(bl);
        this.remove.setEnabled(bl);
        this.add.setEnabled(bl);
    }

    public PopUpLocation(PopUpDlg popUpDlg) {
        super(popUpDlg);
        this.setLayout(null);
        this.requireData = true;
        this.results.setModel(new DefaultListModel());
        this.remove.setEnabled(false);
        this.add(this.st_DESCRIPT);
        this.add(this.add);
        this.add(this.remove);
        this.add(this.worldWide);
        this.add(this.j_SCROLL_PANE);
        this.add.addActionListener(this);
        this.remove.addActionListener(this);
        this.worldWide.addActionListener(this);
        this.results.addListSelectionListener(this);
    }
}

