/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.notify;

import com.ibm.nzna.projects.common.quest.brand.Brands;
import com.ibm.nzna.projects.common.quest.doc.DocumentRow;
import com.ibm.nzna.projects.common.quest.type.TypeCategoryRec;
import com.ibm.nzna.projects.common.quest.type.TypeList;
import com.ibm.nzna.projects.common.quest.type.TypeListListener;
import com.ibm.nzna.projects.common.quest.type.TypeResolutionRec;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.DataLengths;
import com.ibm.nzna.projects.qit.app.DateSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.app.UserSystem;
import com.ibm.nzna.projects.qit.doc.gui.SelectDocDlg;
import com.ibm.nzna.projects.qit.doc.gui.SelectDocListener;
import com.ibm.nzna.projects.qit.gui.UserEntryPanel;
import com.ibm.nzna.projects.qit.notify.NotificationRec;
import com.ibm.nzna.shared.gui.DButton;
import com.ibm.nzna.shared.gui.MaskDocument;
import com.ibm.nzna.shared.util.LogSystem;
import com.ibm.nzna.shared.util.WinUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class SendNotifyDlg
extends JDialog
implements DataLengths,
TypeListListener,
SelectDocListener,
ActionListener,
Runnable,
AppConst {
    private static final String THREAD_SAVEANDEXIT = "SaveExit";
    private DButton pb_FIND = null;
    private DButton pb_PASTE = null;
    private DButton pb_CANCEL = null;
    private DButton pb_SEND = null;
    private JComboBox cb_BRAND = null;
    private JComboBox cb_RESOLUTION = null;
    private UserEntryPanel ef_USERID = null;
    private JTextField ef_SUBJECT = null;
    private JTextArea mle_COMMENT = null;
    private JTextField ef_DOCIND = null;
    private JScrollPane scr_COMMENT = null;
    private JLabel st_BRAND = null;
    private JLabel st_SUBJECT = null;
    private JLabel st_BRAND_PM = null;
    private JLabel st_RESOLUTION = null;
    private JLabel st_DOCUMENTID = null;
    private JPanel pnl_HOLDER = null;
    private NotificationRec notifyRec = null;
    private boolean allowClose = false;
    private boolean allowInput = true;
    private int id = 0;

    private final void initialize(Frame frame) {
        this.createControls();
        ((Component)this).setSize(450, 350);
        WinUtil.centerChildInParent(this, frame);
        if (this.notifyRec != null) {
            this.refreshData();
        }
        this.setDefaultCloseOperation(0);
    }

    public NotificationRec getResult() {
        ((Component)this).setVisible(true);
        return this.notifyRec;
    }

    public void createControls() {
        Container container = this.getContentPane();
        this.pb_SEND = new DButton(Str.getStr(516));
        this.pb_PASTE = new DButton(Str.getStr(55));
        this.pb_CANCEL = new DButton(Str.getStr(2));
        this.pb_FIND = new DButton(Str.getStr(470));
        this.cb_BRAND = new JComboBox(Brands.getBrands());
        this.cb_RESOLUTION = new JComboBox();
        this.ef_USERID = new UserEntryPanel();
        this.ef_SUBJECT = new JTextField(new MaskDocument(0, 100), "", 0);
        this.ef_DOCIND = new JTextField(new MaskDocument(3, 10), "", 0);
        this.mle_COMMENT = new JTextArea(new MaskDocument(0, 254));
        this.scr_COMMENT = new JScrollPane(this.mle_COMMENT);
        this.st_BRAND = new JLabel(Str.getStr(145));
        this.st_SUBJECT = new JLabel(Str.getStr(661));
        this.st_BRAND_PM = new JLabel(Str.getStr(660));
        this.st_RESOLUTION = new JLabel(Str.getStr(169));
        this.st_DOCUMENTID = new JLabel(Str.getStr(264));
        this.pb_FIND.addActionListener(this);
        this.pb_CANCEL.addActionListener(this);
        this.pb_PASTE.addActionListener(this);
        this.pb_SEND.addActionListener(this);
        container.setLayout(null);
        container.add(this.st_BRAND);
        container.add(this.st_SUBJECT);
        container.add(this.st_BRAND_PM);
        container.add(this.st_RESOLUTION);
        container.add(this.st_DOCUMENTID);
        container.add(this.ef_USERID);
        container.add(this.cb_BRAND);
        container.add(this.cb_RESOLUTION);
        container.add(this.ef_SUBJECT);
        container.add(this.ef_DOCIND);
        container.add(this.pb_FIND);
        container.add(this.scr_COMMENT);
        container.add(this.pb_SEND);
        container.add(this.pb_PASTE);
        container.add(this.pb_CANCEL);
    }

    public void refreshData() {
        if (this.notifyRec != null) {
            this.pb_CANCEL.setVisible(!this.notifyRec.mustSend);
            if (this.notifyRec.toUser != null) {
                if (this.notifyRec.toUser.equals("GET_USER_FROM_BRAND")) {
                    this.ef_USERID.setEnabled(false);
                } else if (this.notifyRec.toUser != null) {
                    this.ef_USERID.setText(this.notifyRec.toUser);
                }
            } else {
                this.ef_USERID.setText("");
            }
            this.ef_SUBJECT.setText(this.notifyRec.subject);
            this.cb_BRAND.setSelectedItem(this.notifyRec.brandRec);
            if (this.notifyRec.docInd > 0) {
                this.ef_DOCIND.setText("" + this.notifyRec.docInd);
                this.ef_DOCIND.setEnabled(false);
                this.pb_FIND.setEnabled(false);
            }
            this.mle_COMMENT.setText(this.notifyRec.comments);
            if (this.notifyRec.sendType == 1) {
                this.setTitle(Str.getStr(662));
            } else if (this.notifyRec.sendType == 2) {
                this.setTitle(Str.getStr(36));
            }
            this.ef_SUBJECT.requestFocus();
            TypeList.refreshList(this.cb_RESOLUTION, 16, (TypeListListener)this);
        }
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        int n = GUISystem.getRowHeight();
        int n2 = 5;
        super.doLayout();
        this.st_BRAND_PM.setBounds(12, n2, 285, n);
        this.ef_USERID.setBounds(112, n2, 185, n + 2);
        this.ef_SUBJECT.setBounds(112, n2 += n + 4, 185, n);
        this.st_SUBJECT.setBounds(12, n2, 47, n);
        this.cb_BRAND.setBounds(112, n2 += n + 2, 185, n);
        this.st_BRAND.setBounds(12, n2, 67, n);
        this.cb_RESOLUTION.setBounds(112, n2 += n + 8, 185, n);
        this.st_RESOLUTION.setBounds(12, n2, 100, n);
        this.ef_DOCIND.setBounds(112, n2 += n + 8, 91, n);
        this.st_DOCUMENTID.setBounds(12, n2, 93, n);
        this.pb_FIND.setBounds(205, n2, 50, n);
        this.scr_COMMENT.setBounds(12, n2 += n + 2, 400, dimension.height - 70 - n2);
        this.pb_SEND.setBounds(12, dimension.height - 60, 70, 25);
        this.pb_PASTE.setBounds(87, dimension.height - 60, 90, 25);
        this.pb_CANCEL.setBounds(182, dimension.height - 60, 90, 25);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.allowInput && actionEvent.getSource() instanceof DButton) {
            DButton dButton = (DButton)actionEvent.getSource();
            if (this.pb_FIND == dButton) {
                new SelectDocDlg(0, true).addSelectDocListener(this);
            } else if (this.pb_SEND == dButton) {
                String string = this.ef_USERID.getUserId();
                if (string != null) {
                    if (this.saveData()) {
                        this.enableComponents(false);
                        new Thread((Runnable)this, THREAD_SAVEANDEXIT).start();
                    } else {
                        this.enableComponents(true);
                    }
                } else {
                    this.setTitle(Str.getStr(663));
                }
            } else if (this.pb_CANCEL == dButton) {
                if (!this.notifyRec.mustSend) {
                    this.notifyRec = null;
                    this.allowClose = true;
                    this.closeWindow();
                }
            } else if (this.pb_PASTE == dButton) {
                this.paste();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean saveData() {
        TypeCategoryRec typeCategoryRec = (TypeCategoryRec)this.cb_BRAND.getSelectedItem();
        TypeResolutionRec typeResolutionRec = (TypeResolutionRec)this.cb_RESOLUTION.getSelectedItem();
        String string = this.ef_SUBJECT.getText();
        String string2 = this.mle_COMMENT.getText();
        int n = 0;
        String string3 = this.ef_USERID.getUserId();
        boolean bl = false;
        try {
            n = new Integer(this.ef_DOCIND.getText());
        }
        catch (NumberFormatException numberFormatException) {
        }
        if (typeCategoryRec == null) {
            GUISystem.printBox(6, 466);
            return bl;
        }
        if (typeResolutionRec == null) {
            this.setTitle(Str.getStr(664));
            return bl;
        }
        if (string == null || string.length() == 0) {
            this.setTitle(Str.getStr(665));
            return bl;
        }
        if (string2 == null || string2.length() == 0) {
            this.setTitle(Str.getStr(666));
            return bl;
        }
        if (string3 == null || string3.length() == 0) {
            this.setTitle(Str.getStr(663));
            return bl;
        }
        if (this.notifyRec == null) {
            this.notifyRec = new NotificationRec();
        }
        this.notifyRec.openDate = DateSystem.getDate(2);
        this.notifyRec.comments = string2;
        this.notifyRec.toUser = string3;
        this.notifyRec.fromUser = UserSystem.getUserId();
        this.notifyRec.brandRec = typeCategoryRec;
        this.notifyRec.resolRec = typeResolutionRec;
        this.notifyRec.docInd = n;
        this.notifyRec.subject = string;
        this.notifyRec.updateRecStatus(0);
        this.notifyRec.updateRecStatus(2);
        return true;
    }

    public void notifyClose() {
    }

    public void run() {
        String string = Thread.currentThread().getName();
        if (string.equals(THREAD_SAVEANDEXIT)) {
            this.enableComponents(false);
            if (this.notifyRec.saveToDatabase(this.notifyRec)) {
                this.enableComponents(true);
                this.notifyRec.notifySent = true;
                this.allowClose = true;
                this.closeWindow();
            }
            this.enableComponents(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void paste() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (clipboard == null) return;
        try {
            Transferable transferable = clipboard.getContents(this);
            if (transferable == null) return;
            String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            if (string == null) return;
            this.mle_COMMENT.setText(string);
            return;
        }
        catch (Exception exception) {
            LogSystem.log(1, exception);
        }
    }

    public boolean destroyWin() {
        this.ef_USERID.stop();
        return true;
    }

    public void closeWindow() {
        if (this.allowClose) {
            this.dispose();
        }
    }

    private final void enableComponents(boolean bl) {
        this.allowInput = bl;
    }

    public void listRefreshed(int n) {
        if (this.notifyRec != null && n == 16 && this.notifyRec.resolRec != null) {
            this.cb_RESOLUTION.setSelectedItem(this.notifyRec.resolRec);
        }
    }

    public void selectDocComplete(Vector vector) {
        DocumentRow documentRow;
        if (vector != null && (documentRow = (DocumentRow)vector.elementAt(0)).isDraft()) {
            this.ef_DOCIND.setText("" + documentRow.getDocumentInd());
        }
    }

    public SendNotifyDlg(Frame frame) {
        super(frame, Str.getStr(659), true);
        this.initialize(frame);
    }

    public SendNotifyDlg(Frame frame, NotificationRec notificationRec) {
        super(frame, Str.getStr(659), true);
        this.notifyRec = notificationRec;
        this.initialize(frame);
    }
}

