/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.product;

import com.ibm.nzna.projects.common.quest.brand.Brands;
import com.ibm.nzna.projects.common.quest.type.TypeBrandRec;
import com.ibm.nzna.projects.common.quest.type.TypeGroupRec;
import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.QITRec;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.doc.DocFamilyRec;
import com.ibm.nzna.projects.qit.product.ProductConstants;
import com.ibm.nzna.projects.qit.product.ProductRec;
import com.ibm.nzna.shared.gui.MultiListRow;
import java.io.Serializable;

public final class MachineRec
extends QITRec
implements MultiListRow,
AppConst,
Serializable,
ProductConstants {
    private String machine = "";
    private int brandGroupInd = 0;
    private boolean isAll = false;
    private boolean isOption = false;

    public int columnCount() {
        return 1;
    }

    public char[] getDisplayDescript(int n) {
        try {
            return this.machine.toCharArray();
        }
        catch (NullPointerException nullPointerException) {
            return new String("Unknown").toCharArray();
        }
    }

    public Object getColumnData(int n) {
        try {
            return this.machine;
        }
        catch (NullPointerException nullPointerException) {
            return new String("Unknown");
        }
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof DocFamilyRec) {
            bl = ((DocFamilyRec)object).getBrandGroupInd() == this.brandGroupInd;
        } else if (object instanceof MachineRec) {
            MachineRec machineRec = (MachineRec)object;
            if (machineRec.machine.trim().equals(this.machine.trim()) && machineRec.brandGroupInd == this.brandGroupInd) {
                bl = true;
            }
        } else if (object instanceof ProductRec) {
            MachineRec machineRec = (MachineRec)((ProductRec)object).getFieldData(2);
            if (machineRec.machine.equals(this.machine) && machineRec.brandGroupInd == this.brandGroupInd) {
                bl = true;
            }
        } else if (object instanceof TypeGroupRec) {
            bl = ((TypeGroupRec)object).getBrandGroupInd() == this.brandGroupInd;
        }
        return bl;
    }

    public int getBrandGroupInd() {
        return this.brandGroupInd;
    }

    public void setBrandGroupInd(int n) {
        TypeBrandRec typeBrandRec = Brands.brandRecFromBrandGroupInd((int)n);
        this.brandGroupInd = n;
        if (typeBrandRec != null) {
            this.isOption = typeBrandRec.ind == 6;
        }
    }

    public String getMachine() {
        if (this.isOption) {
            return this.machine;
        }
        if (this.machine.length() > 4) {
            return this.machine.substring(0, 4);
        }
        return this.machine;
    }

    public String getSubMachine() {
        if (this.machine.length() > 4) {
            return this.machine.substring(0, 4);
        }
        return this.machine;
    }

    public void setMachine(String string) {
        this.machine = string;
    }

    public String toString() {
        if (this.isAll) {
            return this.machine + "(" + Str.getStr(218) + ")";
        }
        return this.machine;
    }

    public TypeGroupRec getTypeGroupRec() {
        return Brands.groupRecFromBrandGroupInd((int)this.brandGroupInd);
    }

    public void setAll(boolean bl) {
        this.isAll = bl;
    }

    public boolean getAll() {
        return this.isAll;
    }

    public boolean isOption() {
        return this.isOption;
    }

    public void setDescript(String string) {
    }

    public MachineRec(int n, String string) {
        this.setBrandGroupInd(n);
        this.setMachine(string);
    }

    public MachineRec() {
    }
}

