/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nzna.projects.qit.product;

import com.ibm.nzna.projects.qit.app.AppConst;
import com.ibm.nzna.projects.qit.app.FieldListener;
import com.ibm.nzna.projects.qit.app.FontSystem;
import com.ibm.nzna.projects.qit.app.GUISystem;
import com.ibm.nzna.projects.qit.app.ImageSystem;
import com.ibm.nzna.projects.qit.app.LocaleRec;
import com.ibm.nzna.projects.qit.app.StatusRec;
import com.ibm.nzna.projects.qit.app.Str;
import com.ibm.nzna.projects.qit.gui.ViewerUtil;
import com.ibm.nzna.projects.qit.product.MachineRec;
import com.ibm.nzna.projects.qit.product.ProductConstants;
import com.ibm.nzna.projects.qit.product.ProductRec;
import com.ibm.nzna.shared.util.Text;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.util.Vector;
import javax.swing.JComponent;

public class ProductFieldViewer
extends JComponent
implements AppConst,
ProductConstants,
FieldListener {
    private static final Color lightBlue = new Color(128, 128, 192);
    private static final Color valueColor = new Color(0, 0, 150);
    private static final int originalWidth = 400;
    private static final int originalHeight = 100;
    private static final int infoY = 34;
    private static final int WORD_BREAK_COUNT = 65;
    private int fieldId = 0;
    private ProductRec prodRec = null;
    private String[] strArray = null;
    private JComponent previewPane = null;
    private Vector historyVec = null;
    private String title = "";
    private int rowHeight = GUISystem.getRowHeight();
    private int fontHeight = 0;
    private Dimension prefSize = new Dimension(400, 110);

    public void setProductRec(ProductRec productRec) {
        if (this.prodRec != null) {
            this.prodRec.removeFieldListener(this);
            this.prodRec = null;
        }
        this.prodRec = productRec;
        if (productRec != null) {
            productRec.addFieldListener(this);
        }
        this.setFieldId(this.fieldId);
    }

    public void setFieldId(int n) {
        this.fieldId = n;
        switch (n) {
            case 5: 
            case 7: {
                this.strArray = new String[1];
                this.strArray[0] = "";
                this.prefSize.height = 40;
                break;
            }
            case 1000: {
                this.prefSize.height = 100;
                break;
            }
            case 1001: {
                this.prefSize.height = 85;
                break;
            }
            case 4: {
                this.prefSize.height = 26;
                break;
            }
        }
        this.fieldChanged(this.prodRec, n);
    }

    public boolean isField(int n) {
        boolean bl = false;
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                bl = this.fieldId == 1000;
                break;
            }
            case 9: 
            case 10: 
            case 16: {
                bl = this.fieldId == 1001;
                break;
            }
            default: {
                bl = n == this.fieldId;
                break;
            }
        }
        return bl;
    }

    public Dimension getPreferredSize() {
        return this.prefSize;
    }

    public Dimension getMinimumSize() {
        return this.prefSize;
    }

    public void fieldChanged(Object object, int n) {
        block16: {
            try {
                if (object == null || !this.isField(n)) break block16;
                this.prodRec = (ProductRec)object;
                this.title = this.prodRec.getFieldDescription(n);
                switch (n) {
                    case 5: {
                        this.strArray = Text.formatStringLineBreaks((String)this.prodRec.getFieldData(n), 65);
                        if (this.strArray != null) {
                            this.prefSize.height = (this.strArray.length + 2) * this.fontHeight;
                        }
                        this.title = this.prodRec.getFieldDescription(n);
                        this.invalidate();
                        break;
                    }
                    case 7: {
                        LocaleRec localeRec = (LocaleRec)this.prodRec.getFieldData(7);
                        this.title = this.prodRec.getFieldDescription(n);
                        if (localeRec == null) break;
                        this.strArray = Text.formatStringLineBreaks(localeRec.getLocaleList(), 65);
                        this.prefSize.height = (this.strArray.length + 2) * this.fontHeight;
                        this.invalidate();
                        break;
                    }
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        this.title = this.prodRec.getFieldDescription(1000);
                        break;
                    }
                    case 4: {
                        this.title = this.prodRec.getFieldDescription(n);
                        this.prefSize.height = 30;
                        break;
                    }
                    case 6: {
                        this.title = this.prodRec.getFieldDescription(n);
                        this.prefSize.height = 43;
                        break;
                    }
                    case 8: {
                        this.historyVec = (Vector)this.prodRec.getFieldData(8);
                        this.title = this.prodRec.getFieldDescription(n);
                        this.prefSize.height = this.historyVec != null ? (this.historyVec.size() + 1) * this.rowHeight + 30 : 25;
                        this.invalidate();
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 16: {
                        this.title = this.prodRec.getFieldDescription(1001);
                        break;
                    }
                }
                try {
                    if (this.previewPane == null) {
                        this.previewPane = (JComponent)this.getParent();
                    }
                    if (this.previewPane != null) {
                        this.previewPane.revalidate();
                        this.previewPane.repaint();
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void paintComponent(Graphics graphics) {
        if (graphics != null && this.prodRec != null) {
            Dimension dimension = this.getSize();
            dimension.width -= 2;
            dimension.height -= 2;
            graphics.setColor(Color.white);
            graphics.fillRect(3, 3, dimension.width - 6, dimension.height);
            if (this.fieldId != 4) {
                ViewerUtil.paintTitle(graphics, dimension, this.title);
            }
            switch (this.fieldId) {
                case 4: {
                    this.paintProductNumber(graphics, dimension);
                    break;
                }
                case 5: 
                case 7: {
                    int n = 32;
                    graphics.setColor(valueColor);
                    graphics.setFont(FontSystem.smallTitleFont);
                    ViewerUtil.paintMultiLine(32, graphics, dimension, this.fontHeight, this.strArray);
                    break;
                }
                case 1000: {
                    this.paintProductInfo(graphics, dimension);
                    break;
                }
                case 6: {
                    this.paintStatusInfo(graphics, dimension);
                    break;
                }
                case 8: {
                    this.paintStatusHistoryInfo(graphics, dimension);
                    break;
                }
                case 1001: {
                    this.paintProductDatabaseInfo(graphics, dimension);
                    break;
                }
            }
        }
    }

    private void paintProductNumber(Graphics graphics, Dimension dimension) {
        graphics.setFont(FontSystem.largeTitleFont);
        graphics.setColor(Color.black);
        graphics.drawImage(ImageSystem.getImage((Object)this, 36), 0, 0, this);
        if (this.prodRec.getFieldData(4) != null) {
            graphics.drawString((String)this.prodRec.getFieldData(4), 5, 20);
        }
    }

    private void paintProductInfo(Graphics graphics, Dimension dimension) {
        int n = 34;
        int n2 = 8;
        graphics.setColor(valueColor);
        ViewerUtil.drawDescriptValuePair(graphics, this.prodRec.getFieldDescription(0), this.prodRec.getFieldData(0), 150, n2, n, FontSystem.smallTitleFont, valueColor);
        ViewerUtil.drawDescriptValuePair(graphics, this.prodRec.getFieldDescription(1), this.prodRec.getFieldData(1), 150, n2, n += this.rowHeight, FontSystem.smallTitleFont, valueColor);
        ViewerUtil.drawDescriptValuePair(graphics, this.prodRec.getFieldDescription(2), ((MachineRec)this.prodRec.getFieldData(2)).getMachine(), 150, n2, n += this.rowHeight, FontSystem.smallTitleFont, valueColor);
        n += this.rowHeight;
        if (!this.prodRec.isOption()) {
            ViewerUtil.drawDescriptValuePair(graphics, this.prodRec.getFieldDescription(3), this.prodRec.getFieldData(3), 150, n2, n, FontSystem.smallTitleFont, valueColor);
        }
        n += this.rowHeight;
    }

    private void paintStatusInfo(Graphics graphics, Dimension dimension) {
        if (this.prodRec.getFieldData(6) != null) {
            ViewerUtil.drawDescriptValuePair(graphics, Str.getStr(319), ((StatusRec)this.prodRec.getFieldData(6)).getColumnData(0), 75, 8, 34, FontSystem.smallTitleFont, valueColor);
            ViewerUtil.drawDescriptValuePair(graphics, Str.getStr(708), ((StatusRec)this.prodRec.getFieldData(6)).getColumnData(1), 75, 188, 34, FontSystem.smallTitleFont, valueColor);
        }
    }

    public void paintStatusHistoryInfo(Graphics graphics, Dimension dimension) {
        int n = 34;
        int n2 = 8;
        int n3 = 0;
        if (this.historyVec != null) {
            int n4 = this.historyVec.size();
            graphics.setColor(Color.black);
            graphics.setFont(FontSystem.smallTitleFont);
            graphics.drawString(Str.getStr(319), n2, n);
            graphics.drawString(Str.getStr(708), n2 + 150, n);
            graphics.drawLine(n2, n + 1, dimension.width - n2 * 2, n + 1);
            n += 14;
            graphics.setColor(valueColor);
            graphics.setFont(FontSystem.smallTitleFont);
            while (n3 < n4) {
                if (this.historyVec.elementAt(n3) != null) {
                    graphics.drawString((String)((StatusRec)this.historyVec.elementAt(n3)).getColumnData(0), n2, n);
                    graphics.drawString((String)((StatusRec)this.historyVec.elementAt(n3)).getColumnData(1), n2 + 150, n);
                    n += this.rowHeight;
                }
                ++n3;
            }
        }
    }

    private void paintProductDatabaseInfo(Graphics graphics, Dimension dimension) {
        int n = 8;
        int n2 = 34;
        ViewerUtil.drawDescriptValuePair(graphics, this.prodRec.getFieldDescription(16), "" + this.prodRec.getProdInt(), 130, n, n2, FontSystem.smallTitleFont, valueColor);
        ViewerUtil.drawDescriptValuePair(graphics, this.prodRec.getFieldDescription(9), this.prodRec.getFieldData(15), 130, n, n2 += this.rowHeight, FontSystem.smallTitleFont, valueColor);
        ViewerUtil.drawDescriptValuePair(graphics, this.prodRec.getFieldDescription(10), this.prodRec.getFieldData(14), 130, n, n2 += this.rowHeight, FontSystem.smallTitleFont, valueColor);
    }

    public ProductFieldViewer(ProductRec productRec, int n) {
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(FontSystem.smallTitleFont);
        this.fontHeight = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
        this.setProductRec(productRec);
        this.setFieldId(n);
    }
}

